{[VOLUMES.INC]Ŀ}
{                                                                          }
{                         }
{                                         }
{                              }
{                                               }
{                             2.11+  }
{                                                                          }
{             *** Strukturen der Volume-Dateien (*.VOL) ***                }
{     Copyright 1993-95 K.Meyer & S.Briesenick; All rights reserved.       }
{}

{ Wichtiger Hinweis:                                                         }
{ ~~~~~~~~~~~~~~~~~                                                          }
{ Um die Volume-Datei mglichst kompakt zu halten, werden Strings variabler  }
{ Lnge GEPACKT gespeichert. Dies bedeutet, da nur die relevanten Teile     }
{ des Strings gespeichert werden und nicht seine theoretische Lnge. Ein     }
{ gepackter String sieht in der Datei folgendermaen aus:                    }
{                                                                            }
{   Length : Byte;                                                           }
{   Chars  : Array[1..<Length>] of Char;                                     }
{                                                                            }
{ Bei leeren Strings wird demzufolge nur das Lngenbyte gespeichert.         }


{Ŀ}
{ File-Header-Kennung                                                      }
{}

CONST

  VID = 'UP'#14;  { File-Header-Kennung }


{Ŀ}
{ Zuerst der Volume-Header                                                 }
{}

TYPE

  Volume_Header = RECORD

    File_ID   : Array[1..3] of Char;

  { Prfkennung => VID ('UP'#14) }

    Created   : Word;

  { Create-Datum der Volumedatei (julianisch) }

    AreaCount : Word;

  { Anzahl Areas im Volume }

    Reserved  : Array[1..8] of Byte;

  { Reservierter Bereich }

    Flags     : Byte;

  { Volume-Flags:  Bit 7: 0 = HD,      1 = CD    }
  {                Bit 6: 0 = inaktiv, 1 = aktiv }

    Title     : Array[1..32] of Char;

  { Volume-Titel: Normalerweise 0-terminiert;                      }
  {               wenn Title[32]<>#0, dann 32 Zeichen langer Titel }

    VolumeID  : String[12];

  { Volume-ID, !!! gepacktes Format !!!! }

    VolumeCRC : LongInt;

  { Volume-CRC, 0 wenn ungenutzt }

  END;


{Ŀ}
{ Folgender RECORD ist 'AreaCount' mal hintereinander gespeichert          }
{}

TYPE

  Volume_Record = RECORD

    Name  : String[60];

  { Area-Titel, gepacktes Format }

    Path  : String[64];

  { Pfad *ohne* Backslash am Ende, gepacktes Format }

    Fake  : String[79];

  { Fake-Pfad/Name, gepacktes Format }

    Group : Byte;

  { Gruppen-Nummer }

  END;


{Ŀ}
{                                                                          }
{ Der Aufbau der kompletten Volume-Datei sieht folgendermaen aus:         }
{                                                                          }
{   [Volume_Header]                                                        }
{   ARRAY[1..<Volume_Header.AreaCount>] OF [Volume_Record]                 }
{                                                                          }
{[EOF]}
