{[USERS.INC]Ŀ}
{                                                                          }
{                         }
{                                         }
{                              }
{                                               }
{                             2.20+  }
{                                                                          }
{          *** Strukturen der User-Datenbank (EasyERP.USR) ***             }
{     Copyright 1993-95 K.Meyer & S.Briesenick; All rights reserved.       }
{}

{ Wichtiger Hinweis:                                                         }
{ ~~~~~~~~~~~~~~~~~                                                          }
{ Alle Strings liegen in einem BASIC-Typischen Format vor. Erkenntlich sind  }
{ diese an der Deklaration "ARRAY[1..xx] OF CHAR;". Diese Art von Strings    }
{ haben weder ein Lngen-Byte, noch ein Ende-Kennzeichen. Die Strings sind   }
{ auf volle Lnge mit Blanks aufgefllt. Um den String in seiner echten      }
{ Lnge zu erhalten, sind von rechts her alle Blanks zu entfernen.           }


{Ŀ}
{ %EASYERP%\EasyERP.USR                                                    }
{}

TYPE

  GroupSet   = Set of 0..255;
  AddrType   = RECORD Zone, Net, Node, Point: Word; END;

  UserRecord = RECORD

    Username    : Array[1..30] of Char;
    Adress      : AddrType
    Location    : Array[1..40] of Char;
    Reserved1   : Word;
    TICPwd      : Array[1..16] of Char;
    TICArea     : Array[1..16] of Char;
    BBS_DLC     : Array[1.. 8] of Char;
    FakeAka     : AddrType;
    Reserved2   : Byte;
    Groups      : GroupSet;
    Flags       : Word;

  { Bit  0 : Requests verboten    Bit  7 : TIC mit LongDesc     }
  { Bit  1 : Limits Ignorieren    Bit  8 : Immer auf Hold       }
  { Bit  2 : Keine MSG senden     Bit  9 : Adult Level          }
  { Bit  3 : BBS immer senden     Bit 10 : VIP Level            }
  { Bit  4 : BTM immer senden     Bit 11 : DupeChecking         }
  { Bit  5 : TIC immer senden     Bit 14 : Kill-Flag            }
  { Bit  6 : Keine CRC in TIC     Bit 15 : Statistik korrigiert }

    FLimit      : Word;
    KLimit      : Word;
    Calls       : Word;
    Lastcall    : Word;         { Julianisches Datumsformat }
    FilesAll    : Word;
    KByteAll    : LongInt;
    FilesToday  : Integer;
    KByteToday  : LongInt;
    LastConnect : Byte;

  { 0 = No Request     9 =  21600 BPS }
  { 1 =   2400 BPS    10 =  24000 BPS }
  { 2 =   4800 BPS    11 =  26400 BPS }
  { 3 =   7200 BPS    12 =  28800 BPS }
  { 4 =   9600 BPS    13 =  38400 BPS }
  { 5 =  12000 BPS    14 =  57600 BPS }
  { 6 =  14400 BPS    15 =  64000 BPS }
  { 7 =  16800 BPS    16 = 128000 BPS }
  { 8 =  19200 BPS    17 = NetRequest }

    Reserved3   : Byte;

  END;

{Ŀ}
{ Die Anzahl der Stze erhlt man nach folgender Formel:                   }
{ RecCount:= FileSize DIV SizeOf(UserRecord);                              }
{[EOF]}
