{[EEINDEX.INC]Ŀ}
{                                                                          }
{                         }
{                                         }
{                              }
{                                               }
{                             2.11+  }
{                                                                          }
{             *** Strukturen der Index-Dateien (*.IDX) ***                 }
{     Copyright 1993-95 K.Meyer & S.Briesenick; All rights reserved.       }
{}

{ Wichtige Hinweise:                                                         }
{ ~~~~~~~~~~~~~~~~~                                                          }
{ Alle Strings liegen in einem BASIC-Typischen Format vor. Erkenntlich sind  }
{ diese an der Deklaration "ARRAY[1..xx] OF CHAR;". Diese Art von Strings    }
{ haben weder ein Lngen-Byte, noch ein Ende-Kennzeichen. Die Strings sind   }
{ auf volle Lnge mit Blanks aufgefllt. Um den String in seiner echten      }
{ Lnge zu erhalten, sind von rechts her alle Blanks zu entfernen.           }
{                                                                            }
{ Bei Satznummern wird immer von 1 an gezhlt. Die Position innerhalb der    }
{ jeweiligen Datei erhlt man nach folgender Formel:                         }
{ FilePos:= Pred(RecNo)*SizeOf(Struct);                                      }
{                                                                            }
{ Die Anzahl der Stze erhlt man nach folgender Formel:                     }
{ RecCount:= FileSize DIV SizeOf(Struct);                                    }
{                                                                            }
{ Alle Index-Dateien sind immer geshared (deny none) zu ffnen! Um zu ver-   }
{ hindern, da ein anderer Task den Index neu anlegt/updated, ist das Sema-  }
{ phore EE_RUN<task>.ERP zu setzen/abzufragen. Das Semaphore liegt im selben }
{ Verzeichnis, die der Index. <Task> ist die zweistellige, dezimale Task-    }
{ nummer, welche den auf den Index zugreift und somit den Index fr andere   }
{ Tasks fr Schreibzugriffe gesperrt hat. Jeder Task, der lesend auf den     }
{ Index zugreifen will, muss dieses Semaphore setzen. Schreibend darf nur    }
{ dann auf den Index zugegriffen werden, wenn kein taskfremdes Semaphore     }
{ existiert!  Zudem existiert noch ein Critical-Semaphore: ACCESS.ERP        }
{ Solange dieses Semaphore existiert, darf weder lesend noch schreibend      }
{ auf den Index zugegriffen werden. Beim EE_RUN<task>.ERP darf zumindest     }
{ lesend auf den Index zugegriffen werden. ACCESS.ERP darf nur dann gesetzt  }
{ werden, wenn kein taskfremdes EE_RUN<task>.ERP Semaphore existiert!        }


{Ŀ}
{ EE_DRIVE.IDX                                                             }
{}

TYPE

  DriveIndex = RECORD

    Drive         : Byte;

  { Bit 0-5 : Laufwerks-Nummer A=1, B=2, etc. }
  { Bit 6   : inaktiv/aktiv                   }
  { Bit 7   : 0=HD, 1=CD                      }

    VolCRC32      : LongInt;                                    { Volume-CRC }
    VolumeID      : Array[1..12] of Char;                        { Volume-ID }
    Title         : Array[1..32] of Char;                     { Volume Titel }
    NoOf1stDir    : LongInt;                    { Satznummer der ersten Area }
    NumberOfAreas : Integer;                  { Anzahl der Areas des Volumes }
    NumberOfFiles : LongInt;                  { Anzahl der Files des Volumes }
    CheckCRC      : LongInt;                { Prfsumme ber die *.VOL Datei }

  END;

{ Die Volumes liegen in keiner definierten Reihenfolge in der Indexdatei.    }
{ Um ein bestimmtes Volume zu finden, ist diese Indexdatei also sequentiell  }
{ zu durchsuchen.                                                            }


{Ŀ}
{ EE_AREAS.IDX                                                             }
{}

TYPE

  AreasIndex = RECORD

    VolNo         : Integer;                        { Satznummer des Volumes }
    Name          : Array[1..60] of Char;                { Area Beschreibung }
    Path          : Array[1..64] of Char;                    { Pfad der Area }
    Fake          : Array[1..79] of Char;                    { Fake der Area }
    Group         : Byte;                           { Gruppennummer der Area }
    NumberOfFiles : Integer;                  { Anzahl der Files in der Area }
    AreaCRC       : LongInt;             { Prfsumme ber die Files der Area }

  END;

{ Alle Areas eines Volumes liegen stets hintereinander. Die erste Area eines }
{ Volumes bekommt man ber den Eintrag 'NoOf1stDir' aus dem Drive-Index. Ab  }
{ dieser Position liegen dann 'NumberOfAreas' Areas dieses Volumes hinter-   }
{ einander. Die Areas eines Volumes liegen i.d.R. sortiert nach dem Titel    }
{ vor; es wre aber auch eine andere, bzw. gar keine Sortierreihenfolge      }
{ mglich.                                                                   }


{Ŀ}
{ EE_FILES.IDX                                                             }
{}

TYPE

  FilesIndex = RECORD

    Name          : Array[1..8] of Char;                        { Datei-Name }
    Ext           : Array[1..3] of Char;                   { Datei-Extention }
    AreaNo        : LongInt;                           { Satznummer der Area }
    FileTime      : LongInt;                 { Datei-Datum/Zeit (DOS-Format) }
    FileSize      : LongInt;                                    { Dateigre }

  END;

{ Diese Datei liegt als einzigste sortiert nach 'Name'+'Ext'+'AreaNo' vor.   }
{ Es ist daher mglich mittels Binr-Suche in die Index-Datei einzusteigen,  }
{ um eine bestimmte Datei zu finden. ber 'AreaNo' kann dann in den Area-    }
{ Index eingestiegen werden, um den Pfad innerhalb des Volumes zu erhalten.  }
{ ber den Area-Eintrag 'VolNo' kann dann auf das Volume, und somit auf den  }
{ Laufwerksbuchstaben, zugegriffen werden.                                   }


{Ŀ}
{[EOF]}
