/*
Copyright (C) 1997-1998 Erwin Waterlander

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifdef VMS
#  define EXIT_OK 1
#  define ALT_SW || *argv[i]=='/'
#  define CHDIR(s) vms_chdir(s)
#else
#  define EXIT_OK 0
#  define CHDIR(s) chdir(s)
#  ifdef MSDOS
#    define ALT_SW || *argv[i]=='/'
#    define TREEFILE "\\treedata.wcd"
#    define EXTRA_TREEFILE "\\extra.wcd"
#    define BANFILE "\\ban.wcd"
#    define ALIASFILE "\\alias.wcd"
#    define STACKFILE "c:\\stack.wcd"
#    define ROOTDIR "\\"
#    define GO_FILE "c:\\wcd.go"
#    define DIR_SEPARATOR '/'
#  else /* ?UNIX */
#    define ALT_SW
#    define TREEFILE "/.treedata.wcd"
#    define EXTRA_TREEFILE "/.extra.wcd"
#    define BANFILE "/.ban.wcd"
#    define ALIASFILE "/.alias.wcd"
#    define STACKFILE "/.stack.wcd"
#    define ROOTDIR "/"
#    define HOMESTRING "/home/"
#    define GO_FILE "/bin/wcd.go"
#    define DIR_SEPARATOR '/'
#  endif /* ?MSDOS */
#endif /* ?VMS */

#if defined(MSDOS) || defined(VMS)
#  define OP_DIR ""
#else /* ?unix */
#  define OP_DIR "."
#endif /* ?MSDOS|VMS */

#ifdef MSDOS
#  define STAT stat
#else /* unix */
#  define STAT lstat /* don't expand symbolic links */
#endif

#define VERSION      "2.1.7"
#define VERSION_DATE "Sep 2 1998"


/* Function prototypes */

void finddirs(char *dir);
void read_banfile(char* banfilename, nameset bd);
int  checkban(char *dir, nameset bd);
int check_double_match(char *dir, int perfect,
                       nameset pm, nameset wm);
void scanfile(char *org_dir, char *filename, int ignore_case,
              nameset pm, nameset wm, nameset bd);
void scanaliasfile(char *org_dir, char *filename,
                   nameset pm, nameset wm);
int  strcompare(const char*, const char*, int);
void printhelp(void);
int  wcd_get_int(void);
int wcd_exit(nameset pm, nameset wm, nameset ef, nameset bd, WcdStack ws);
#ifdef BASH
	void empty_wcdgo(char *go_file, int changedrive, char *drive);
#else
	void empty_wcdgo(char *go_file);
#endif
int SpecialDir(const char *path);

