/*
Copyright (C) 1997-1998 Erwin Waterlander

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "dosdir.h"
#include "std_macro.h"
#include "structures.h"
#include "WcdStack.h"
#include "text.h"
#include "wcd.h"
#include "stack.h"

/********************************************************************
 *
 *                 stack_add
 *
 ********************************************************************/

int stack_add(WcdStack ws, char *dir)
{
	ws->lastadded++;

	if(ws->lastadded == ws->maxsize)
		ws->lastadded = 0;

	ws->current = ws->lastadded;

	/* printWcdStack("add ", ws, stdout); */

	/* free old dir string if present */
	if (ws->dir != NULL)
	if((ws->dir[ws->lastadded] != NULL) && (ws->size == ws->maxsize))
	free (ws->dir[ws->lastadded]);

	putTextelementAtWcdStack(textNew(dir), ws->lastadded, ws);

	return(0);
}
/********************************************************************
 *
 *                 stack_read
 *
 ********************************************************************/

int stack_read(WcdStack ws,char *stackfilename)
{

	FILE *infile;
	char tmp[DD_MAXDIR];
	int error, i, j;
	char c;


	/* open stack-file */
	if  ((ws->maxsize <= 0)||((infile = fopen(stackfilename,"r")) == NULL))
	{
		/* fprintf(stderr,"Error opening stack-file\n"); */
		ws->lastadded = -1;
		ws->current = -1;
	}
	else
	{
		if(fscanf(infile,"%d %d",&ws->lastadded,&ws->current)==2)
		{

		   while( !feof(infile)&&(ws->size < ws->maxsize) )
		   {

			j=0;
			error = 0;
			/* read a line */
			for(i=0; ((c=getc(infile)) != '\n') && (!feof(infile)) ;i++)
				if (i < (DD_MAXDIR-1))
				{
					tmp[i]=c;
					j++;
				}
				else error = 1;
			tmp[j]='\0';  /* end string */
			
			if(error)
				printf("Error: line too long ( %d > %d). Fix: increase DD_MAXDIR.\n",i,(DD_MAXDIR-1));

			if (strlen(tmp) > 0 )
		    	addTexttoWcdStack(textNew(tmp), ws);
		   }
		}
		else
		  {
		  	printf("Error parsing stack\n");
			ws->lastadded = -1;
			ws->current = -1;
		  }

		fclose(infile);

		if (ws->lastadded >= ws->size)
		ws->lastadded = 0;
		if (ws->current >= ws->size)
		ws->current = 0;
	}

 /*	printWcdStack("READ ", ws, stdout); */
	return(0);
}
/********************************************************************
 *
 *                 stack_print
 *
 * Returns: On succes: the index number of the chosen stack entry
 *          On fail: -1
 *
 ********************************************************************/

int stack_print(WcdStack ws)
{

	int  i, start, j, k=1;


/*	printWcdStack("XXX ", ws, stdout); */


	if((ws == NULL) || (ws->maxsize <= 0))
	return (-1);
	else
		if( ((ws->size) <= 0) || ((ws->size) > ws->maxsize) )
		return (-1);
		else
		{

	if (ws->size < ws->maxsize)
		start = 0;
	else
	   start = ws->lastadded + 1;

	if (ws->lastadded >= ws->maxsize)
	 start = 0;

		   for(i=0; i < (ws->size) ; i++)
		   {
			j = (i + start)%(ws->size);
		  	printf("%2d ",k);
			k++;

			printf("%s",ws->dir[j]);
			if (j == ws->current)
				printf(" *");
			printf("\n");
		   }

		printf("\nPlease choose one (<Enter> to abort): ");
		i = wcd_get_int();

		if (( i <=0)||(i > ws->size)) /* fail */
		{
			return(-1);
	    }
		else    /* succes */
		{
			i = ( i - 1 + start)%(ws->size);
			ws->current = i;
			return(i);
		}
		}
}
/********************************************************************
 *
 *                 stack_push
 *
 ********************************************************************/

char* stack_push(WcdStack ws, int push_ntimes)
{

	int  new_stack_nr;

	if(ws == NULL)
	return (NULL);
	else
		if( ((ws->size) <= 0) || ((ws->size) > ws->maxsize) )
		return (NULL);
		else
		{

	        push_ntimes = push_ntimes % ws->size;

	        new_stack_nr = ws->current - push_ntimes;

	        if(new_stack_nr < 0)
	        new_stack_nr = ws->size + new_stack_nr;

	        ws->current = new_stack_nr;

	        return(ws->dir[ws->current]);
		}
}
/********************************************************************
 *
 *                 stack_pop
 *
 *
 *
 ********************************************************************/

char* stack_pop(WcdStack ws, int pop_ntimes)
{

	int  new_stack_nr;


	if(ws == NULL)
	return (NULL);
	else
		if( ((ws->size) <= 0) || ((ws->size) > ws->maxsize) )
		return (NULL);
		else
		{
	         pop_ntimes = pop_ntimes % ws->size;

	         new_stack_nr = ws->current + pop_ntimes;

	         if(new_stack_nr > (ws->size -1))
	         new_stack_nr =  new_stack_nr - ws->size;

	         ws->current = new_stack_nr;
	         return(ws->dir[ws->current]);
		}
}
/********************************************************************
 *
 *                 stack_write
 *
 ********************************************************************/

int stack_write(WcdStack ws,char *stackfilename)
{
	FILE *outfile;
	int  i;

	if (ws->maxsize <= 0)
	   return(0);
	else
	if ( (outfile = fopen(stackfilename,"w")) == NULL)
	{
		fprintf(stderr,"Error opening stack-file for write.\n");
		return(0);
	}
	else
	{
		fprintf(outfile,"%d %d\n",ws->lastadded,ws->current);
		for(i=0;((i<ws->size)&&(i<ws->maxsize));i++)
		{
	  /*		printf("writing line %d\n",i);  */
			fprintf(outfile,"%s\n",ws->dir[i]);
		}
		fclose(outfile);
	}
	return(0);
}

