/*
Copyright (C) 1997-1998 Erwin Waterlander

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <stdio.h>
#include <string.h>
#include "tailor.h"
#ifdef MSDOS
#  include <conio.h>
#endif
#include "std_macro.h"
#include "structures.h"
#include "nameset.h"
#include "wcd.h"

#define OFFSET 39
#define SCROLL_WIN_HEIGHT 22

/************************************************************************
 *
 *  display_list(nameset list)
 *
 *  Display a match list on screen.
 *  Under unix we make use of the standard scroll-back
 *  capability of the terminal.
 *  This function has a scroll-back function for MSDOS.
 *
 ************************************************************************/

void swap(nameset list, int i, int j)
{  text temp;

   temp = list->array[i];
   list->array[i] = list->array[j];
   list->array[j] = temp;
}

void ssort (nameset list, int left, int right)
{
 int i, last;

  if (left >= right) return; /* fewer than 2 elements */

  swap(list, left, (left + right)/2);
  last = left;

  for (i = left+1; i <=right; i++)
  	if  (strcmp(list->array[i],list->array[left])<0)
	   swap(list, ++last, i);

  swap(list, left, last);
  ssort(list, left, last-1);
  ssort(list, last+1, right);

}

void sort_list(nameset list)
{
 ssort(list,0,(list->size)-1);
}


#ifdef MSDOS

int display_list(nameset list,int perfect)
{
int i,j=0, top, bottom, c=0, extended;
char number_str[256];

		sort_list(list);

		for (i=0;i<list->size;i++)
			printf("%d  %s\n",i+1,list->array[i]);

		i= -1;

		if(perfect)
		  printf("\nPerfect ");
		else
		  printf("\nWild ");
		printf("match for %d directories.\n",list->size);
		printf("Please choose one (<Enter> to abort): ");
		fflush(stdout);

		if (list->size > SCROLL_WIN_HEIGHT )
		{
			bottom = list->size -1;
			top = bottom - SCROLL_WIN_HEIGHT + 1 ;

			while ( c != 13 )
			{

			  c = getch();

			  switch(c)
			  {
			  case 0:   /* extended key */
			    extended = getch();

				if ((extended == 73) || /* Page Up */
				    (extended == 72))   /* Arrow Up */
				{
			      window(1,1,80,SCROLL_WIN_HEIGHT+1);
			      clrscr();

				  if(bottom > (SCROLL_WIN_HEIGHT -1))
				  {
				    bottom = bottom - SCROLL_WIN_HEIGHT ;
				    top = top - SCROLL_WIN_HEIGHT ;
				  }

				  if (top<0) top = 0;

				  if (bottom < (SCROLL_WIN_HEIGHT -1) )
				  gotoxy(1,SCROLL_WIN_HEIGHT-bottom);

				  for (i=top;i<=bottom;i++)
					cprintf("%d  %s\n\r",i+1,list->array[i]);
				} /* Page Up */

				if ((extended == 81) || /* Page down */
					(extended == 80))   /* Arrow down */
				{
			      window(1,1,80,SCROLL_WIN_HEIGHT+1);
			      clrscr();

				  if(bottom < (list->size -1 ))
				  {
				    bottom = bottom + SCROLL_WIN_HEIGHT ;
				    top = bottom - SCROLL_WIN_HEIGHT + 1;
				  }

				  for (i=top;i<=bottom;i++)
					cprintf("%d  %s\n\r",i+1,list->array[i]);
			    }/* Page down */
				if ((extended==83)||(extended==75)) /* delete or arrow left */
				{
				   window (1,SCROLL_WIN_HEIGHT+1,80,25);
				   if(j>0) j--;
				   gotoxy(OFFSET + j, 3);
				   cprintf(" ");
				}
				window (1,SCROLL_WIN_HEIGHT+1,80,25);
				gotoxy (OFFSET + j, 3);
			  break;
			  case 8:  /* backspace */
				window (1,SCROLL_WIN_HEIGHT+1,80,25);
				if(j>0) j--;
				gotoxy(OFFSET + j, 3);
				cprintf(" ");
				gotoxy(OFFSET + j, 3);
				break;
			  case 3:  /* Control-C */
				j=0;
				c=13;
				break;
			  default:
			    if (( c > 47) && ( c < 58)) /* numbers */
			    {
				   window (1,SCROLL_WIN_HEIGHT+1,80,25);
				   number_str[j] = (char)c;
				   gotoxy (OFFSET + j++, 3);
				   cprintf("%c",(char)c);
			    }
			  break;
			  }
		    }
		number_str[j] = '\0';
		i=atoi(number_str);
		printf("\n");
		}
		else
		{
			i=wcd_get_int();
		}
		return i;
}

#else

int display_list(nameset list,int perfect)
{
  int i;
		sort_list(list);

		for (i=0;i<list->size;i++)
			printf("%d  %s\n",i+1,list->array[i]);

		if(perfect)
		  printf("\nPerfect ");
		else
		  printf("\nWild ");
		printf("match for %d directories.\n",list->size);
		printf("Please choose one (<Enter> to abort): ");

		return wcd_get_int();
}
#endif
