// filecnv.cpp
// File Area Conversion Tag 2.7 to Maximus 3.01
// (C) Copyright 1996, TranStar Technologies
// 02/10/96 - Version 1.0

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#pragma pack(1)
#include "\bbsdev\tag.h"
//#include "max.h"
#pragma pack()
#include <share.h>
#include <conio.h>

#define TRUE    1
#define FALSE   0

typedef unsigned char BYTE;
typedef unsigned short WORD;

FILE *instream, *outstream;
UlRec fboard;
short count = 0;
char ListFile[64];
UlfRec farea;

void strip(char *string);
void __pascal pas2c(char *source, char *dest);
void TStrip(char *string);
BYTE ask(char *string);
void ConvertBoard();
void WriteListFile();
void fixname(char *filename);

void main(int argc, char **argv)
{
    printf("FILECNV 1.0 - Tag 2.7x to Maximus 3.01 File Area Converter\n");
    printf("(C) Copyright 1996, TranStar Technologies\n\n");
    if (argc!=3) {
        printf("Usage: path-fboards.dat path-fareas.ctl\n");
        exit(0);
    }
    if ((instream = _fsopen(argv[1], "rb", _SH_DENYNO)) == NULL) {
        printf("Can't open %s\n", argv[1]);
        exit(0);
    }
    if ((outstream = fopen(argv[2], "wt")) == NULL) {
        printf("Can't create %s\n", argv[2]);
        fclose(instream);
        exit(0);
    }

    while(!feof(instream)) {
        if (fread(&fboard, sizeof(UlRec), 1, instream) != 1) break;
        ConvertBoard();
        count++;
    }
    fclose(instream);
    fclose(outstream);
    printf("\n%d file areas defined.\n", count);
}


void strip(char *string)
{
    short c;

    if (string[strlen(string) - 1] == '\n')
        string[strlen(string) - 1] = 0;
    if (string[strlen(string) - 1] == '\r')
        string[strlen(string) - 1] = 0;
    while(1) {
        c = (short)strlen(string);
        if (!c) break;
        if (string[c - 1] != ' ') break;
        string[c - 1] = 0;
    }
}

void __pascal pas2c(char *source, char *dest)
{
    short slen;
    char *p;

    p = source;
    slen = *p;
    p++;
    memcpy(dest, p, slen);
    dest[slen] = 0;
}


void TStrip(char *string)
{
    char tmp[80], *p, *q;

    p = string;
    q = tmp;
    while(*p) {
        if (*p == 3) {
            p += 2;
            continue;
        }
        *q = *p;
        p++;
        q++;
    }
    *q = 0;
    strcpy(string, tmp);
}


BYTE ask(char *string)
{
    short c;
    
reget:
    printf("%s (Y/N)? ", string);
    c = getche();
    c = toupper(c);
    printf("%c\n", c);
    if (c == 'Y') return TRUE;
    if (c == 'N') return FALSE;
    goto reget;
}

void ConvertBoard()
{
    char tmp[132];

    pas2c((char *)fboard.Name, tmp);
    TStrip(tmp);
    printf("%3d: %s\n", count, tmp);

    fprintf(outstream, "FileArea %d\n", count);
    fprintf(outstream, "\tDesc\t\t%s\n", tmp);
    fprintf(outstream, "\tACS\t\t%d", (short)fboard.DSL);
    if (fboard.ArLvl != '@') fprintf(outstream, "/%c", (char)fboard.ArLvl);
    fprintf(outstream, "\n");
    pas2c((char *)fboard.DlPathname, tmp);
    fprintf(outstream, "\tDownload\t\t%s\n", tmp);
    strcpy(ListFile, tmp);
    pas2c((char *)fboard.UlPathName, tmp);
    fprintf(outstream, "\tUpload\t\t%s\n", tmp);

    pas2c((char *)fboard.Filename, tmp);
    if (tmp[0] == '`' || tmp[0] == '@') {
        fprintf(outstream, "\tFileList\t\t");
        sprintf(ListFile, "File\\%s.BBS", &tmp[1]);
        fprintf(outstream, "File\\%s.BBS\n", &tmp[1]);
    } else {
        strcat(ListFile, tmp);
        strcat(ListFile, ".BBS");
    }
    if (fboard.Flags.IsCdRom)
        fprintf(outstream, "\tType\t\tCD\n");
    fprintf(outstream, "End FileArea\n\n");
    if (ask("Convert area")) WriteListFile();
}


void WriteListFile()
{
    FILE *dirstream, *bbsstream;
    char *p, tmp[132];
    
    strcpy(tmp, ListFile);
    p = strstr(tmp, ".BBS");
    if (p == NULL) return;
    strcpy(p, ".DIR");
    if ((dirstream = _fsopen(tmp, "rb", _SH_DENYNO)) == NULL) {
        printf("Cannot open TAG DIR file %s\n", tmp);
        return;
    }
    if ((bbsstream = fopen(ListFile, "wt")) == NULL) {
        printf("Cannot make BBS file %s\n", ListFile);
        fclose(dirstream);
        return;
    }
    
    while(!feof(dirstream)) {
        if (fread(&farea, sizeof(UlfRec), 1, dirstream) != 1) break;
        pas2c((char *)farea.Filename, tmp);
        fixname(tmp);
        fprintf(bbsstream, "%-12s ", tmp);
        pas2c((char *)farea.Description, tmp);
        fprintf(bbsstream, "%s\n", tmp);
    }
    fclose(dirstream);
    fclose(bbsstream);
}

        
void fixname(char *filename)
{
    char *p, *q, tmp[20];
    
    p = filename;
    q = tmp;
    while(*p) {
        if (*p == ' ') {
            p++;
            continue;
        }
        *q = *p;
        q++;
        p++;
    }
    *q = 0;
    strcpy(filename, tmp);
}
