  '***********************************************************************
  '* Program Name:  Summary of EchoMail Tag Statistics (SETS)            *
  '* Author:  R.J. (Bob) Ross - SysOp RJ's Byteline BBS FidoNet 1:134/75 *
  '* Started:  Apr 17th 1992                                             *
  '* Completed: Version 1.00 -  May 8th, 1992                            *
  '* Completed: Version 1.01 -  May 13th, 1992                           *
  '* Beta Version 1.02 - May 18th, 1993                                  *
  '* Beta Version 1.02C - June 2nd, 1993                                 *
  '* Beta Version 1.02D - Dec 17th, 1993                                 *
  '* Completed: Version 2.00 - May 23rd, 1994                            *
  '***********************************************************************
  '
    DEFINT A-Z
    DECLARE FUNCTION ComputeCRC& (X$)
    DECLARE SUB Copyright ()
    DECLARE FUNCTION DosError%
    DECLARE FUNCTION Exist% (FileName$)
    DECLARE SUB Help ()
    DECLARE SUB ISort (Tmp1$(), Tmp2%(), CNT%)
    DECLARE FUNCTION LineCount% (FileName$, Buffer$)
    DECLARE SUB FileView (FileName$, Ky, Action, FVI AS ANY, SEG Array)
    DECLARE FUNCTION MonthName$ (Month%)
    DECLARE FUNCTION ParseString$ (CurPos%, Work$, Delimit$)
    DECLARE SUB PrtCtrDisp (PrtRec%, LN%)
    DECLARE FUNCTION QPTrim$ (Work$)
    DECLARE SUB Sort (Tmp1&(), Tmp2&(), CNT%)
  
    CONST Version = "SETS Version 2.00"
    CONST ID1 = "Summary of EchoMail Tag Statistics - "
    CONST ID2 = "Copyright 1992-94 by R.J. (Bob) Ross - ALL RIGHTS RESERVED"
    CONST ID3 = "SysOp RJ's Byteline BBS - FidoNet 1:134/75"
  
    Comma$ = CHR$(44)
    CONST False = 0
    CONST True = NOT False
    ExcludeTags% = False
    HistUpdate% = False
    NotStartLog% = True
    NoAnsi% = False
    SquishLog% = True
    WriteHistTxt% = False
    Begin$ = "[* Unknown *] "
    EndLog$ = "[* Unknown *] "
    LogFile$ = "Squish.log"
  
  'History data base SetsHist.dat
    TYPE SetsStats
        TagName AS STRING * 13
        MessagesIn AS LONG
        MessagesOut AS LONG
        MessageDupes AS LONG
    END TYPE
  
    DIM SetsStatsRec AS SetsStats
    DIM Rpt$(1 TO 15)
  
    Rpt$(1) = "Summary of EchoMail Tag Statistics"
  
  'Report output format
    Rpt$(2) = "ĿĿ"
    Rpt$(3) = "   EchoTag    In  Out  Dup Nodes   EchoTag    In  Out  Dup Nodes"
    Rpt$(4) = "ĴĴ"
  
    Rpt$(5) = ""
  
    Rpt$(6) = ""
    Rpt$(7) = "ͻ"
    Rpt$(8) = ""
    Rpt$(9) = "ͼ"
  
    Rpt$(10) = "HISTORY - Summary of EchoMail Tag Statistics"
  
    Rpt$(11) = "Ŀ"
    Rpt$(12) = "  EchoTag                Incoming          Outgoing            Dupes   "
    Rpt$(13) = "Ĵ"
  
    Rpt$(14) = "Ĵ"
  
    Rpt$(15) = ""
  
  'Switches
    P% = INSTR(COMMAND$, "-LL") 'List last report
    IF P% THEN
        IF Exist%("SETSRPT.TXT") THEN
            GOTO ListFile
        ELSE
            BEEP
            CALL Copyright
            LOCATE 13, 20
            PRINT "SETSRpt.Txt not found "
            END
        END IF
    END IF
  
    IF INSTR(COMMAND$, "-H ") THEN              'Help screen
        CALL Copyright
        CALL Help
        END
    END IF
  
    IF RIGHT$(COMMAND$, 2) = "-H" THEN          'Help screen
        CALL Copyright
        CALL Help
        END
    END IF
  
    P% = INSTR(COMMAND$, "-HLL")                'List last History report
    IF P% THEN
        IF Exist%("SETSHist.TXT") THEN
            GOTO ListFile
        ELSE
            BEEP
            CALL Copyright
            LOCATE 13, 20
            PRINT "SETSHist.Txt not found "
            END
        END IF
    END IF
  
    P% = INSTR(COMMAND$, "-QM") 'QMail logfile
    IF P% THEN
        SquishLog% = False
        LogFile$ = "QM.Log"
    END IF
  
    P% = INSTR(COMMAND$, "-HT") 'Write SetsHist.Txt
    IF P% THEN
        WriteHistTxt% = True
    END IF
  
    P% = INSTR(COMMAND$, "-HU") 'Create or update history file SetsHist.dat
    IF P% THEN
        HistUpdate% = True
    END IF
  
    P% = INSTR(COMMAND$, "LOG=")                'Alternate logfile
    IF P% THEN
        Temp$ = MID$(COMMAND$, P% + 4)
        P% = INSTR(Temp$, " ")
        IF P% THEN Temp$ = LEFT$(Temp$, P% - 1)
        LogFile$ = Temp$
    END IF
  
    IF NOT Exist%(LogFile$) THEN
        BEEP
        CALL Copyright
        LOCATE 13, 20
        PRINT "Log File: "; LogFile$; " not found."
        END
    END IF
  
  'Exclude some echo tags
    P% = INSTR(COMMAND$, "-X")  'Exclude tag file
    IF P% THEN
        Temp$ = MID$(COMMAND$, P% + 2)
        P% = INSTR(Temp$, " ")
        IF P% THEN Temp$ = LEFT$(Temp$, P% - 1)
        ExcludeFile$ = Temp$
        IF Exist%(ExcludeFile$) THEN
            Count% = LineCount%(ExcludeFile$, SPACE$(4096))
            REDIM UnwantedTag$(1 TO Count% - 1)
            OPEN ExcludeFile$ FOR INPUT AS #3
            FOR X% = 1 TO Count% - 1
                LINE INPUT #3, Record$
                UnwantedTag$(X%) = UCASE$(QPTrim$(Record$))
                UnwantedTag$(X%) = LEFT$(UnwantedTag$(X%), 13)
            NEXT
            CLOSE #3
            ExcludeTags% = True
        ELSE
            BEEP
            PRINT "Tag Exclusion file "; ExcludeFile$; " not found!"
            END
        END IF
    END IF
  
    OPEN LogFile$ FOR INPUT AS #1
    OPEN "Squish.$$$" FOR OUTPUT AS #2
  
    IF INSTR(COMMAND$, "-NHA") THEN             'No high ascci in report
        FOR X% = 1 TO 15
            CALL Translate(Rpt$(X%))
        NEXT
    END IF
  
  'Program ID - Copyright notice
    CALL Copyright
  
  'Parse the logfile
    LN% = 20
    PrtRec% = 0
    LOCATE 13, LN% + 1
    PRINT "Scanning: "; LogFile$
  
    Ctr% = 0
  'Squish.log (default)
    IF SquishLog% THEN
        DO UNTIL EOF(1)
            LINE INPUT #1, Record$
            IF MID$(Record$, 19, 4) = "SQSH" THEN
                IF NotStartLog% THEN
                    IF INSTR(19, Record$, "SQSH Begin,") THEN
                      'Start date & time
                        Begin$ = MID$(Record$, 3, 15)
                        NotStartLog% = False
                    END IF
                END IF
                IF INSTR(19, Record$, "SQSH End.") THEN
                  'Finish log date & time
                    EndLog$ = Record$
                END IF
                IF LEFT$(Record$, 1) = ":" THEN
                    IF INSTR(Record$, "Sent/killed") THEN
                      'do nothing
                    ELSEIF INSTR(Record$, "Packed") THEN
                      'do nothing
                    ELSEIF INSTR(Record$, "busy") THEN
                      'do nothing
                    ELSEIF ExcludeTags% THEN
                      'Good record but do we want it!
                        P% = INSTR(27, Record$, " ")
                        IF P% THEN
                            TempTag$ = MID$(Record$, 27, P% - 27)
                            TempTag$ = LEFT$(TempTag$, 13)
                            SkipTag% = False
                          
                            FOR X% = 1 TO Count% - 1
                                IF TempTag$ = UnwantedTag$(X%) THEN
                                    SkipTag% = True
                                    EXIT FOR
                                END IF
                            NEXT
                          
                        END IF
                        IF NOT SkipTag% THEN
                            PRINT #2, MID$(Record$, 27)
                            Ctr% = Ctr% + 1: PrtRec% = PrtRec% + 1
                            CALL PrtCtrDisp(PrtRec%, LN%)
                        END IF
                    ELSE
                        PRINT #2, MID$(Record$, 27)
                        Ctr% = Ctr% + 1: PrtRec% = PrtRec% + 1
                        CALL PrtCtrDisp(PrtRec%, LN%)
                    END IF
                END IF
            END IF
        LOOP
    ELSE
      'QM Log
        DO UNTIL EOF(1)
            LINE INPUT #1, Record$
            IF NotStartLog% THEN
                IF LEFT$(Record$, 5) = "BEGIN" THEN
                  'Start date & time
                    Mnth$ = MonthName$(VAL(MID$(Record$, 7, 2)))
                    Begin$ = MID$(Record$, 10, 2) + " " + Mnth$ + " " + MID$(Record$, 18, 8)
                  'BEGIN 10-22-1993 01:01:08  Disk=6221824b  Memory=220k/220k ---------------------
                    NotStartLog% = False
                END IF
            END IF
            IF LEFT$(Record$, 3) = "END" THEN
              'Finish log date & time
                Mnth$ = MonthName$(VAL(MID$(Record$, 5, 2)))
                EndLog$ = "   " + MID$(Record$, 8, 2) + " " + Mnth$ + " " + MID$(Record$, 16, 8)
            END IF
            IF MID$(Record$, 5, 7) = "+ ECHO:" THEN
                IF INSTR(Record$, "Sent/killed") THEN
                  'do nothing
                ELSEIF INSTR(Record$, "Packed") THEN
                  'do nothing
                ELSEIF INSTR(Record$, "busy") THEN
                  'do nothing
                ELSEIF ExcludeTags% THEN
                  'Good record but do we want it!
                    P% = INSTR(13, Record$, " ")
                    IF P% THEN
                        TempTag$ = MID$(Record$, 13, P% - 13)
                        TempTag$ = LEFT$(TempTag$, 13)
                        SkipTag% = False
                      
                        FOR X% = 1 TO Count% - 1
                            IF TempTag$ = UnwantedTag$(X%) THEN
                                SkipTag% = True
                                EXIT FOR
                            END IF
                        NEXT
                      
                    END IF
                    IF NOT SkipTag% THEN
                        PRINT #2, MID$(Record$, 13)
                        Ctr% = Ctr% + 1: PrtRec% = PrtRec% + 1
                        CALL PrtCtrDisp(PrtRec%, LN%)
                    END IF
                ELSE
                    PRINT #2, MID$(Record$, 13)
                    Ctr% = Ctr% + 1: PrtRec% = PrtRec% + 1
                    CALL PrtCtrDisp(PrtRec%, LN%)
                END IF
            END IF
        LOOP
    END IF
    CLOSE
  
    IF Ctr% THEN
        OPEN "Squish.$$$" FOR INPUT AS #1
      ' $DYNAMIC
        REDIM Idx&(1 TO Ctr%)
        REDIM Seeks&(1 TO Ctr%)
        CurSeek& = 1
      
        FOR LC% = 1 TO Ctr%
            LINE INPUT #1, Record$
            Seeks&(LC%) = CurSeek&
            CurSeek& = CurSeek& + LEN(Record$) + 2
            Tag$ = ParseString$(1, Record$, " ")
            Tag$ = RTRIM$(Tag$)
            Tag$ = LEFT$(Tag$, 13)
            Idx&(LC%) = ComputeCRC&(Tag$)
            PrtRec% = PrtRec% + 1
            CALL PrtCtrDisp(PrtRec%, LN%)
        NEXT
        CLOSE
      
      'Sort the index
        LOCATE 15, LN% + 1
        PRINT "Sorting index - ";
        CALL Sort(Idx&(), Seeks&(), Ctr%)
        PRINT "finished index sort"
      
        OPEN "Squish.$$$" FOR INPUT AS #1
        OPEN "squish.$$s" FOR OUTPUT AS #2
      
        FOR X% = 1 TO Ctr%
            SEEK #1, Seeks&(X%)
            LINE INPUT #1, Record$
            PRINT #2, Record$
            LOCATE 16, LN% + 1
            PRINT "Writing first pass: "; X%
        NEXT
        PRINT #2, ""
        CLOSE
      
        OPEN "squish.$$s" FOR INPUT AS #1
        OPEN "squish.$$c" FOR OUTPUT AS #2
      
      
      'First record
        LINE INPUT #1, Record1$
        Tag1$ = ParseString$(1, Record1$, " ")
        Tag1$ = RTRIM$(Tag1$)
        Tag1$ = LEFT$(Tag1$, 13)
      
        IF SquishLog% THEN
            P% = INSTR(Record1$, "Toss=")
            IF P% THEN
                Toss% = VAL(MID$(Record1$, P% + 5))
                TagTotToss% = TagTotToss% + Toss%
            END IF
        END IF
      
        IF NOT SquishLog% THEN
            Toss% = VAL(MID$(Record1$, 33))
            TagTotToss% = TagTotToss% + Toss%
        END IF
      
        IF SquishLog% THEN
            P% = INSTR(Record1$, "Sent=")
            IF P% THEN
                Sent% = VAL(MID$(Record1$, P% + 5))
                TagTotSent% = TagTotSent% + Sent%
            END IF
        END IF
      
        IF NOT SquishLog% THEN
            Sent% = VAL(MID$(Record1$, 45))
            TagTotSent% = TagTotSent% + Sent%
        END IF
      
        P% = INSTR(Record1$, "Dupe=")
        IF P% THEN
            Dups% = VAL(MID$(Record1$, P% + 5))
            TagTotDups% = TagTotDups% + Dups%
        END IF
      
        IF NOT SquishLog% THEN
            P% = INSTR(Record1$, "(Dupes=")
            IF P% THEN
                Dups% = VAL(MID$(Record1$, P% + 7))
                TagTotDups% = TagTotDups% + Dups%
            END IF
        END IF
      
      
      'All remaining records
        FOR X% = 1 TO Ctr%
            LINE INPUT #1, Record2$
            Tag2$ = ParseString$(1, Record2$, " ")
            Tag2$ = RTRIM$(Tag2$)
            Tag2$ = LEFT$(Tag2$, 13)
            IF Tag1$ = Tag2$ THEN
                IF SquishLog% THEN
                    P% = INSTR(Record2$, "Toss=")
                    IF P% THEN
                        Toss% = VAL(MID$(Record2$, P% + 5))
                        TagTotToss% = TagTotToss% + Toss%
                    END IF
                END IF
                IF NOT SquishLog% THEN
                    Toss% = VAL(MID$(Record2$, 33))
                    TagTotToss% = TagTotToss% + Toss%
                END IF
              
                P% = INSTR(Record2$, "Sent=")
                IF P% THEN
                    Sent% = VAL(MID$(Record2$, P% + 5))
                    TagTotSent% = TagTotSent% + Sent%
                END IF
                P% = INSTR(Record2$, "Dupe=")
                IF P% THEN
                    Dups% = VAL(MID$(Record2$, P% + 5))
                    TagTotDups% = TagTotDups% + Dups%
                END IF
                IF NOT SquishLog% THEN
                    P% = INSTR(Record2$, "(Dupes=")
                    IF P% THEN
                        Dups% = VAL(MID$(Record2$, P% + 7))
                        TagTotDups% = TagTotDups% + Dups%
                    END IF
                END IF
            ELSE
                PRINT #2, Tag1$; Comma$; TagTotToss%; Comma$; TagTotSent%;
                PRINT #2, Comma$; TagTotDups%
                RecCount% = RecCount% + 1
                LOCATE 17, LN% + 1
                PRINT "Accumulating multiple tags: "; RecCount%
                Record1$ = Record2$
                TagTotToss% = 0
                TagTotSent% = 0
                TagTotDups% = 0
                IF NOT SquishLog% THEN
                    Toss% = VAL(MID$(Record2$, 33))
                    TagTotToss% = TagTotToss% + Toss%
                END IF
                P% = INSTR(Record1$, "Toss=")
                IF P% THEN
                    Toss% = VAL(MID$(Record1$, P% + 5))
                    TagTotToss% = TagTotToss% + Toss%
                END IF
                P% = INSTR(Record1$, "Sent=")
                IF P% THEN
                    Sent% = VAL(MID$(Record1$, P% + 5))
                    TagTotSent% = TagTotSent% + Sent%
                END IF
                P% = INSTR(Record1$, "Dupe=")
                IF P% THEN
                    Dups% = VAL(MID$(Record1$, P% + 5))
                    TagTotDups% = TagTotDups% + Dups%
                END IF
                IF NOT SquishLog% THEN
                    P% = INSTR(Record1$, "(Dupes=")
                    IF P% THEN
                        Dups% = VAL(MID$(Record1$, P% + 7))
                        TagTotDups% = TagTotDups% + Dups%
                    END IF
                END IF
                Tag1$ = Tag2$
            END IF
        NEXT
        CLOSE
      
        OPEN "squish.$$c" FOR INPUT AS #1
      
        ERASE Idx&, Seeks&
      
        REDIM Rec$(1 TO RecCount%)
        FOR X% = 1 TO RecCount%
            LINE INPUT #1, Rec$(X%)
            LOCATE 18, LN% + 1
            PRINT "Final sort: "; X%
        NEXT
        CLOSE
      
        CALL SortStr(BYVAL VARPTR(Rec$(1)), RecCount%, 0)
        IF DosError% THEN
            BEEP
            LOCATE 19, LN% + 1
            PRINT "A DOS error detected during Sort."
            LOCATE 20, LN% + 1
            PRINT "Program terminated."
            END
        END IF
    END IF
  
    IF RecCount% > 0 THEN
      
      'This to elimate CRC errors after accumulating Tags
      
        OPEN "Sets.$CS" FOR OUTPUT AS #5
        FOR X% = 1 TO RecCount%
            PRINT #5, Rec$(X%)
        NEXT
        CLOSE #5
      
      'SETS.$CS to to $c1 to get rid of all the dup tags
      
        OPEN "sets.$cs" FOR INPUT AS #5
        OPEN "sets.$c1" FOR OUTPUT AS #6
      
      'First
        INPUT #5, Tag1$, Toss1%, Sent1%, Dups1%
      
      'And then
        DO WHILE NOT EOF(5)
          
            INPUT #5, Tag2$, Toss2%, Sent2%, Dups2%
            IF Tag1$ = Tag2$ THEN
                Tag2$ = Tag1$
                Toss1% = Toss1% + Toss2%
                Sent1% = Sent1% + Sent2%
                Dups1% = Dups1% + Dups2%
            ELSE
                PRINT #6, Tag1$; Comma$; Toss1%; Comma$; Sent1%; Comma$; Dups1%
                Tag1$ = Tag2$
                Toss1% = Toss2%
                Sent1% = Sent2%
                Dups1% = Dups2%
            END IF
        LOOP
      
        PRINT #6, Tag1$; Comma$; Toss1%; Comma$; Sent1%; Comma$; Dups1%
        CLOSE #5
        CLOSE #6
      
        RecCount% = LineCount%("sets.$c1", SPACE$(4096))
        REDIM Rec$(1 TO RecCount%)
      
        OPEN "sets.$c1" FOR INPUT AS #6
      
        FOR X% = 1 TO RecCount%
            LINE INPUT #6, Rec$(X%)
        NEXT
        CLOSE #6
    END IF
  
    IF EndLog$ = "[* Unknown *] " THEN
      'Do nothing
    ELSE
        EndLog$ = MID$(EndLog$, 3, 16)
    END IF
  
    OPEN "SETSRpt.Txt" FOR OUTPUT AS #2
    Ctr% = 0
  
    PRINT #2, LogFile$; TAB(77 - LEN(Version)); Version
    PRINT #2,
    PRINT #2, SPC(24); Rpt$(1)
    PRINT #2, SPC(21); Begin$; " - To - "; EndLog$
    FOR X% = 2 TO 4
        PRINT #2, Rpt$(X%)
    NEXT
  
    IF HistUpdate% THEN
        IF Exist%("Sets.$C1") THEN
            OPEN "Sets.$C1" FOR INPUT AS #1
            OPEN "SetsHist.dat" FOR RANDOM AS #3 LEN = LEN(SetsStatsRec)
            RecNum% = LOF(3) \ LEN(SetsStatsRec)
            IF RecNum% = 0 THEN
                OPEN "SetsHist.dte" FOR OUTPUT AS #4
                PRINT #4, Begin$
                PRINT #4, EndLog$
                CLOSE #4
                DO UNTIL EOF(1)
                    INPUT #1, Tag$, MsgIn%, MsgOut%, MsgDupes%
                    Tag$ = Tag$ + (SPACE$(13 - LEN(Tag$)))
                  'Tag$ = LEFT$(Tag$, 13)
                  'PRINT Tag$
                    RecNum% = RecNum% + 1
                    SetsStatsRec.TagName = Tag$
                    SetsStatsRec.MessagesIn = MsgIn%
                    SetsStatsRec.MessagesOut = MsgOut%
                    SetsStatsRec.MessageDupes = MsgDupes%
                    LOCATE 19, LN% + 1
                    PRINT "Creating SetsHist.Dat Record "; X%
                    PUT #3, RecNum%, SetsStatsRec
                LOOP
                CLOSE (1)
                CLOSE (3)
            ELSEIF RecNum% > 0 THEN
                Match% = False
                IF Exist%("SetsHist.dte") THEN
                    OPEN "SetsHist.dte" FOR INPUT AS #4
                    LINE INPUT #4, BeginHist$
                    LINE INPUT #4, Junk$
                    CLOSE #4
                ELSE BeginHist$ = "[* Unknown *] "
                END IF
                OPEN "SetsHist.dte" FOR OUTPUT AS #4
                PRINT #4, BeginHist$
                PRINT #4, EndLog$
                CLOSE #4
                DO UNTIL EOF(1)
                    INPUT #1, Tag$, MsgIn%, MsgOut%, MsgDupes%
                    Tag$ = LEFT$(Tag$, 13)
                    Match% = False
                    FOR X% = 1 TO RecNum%
                        GET #3, X%, SetsStatsRec
                        IF RTRIM$(SetsStatsRec.TagName) = RTRIM$(Tag$) THEN
                            SetsStatsRec.MessagesIn = SetsStatsRec.MessagesIn + MsgIn%
                            SetsStatsRec.MessagesOut = SetsStatsRec.MessagesOut + MsgOut%
                            SetsStatsRec.MessageDupes = SetsStatsRec.MessageDupes + MsgDupes%
                            PUT #3, X%, SetsStatsRec
                            Match% = True
                            LOCATE 19, LN% + 1
                            PRINT "Updating SetsHist.Dat Record "; X%
                            EXIT FOR
                        END IF
                    NEXT
                    IF NOT Match% THEN
                        RecNum% = RecNum% + 1
                        SetsStatsRec.TagName = Tag$
                        SetsStatsRec.MessagesIn = MsgIn%
                        SetsStatsRec.MessagesOut = MsgOut%
                        SetsStatsRec.MessageDupes = MsgDupes%
                        PUT #3, RecNum%, SetsStatsRec
                    END IF
                LOOP
            END IF
        END IF
    END IF

  'Re-initialize to use again below
    TotToss& = 0
    TotSent& = 0
    TotDups& = 0
  
  'Report detail lines
    FOR X% = 1 TO RecCount%
        Posn% = 1
        Tag$ = ParseString(Posn%, Rec$(X%), ",")
        Tag$ = LEFT$(Tag$, 13)
        Toss$ = ParseString(Posn%, Rec$(X%), ",")
        Toss% = VAL(Toss$)
        Sent$ = ParseString(Posn%, Rec$(X%), ",")
        Sent% = VAL(Sent$)
        Dups$ = ParseString(Posn%, Rec$(X%), ",")
        Dups% = VAL(Dups$)
        Ctr% = Ctr% + 1
        SELECT CASE Ctr%
        CASE IS = 1
            PRINT #2, Rpt$(5); LEFT$(Tag$, 13); TAB(16);
            IF Toss% THEN
                PRINT #2, USING "####"; Toss%;
            END IF
            PRINT #2, TAB(21);
            IF Sent% THEN
                PRINT #2, USING "#####"; Sent%;
            END IF
            PRINT #2, TAB(27);
            IF Dups% THEN
                PRINT #2, USING "#####"; Dups%;
            END IF
            IF Sent% >= Toss% THEN
                IF Toss% THEN
                    IF Sent% THEN
                        Nodes% = Sent% \ Toss%
                    END IF
                END IF
            END IF
            IF Nodes% THEN
                PRINT #2, TAB(34);
                PRINT #2, USING "###"; Nodes%;
                Nodes% = 0
            END IF
            TotToss& = TotToss& + Toss%
            TotSent& = TotSent& + Sent%
            TotDups& = TotDups& + Dups%
        CASE IS = 2
            PRINT #2, TAB(38); Rpt$(5); Rpt$(5);
            PRINT #2, LEFT$(Tag$, 13); TAB(54);
            IF Toss% THEN
                PRINT #2, USING "####"; Toss%;
            END IF
            PRINT #2, TAB(59);
            IF Sent% THEN
                PRINT #2, USING "#####"; Sent%;
            END IF
            PRINT #2, TAB(65);
            IF Dups% THEN
                PRINT #2, USING "#####"; Dups%;
            END IF
            IF Sent% >= Toss% THEN
                IF Toss% THEN
                    IF Sent% THEN
                        Nodes% = Sent% \ Toss%
                    END IF
                END IF
            END IF
            IF Nodes% THEN
                PRINT #2, TAB(72);
                PRINT #2, USING "###"; Nodes%;
                Nodes% = 0
            END IF
          
            PRINT #2, TAB(76); Rpt$(5)
            TotToss& = TotToss& + Toss%
            TotSent& = TotSent& + Sent%
            TotDups& = TotDups& + Dups%
            Ctr% = 0
            LOCATE 20, LN% + 1
            PRINT "Writing:  SETSRpt.Txt "; X%
        END SELECT
    NEXT
    IF Ctr% = 1 THEN
        PRINT #2, TAB(38); Rpt$(5); Rpt$(5); TAB(76); Rpt$(5)
    END IF
  
  'Report totals
    PRINT #2, Rpt$(6)
    PRINT #2,
    PRINT #2, SPC(18); Rpt$(7)
    PRINT #2, SPC(18); Rpt$(8); "  Total Messages Received = ";
    PRINT #2, USING "#######"; TotToss&;
    PRINT #2, SPC(1); Rpt$(8)
    PRINT #2, SPC(18); Rpt$(8); "      Total Messages Sent = ";
    PRINT #2, USING "#######"; TotSent&;
    PRINT #2, SPC(1); Rpt$(8)
    PRINT #2, SPC(18); Rpt$(8); " Total Duplicate Messages = ";
    PRINT #2, USING "#######"; TotDups&;
    PRINT #2, SPC(1); Rpt$(8)
    PRINT #2, SPC(18); Rpt$(9)
    CLOSE
    LOCATE 21, LN% + 1
    PRINT "Finished: SETSRpt.Txt"
  
    ERASE Rec$
  
  'History text file SETSHist.txt
    IF WriteHistTxt% THEN
        TotToss& = 0
        TotSent& = 0
        TotDups& = 0
        IF Exist%("SetsHist.dat") THEN
            OPEN "SetsHist.dat" FOR RANDOM AS #3 LEN = LEN(SetsStatsRec)
            RecNum% = LOF(3) \ LEN(SetsStatsRec)
            BeginHist$ = "[* Unknown *] "
            EndLog$ = "[* Unknown *] "
             IF Exist%("SetsHist.dte") THEN
                 OPEN "SetsHist.dte" FOR INPUT AS #4
                 LINE INPUT #4, BeginHist$
                 LINE INPUT #4, EndLog$
                 CLOSE #4
             END IF
            REDIM Rec%(1 TO RecNum%)
            REDIM Rec$(1 TO RecNum%)
          
            FOR X% = 1 TO RecNum%
                Rec%(X%) = X%
            NEXT
          
            FOR X% = 1 TO RecNum%
                GET #3, X%, SetsStatsRec
                Rec$(X%) = SetsStatsRec.TagName
            NEXT
            
            CALL ISort(Rec$(), Rec%(), RecNum%)
            OPEN "SetsHist.Txt" FOR OUTPUT AS #5
            PRINT #5, "SetsHist.Dat"; TAB(77 - LEN(Version)); Version
            PRINT #5,
            PRINT #5, SPC(19); Rpt$(10)
            PRINT #5, SPC(22); BeginHist$; " - To - "; EndLog$
          
            FOR X% = 11 TO 13
                PRINT #5, Rpt$(X%)
            NEXT
            FOR X% = 1 TO RecNum%
                GET #3, Rec%(X%), SetsStatsRec
                PRINT #5, Rpt$(5); "  "; SetsStatsRec.TagName;
                PRINT #5, TAB(25);
                PRINT #5, USING "###,###,###"; SetsStatsRec.MessagesIn;
                PRINT #5, SPC(8);
                PRINT #5, USING "###,###,###"; SetsStatsRec.MessagesOut;
                PRINT #5, SPC(7);
                PRINT #5, USING "###,###,###"; SetsStatsRec.MessageDupes;
                PRINT #5, TAB(76); Rpt$(5)
                TotToss& = TotToss& + SetsStatsRec.MessagesIn
                TotSent& = TotSent& + SetsStatsRec.MessagesOut
                TotDups& = TotDups& + SetsStatsRec.MessageDupes
            NEXT
            PRINT #5, Rpt$(14)
            PRINT #5, Rpt$(5); "  **TOTAL";
            PRINT #5, TAB(25);
            PRINT #5, USING "###,###,###"; TotToss&;
            PRINT #5, SPC(8);
            PRINT #5, USING "###,###,###"; TotSent&;
            PRINT #5, SPC(7);
            PRINT #5, USING "###,###,###"; TotDups&;
            PRINT #5, TAB(76); Rpt$(5)
            PRINT #5, Rpt$(15)
            LOCATE 22, LN% + 1
            PRINT "Finished: SetsHist.txt"
            CLOSE #5
        ELSE
            LOCATE 20, LN% + 1
            PRINT "Data File SetsHist.dat not found!"
        END IF
    END IF

    P% = INSTR(COMMAND$, "-L")  'List to the screen
    IF P% THEN
      'list the file to the screen
    ELSE
        CLOSE
        GOSUB KillFiles
        END
    END IF
  
ListFile:
    CLEAR
    TYPE FVInfo
        Colr        AS INTEGER  'Text color (white on black default)
        ULRow       AS INTEGER  'these four describe the window's corners
        ULCol       AS INTEGER
        LRRow       AS INTEGER
        LRCol       AS INTEGER
        HorizOffset AS INTEGER  'left margin within the window (see below)
        LoPtr       AS INTEGER  'used internally -- do not change!
        FileHandle  AS INTEGER  'internal (the DOS file handle if you care)
        EndOfFile   AS INTEGER  'used internally -- do not change!
        LineNumber  AS LONG     'line number of top line displayed, READ ONLY
        TabStop     AS INTEGER  'Tab stop setting (see below)
        FileSeek    AS LONG     'force read anywhere in the file (see below)
        FileOffset  AS LONG     'used internally -- do not change!
    END TYPE
  
    DIM FVI0 AS FVInfo          'create the TYPE variable
    REDIM Array(1 TO 16384)     'set up the MANDATORY 32K buffer
  
    FVI0.Colr = 10              'select a display color
    FVI0.ULRow = 2              'define the window corners
    FVI0.ULCol = 1
    FVI0.LRRow = 24
    FVI0.LRCol = 80
    FVI0.TabStop = 8
  
    IF INSTR(COMMAND$, "-LL") THEN FileName$ = "SetsRpt.txt"
    IF INSTR(COMMAND$, "-L") THEN FileName$ = "SetsRpt.txt"
    IF INSTR(COMMAND$, "-HLL") THEN FileName$ = "SetsHist.txt"
  
    LN% = 76 - (LEN(ID1) + LEN(Version))
  
    CLS
    Ky = 0      'no keystrokes pending
    Action = 1  'tell FileView to assume full control
    DO
        LOCATE 1, 1
        PRINT SPACE$(LN% \ 2); ID1; Version; SPACE$(LN% \ 2)
        LOCATE 25, 1
        COLOR 0, 7
        PRINT "Line:"; LEFT$(STR$(FVI0.LineNumber) + SPACE$(3), 4);
        PRINT "File:"; LEFT$(FileName$ + SPACE$(15), 15);
        PRINT "QUIT: ESC or X  MOVE: "; CHR$(24); CHR$(25); CHR$(27);
        PRINT CHR$(26); " PgUp PgDn Home End";
      
        FileView FileName$, Ky, Action, FVI0, Array(1)
        IF Ky = 27 OR Ky = 88 OR Ky = 120 THEN
            EXIT DO
        END IF
    LOOP
    COLOR 7, 0
    PRINT
    LOCATE 25, 1
    CALL ClearEOL(0)
    CLOSE
    GOSUB KillFiles
    END

  'Erase all temp files
KillFiles:
    IF Exist%("Squish.$$$") THEN KILL "Squish.$$$"
    IF Exist%("Squish.$$s") THEN KILL "Squish.$$s"
    IF Exist%("Squish.$$c") THEN KILL "Squish.$$c"
    IF Exist%("Sets.$cs") THEN KILL "Sets.$cs"
    IF Exist%("Sets.$c1") THEN KILL "Sets.$c1"
    RETURN

REM $STATIC
DEFSNG A-Z
    FUNCTION ComputeCRC& (X$) STATIC
      ' ComputeCRC - Copyright (C) 1989, Donn Bly, 1:236/7.0
      '
      ' Standard Donn Bly Licencing Agreement:
      '  This code may be used for anything that you want, except for profit.  If
      '  you want to profit from my work you had better talk to me first.
      '
        STATIC InputByte AS INTEGER, CRCWord AS LONG, C%, FeedBackBit AS INTEGER
      '
      ' CRC Calculation Polynomial = X^16+X^15+X^2+X^0
      '
      ' X$ is the block on which to compute the CRC
      '
        CRCWord = 0
        FOR C% = 1 TO LEN(X$)
            InputByte = ASC(MID$(X$, C%, 1))
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 128) = 128)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 64) = 64)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 32) = 32)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 16) = 16)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 8) = 8)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 4) = 4)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 2) = 2)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 1) = 1)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
        NEXT C%
        ComputeCRC& = CRCWord
    END FUNCTION

DEFINT A-Z
    SUB Copyright
        CLS
        PRINT TAB(42 - LEN(ID1) + LEN(Version) \ 2); ID1; Version
        PRINT TAB(40 - LEN(ID2) \ 2); ID2
        PRINT TAB(40 - LEN(ID3) \ 2); ID3
        PRINT STRING$(79, "")
    END SUB

    SUB Help
      ' PRINT "Use:"
        PRINT "Use:     SETS [<-switches->] [LOG=logfilename]"
        PRINT
        PRINT "         Switches and LOG=logfile are optional and may be given in any "
        PRINT "         order.  The default produces SETSRpt.Txt in the parent/home "
        PRINT "         directory where SETS.EXE and Squish.log reside."
        PRINT "Switches:"
        PRINT "         = No switch produces SETSRpt.Txt using Squish.log and exits."
        PRINT " -H      = This brief help screen."
        PRINT " -HLL    = List the last  created SetsHist.Txt to the screen."
        PRINT " -HT     = Write a text output history summary as SetsHist.Txt"
        PRINT " -HU     = Create or update data file SetsHist.Dat."
        PRINT " -L      = Produce SETSRpt.txt and list to the screen."
        PRINT " -LL     = List the last created SETSRpt.Txt file to the screen."
        PRINT " -NHA    = Don't use high ascii characters to produce SETSRpt.Txt."
        PRINT " -QM     = Use QMail format logfile (default QM.Log)"
        PRINT " -X      = Exclude tags from report.  Eg: -Xd:\path\Sets.xcl"
        PRINT " LOG=    = log path\log filename.  Optional if Squish.log in parent dir."
        PRINT STRING$(79, "")
    END SUB

    SUB ISort (Tmp1$(), Tmp2%(), CNT%) STATIC
      '
      ' --- The Shell-Metzner Sort Subroutine --- <Fast!>
      '
        M% = CNT%
        WHILE M% > 1
            M% = INT(M% / 2)
            FOR J% = 1 TO CNT% - M%
                FOR I% = J% TO 1 STEP -M%
                    k% = I% + M%
                  'IF Tmp1$(i%) >= Tmp1$(k%) THEN
                    IF Tmp1$(I%) <= Tmp1$(k%) THEN
                        I% = 0
                    ELSE
                        SWAP Tmp1$(I%), Tmp1$(k%)
                        SWAP Tmp2%(I%), Tmp2%(k%)
                    END IF
                NEXT I%
            NEXT J%
        WEND
    END SUB

    SUB PrtCtrDisp (PrtRec%, LN%) STATIC
        SELECT CASE PrtRec%
        CASE IS = 1
            LOCATE 14
            PRINT SPC(LN%); "Working    |"
        CASE IS = 2
            LOCATE 14
            PRINT SPC(LN%); "Working    / "
        CASE IS = 3
            LOCATE 14
            PRINT SPC(LN%); "Working    - "
        CASE IS = 4
            LOCATE 14
            PRINT SPC(LN%); "Working    \ "
        CASE ELSE
            IF PrtRec% > 4 THEN PrtRec% = 1
        END SELECT
      
    END SUB

DEFSNG A-Z
    SUB Sort (Tmp1&(), Tmp2&(), CNT%) STATIC
      '
      ' --- The Shell-Metzner Sort Subroutine --- <Fast!>
      '
        M% = CNT%
        WHILE M% > 1
            M% = INT(M% / 2)
            FOR J% = 1 TO CNT% - M%
                FOR I% = J% TO 1 STEP -M%
                    k% = I% + M%
                  'IF TMP1&(i%) >= TMP1&(k%) THEN
                    IF Tmp1&(I%) <= Tmp1&(k%) THEN
                        I% = 0
                    ELSE
                        SWAP Tmp1&(I%), Tmp1&(k%)
                        SWAP Tmp2&(I%), Tmp2&(k%)
                    END IF
                NEXT I%
            NEXT J%
        WEND
    END SUB

