/*
 Maximus Squish base date fixer, v0.3
 Copyright (c) 2000 William McBrine
 Distributed under the GNU General Public License

 This is (I hope) pure ANSI C, and not dependent on any non-standard
 external libraries.
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

/* If your compiler supports strftime(), you can uncomment the next line. */
/* #define HAS_STRFTIME */

typedef unsigned char pshort[2];
typedef unsigned char plong[4];
typedef unsigned char pbyte;

typedef struct
{
	pshort opt;
	pbyte name, rsvd1;
	pshort acs, menuname;
} OVERRIDE;

typedef struct
{
	pshort zone, net, node, point;
} NETADDR;

typedef struct
{
	pshort cbArea, num_override, cbHeap, division;
	pshort name, acs, path, echo_tag, descript, origin;
	pshort menuname, menureplace;

	pshort attribs;

	NETADDR primary, seenby;
	pshort attribs_2, type;

	pshort killbyage, killbynum, killskip;
	pshort barricade, barricademenu;

	plong cbPrior;

	pshort attachpath;
	plong rsvd4;
} MAREA;

#define MSGLOCAL	0x00000100L

typedef struct {
	char misc1[104];
	plong begin_frame;
	char misc2[148];
} SQSTART;

typedef struct {
	plong id, next_frame;
	char misc[20];
} SQHDR;

typedef struct {
	plong attr;
	char from[36], to[36], subject[72];
	char netaddrs[16];
	plong date_written, date_arrived;
	pshort utc_ofs;
	plong replyto;
	plong replies[9];
	plong umsgid;
	char __ftsc_date[20];
} XMSG;

typedef struct
{
	char tag[21];
	void *next;
} ECHO;

struct tm *getdostime(unsigned long packed)
{
	static struct tm unpacked;

	unpacked.tm_mday = packed & 0x1f;
	packed >>= 5;
	unpacked.tm_mon = (packed & 0x0f) - 1;
	packed >>= 4;
	unpacked.tm_year = (packed & 0x7f) + 80;
	packed >>= 7;

	unpacked.tm_sec = (packed & 0x1f) << 1;
	packed >>= 5;
	unpacked.tm_min = packed & 0x3f;
	packed >>= 6;
	unpacked.tm_hour = packed & 0x1f;

	return &unpacked;
}

unsigned getshort(const unsigned char *x)
{
	return ((unsigned) x[1] << 8) + (unsigned) x[0];
}

unsigned long getlong(const unsigned char *x)
{
	return ((unsigned long) x[3] << 24) + ((unsigned long) x[2] << 16) +
		((unsigned long) x[1] << 8) + (unsigned long) x[0];
}

void myfgets(char *s, size_t size, FILE *stream)
{
	if (!feof(stream) && fgets(s, size, stream)) {
		char *end;

		end = s + strlen(s) - 1;
                
		if (*end != '\n')
			while (!feof(stream) && (fgetc(stream) != '\n'));

		while ((*end == '\n') || (*end == '\r'))
			*end-- = '\0';
        } else
		s[0] = '\0';
}

int sqbwfix(const char *fixbase)
{
#ifndef HAS_STRFTIME
	static const char *month[] = {"Jan", "Feb", "Mar", "Apr", "May",
		"Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
	struct tm *haha;
#endif
	FILE *sqh;
	unsigned long next, attr, updated = 0;
	SQSTART startrec;
	SQHDR frame;
	XMSG header;
	char date[20], *fixname;

	fixname = malloc(strlen(fixbase) + 5);
	sprintf(fixname, "%s.sqd", fixbase);
	printf("Processing %s... ", fixname);

	sqh = fopen(fixname, "rb+");
	if (!sqh) {
		printf("could not open\n\n");
		free(fixname);
		return -1;
	}

	fread(&startrec, sizeof startrec, 1, sqh);
	next = getlong(startrec.begin_frame);

	while (next) {
		fseek(sqh, next, SEEK_SET);
		fread(&frame, sizeof frame, 1, sqh);
		fread(&header, sizeof header, 1, sqh);

		attr = getlong(header.attr);

		if (attr & MSGLOCAL) {
#ifdef HAS_STRFTIME
			strftime(date, 30, "%d %b %y  %H:%M:%S",
				getdostime(getlong(header.date_written)));
#else
			haha = getdostime(getlong(header.date_written));

			sprintf(date, "%02d %s %02d  %02d:%02d:%02d",
				haha->tm_mday, month[haha->tm_mon],
				haha->tm_year % 100, haha->tm_hour,
				haha->tm_min, haha->tm_sec);
#endif
			if (strncmp(header.__ftsc_date, date, 20)) {
				fseek(sqh, -20L, SEEK_CUR);
				fwrite(date, 20, 1, sqh);
				updated++;
			}
		}

		next = getlong(frame.next_frame);
	}

	fclose(sqh);
	printf("%ld messages updated\n\n", updated);
	free(fixname);

	return 0;
}

int main(int argc, char **argv)
{
	MAREA marea;
	FILE *etoss, *mdat;
	ECHO base, *echo;
	long skip;
	size_t blksize;
	unsigned offst;
	int result;
	char etmp[30], *zheap;

    printf("Maximus Squish base date fixer v0.3\n");
	printf("Copyright (c) 2000 William McBrine\n\n");

	result = 0;

	if (2 != argc) {
		printf("Syntax: %s echotoss.log\n", argv[0]);
		return -1;
	}

	echo = &base;
	etoss = fopen(argv[1], "r");
	if (!etoss) {
		printf("Could not open %s\n", argv[1]);
		return -1;
	}

	while (!feof(etoss)) {
		myfgets(etmp, sizeof etmp, etoss);

		if (etmp[0]) {
			echo->next = malloc(sizeof(ECHO));
			echo = (ECHO *) (echo->next);

			strncpy(echo->tag, etmp, 20);
			echo->tag[20] = '\0';

			echo->next = NULL;
		}
	};

	fclose(etoss);	

	mdat = fopen("marea.dat", "rb");
	if (!mdat) {
		printf("Could not open MAREA.DAT\n");
		return -1;
	}

	fseek(mdat, 4L, SEEK_SET);

	while (!feof(mdat)) {
		fread(&marea, sizeof marea, 1, mdat);
		skip = (sizeof(OVERRIDE)) * getshort(marea.num_override);
		if (skip)
			fseek(mdat, skip, SEEK_CUR);
		blksize = getshort(marea.cbHeap);
		zheap = malloc(blksize);
		fread(zheap, blksize, 1, mdat);

		offst = getshort(marea.echo_tag);

		echo = &base;
		while (echo->next) {
			echo = (ECHO *) (echo->next);
			if (!strncmp(echo->tag, zheap + offst, 20) &&
			    (2 == getshort(marea.type))) {
				printf("Echotag: %s\n", zheap + offst);
				result += sqbwfix(zheap +
					getshort(marea.path));
				break;
			}
		}

		free(zheap);
	}
	fclose(mdat);

	return result;
}
