//<c>   Copyright 1998-1999 by Gerry J. Danen; all rights reserved.

//<t>   Convert Squish Message Bases to HTML

//      Compiled with Microsoft C 8.00. Requires DANEN library and
//      Squish Developers Kit Version 2.00 (SQDEV200.ZIP) to recompile.
//      Source released into the Public Domain.


#include"gd_tools.h"
#include"gd_extrn.h"
#include"gd_ansi.h"
#include"msgapi.h"              // from Squish Developers Kit v2.00


#define pgVERS_ "V1.00b"
#define pgTITL_ "Convert Squish Message Base to HTML"
#define pgCOPR_ "1998"

#define DEBUG   0

#if     (! LARGE_MODEL)
  #error LARGE MEMORY MODEL REQUIRED
#endif


#define HTML_FONT               "Verdana, Arial, Helvetica"
#define HTML_BG                 "bg_y2k.gif"    // "/_support/bg_y2k.gif"
#define BUFSIZE                 4096
#define PREV_INIT_STRING        "**!@#$%^&(abc)_+**"
#define MAXKEY                  140


//      variables starting with SQ are used by the Squish message API
char    *SQbufr, *SQctrl,
        cLast='\xFF', cMarker='\xFE', sMarker[]="\xFE", cmd[1025], msFrom[XMSG_FROM_SIZE*2],
        msSubj[XMSG_SUBJ_SIZE*2], msTo[XMSG_TO_SIZE*2], msDate[12], msTime[8],
        sArchiveName[FS_LEN], sMsgOut[FS_LEN], sPrefix[5], sSQD[FS_LEN],
        sSortWork[]="SQ$SORT.$$$", sTmp[FS_LEN],
        sTopOut[FS_LEN], sPrevSubj[XMSG_SUBJ_SIZE*2]=PREV_INIT_STRING ;
int     iLongestKey=0, iKeySizeErrors=0 ;
FILE    *fTop, *fMsg, *fTmp, *fWrk ;
ULONG   nTotalMessages=0, nThisMsg=0, nTopicNumber=0, nTotalTopics=0,
        nEarlyDate=999999999 ;
BOOL    ynProcess ;
XMSG    SQmsg ;
HAREA   SQhArea ;
HMSG    SQhMsg ;
dword   SQoffset ;
long    SQgot ;
int     SQmsgtype, SQctrlsize ;
struct _minf SQmi ;


//      function definitions
void    main(int argc,char *argv[]);
void    help(void);
void    init(STRING par1,STRING par2);
void    phase_1(void);
void    phase_2(void);
void    phase_3(void);
void    finish(void);
void    format_header_field(STRING pDest,STRING pFrom,STRING pXlate);


// ---- User Help ----------------------------------------------------------- //~~~

void    help( void )
{
    printf(
        "%s converts a Squish message base to a set of HTML pages, \n"
        "and a top index to control access to individual pages.\n\n"
        "%s needs 2 parameters: the name of the .SQ? database, and the name of the\n"
        "top level index.\n\n"
        "Example: %s 2000 y2kmess\n\n"
        "This will read 2000.SQ*, and create Y2KMESS.HTM, along with Y2KM0001.HTM,\n"
        "Y2KM0002.HTM, Y2KM0003.HTM, etc.\n\n"
        "The created pages are best viewed with IE4 and later, as it uses font styles.\n"
        "Netscape and other browser users should experiment with default fonts to get\n"
        "pages to show nicely. Try the Verdana/Arial/Helvetica fonts with 8 and 10pt\n"
        "size. Verdana 8pt and Arial 10pt worked well in our tests.\n\n",
        get_global_program_name(), get_global_program_name(), get_global_program_name() );
    exit( GD_ERROR_HELP );
}



void    write_temp( FILE *ff, ULONG msgnum, STRING subj, STRING fr, STRING to, STRING dt, ULONG d, ULONG early )
{
    static UCHAR key[161], sub[sizeof(msSubj)], sdt[9], smn[9] ;

    sprintf( sdt, "%08ld", d );
    sprintf( smn, "%05lu", msgnum );
    ST_CPY( key, subj );
    st_keep_only_alnum( key );
    format_header_field( sub, subj, "!^*_" );
    ST_CAT( key, sub );
    ST_CAT( key, sdt );
    ST_CAT( key, smn );
    strupr( key );
    if ( (int) strlen(key) > iLongestKey )
        iLongestKey = strlen(key);
    if ( (int) strlen(key) > (int) MAXKEY )
        iKeySizeErrors ++ ;
    ST_CAT( key, "                                                                                                                                " );
    key[MAXKEY] = EOS ;
    fprintf( ff, "%s%c%lu%c%s%c%s%c%s%c%s%c%lu\n",
                 key,    cMarker,
                 msgnum, cMarker,
                 subj,   cMarker,
                 fr,     cMarker,
                 to,     cMarker,
                 dt,     cMarker,
                 early );
#if DEBUG
// printf("wt> %d %s %s %s %s\n", (int) msgnum, subj, fr, to, dt );
#endif
}


void    format_header_field( STRING pDest, STRING pFrom, STRING pXlate )
{
    strcpy( pDest, pFrom );
    st_xlate( pDest, pXlate, "" );
    st_reduce_spaces( pDest );
    st_trim ( pDest );
    st_uplow( pDest );

//  remove leading and trailing junk characters
    while ( *pDest != EOS )                     // leading character check
    {
        if ( isalnum(*pDest) )
            break ;
        if ( *pDest == '\"' ||
             *pDest == '`' ||
             *pDest == '$' ||
             *pDest == '[' ||
             *pDest == '(' )
            break ;
        *pDest = ' ' ;
        st_trim ( pDest );
    }
    while ( ST_LASTCHAR(pDest) != EOS )         // trailing character check
    {
        if ( isalnum(ST_LASTCHAR(pDest)) )
            break ;
        if ( ST_LASTCHAR(pDest) == '\"' ||
             ST_LASTCHAR(pDest) == '\'' ||
             ST_LASTCHAR(pDest) == '`' ||
             ST_LASTCHAR(pDest) == '?' ||
             ST_LASTCHAR(pDest) == ']' ||
             ST_LASTCHAR(pDest) == ')' )
            break ;
        ST_CLR_LASTCHAR(pDest);
        st_trim ( pDest );
    }
}


void    format_date( UCHAR date[] )
{
    date[2] = date[6] = ' ' ;
    if ( date[0] == '0' )
        date[0] = ' ' ;
    st_trim( date );
}


long    format_header_data( STRING sub, STRING frm, STRING to, STRING dt, STRING tm )
{
    static long d, m, y, hh, mm, ss, nDt ;
    static char sTm[8], sDt[12] ;

    format_header_field( frm, SQmsg.from, "." );
    format_header_field( to , SQmsg.to  , "." );
    format_header_field( sub, SQmsg.subj, "!^*_" );

    st_get_word( cmd, sub );
    if ( st_eq( cmd, "re" ) || st_eq( cmd, "re:" ) )
        st_remove_word( sub );                  // remove first word in string

    d   = SQmsg.date_written.date.da ;
    m   = SQmsg.date_written.date.mo ;
    y   = SQmsg.date_written.date.yr+1980 ;

    nDt = (long) (y*10000+m*100+d) ;

    hh  = SQmsg.date_written.time.hh ;
    mm  = SQmsg.date_written.time.mm ;
    ss  = SQmsg.date_written.time.ss ;

    FormatTime( ((INT32) ((hh*100)+mm)), sTm, 2, 0 );
    FormatDate( ((INT32) nDt), sDt, 9 );
    format_date( sDt );
    if ( sTm[0] == '0' )  sTm[0] = ' ' ;
    st_trim( sTm );
    strcpy( dt, sDt );
    strcpy( tm, sTm );
    return( nDt );
}



// ---- Message File Processing --------------------------------------------- //~~~

void    new_message_file( void )
{
    sprintf( sMsgOut, "%s%04d.HTM", sPrefix, nTopicNumber );
    fMsg = fopen( sMsgOut, "w" );
    if ( ! fMsg )
    {
        fprintf( stderr, "\rCannot create %s\a\n", sMsgOut );
        exit( GD_ERROR_CANNOT_OPEN_FOR_WRITE );
    }
    fprintf( stderr, "\rCreating %s", sMsgOut );

    fprintf( fMsg, "<html><head><title>%s: %s</title>"
                   "<meta name=\"GENERATOR\" content=\"%s %s\"></head><body>\n",
                   sArchiveName, msSubj, pgm_name, pgm_vers );
}


void    process_message( long len )
{
    register int x ;
    register char c ;

    ynProcess = TRUE ;
    LOOP( x, 0, (len-1), 1 )
    {
        c = SQbufr[x] ;
        if ( c == '\0' || c == '\x01' )         // ASCII 00 or 01
        {
            ynProcess = FALSE ;
            return ;
        }
        // skip linefeeds ('\n') and soft returns ('\x8d') from older apps
        if ( c != '\n' && c != '\x8d' )
        {
            if ( c == '\r' )
                cLast = '\n' ;
            else
                cLast = c ;
            if ( cLast == '\n' )
                fprintf( fMsg, "<br>\n" );
            else
                fprintf( fMsg, "%s", ht_ch2html(cLast, cmd) );
        }
    }
}


void    process_message_exit( void )
{
    fprintf( fMsg, "\n</font></strong></td></tr></table></div>\n" );
}


void    close_message_file( void )
{
    if ( nTopicNumber > 0 )
    {
        fprintf( fMsg, "</body></html>\n" );
        fclose( fMsg );
    }
}


// ---- Open/Close Index HTML file ------------------------------------------ //~~~

void    open_index_html( void )
{
    fTop = fopen( sTopOut, "w" );
    if ( ! fTop )
    {
        fprintf( stderr, "\rCannot create %s\a\n", sTopOut );
        exit( GD_ERROR_CANNOT_OPEN_FOR_WRITE );
    }

    fprintf( fTop,
             "<html><head><meta name=\"GENERATOR\" content=\"%s %s\">\n"
             "<title>Message Archive %s - Index</title></head>"
             "<body background=\"%s\" bgcolor=\"#D0FFFF\">\n",
             pgm_name, pgm_vers, sArchiveName, HTML_BG );
    fprintf( fTop,
             "<table border=\"9\" width=\"100%%\" cellspacing=\"0\" "
             "bgcolor=\"#FFFFB0\">\n<tr><td width=\"100%%\">"
             "<p align=\"center\"><font face=\"%s\" size=\"5\" "
             "color=\"#FF0000\"><strong>Message Archive %s</strong>"
             "</font></td></tr></table>\n",
             HTML_FONT, sArchiveName );
    fprintf( fTop,
             "<p align=\"center\"><font size=\"2\" face=\"Arial\">"
             "<strong>%lu</strong> messages in <strong>%lu</strong> "
             "topics</font></p>\n<table border=\"0\" width=\"100%%\" "
             "cellspacing=\"0\" valign=\"middle\" style=\"font-family: "
             "%s; font-size: 8pt\">\n",
             nTotalMessages, nTotalTopics, HTML_FONT );
    fprintf( fTop,
             "<tr><td>&nbsp;</td><td><strong>Topic</strong></td>"
             "<td><strong>Date</strong></td>"
             "<td align=\"right\"><strong>#</strong></td></tr>\n" );
}


void    close_index_html( void )
{
    UCHAR       temp[81], date[21] ;

    strcpy( cmd, pgm_copyrite );
    st_get_word( temp, cmd );
    st_remove_word( cmd );
    strcpy( date, TodaysCDate() );
    format_date( date );

    fprintf( fTop,
             "</table><hr><font color=\"#000080\" size=\"1\" "
             "face=\"Arial, Verdana, Helvetica\"><strong>"
             "Created by %s %s on %s<br>%s %s %s.</strong><br>\n"
             "Send e-mail to <a href=\"mailto:gdanen@bigfoot.com?subject="
             "Improving %s %s\">Gerry Danen</a> for suggestions on how to "
             "improve this program.<br>\n"
             "Best viewed with Internet Explorer 4.0 and higher.<br>"
             "</font></body></html>\n",
             pgm_name, pgm_vers, date, temp, "&copy;", cmd,
             pgm_name, pgm_vers );
    fclose( fTop );
}


void    open_temp_for_writing( void )
{
    fTmp = fopen( sTmp, "w" );
    if ( ! fTmp )
    {
        fprintf( stderr, "\rCannot create temporary file %s...\a\n", sTmp );
        exit( GD_ERROR_CANNOT_OPEN_FOR_WRITE );
    }
}


void    open_sorted_file( void )
{
    fWrk = fopen( sSortWork, "r" );
    if ( ! fWrk )
    {
        fprintf( stderr, "\rCannot open sort file %s for reading...\a\n", sSortWork );
        exit( GD_ERROR_CANNOT_OPEN_FOR_READ );
    }
}


// ---- Initialization ------------------------------------------------------ //~~~

void    init( STRING par1, STRING par2 )
{
    ST_CPY( sSQD,    par1 );
    ST_CPY( sTopOut, par2 );
    ST_CPY( sPrefix, par2 );
    strupr( sSQD );
    ST_CPY( sArchiveName, sSQD );
    strlwr( sTopOut );
    strlwr( sPrefix );
    ST_CAT( sSQD,    ".SQD" );
    ST_CAT( sTopOut, ".HTM" );

    sprintf( sTmp, "%s.TMP", get_global_program_name() );  // temp file for indexing

    MsgOpenApi( &SQmi );
    SQmsgtype = MSGTYPE_SQUISH ;

    if ( (SQhArea = MsgOpenArea(par1, MSGAREA_NORMAL, SQmsgtype)) == NULL )
    {
        fprintf( stderr, "Cannot open message area \"%s\" for reading!\a\n", par1 );
        exit( GD_ERROR_CANNOT_OPEN_FOR_READ );
    }

    MsgLock( SQhArea );

    if ( (SQbufr = malloc(BUFSIZE)) == NULL )
    {
        fprintf( stderr, "Out of memory...\n" );
        exit( 1 );
    }

    nTotalMessages = (ULONG) MsgHighMsg(SQhArea);
}


// ---- Phase 1: Create Temp file with an entry for each message ------------ //~~~

void    phase_1( void )
{
    long        nDt ;

    fprintf( stderr, "\nPhase 1: reading message base and creating temporary file %s\n", sTmp );
    fprintf( stderr, "Processing %lu messages\n", nTotalMessages );

    open_temp_for_writing();

    for ( nThisMsg = 1L; nThisMsg <= MsgHighMsg(SQhArea); nThisMsg ++ )
    {
        if ( (SQhMsg = MsgOpenMsg(SQhArea,MOPEN_READ,(dword)nThisMsg)) == NULL )
            continue;

        SQctrlsize = (int)MsgGetCtrlLen(SQhMsg);
        if ( (SQctrl = malloc(SQctrlsize)) == NULL )
            SQctrlsize = 0 ;

        //  read control information
        MsgReadMsg( SQhMsg, &SQmsg, 0L, 0L, NULL, SQctrlsize, SQctrl );

        nDt = format_header_data( msSubj, msFrom, msTo, msDate, msTime );
        write_temp( fTmp, nThisMsg, msSubj, msFrom, msTo, msDate, nDt, nDt );

        if ( SQctrl )
            free( SQctrl );

        MsgCloseMsg( SQhMsg );
    }
    fclose( fTmp );

#if DEBUG
system( "copy sq.tmp d:\\sq1.tmp >nul" );
#endif

    fl_delete( sSortWork );
    fprintf( stderr, "Sorting %s\n", sTmp );
    sprintf( cmd, "sorttext %s %s >nul", sTmp, sSortWork );
    system( cmd );

#if DEBUG
sprintf( cmd, "copy %s %s >nul", sSortWork, "d:\\sq1.srt" ); system( cmd );
#endif
}


// ---- Phase 2: Fix Topic info on Temp file -------------------------------- //~~~

void    phase_2( void )
{
    char        msgnum[11], subj[sizeof(msSubj)], dt[20],
                cmdx[sizeof(cmd)], saved[sizeof(cmd)], sYMD[20] ;
    ULONG       nYMD ;
    int         iMessNumber=0 ;

    fprintf( stderr, "\nPhase 2: adding topic headers to %s\n", sTmp );

    open_sorted_file();
    open_temp_for_writing();

    strcpy( sPrevSubj, PREV_INIT_STRING );
    iMessNumber = 0 ;

    while ( fgets( cmd, (sizeof(cmd)-1), fWrk ) )
    {
        strcpy( saved, cmd );                   // save for later writing
        st_trim( cmd );
        if ( strlen(cmd) )
        {
            iMessNumber ++ ;
            SplitString( cmd , sMarker, subj  , cmdx );  // key
            SplitString( cmdx, sMarker, msgnum, cmd  );  // message number
            SplitString( cmd , sMarker, msSubj, cmdx );  // subject
            SplitString( cmdx, sMarker, msFrom, cmd  );  // from
            SplitString( cmd , sMarker, msTo  , cmdx );  // to
            SplitString( cmdx, sMarker, dt    , cmd  );  // date in text format
            ST_CPY( sYMD, cmd );                // date in ymd format
            nYMD = atol(sYMD);

            if ( ! st_eq(sPrevSubj, msSubj) )
            {
                if ( ! st_eq(sPrevSubj, PREV_INIT_STRING) )
                {
                    write_temp( fTmp, (ULONG)(iMessNumber-1), sPrevSubj, "*", "*", "*", (ULONG) 0, nEarlyDate );
                    nTotalTopics ++ ;
                }
                iMessNumber = 1 ;
                strcpy( sPrevSubj, msSubj );
                nEarlyDate = nYMD ;
            }
            fprintf( fTmp, "%s", saved );       // write original record
        }
    }

    if ( iMessNumber > 0 )
    {
        write_temp( fTmp, (ULONG)iMessNumber, sPrevSubj, "*", "*", "*", (ULONG) 0, nEarlyDate );
        nTotalTopics ++ ;
    }

    fclose( fTmp );
    fclose( fWrk );
    fprintf( stderr, "Found %lu topics\n", nTotalTopics );

#if DEBUG
    system( "copy sq.tmp d:\\sq2.tmp >nul" );
#endif

    fl_delete( sSortWork );
    fprintf( stderr, "Sorting %s\n", sTmp );
    sprintf( cmd, "sorttext %s %s >nul", sTmp, sSortWork );
    system( cmd );

#if DEBUG
sprintf( cmd, "copy %s %s >nul", sSortWork, "d:\\sq2.srt" ); system( cmd );
#endif
}


// ---- Phase 3: Produce the HTML files ------------------------------------- //~~~

void    phase_3( void )
{
    char        msgnum[11], subj[sizeof(msSubj)], dt[20],
                cmdx[sizeof(cmd)], sYMD[20],
                fr[sizeof(msFrom)], to[sizeof(msTo)] ;
    ULONG       nYMD ;
    int         iMsg = 0, iMessagesInTopic = 0 ;

    fprintf( stderr, "\nPhase 3: creating html files\n" );

    open_sorted_file();
    open_index_html();

    strcpy( sPrevSubj, PREV_INIT_STRING );
    nTopicNumber = 0 ;

    while ( fgets( cmd, (sizeof(cmd)-1), fWrk ) )
    {
        st_trim( cmd );
        if ( strlen(cmd) )
        {
            SplitString( cmd , sMarker, subj  , cmdx );  // key
            SplitString( cmdx, sMarker, msgnum, cmd  );  // message number
            SplitString( cmd , sMarker, msSubj, cmdx );  // subject
            SplitString( cmdx, sMarker, msFrom, cmd  );  // from
            SplitString( cmd , sMarker, msTo  , cmdx );  // to
            SplitString( cmdx, sMarker, dt    , cmd  );  // date in text format
            ST_CPY( sYMD, cmd );                // date in ymd format

            nThisMsg = atol(msgnum);
            nYMD = atol(sYMD);
            FormatDate( ((INT32) nYMD), sYMD, 9 );
            format_date( sYMD );

            ht_str2html( subj, msSubj );
            ht_str2html( fr  , msFrom );
            ht_str2html( to  , msTo   );

            if ( ! st_eq(sPrevSubj, msSubj) )   // header record
            {
                nTopicNumber ++ ;
                iMsg = 0 ;
                iMessagesInTopic = (int) nThisMsg ;
                fprintf( fTop,
                         "<tr><td align=\"right\">%lu</td>"
                         "<td><a href=\"%s%04lu.htm#1\">%s</a></td>"
                         "<td>%s</td>"
                         "<td align=\"right\">%ld</td></tr>\n",
                         nTopicNumber, sPrefix, nTopicNumber, subj, sYMD, nThisMsg );
                close_message_file();
                new_message_file();
                strcpy( sPrevSubj, msSubj );
            }
            else                                // message record
            {
                if ( (SQhMsg = MsgOpenMsg(SQhArea,MOPEN_READ,(dword)nThisMsg)) != NULL )
                {
                    SQctrlsize = (int)MsgGetCtrlLen(SQhMsg);

                    if ( (SQctrl = malloc(SQctrlsize)) == NULL )
                        SQctrlsize = 0 ;

                    //  read control information
                    MsgReadMsg( SQhMsg, &SQmsg, 0L, 0L, NULL, SQctrlsize, SQctrl );

                    format_header_data( msSubj, msFrom, msTo, msDate, msTime );
                    ht_str2html( cmd, msSubj );  ST_CPY( msSubj, cmd );
                    ht_str2html( cmd, msFrom );  ST_CPY( msFrom, cmd );
                    ht_str2html( cmd, msTo   );  ST_CPY( msTo  , cmd );

// msg header
                    iMsg ++ ;
                    fprintf( fMsg,
                             "<font size=\"1\" face=\"%s\"><small><small><small>"
                             "<a name=\"%d\">%d/%d</a></small></small></small><br>"
                             "<table border=\"1\" width=\"100%%\" cellspacing=\"0\">"
                             "<tr><td><table border=\"0\" width=\"100%%\" cellspacing=\"0\" "
                             "cellpadding=\"0\"><tr><td width=\"90%%\" bgcolor=\"#FFFFB0\">"
                             "<strong><font size=\"2\" face=\"%s\">%s</font></strong></td>"
                             "<td width=\"10%%\" bgcolor=\"#FFFFB0\"><p align=\"right\">"
                             "<font size=\"1\" face=\"%s\">%lu</font></td></tr></table>\n",
                             HTML_FONT, iMsg, iMsg, iMessagesInTopic, HTML_FONT, msSubj, HTML_FONT, nThisMsg );
                    fprintf( fMsg,
                             "<table border=\"0\" width=\"100%%\" cellspacing=\"0\" "
                             "cellpadding=\"0\"><tr><td width=\"41%%\"><font size=\"2\" "
                             "face=\"%s\" color=\"#0000A0\"><strong>%s</strong></font></td>"
                             "<td width=\"35%%\"><font size=\"1\" face=\"%s\"><strong>"
                             "To %s</strong></font></td><td width=\"24%%\">"
                             "<p align=\"right\"><font size=\"1\" face=\"%s\">%s %s"
                             "</font></td></tr></table></td></tr></table>\n",
                             HTML_FONT, msFrom, HTML_FONT, msTo, HTML_FONT, msDate, msTime );
// msg body
                    fprintf( fMsg,
                             "<div align=\"right\"><table border=\"0\" width=\"95%%\" "
                             "cellspacing=\"0\"><tr><td width=\"100%%\" bgcolor=\"#D0FFFF\" "
                             "background=\"%s\"><strong><font size=\"1\" face=\"%s\">\n",
                             HTML_BG, HTML_FONT );

                    cLast = '\n' ;

                    //  read message in blocks of BUFSIZE
                    for ( SQoffset = 0L ; SQoffset < MsgGetTextLen(SQhMsg) ; )
                    {
                        SQgot = MsgReadMsg( SQhMsg, NULL, SQoffset, BUFSIZE, SQbufr, 0L, NULL );

                        if ( SQgot <= 0 )
                            break;

                        process_message( SQgot );
                        if ( ! ynProcess )
                            break ;

                        SQoffset += SQgot;
                    }

                    process_message_exit();

                    if ( SQctrl )
                        free( SQctrl );

                    MsgCloseMsg( SQhMsg );
                }
            }
        }
    }

    close_message_file();
    close_index_html();
}


// ---- Finish up ----------------------------------------------------------- //~~~

void    finish( void )
{
    free( SQbufr );
    MsgCloseArea( SQhArea );
    MsgCloseApi();

    fprintf( stderr, "\n%lu topic pages created...\n"
                     "Longest sort key is %d characters.\n",
                     nTotalTopics, iLongestKey );

    if ( iKeySizeErrors > 0 )
        fprintf( stderr, "\a%d RECORDS EXCEED KEY LENGTH OF %d\n\n"
                         "You need to recompile the program and increase MAXKEY!\a\n",
                         iKeySizeErrors, MAXKEY );

    fprintf( stderr, "E-mail comments to gdanen@bigfoot.com\n\n" );

    fcloseall();
}


// ---- Main ---------------------------------------------------------------- //~~~

void    main( int argc, char *argv[] )
{

    tt_init( SHAREWARE_VERSION, 0, pgVERS_, pgTITL_, pgCOPR_ );
    ansi_cls( 2, stderr );
    logon(1);
    fprintf( stderr, "Portions Copyright 1989-1994 by SCI Communications.\n\n" );

    if ( argc != 3 )
        help();

    init( argv[1], argv[2] );
    phase_1();
    phase_2();
    phase_3();
    finish();

#if ! DEBUG
    fl_delete( sTmp );
    fl_delete( sSortWork );
#endif

    exit( GD_ERROR_NONE );
}
