/*
 * SMTP.C SMTP daemon for OS/2 using EMX.  (c) 1995 Pete Appleton. Code is
 * subject to GNU license conditions.   createunique() adapted from Dr. Niel
 * Kempson's deliver.exe
 */

/******************************************************************

  Modified to make *.BAG compatible email bundles
  jfesler@gigo.com 5/95
  - Original code made up to 100 individual files, one per
    recipient; envelope information was not preserved.
  - Modified version makes one single file, in unix lf format,
    starting with "#! rmail 0 recipient1 recipient2 ...
    (0 indicates, for our purposes, that the size is unknown
    but there will be no other messages in that file).
  - *.BAG files are created for the temp files
  - Also, mail coming in for _any_ domain (I mean, _any_!)
    will be accepted.

  - 8/11/95 - Fixed the !@#$! memory leaks, in strip_crlf
    and createuniq (allocated memory, but never freed it).
  - Finished removing unused options.  Also, ported for
    simple NNTP receiving (packaged seperately).
  - Modifications to allow for sites that don't have a valid hostname()
    to still function (their hostname is created on the fly, simply
    their IP address).  Old code:  bombed on the NULL.


******************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/*
 * #include <os2.h>
 */
#include <sys\types.h>
#include <sys\socket.h>
#include <netinet\in.h>
#include <sys\ioctl.h>
#include <arpa\inet.h>
#include <unistd.h>
#include <netdb.h>
#include <fcntl.h>
#include <io.h>
#include <share.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <signal.h>
#include <time.h>
#include <setjmp.h>
#include "smtpd.h"
#include "match.h"

#define PORT 25
#define TIMEOUT 300

int             inetd = 0;
int             colonhack = 0;
/* Can't someone just do a "#include *" extension? */

int             hsock_in, hsock_out;	/* socket descriptors, kept global
					 * for close routines */
int             daemon_stat;	/* daemon status, ditto */

void            closein(void);
void            closeout(void);
void            stripcrlf(char *);

int             alarmhit = 0;
int             debug = 0;
char            colorstring[256];

void
myhandler(int sig)
{
	alarmhit = sig;
	signal(sig, SIG_ACK);
	switch (sig) {
	case SIGPIPE:
		fprintf(stderr, "SIGNAL %i: Broken pipe (they disconnected)\n", sig);
		break;
	case SIGALRM:
		fprintf(stderr, "SIGNAL %i: Alarm (timeout)\n", sig);
		break;
	default:
		fprintf(stderr, "SIGNAL %i: Unhandled signal\n", sig);
		break;
	}
}

jmp_buf         jbuf;

int
quiethandler(int sig)
{
	alarmhit = sig;
	signal(sig, SIG_ACK);
	printf("No identd; longjmp'ing\n");
	longjmp(&jbuf, 1);
}


char           *
datestring(char *s)
{
	static char     buf[150];
	struct tm      *time_now;
	time_t          secs_now;

	tzset();
	time(&secs_now);
	time_now = localtime(&secs_now);
	strftime(buf, sizeof(buf) - 1, s, time_now);
	return buf;
}


void
doingnews(int i)
{
	FILE           *file;
	char            buf[256];
	if (getenv("MAILSTAT"))
		strcpy(buf, getenv("MAILSTAT"));
	else
		return;
	file = fopen(buf, "wt");
	printf("Updating status file %s\n", buf);
	if (file) {
		if (i)
			fprintf(file, "SMTPD_Email Rcv'g since %s\n", datestring("%H:%M"));
		else
			fprintf(file, "SMTPD_Email idle since %s\n", datestring("%H:%M"));
		fclose(file);

	}
}

char            lastuser[256];

void
iduser(int portin, struct sockaddr_in * idsout)
{
	int             s, a, b, c, d;
	char            buf[256];
	char           *p;
	struct sockaddr_in sin;
	FILE           *fi;
	FILE           *fo;
	int             i;

	memset(&sin, 0, sizeof(sin));
	memset(lastuser, 0, sizeof(lastuser));

	if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		fprintf(stderr, "Unable to open outgoing socket for identd\n");
	}
	/*
	 * printf("Socket number for identd to use: %u\n", s);
	 */
	sin.sin_family = AF_INET;
	sin.sin_port = htons(113);
	memcpy(&(sin.sin_addr), &(idsout->sin_addr), 8);
	d = (sin.sin_addr.s_addr & 0xff000000) / 0x1000000;
	c = (sin.sin_addr.s_addr & 0xff0000) / 0x10000;
	b = (sin.sin_addr.s_addr & 0xff00) / 0x100;
	a = (sin.sin_addr.s_addr & 0xff);
	/*
	 * printf("Checking_%u.%u.%u.%u:%u\n", a, b, c,
	 * d,ntohs(idsout->sin_port));
	 */


	if (setjmp(&jbuf) != 0) {
		/* timeout */
		i = close(s);	/* release socket */
		printf("setjmp returned back due to an alarm\n");
		return;
	}
	signal(SIGPIPE, quiethandler);
	signal(SIGALRM, quiethandler);
	alarm(15);
	if (connect(s, &sin, sizeof(sin)) < 0) {
		/* no identd server on remote machine */
		i = close(s);	/* release socket */
		return;
	}
	alarm(0);
	signal(SIGPIPE, myhandler);
	signal(SIGALRM, myhandler);
	sprintf(buf, "%u, %u\r\n", ntohs(idsout->sin_port), portin);
	fo = fdopen(s, "w");
	fi = fdopen(s, "r");
	if (!fo) {
		printf("Can't open output stream\n");
		exit(1);
	}
	if (!fi) {
		printf("Can't open input stream\n");
		exit(1);
	}
	sosend(fo, buf);
	soread(fi, buf);

	/* printf(buf); */

	p = strtok(buf, ":");	/* port numbers */
	p = strtok(NULL, ":");	/* info */
	p = strtok(NULL, ":");	/* system type */
	p = strtok(NULL, ": \r\n");	/* user */
	if (p) {
		/* printf("User name is %s\n",p); */
		strcpy(lastuser, p);
	}
	close(s);
	fclose(fi);
	fclose(fo);
}

char           *
trythis(int socket, int portnum)
{
	int             length;
	struct sockaddr sa;
	struct sockaddr_in *sin = (struct sockaddr_in *) & sa;
	struct hostent *hp;
	static char     host_name[256];
	length = sizeof(sa);

	if (getpeername(socket, &sa, &length) < 0) {
		/* function failed, example errno, whatever... */
		return "foobar";
		/* exit(), return, break and so forth */
	}
	/* Now, resolve the address */

	hp = gethostbyaddr((char *) &sin->sin_addr.s_addr,
			   sizeof(sin->sin_addr.s_addr),
			   AF_INET);
	strcpy(host_name, (char *) (hp ? hp->h_name : inet_ntoa(sin->sin_addr)));

	if (inetd)
		printf("%sSMTP:%5u>>> Incoming connection is from %s\n", colorstring, inetd, host_name);
	else
		printf("Incoming connection is from %s\n", host_name);

	signal(SIGPIPE, quiethandler);
	signal(SIGALRM, quiethandler);
	alarm(15);
	/* iduser(portnum, sin); */
	alarm(0);

	signal(SIGPIPE, myhandler);
	signal(SIGALRM, myhandler);

	if (lastuser[0]) {
		if (inetd)
			printf("%sSMTP:%5u>>> identd reports %s\n", colorstring, inetd, lastuser);
		else
			printf("identd reports %s\n", lastuser);

	}
	return host_name;
}

char           *
sendok(char *theirname, char *sender, char *recipient)
{
	static char     results[1024];
	static char     buffer[1024];
	char           *p1, *p2, *p3, *p4, *p5;
	FILE           *file;
	int             linenum = 0;

	strcpy(results, "250 OK\r\n");
	file = fopen("/tcpip/etc/smtpd.ok", "rt");
	if (!file) {
		printf("Could not open /tcpip/etc/smtpd.ok\n");
		return results;
	}
	while (!feof(file)) {
		memset(buffer, 0, sizeof(buffer));
		fgets(buffer, sizeof(buffer), file);
		linenum++;
		p1 = strtok(buffer, " \x09");	/* symbol */
		p2 = strtok(NULL, " \x09");	/* host */
		p3 = strtok(NULL, " \x09");	/* sender */
		p4 = strtok(NULL, " \x09");	/* recipient */
		p5 = strtok(NULL, "\r\n");	/* remainder */
		if (!p1)
			continue;
		if (*p1 == '#')
			continue;
		if (*p1 != '+')
			if (*p1 != '-')
				if (*p1 != '=') {
					printf("Invalid token in smtpd.ok file line %u\n", linenum);
					continue;
				}
		if (!p4) {
			printf("Invalid number of tokens in smtpd.ok file line %u\n", linenum);
			continue;
		}
		if (*p1 != '+')
			if (!p5) {
				printf("Invalid number of tokens in smtpd.ok file line %u\n", linenum);
				continue;
			}
		/* wildcards first  */
		if (match(p2, theirname))
			if (match(p3, sender))
				if (match(p4, recipient)) {
					if (!p5)
						p5 = "";
					if (debug == 2)
						printf("**** match on **** %s %s %s %s %s\n", p1, p2, p3, p4, p5);
					if (*p1 == '=') {
						strcpy(results, p5);
						strcat(results, "\r\n");
						goto quit;
					}
					if (*p1 == '+') {
						strcpy(results, "250 OK\r\n");
					}
					if (*p1 == '-') {
						strcpy(results, p5);
						strcat(results, "\r\n");
					}
				}
	}

quit:
	fclose(file);
	return results;

}

void
main(int argc, char *argv[])
{
	char            buffer[80];
	char           *hostname;
	char            hostidbuf[256];	/* used when hostname returns NULL */
	char            dlvr_agent[256];
	struct sockaddr_in sock_in, sock_out;
	struct hostent *hoststruct;
	char            theirname[256];
	FILE           *fi, *fo;
	int             dlvr_type, i, x;
	unsigned char   a, b, c, d;
	time_t          t;
	char           *p;

	int             processconnection(char *, char *, FILE *, FILE *, int, char *);
	void            usage(char *);

	i = getpid() % 14;
	switch (i) {
	case 0:
		strcpy(colorstring, "[0;31m");
		break;
	case 1:
		strcpy(colorstring, "[0;32m");
		break;
	case 2:
		strcpy(colorstring, "[0;33m");
		break;
	case 3:
		strcpy(colorstring, "[0;34m");
		break;
	case 4:
		strcpy(colorstring, "[0;35m");
		break;
	case 5:
		strcpy(colorstring, "[0;36m");
		break;
	case 6:
		strcpy(colorstring, "[0;37m");
		break;
	case 7:
		strcpy(colorstring, "[0;1;31m");
		break;
	case 8:
		strcpy(colorstring, "[0;1;32m");
		break;
	case 9:
		strcpy(colorstring, "[0;1;33m");
		break;
	case 10:
		strcpy(colorstring, "[0;1;34m");
		break;
	case 11:
		strcpy(colorstring, "[0;1;35m");
		break;
	case 12:
		strcpy(colorstring, "[0;1;36m");
		break;
	case 13:
		strcpy(colorstring, "[0;1;37m");
		break;
	}


	signal(SIGPIPE, myhandler);
	signal(SIGALRM, myhandler);
	gethostname(buffer, 80);
	hoststruct = gethostbyname(buffer);
	a = hoststruct->h_addr[0];
	b = hoststruct->h_addr[1];
	c = hoststruct->h_addr[2];
	d = hoststruct->h_addr[3];
	if (hoststruct->h_name == NULL) {	/* no name */
		hoststruct->h_name = hostidbuf;
		sprintf(hostidbuf, "%i.%i.%i.%i", a, b, c, d);
	}
	hostname = strdup(hoststruct->h_name);
	if (argc == 2) {
		if (stricmp(argv[1], "-t")) {
			usage(argv[0]);
			exit(1);
		}
		/* we *are* in test mode.. */
		dlvr_type = DONTSPOOL;
	} else {
		dlvr_type = SPOOLDIRECT;
		strcpy(dlvr_agent, ".\\");
		for (i = 1; i < argc; i++) {
			p = argv[i];
			if (!p)
				continue;

			if (stricmp(p, "-p") == 0) {
				i++;
				p = argv[i];
				strcpy(dlvr_agent, p);
				if (*p)
					if (p[strlen(p) - 1] == '\\')
						p[strlen(p) - 1] = 0;
			} else if (stricmp(p, "-:") == 0) {
				colonhack = 1;
			} else if (stricmp(p, "-s") == 0) {
				i++;
				p = argv[i];
				inetd = atol(p);
				printf("%sSMTP:%5u--- SMTP Daemon Starting\n",
				       colorstring, inetd);
			} else {
				printf("SMTPD: Invalid option \"%s\"\n", p);
				usage(argv[0]);
				exit(1);
			}
		}
	}
	if (!inetd) {
		printf("\x1b[0;1;36mSMTP Daemon for GIGO 6/10/95 (C) 1995 Jason Fesler.\n");
		printf("\x1b[0;36mOriginal code (C) 1995 Pete Appleton, and subject to GNU license.\n");

		printf("\x1b[0;1;33m");	/* bright for warnings! */
		hsock_in = socket(AF_INET, SOCK_STREAM, 0);
		memset(&sock_in, 0, sizeof(sock_in));
		i = 1;
		x = setsockopt(hsock_in, SOL_SOCKET, SO_REUSEADDR, &i, sizeof(i));
		if (x) {
			perror("Error on setsockopt()");
			exit(1);
		}
		printf("Daemon configured for %s (%i.%i.%i.%i) port %i\n", hostname, a, b, c, d, PORT);

		sock_in.sin_family = AF_INET;
		sock_in.sin_addr.s_addr = INADDR_ANY;
		sock_in.sin_port = htons(PORT);

		memset(buffer, 0, 80);
		if (hsock_in == -1) {
			perror("Error occured on socket()");
			exit(1);
		}
		atexit(closein);
		x = bind(hsock_in, (struct sockaddr *) & sock_in, sizeof(sock_in));
		if (x == -1) {
			perror("Error occured on bind()");
			exit(1);
		}
	}
	do {
		if (!inetd) {
			x = listen(hsock_in, 0);
			if (x == -1) {
				perror("Error occured on listen()");
				exit(1);
			}
			printf("\x1b[31m");
			printf("Waiting for connection...\n");
			i = sizeof(sock_out);
			hsock_out = accept(hsock_in, (struct sockaddr *) & sock_out, &i);
			if (hsock_out == -1) {
				perror("Error occured on accept()");
				exit(1);
			}
		} else {
			hsock_out = _impsockhandle(inetd, 0);
			if (hsock_out == -1) {
				printf("SMPTD: error occured on accept()");
				exit(1);
			}
		}
		fo = fdopen(hsock_out, "w");
		fi = fdopen(hsock_out, "r");
		if (!fo) {
			printf("Can't open output stream\n");
			exit(1);
		}
		if (!fi) {
			printf("Can't open input stream\n");
			exit(1);
		}
		atexit(closeout);

		strcpy(theirname, trythis(hsock_out, PORT));
		time(&t);

		/*
		 * printf("Connection from %s@%s
		 * %s",lastuser[0]?lastuser:"unknown",theirname, ctime(&t));
		 */

		if (!inetd) {
			doingnews(1);
			printf("\x1b[0;1;33m");
		}
		daemon_stat = STATUS_TRANSINPROGRESS;

		x = processconnection(dlvr_agent, hostname, fi, fo, dlvr_type, theirname);
		if (!inetd) {
			doingnews(0);
			daemon_stat = STATUS_IDLE;
		}
		if (x) {
			if (inetd)
				printf("%sSMTP:%5u!!! Mail failed... ", colorstring, inetd);
			else
				printf("\x1b[0;1;33mMail failed... ");
		}
		switch (x) {
		case CONN_NORMTERM:
			/* printf("Connection terminated normally.\n"); */
			break;
		case CONN_SOCKETBROKEN:
			printf("Broken socket\n");
			break;
		case CONN_AGENTERROR:
			printf("Couldn't open delivery agent.");
			break;
		case CONN_UNKNOWN:
			printf("Unknown error!\n");
			break;
		default:
			printf("Error and/or timeout!\n");
		}
		close(hsock_out);
		fclose(fi);
		fclose(fo);
		if (inetd)
			break;
	} while (1);
}

int
processconnection(char *dlvr_agent, char *hostname, FILE * fi, FILE * fo, int dlvr_type, char *clientname)
{

	int             sosend(FILE *, char *);
	int             soread(FILE *, char *);
	char           *transp(char *);
	FILE           *creatunique(char *);

	int             retcode = CONN_NORMTERM, heloflag = 0, mailflag = 0, rcptflag = 0, x = 0, i = 0;
	char            inp_line[MAXDATA];
	/* char            fwdpath[100][65]; */
	FILE           *pipe = NULL;
	char           *commands[] = {"helo", "mail from:", "rcpt to:", "data", "quit", "rset", "noop", "$$$"};
	char            buffer[80];
	char           *temp;
	time_t          t;
	char            recipients[256 * 256];
	char            sender[256];
	char           *p;

	inp_line[0] = '\0';
	alarmhit = 0;

#ifdef COMPILERKLUDGE
	if (lastuser[0] == 0) {
		strcpy(recipients, "220-Waking up..\r\n");
		sosend(fo, recipients);
	}
#endif

	sprintf(recipients, "220 %s - GIGO SMTP Server Ready.  Elvis was here!\r\n", hostname);
	sosend(fo, recipients);
	memset(recipients, 0, sizeof(recipients));
	do {
		memset(inp_line, 0, sizeof(inp_line));
		x = soread(fi, inp_line);
		/* fprintf(stderr,"alarmhit=%i |",alarmhit); */
		if (alarmhit) {
			retcode = CONN_SOCKETBROKEN;
			return retcode;
		}
		if (x == -1) {
			retcode = CONN_SOCKETBROKEN;
		} else {
			if (inetd)
				printf("%sSMTP:%5u>>> %s", colorstring, inetd, inp_line);
			else
				printf("\x1b[0;36m>>> %s", inp_line);
			for (i = 0; i <= HASHCOMMS; i++) {
				if (!strnicmp(commands[i], inp_line, strlen(commands[i])))
					break;
			}
		}
		switch (i) {
		case 0:
			temp = &inp_line[4];
			while(strchr(temp,' ')) temp++;
			x = 0;
			stripcrlf(temp);
			if (strlen(temp)) {
				if (!stricmp(clientname, temp)) {
					x = 1;
				}
				/* if (inetd)  = 1; */

				if (x) {
					sprintf(buffer, "250 %s OK %s -- only programmers spell HELLO  as HELO!\r\n", hostname, lastuser);
					sosend(fo, buffer);
					heloflag = 1;
				} else {
					if ((lastuser[0]) && (strcmp(lastuser, "root"))) {
						sprintf(buffer, "250 We know who you are %s@%s!\r\n", lastuser, clientname);
					} else {
						sprintf(buffer, "250 We know who you are %s!\r\n", clientname);
					}
					sosend(fo, buffer);
					heloflag = 1;
				}
			} else {
				sosend(fo, "501 Require client ID data\r\n");
			}
			break;
		case 1:
			if (!mailflag && heloflag) {
				sosend(fo, "250 OK\r\n");
				mailflag = 1;
				temp = strchr(inp_line, '>');
				if (temp)
					*temp = 0;
				temp = strchr(inp_line, '<');
				if (temp)
					temp++;
				else
					temp = inp_line;
				strcpy(sender, temp);


			} else {
				if (heloflag) {
					sosend(fo, "503 Mail from: command already received.  Multitasking personalities?\r\n");
				} else {
					sosend(fo, "503 HELO not received.  We don't talk to strangers.\r\n");
				}
			}
			break;
		case 3:
			if (mailflag && rcptflag) {
				x = 0;
				switch (dlvr_type) {
				case DONTSPOOL:
					pipe = fopen("nul", "w");
					break;
					break;
				case SPOOLDIRECT:
					pipe = creatunique(dlvr_agent);
					break;
				}
				if (!pipe)
					x = -1;
				if (!x) {
					sosend(fo, "354 OK, send data.  Finish with <CR><LF>.<CR><LF>\r\n");
					time(&t);
					if (dlvr_agent) {
						fprintf(pipe, "#! rmail 0 %s\n", recipients);

						if (lastuser[0])
							fprintf(pipe, "X-Delivered-From: %s (%s)\n", clientname, lastuser);
						else
							fprintf(pipe, "X-Delivered-From: %s\n", clientname);
						fprintf(pipe, "X-Received-By: OS/2 SMTP Daemon v0.30/gigo\n");
						fprintf(pipe, "Received: %s %s", hostname, ctime(&t));
					}
					do {
						x = soread(fi, inp_line);

						temp = transp(inp_line);
						stripcrlf(temp);
						if (temp != NULL && x != -1) {
							if (dlvr_agent) {
								fprintf(pipe, "%s\n", temp);
								if (debug == 2) {
									printf("%s%s\n", colorstring, temp);
								}
							}
						} else {
							x = -1;
						}
						if (alarmhit) {
							if (dlvr_agent)
								fprintf(pipe, "\n\n** Error on SMTP receive; you may see duplicates of this message.\n\n");
							x = -1;
							fclose(pipe);
							mailflag = 0;
							rcptflag = 0;
							retcode = CONN_SOCKETBROKEN;
							return retcode;
						}
					} while (x != -1);
					sosend(fo, "250 OK (scribble scribble scribble) mail accepted\r\n");
					/*
					 * printf("\x1b[0;1;33mReceived
					 * mail\n");
					 */
					x = 0;
				} else {
					sosend(fo, "451 Error in SMTP daemon ;-(\r\n");
				}
				fclose(pipe);
				if (!x) {
					mailflag = 0;
					rcptflag = 0;
					memset(recipients, 0, sizeof(recipients));
				}
			} else {
				sosend(fo, "503 MAIL and RCPT commands not received\r\n");
			}
			x = 0;
			break;
		case 2:
			if (heloflag) {
				stripcrlf(inp_line);
				if ((strlen(recipients) + 256) > sizeof(recipients)) {	/* we've got too many
											 * recipients! */
					sosend(fo, "451 Too many recipients for this batch\r\n");
				} else if (strchr(inp_line, '<') && (strchr(inp_line, '>') == inp_line + strlen(inp_line) - 1)) {

					temp = strchr(inp_line, '>');
					if (temp)
						*temp = 0;
					temp = strchr(inp_line, '<');
					if (temp)
						temp++;

					/* for jon@fido.net */

					if (colonhack)
						if (temp[0] == '@')
							if (strchr(temp, ':'))
								temp = strchr(temp, ':') + 1;
					p = sendok(clientname, sender, temp);
					if (!debug) 
					{ /* show results of various email addresses; this already contains the \r\n */
					 	if (inetd)
		printf("%sSMTP:%5u<<< %s", colorstring, inetd, p);
	else
		printf("%s", p);

					}
					if (!p)
						p = "550 unknown state in mailer";
					if (atoi(p) == 250) {
						rcptflag++;
						if (temp)
							sprintf(recipients + strlen(recipients), " %s", temp);
					}
					sosend(fo, p);
				} else {
					sosend(fo, "501 Error in parameters - address format not understood\r\n");
				}
			} else {
				sosend(fo, "503 HELO command not received\r\n");
			}
			break;
		case 4:
			x = -1;
			sprintf(buffer, "221 %s OK, see ya!\r\n", hostname);
			sosend(fo, buffer);
			break;
		case 5:
			sosend(fo, "250 OK Rebooting..\r\n");
			if (pipe)
				fclose(pipe);
			pipe = NULL;
			mailflag = 0;
			rcptflag = 0;
			memset(recipients, 0, sizeof(recipients));
			break;
		case 6:
			sosend(fo, "250 Task intensive operation aborted\r\n");
			break;
		default:
			sosend(fo, "502 Huh?\r\n");
		}
	} while (x != -1);

	return (retcode);
}

int
sosend(FILE * file, char *data)
{
	int             retcode;

	retcode = fputs(data, file);

	if (debug) {
		if (inetd)
			printf("%sSMTP:%5u<<< %s", colorstring, inetd, data);
		else
			printf("\x1b[0;32m<<< %s", data);
	}
	fflush(file);
	if (retcode == EOF) {
		retcode = -1;
	} else {
		retcode = strlen(data);
	}
	return (retcode);
}

int
soread(FILE * file, char *data)
{
	int             retcode;
	char           *temp;
	alarm(TIMEOUT);		/* Be sure to abort out of routines */
	temp = fgets(data, MAXDATA, file);
	alarm(0);		/* turn off the alarm */
	if (temp) {
		retcode = strlen(data);
	} else {
		retcode = -1;
	}
	return (retcode);
}

void
stripcrlf(char *temp)
{
	if (temp) {
		if (strchr(temp, '\r')) {
			*strchr(temp, '\r') = '\0';
		}
		if (strchr(temp, '\n')) {
			*strchr(temp, '\n') = '\0';
		}
	}
}

void
closein(void)
{
	close(hsock_in);
}

void
closeout(void)
{
	close(hsock_out);
}

char           *
transp(char *dataline)
{
	static char     retval[2048];
	strcpy(retval, dataline);
	stripcrlf(retval);

	if (retval[0] == '.') {
		if (retval[1] == '\0') {
			return NULL;
		} else {
			return &retval[1];
		}
	}
	return &retval[0];
}

FILE           *
creatunique(char *path)
{
	FILE           *file = NULL;
	static char     fname[1024];
	time_t          t;
	int             fh, i;

	time(&t);
	fh = -1;

	strcpy(fname, path);
	for (i = 0; i < 1000; ++i) {
		sprintf(fname, "%s\\%.8lx.bag", path, (unsigned long) (t + i));
		fh = sopen(fname, O_WRONLY | O_CREAT | O_EXCL, SH_DENYRW, S_IREAD | S_IWRITE);

		if (fh != -1)
			break;

		if (errno != EEXIST) {
			perror(fname);
		}
	}
	if (fh == -1) {
		file == NULL;
	} else {
		file = fdopen(fh, "wb");
		if (inetd)
			printf("SMTP:%5u--- opening %s\n", inetd, fname);
	}
	return file;
}
void
usage(char *exename)
{
	printf("\nUsage:  %s -p <directory> \n",
	       strlwr(strrchr(exename, '\\') + 1));
}
