/*
 * COPYRIGHT 1996 BY JASON FESLER.  ALL RIGHTS RESERVED. Please see
 * LICENSE.TXT for licensing details.
 * 
 * This includes for the use of any portion of this source code, or any binaries
 * derived from it!
 * 
 */

#include "jfcommon.h"




#ifdef BRAINSTORMING

openindex();			/* with locking, otherwise fail! */
readindex();			/* into internal memory */
writeindex();			/* rewrite index back, truncating if needed */
closeindex();			/* unlock & close */
addindex();			/* openindex(), append 1 line, closeindex(); */

readmsg_open();			/* open message, prep for reading */
readmsg_read();			/* read "x" amount */
readmsg_rewind();		/* go back if needed */
readmsg_close();		/* close the message */
readmsg_delete();		/* delete by name */

writemsg_open();		/* design local identifier, open file/record */
writemsg_write();		/* write buffer to disk */
writemsg_close();		/* close the file */

/*
 * We are not going to aim for threading on this project. I'm not up to speed
 * for unix threading; os/2 doesn't seem to be a *popular* server.  So, we'll
 * simply and aim for single threads..
 */


#endif BRAINSTORMING

struct options  option;
indextype       indexptr[MAX_MESSAGES];
long            indexcount = 0;
int             jfpop_err = 0;
char            jfpop_errstr[1024] = "";
int             _argc;
char          **_argv;


void
panic(char *file, long line, char *text)
{
	fprintf(stderr, "%s (%s, %li): %s\r\n", _argv[0], file, line, text);
	exit(1);
}

void
showhelp(char *filename)
{
	char            helpfile[1024];
	char           *p;
	char            linebuf[256];
	FILE           *file;

	strcpy(helpfile, filename);
	p = strrchr(helpfile, '.');
	if (!p)
		panic(__FILE__, __LINE__, "Unable to determine where the help file is");
	strcpy(p, ".hlp");
	file = fopen(helpfile, "rt");
	if (!file)
		panic(__FILE__, __LINE__, "Unable to open the help file");
	while (!feof(file)) {
		memset(linebuf, 0, sizeof(linebuf));
		fgets(linebuf, sizeof(linebuf), file);
		p = strpbrk(linebuf, "\r\n");
		if (p)
			*p = 0;
		printf("%s\n", linebuf);
	}
	fclose(file);
	exit(1);
}


#ifndef __OS2__
char           *
strlwr(char *source)
{
	char           *p;
	p = source;
	while (p && (*p)) {
		*p = tolower(*p);
		p++;
	}
	return source;
}

int
strnicmp(char *s1, char *s2, int length)
{
	char            buf1[1024];
	char            buf2[1024];
	strncpy(buf1, s1, sizeof(buf1));
	strncpy(buf2, s2, sizeof(buf2));
	strlwr(buf1);
	strlwr(buf2);
	buf1[length] = 0;
	buf2[length] = 0;
	return strcmp(buf1, buf2);
}

#endif
void
readoptions(void)
{
	int             needhelp = 0;
	int             i;
	memset(&option, 0, sizeof(option));
	memset(&indexptr, 0, sizeof(indexptr));
	for (i = 1; i < _argc; i++) {
		if (strcmp(_argv[i], "-d") == 0)
			option.debug = 1;
		else if (strcmp(_argv[i], "-w") == 0) {
			i++;
			if (i < _argc)
				option.wait = atol(_argv[i]);
		} else if (strcmp(_argv[i], "-s") == 0) {
			i++;
			if (i < _argc)
				option.socket = atol(_argv[i]);
		} else if (strcmp(_argv[i], "-u") == 0) {
			i++;
			if (i < _argc)
				strcpy(option.username, _argv[i]);
		} else if (strcmp(_argv[i], "-e") == 0) {
			i++;
			if (i < _argc)
				option.errorlevel = atoi(_argv[i]);
		} else if (strcmp(_argv[i], "-m") == 0) {
			i++;
			if (i < _argc)
				strcpy(option.mode, _argv[i]);
		} else if (strcmp(_argv[i], "-h") == 0) {
			showhelp(_argv[0]);
		} else {
			fprintf(stderr, "Unknown parameter: %s\n", _argv[i]);
			needhelp = 1;
		}		/* end of if/else statements */

	}			/* end of for(;;) loop */

	if (needhelp)
		showhelp(_argv[0]);

	if (option.wait == 0)
		option.wait = DEFAULT_OPTION_WAIT;


}

int             jump_receive(void);
int             jump_pop3(void);

int
jumpstart(char *s)
{
	char            buffer[1024];
	char           *p;

	strcpy(buffer, s);
	if (option.mode[0])
		strcpy(buffer, option.mode);
	strlwr(buffer);

	p = strrchr(buffer, '\\');
	if (!p)
		p = strrchr(buffer, '/');
	if (!p)
		p = strrchr(buffer, ':');
	if (!p)
		p = buffer;
	else
		p++;

	if (strstr(buffer, ".exe"))
		*strstr(buffer, ".exe") = 0;

	strcpy(option.mode, p);


	/* now determine what function we are */

	if (strcmp(p, "receive") == 0)
		return jump_receive();
	if (strcmp(p, "pop") == 0)
		return jump_pop3();
	if (strcmp(p, "jfpop") == 0)
		return jump_pop3();
	if (strcmp(p, "jfmail") == 0)
		return jump_receive();
	if (strcmp(p, "mail") == 0)
		return jump_receive();
	if (strcmp(p, "deliver") == 0)
		return jump_receive();

	fprintf(stderr, "Unknown program execution name: %s\n", p);
	return 255;
}

int
main(int argc, char **argv)
{

	_argc = argc;		/* share this info with the rest of the
				 * program */
	_argv = argv;		/* share this info with the rest of the
				 * program */

	readoptions();
	printf("Options: -u %s -w %u -s %u\n",
	       option.username, option.wait, option.socket);
	return jumpstart(argv[0]);
}
