
#include "jfcommon.h"

#ifdef BRAINSTORMING

openindex();			/* with locking, otherwise fail! */
readindex();			/* into internal memory */
writeindex();			/* rewrite index back, truncating if needed */
closeindex();			/* unlock & close */
addindex();			/* openindex(), append 1 line, closeindex(); */

#endif BRAINSTORMING;


char           *index_buffer = NULL;


void
generic_cappath(char *path)
{
	if (path[0] == 0) {
		strcpy(path, "/");
	} else {
		if (path[strlen(path) - 1] != '/')
			strcat(path, "/");
	}
}

char           *
generic_mailpath(char *username)
{
	static char     returnbuf[1024];
	char            initials[1024];

	memset(returnbuf, 0, sizeof(returnbuf));
	if (username[0] == '/') {
		strcpy(returnbuf, username);
		generic_cappath(returnbuf);
	} else {
		strcpy(returnbuf, MAIL_PATH);
		generic_cappath(returnbuf);
#ifdef MAIL_PATH_INITIALS
		strcpy(initials, username);
		initials[MAIL_PATH_INITIALS] = 0;
		strcat(returnbuf, initials);
#endif
		generic_cappath(returnbuf);
		strcat(returnbuf, username);
		generic_cappath(returnbuf);
	}
	return returnbuf;
}


void
makedirectory(char *username)
{
	char            dirname[1024];
	char            tempname[1024];
	int             i;
	strcpy(dirname, generic_mailpath(username));
	for (i = 0; i < strlen(dirname); i++)
		if ((dirname[i] == '/') || (dirname[i] == '\\')) {
			strcpy(tempname, dirname);
			tempname[i] = 0;
			mkdir(tempname, 0770);
			/* need to chown here ! */
		}
}


char            indexlockname[1024];
int
trylockindex(char *filename, FILE * file)
{
	/* use whatever locking works best.. */

	/*
	 * probably best to create a new file in *exclusive* mode and obtain
	 * a lcok on it
	 */

	/* username/lockfile */

	/* if the age of the lock file is really long, delete teh bastard */

	strcpy(indexlockname, filename);	/* save for unlock */
	return 1;
}
int
unlockindex(FILE * file)
{
	/* don't forget to unlock! */
	return 0;
}

FILE           *
openindex(char *username, int forappend)
{
	char            basepath[1024];
	char            indexname[1024];
	FILE           *indexfile = NULL;
	int             retries = 0;

	makedirectory(username);

	strcpy(basepath, generic_mailpath(username));
	sprintf(indexname, "%sindex", basepath);
tryagain:
	indexfile = fopen(indexname, "r+b");
	if ((!indexfile) && (forappend == 0)) {
		jfpop_err = POPERR_NOMSG;
		strcpy(jfpop_errstr, "No messages");
		if (option.debug)
			sprintf(jfpop_errstr + strlen(jfpop_errstr),
				"; no index file %s\n", indexname);
		return NULL;
	}
	if (!indexfile) {
		indexfile = fopen(indexname, "w+b");
		if (!indexfile) {
			jfpop_err = POPERR_NOMSG;
			strcpy(jfpop_errstr, "Unable to open ");
			if (option.debug)
				sprintf(jfpop_errstr + strlen(jfpop_errstr),
					"; file %s\n", indexname);
			return NULL;
		}
	}
	if (trylockindex(indexname, indexfile) == 0) {
		fclose(indexfile);	/* can't trust it if we can't lock it */
		indexfile = NULL;
		retries++;
		sleep(1);
		if (retries < option.wait)
			goto tryagain;
		jfpop_err = POPERR_LOCKWAIT;
		strcpy(jfpop_errstr, "Lock file still in use; giving up");
		return NULL;
	}
	return indexfile;	/* we're locked, and ready to go */
}


void
closeindex(FILE * file)
{
	if (file) {
		unlockindex(file);
		fclose(file);
		file = NULL;
	}
	if (index_buffer) {
		free(index_buffer);
		index_buffer = NULL;
	}
}

#ifndef __OS2__
long
flength(FILE * file)
{
	long            current;
	long            size;
	current = ftell(file);
	fseek(file, 0, SEEK_END);
	size = ftell(file);
	fseek(file, current, SEEK_SET);
	return size;
}

#endif
void
readindex(FILE * file)
{				/* index_buffer is non-null if this works */
	long            length;

	if (file)
#ifndef __OS2__
		length = flength(file);
#else
		length = filelength(fileno(file));
#endif
	else
		length = 0;

	index_buffer = (char *) calloc(1, MAX_MESSAGES + MAX_MESSAGES + length);
	char           *p;
	int             i;
	long            amountread = 0;
	if (!index_buffer) {
		jfpop_err = POPERR_NOMEM;
		strcpy(jfpop_errstr, "No memory!");
		return;
	}
	if (file) {
		fseek(file, 0, SEEK_SET);
		amountread = fread((void *) index_buffer, 1, length, file);
	} else
		amountread = 0;

	if (amountread != length) {
		jfpop_err = POPERR_READ;
		strcpy(jfpop_errstr, "Error reading index; amountread unexpected");
		free(index_buffer);
		index_buffer = NULL;
		return;
	}
	/* Break the buffer up into lines */
	p = strtok(index_buffer, "\r\n");
	if (p)
		for (i = 0; i < MAX_MESSAGES; i++) {
			indexptr[i].text = p;
			if (p != NULL)
				indexcount = i + 1;
			else
				break;
			p = strtok(NULL, "\r\n");
		}
	for (i = 0; i < MAX_MESSAGES; i++) {
		if (indexptr[i].text)
			if (p = strpbrk(indexptr[i].text, "\r\n"))
				*p = 0;
	}
}

void
writeindex(FILE * file)
{
	int             i, status;
	char            filename[1024];
	if (!file)
		return;
	rewind(file);
	chsize(fileno(file), 0);
	rewind(file);
	for (i = 0; i <= indexcount; i++)
		if (indexptr[i].text) {
			if (!indexptr[i].deleted) {
#ifdef PC
				fprintf(file, "%s\r\n", indexptr[i].text);
#else
				fprintf(file, "%s\n", indexptr[i].text);
#endif
			} else {
				/* delete the message */
				strcpy(filename, generic_mailpath(option.username));
				strcat(filename, indexptr[i].text);
				if (strchr(filename, ' '))
					*strchr(filename, ' ') = 0;
				status = unlink(filename);
				if (option.debug)
					fprintf(stderr, "*unlinking %s = %i  %i %s\n", filename,
					    status, errno, strerror(errno));

			}
		}
}

int
addindex(char *user, char *text)
{
	FILE           *file;
	long            length;

	file = openindex(user, 1);
	if (!file)
		return -1;

#ifndef __OS2__
	length = flength(file);
#else
	length = filelength(fileno(file));
#endif
	fseek(file, length, SEEK_SET);
#ifdef PC
	fprintf(file, "%s\r\n", text);
#else
	fprintf(file, "%s\n", text);
#endif
	closeindex(file);
	return 0;
}
