/* simple smtp transporter */

/*
 * Itty-bitty inews for talking to remote server. Simply accept input on
 * stdin (or via a named file) and dump this to the server; add a From: and
 * Path: line if missing in the original. Print meaningful errors from the
 * server. Limit .signature files to MAX_SIGNATURE lines. No processing of
 * command line options.
 * 
 * Original by Steven Grady <grady@ucbvax.Berkeley.EDU>, with thanks from Phil
 * Lapsley <phil@ucbvax.berkeley.edu> Send bug reports to Stan Barber
 * <sob@bcm.tmc.edu>
 */

#include <stdio.h>
#include <stdlib.h>
#include <share.h>
#include <pwd.h>
#include <ctype.h>
#include <time.h>
#include "conf.h"
#include "nntp.h"
#ifndef FOR_NN
#ifdef USG
#include <string.h>
#else not USG
#include <strings.h>
#endif not USG
#endif

#define	MAX_SIGNATURE	4

#include "sockstream.h"
extern int      sockt;

char            tzone[256];
char            host_name[256];
char            whofrom[256];
char            configfile[256];
char            bagdir[256];
FILE           *output;

typedef struct {
	char            address[256];
	int             delivered;
	char            message[256];
}               recipients;
recipients      whoto[256];
int             whotocount;
char            generic[1024];
int             sendok;

char           *receivedline(void);
char           *currentunixdate(void);


char            bouncemsg[16000];
char            bouncenote[16000];
int             bounceofs = 0;
int             sendbounce = 0;



void 
makepath(char *path)
{
	char            buf[512];
	int             i, len;
	len = strlen(path);
	for (i = 0; i < len; i++) {
		if (i == 2)
			if (path[1] == ':')
				continue;	/* ignore root directories */
		if (path[i] == '\\') {
			strcpy(buf, path);
			buf[i] = 0;
			mkdir(buf, 0);
		}		/* endif */
	}			/* for */
}				/* makepath */

FILE           *
uniquefileopen(char *path, char *ext)
{
	long            temp;
	char            buf[256];
	FILE           *file;
loop:
	if ((path != NULL) && (path[0] != 0))
		strcpy(buf, path);
	else
		strcpy(buf, ".\\");
	if (strlen(buf) > 2)
		if (buf[strlen(buf) - 1] == '\\')
			buf[strlen(buf) - 1] = 0;

	mkdir(buf, 0);

	strcat(buf, "\\");

	temp = clock() % 0x100;
	temp += time(NULL) * 0x100;
	sprintf(buf + strlen(buf), "%lx%s", temp, ext);

	file = _fsopen(buf, "rt", SH_DENYWR);
	if (file) {
		fclose(file);
		goto loop;
	}
	file = _fsopen(buf, "wb", SH_DENYWR);
	if (!file)
		goto loop;
	/* msgstring("Creating %s",buf); */
	return file;
}
FILE           *uniquefile(char *path) {
	return uniquefileopen(path, ".BAG");
}
FILE           *uniquetemp(char *path) {
	return uniquefileopen(path, ".TMP");
}


main(argc, argv)
	int             argc;
	char           *argv[];
{
	char            line[NNTP_STRLEN], s[NNTP_STRLEN];
	int             seen_fromline, in_header, seen_header;
	int             response;
	char           *server;
	char           *getserverbyfile();
	register char  *cp;
	long            i;

	whofrom[0] = 0;
	configfile[0] = 0;
	memset(whoto, sizeof(whoto), 0);
	memset(bouncemsg, 0, sizeof(bouncemsg));
	memset(bouncenote, 0, sizeof(bouncenote));

	strcpy(bagdir, "c:/bags/");
	bounceofs = 0;
	whotocount = 0;
	sendok = 0;
	sendbounce = 0;
	tzone[0] = 0;
	if (getenv("TZ") == NULL) {
		printf("TZ variable not set (ie, SET TZ=PST8PDT)");
		return 1;
	}
	strcpy(tzone, getenv("TZ"));
	if (tzone[0] == 0) {
		printf("TZ variable not set (ie, SET TZ=PST8PDT)");
		return 1;
	}
	if (getenv("BAGS") == NULL) {
		printf("BAGS variable not set (ie, SET BAGS=C:/BAGS/)");
		return 1;
	}
	strcpy(bagdir, getenv("BAGS"));
	if (bagdir[0] == 0) {
		printf("BAGS variable not set (ie, SET BAGS=C:/BAGS/)");
		return 1;
	}
	++argv;
	while (argc > 1)
		if (*argv[0] == '-') {
			switch (*((*argv) + 1)) {
			case 'f':
			        ++argv; --argc;
				strcpy(whofrom, (*argv));
				++argv;
				--argc;
				break;
			case 'C':
				strcpy(configfile, (*argv) + 2);
				++argv;
				--argc;
				break;
			default:
				printf("Unknown option %s; ignored\n", *argv);
				++argv;
				--argc;
				break;
			}
		} else {
			strcpy(whoto[whotocount++].address, *argv);
			++argv;
			--argc;
		}
	if (configfile[0] == 0)
		strcpy(configfile, "c:/tcpip/etc/sender.cf");
	if (whofrom[0] == 0)
		strcpy(whofrom, "nobody");
	if (whotocount == 0) {
		printf("Nobody to send to.\n");
		return 1;
	}
	/* printf("Config file: %s\n", configfile); */
/*
	printf("From: %s\n", whofrom);
	for (i = 0; i < whotocount; i++)
		printf("Sending to: %s\n", whoto[i].address);
*/

	uname(host_name);
/*
	printf("Running on host %s\n", host_name);
	*/

	server = getserverbyfile(SERVER_FILE);
	if (server == NULL) {
		fprintf(stderr,
			"Can't get the name of the news server from %s.\n",
			SERVER_FILE);
		fprintf(stderr,
			"Either fix this file, or put MAILSERVER in your enviroment.\n");
		exit(1);
	}
	response = server_init(server);
	if (response < 0) {
		printf("Couldn't connect to %s mail server, try again later.\n",
		       server);
		exit(1);
	}
	printf("Connnection handle %i\n",response);
	if (handle_server_response(response, server) < 0) {
		close_server();
		exit(1);
	}
	sprintf(generic, "HELO %s", host_name);
	put_server(generic);
	(void) get_server(line, sizeof(line));
	if (*line != CHAR_OK) {
		if (atoi(line) == 999) {
			close_server();
			fprintf(stderr,
			      "Sorry, you can't post from this machine.\n");
			exit(1);
		} else {
			fprintf(stderr, "*** Remote error: %s\n", line);
			close_server();
			exit(1);
		}
	}
	sprintf(generic, "MAIL FROM: <%s>", whofrom);
	put_server(generic);
	(void) get_server(line, sizeof(line));
	if (*line != CHAR_OK) {
		if (atoi(line) == 999) {
			close_server();
			fprintf(stderr,
			      "Sorry, you can't post from this machine.\n");
			exit(1);
		} else {
			fprintf(stderr, "*** Remote error: %s\n", line);
			close_server();
			exit(1);
		}
	}
	for (i = 0; i < whotocount; i++) {
		sprintf(generic, "RCPT TO: <%s>", whoto[i].address);
		put_server(generic);
		(void) get_server(line, sizeof(line));
		strncpy(whoto[i].message, line, sizeof(whoto[i].message) - 1);
		if (*line != CHAR_OK) {
			sendbounce = 1;
			fprintf(stderr, "*** Email address not accepted: %s\n", whoto[i].address);
		} else {
			fprintf(stderr, "*** Accepted: %s\n", whoto[i].address);
			sendok = 1;
			whoto[i].delivered = 1;
		}
	}

	if (sendok) {

		put_server("DATA");
		(void) get_server(line, sizeof(line));
		if ((*line != '2') && (*line != '3')) {
			if (atoi(line) == 999) {
				close_server();
				fprintf(stderr,
					"Sorry, you can't post from this machine.\n");
				exit(1);
			} else {
				fprintf(stderr, "*** Remote error: %s\n", line);
				close_server();
				exit(1);
			}
		}
		/*
		 * sockprintf(sockt, "From %s
		 * %s\r\n",whofrom,currentunixdate());
		 */
		sockprintf(sockt, "%s\r\n", receivedline());
		while (gets(s) != NULL) {
			if (s[0] == '.')	/* Single . is eof, so put in
						 * extra one */
				(void) sockputc('.', sockt);
			sockprintf(sockt, "%s\r\n", s);
			bounceofs = strlen(bouncemsg);
			if (bounceofs < 12000)
				sprintf(
					&bouncemsg[bounceofs], "%s\r\n", s);
		}

		sockprintf(sockt, ".\r\n");
		(void) get_server(line, sizeof(line));
		if (*line != CHAR_OK) {
			close_server();
			printf("Article not accepted by server; not posted.\n");
			for (cp = line + 4; *cp && *cp != '\r'; cp++)
				if (*cp == '\\')
					putchar('\n');
				else
					putchar(*cp);
			exit(1);
		}
	} {			/* else if NOT okay to send.. */
		while (gets(s) != NULL) {
			if (s[0] == '.')	/* Single . is eof, so put in
						 * extra one */
				(void) sockputc('.', sockt);
			sockprintf(sockt, "%s\r\n", s);
			bounceofs = strlen(bouncemsg);
			if (bounceofs < 12000)
				sprintf(
					&bouncemsg[bounceofs], "%s\n", s);
		}

	}

	/*
	 * Close server sends the server a "quit" command for us, which is
	 * why we don't send it.
	 */

	close_server();

	if (sendbounce) {
		sprintf(bouncenote, "From: mailer-daemon@%s\n", host_name);
		sprintf(bouncenote + strlen(bouncenote), "To: %s\n", whofrom);
		sprintf(bouncenote + strlen(bouncenote), "Date: %s\n", currentunixdate());
		sprintf(bouncenote + strlen(bouncenote), "Subject: undeliverable mail\n", currentunixdate());
		sprintf(bouncenote + strlen(bouncenote), "\nThe following address(es) were undeliverable.\n\n", currentunixdate());

		for (i = 0; i < whotocount; i++) {
			if (whoto[i].delivered == 0) {
				sprintf(bouncenote + strlen(bouncenote),
					" address: %s\n reason : %s\n\n",
					whoto[i].address, whoto[i].message);
			}
		}
		strcat(bouncenote, "\n --- Message follows: --- (may be truncated if long)\n\n");
		output = uniquefile(bagdir);
		if (output == NULL) {
			fprintf(stderr, "Can not create file in %s! \n", bagdir);
		} else {
			i = strlen(bouncemsg) + strlen(bouncenote);
			fprintf(output, "#! rmail %lu %s\n", i, whofrom);
			fwrite(bouncenote, 1, strlen(bouncenote), output);
			fwrite(bouncemsg, 1, strlen(bouncemsg), output);
			fclose(output);
		}
	}
	exit(0);
}

/*
 * strneql -- determine if two strings are equal in the first n characters,
 * ignoring case.
 * 
 * Parameters:	"a" and "b" are the pointers to characters to be compared.
 * "n" is the number of characters to compare.
 * 
 * Returns:	1 if the strings are equal, 0 otherwise.
 * 
 * Side effects:	None.
 */

strneql(a, b, n)
	register char  *a, *b;
	int             n;
{
	char            lower();

	while (n && lower(*a) == lower(*b)) {
		if (*a == '\0')
			return (1);
		a++;
		b++;
		n--;
	}
	if (n)
		return (0);
	else
		return (1);
}

/*
 * lower -- convert a character to lower case, if it's upper case.
 * 
 * Parameters:	"c" is the character to be converted.
 * 
 * Returns:	"c" if the character is not upper case, otherwise the lower
 * case eqivalent of "c".
 * 
 * Side effects:	None.
 */

char
lower(c)
	register char   c;
{
	if (isascii(c) && isupper(c))
		c = c - 'A' + 'a';
	return (c);
}
char           *
receivedline(void)
{
	static char     buffer[1024];
	sprintf(buffer, "Received: by %s; %s", host_name, currentunixdate());
	return buffer;
}

char           *
currentunixdate(void)
{
	static char     buf[150];
	struct tm      *time_now;
	time_t          secs_now;
	long            temp;
	tzset();
	time(&secs_now);
	time_now = gmtime(&secs_now);
	strftime(buf, sizeof(buf) - 1, "%d %b %y %H:%M:%S", time_now);
	return buf;
}
