
/*
 *  RENUM - Simple *.MSG renumbering utility
 *  Copyright 1994 by Jason Fesler.  All rights reserved.
 *
 *  You are welcome to modify and distribute this source code
 *  under the following conditions:
 *     .  NO MONEY IS INVOLVED.   This program is _free_.  Period.
 *     .  This banner is to remain at the top of the source file
 *        in it's unaltered form.
 *     .  Any modifications made and distributed, must also be
 *        distributed in source form.
 *
 *
 *  This program compiles just fine under Watcom C/C++ 10.0 for OS/2 32-bit exe's.
 *  This program compiles just fine under Borland C++ 3.1 for DOS exes.
 *
 *  Comments can be sent to jfesler@wmeonlin.sacbbx.com or 1:203/7707.0 ..
 *
 */



#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <direct.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include <time.h>
#include <sys\stat.h>
#include <share.h>
#include <dos.h>
#include <conio.h>

#ifdef __BORLANDC__
#include <dirent.h>
#define HUGE huge
#else
#define HUGE
#endif

unsigned long HUGE *existing = NULL;
unsigned long   maxexisting = 0;
unsigned long   totalmsgs = 0;


void            dir_getmessages(char *name)
{
    unsigned long   L;
    char           *p;
    if (totalmsgs < maxexisting)
        if (L = atol(name)) {
            while (*name)
                if (isdigit(*name++) == 0)
                    L = 0;
            if (L)
                existing[totalmsgs++] = L;
        }
}
#define sorttester(c1,c2)                    \
  if (existing[(c1)]>existing[(c2)])         \
   {                                         \
      temp=existing[(c1)];                   \
      existing[(c1)]=existing[(c2)];         \
      existing[(c2)]=temp;                   \
      doneyet=0;                             \
   }


void            sort(void)
{
    unsigned long   counter;
    unsigned long   temp;
    int             doneyet;
    if (totalmsgs < 1)
        return;
loop:
    doneyet = 1;
    for (counter = 1; counter < totalmsgs; counter++)
        sorttester(counter - 1, counter);
    if (!doneyet)
        goto loop;
}

void            goforit(void)
{
    unsigned long   L;
    char            buf1[256],
                    buf2[256];
    if (totalmsgs < 1)
        return;
    for (L = 0; L < totalmsgs; L++)
        if (existing[L] - (L + 1)) {    // or, if existing[L] != (L+1), but
                                        // faster
            cprintf("%lu->%lu\r", existing[L], L + 1);
            sprintf(buf1, "%lu.msg", existing[L]);
            sprintf(buf2, "%lu.msg", L + 1);
            rename(buf1, buf2);
        }
}
/* parse_dir
 *
 * requires extension we are searching for, and a pointer to the appropriate function
 *
 *
 * will call the specified function, with the file name (no path or extension provided)
 *
 */

#ifdef __BORLANDC__
#define opendirspec ""
#else
#define opendirspec "*.*"
#endif


void            parse_dir(char *extension, int single, void func(char *))
{
    DIR            *dir;
    struct dirent  *ent;
    char            buf[256];
    errno = 0;
redo:
    if ((dir = opendir(opendirspec)) == NULL) {
        cprintf("Unable to open directory\r\n");
        return;
    }
    strupr(extension);
    while ((ent = readdir(dir)) != NULL) {
        strcpy(buf, ent->d_name);
        if (strstr(buf, extension)) {
            if (strchr(buf, '.'))
                *strchr(buf, '.') = 0;
            func(buf);
            if (single) {
                free((char *) dir);
                cprintf("Rescanning directory\r\n");
                goto redo;
            }
        }
    }
    free((char *) dir);
}

void            main(int argc, char *argv[])
{
    long            total;
 
    unsigned        drive,
                    dtotal;
    char            returnto[256];
    char            returntothisdrive[256];
    printf("Renum  *.MSG renumbering program\r\nCopyright 1994 by Jason Fesler.  All rights reserved.\r\n");

    getcwd(returnto, sizeof(returnto));
    if (argc > 1) {
        chdir(argv[1]);
        if (argv[1][1] == ':') {
            drive = toupper(argv[1][0]) - 'A' + 1;
            _dos_setdrive(drive, &dtotal);
        }
    }
    getcwd(returntothisdrive, sizeof(returntothisdrive));
    total = 10000;
masterloop:
    maxexisting = total;


#ifdef __BORLANDC__
    existing = (unsigned long HUGE *) farmalloc(total * sizeof(long));
    if (existing)
        _fmemset(existing, 0, (total * sizeof(long)));
#else
    existing = (unsigned long *) calloc(sizeof(unsigned long), total);
#endif

    if (!existing) {
        if ((total -= 10) > 99)
            goto masterloop;
        cprintf("Not enough memory.\r\n");
        exit(255);
    }
    setvbuf(stdout, NULL, _IONBF, 0);

    cprintf("Reading directory\r\n");
    parse_dir(".MSG", 0, dir_getmessages);
    cprintf("Sorting\r\n");
    sort();
    goforit();

    chdir(returntothisdrive);
    chdir(returnto);
    if (returnto[1] == ':') {
        drive = toupper(returnto[0]) - 'A' + 1;
        _dos_setdrive(drive, &dtotal);
    }
    exit(0);
}
