
#include "jfcommon.h"

int             alarmhit = 0;
void
myhandler(int sig)
{
	alarmhit = sig;
#ifndef __OS2__
	/* signal(sig, SIG_ACK); */
#else
	signal(sig, SIG_ACK);
#endif
	switch (sig) {
	case SIGPIPE:
		fprintf(stderr, "SIGNAL %i: Broken pipe (they disconnected)\n", sig);
		break;
	case SIGALRM:
		fprintf(stderr, "SIGNAL %i: Alarm (timeout)\n", sig);
		break;
	default:
		fprintf(stderr, "SIGNAL %i: Unhandled signal\n", sig);
		break;
	}
}
jmp_buf         jbuf;


char           *
stat_command(void)
{
	static char     buf[1024];
	char            line[1024];
	unsigned long   messages = 0;
	unsigned long   bytes = 0;
	char           *recordname, *octets;
	int             i;
	for (i = 0; i < MAX_MESSAGES; i++)
		if (indexptr[i].text)
			if (indexptr[i].deleted == 0) {
				strcpy(line, indexptr[i].text);
				recordname = strtok(line, " \t\r\n");
				octets = strtok(NULL, " \t\n\r");
				if (octets) {
					messages++;
					bytes += atol(octets);
				}
			}
	sprintf(buf, "+OK %lu %lu\r\n", messages, bytes);
	return buf;
}


char           *
list_command(long msgnum, FILE * fo)
{
	static char     buf[1024];
	char            line[1024];
	char           *recordname, *octets;

	if (indexptr[msgnum].text == NULL) {
		strcpy(buf, "-ERR No such message\r\n");
		return buf;
	}
	if (indexptr[msgnum].deleted) {
		strcpy(buf, "-ERR You deleted that message.\r\n");
		return buf;
	}
	strcpy(line, indexptr[msgnum].text);
	recordname = strtok(line, " \t\r\n");
	octets = strtok(NULL, " \t\n\r");
	sprintf(buf, "%lu %s", msgnum + 1, octets);
	return buf;

}

char           *
uidl_command(long msgnum, FILE * fo)
{
	static char     buf[1024];
	char            line[1024];
	char           *recordname, *octets;

	if (indexptr[msgnum].text == NULL) {
		strcpy(buf, "-ERR No such message\r\n");
		return buf;
	}
	if (indexptr[msgnum].deleted) {
		strcpy(buf, "-ERR You deleted that message.\r\n");
		return buf;
	}
	strcpy(line, indexptr[msgnum].text);
	recordname = strtok(line, " \t\r\n");
	octets = strtok(NULL, " \t\n\r");
	sprintf(buf, "%lu %s", msgnum + 1, recordname);
	return buf;

}



void
show_message(long msgnum, FILE * fo, long count)
{
	char            line[1024];
	char           *recordname, *octets;
	msgtype        *msg;
	char            outgoing[1024];
	long            counter = -99999;

	if (indexptr[msgnum].text == NULL) {
		strcpy(outgoing, "-ERR No such message\r\n");
		sosend(fo, outgoing, 1);
		return;
	}
	if (indexptr[msgnum].deleted) {
		strcpy(outgoing, "-ERR You deleted that message.\r\n");
		sosend(fo, outgoing, 1);
		return;
	}
	strcpy(line, indexptr[msgnum].text);
	recordname = strtok(line, " \t\r\n");
	octets = strtok(NULL, " \t\n\r");

	/*
	 * open msg read msg send msg until eof close msg .
	 */
	msg = openmsg(option.username, recordname);
	if (!msg) {
		sprintf(outgoing, "-ERR %s\r\n", jfpop_errstr[0] ?
			jfpop_errstr : "message missing");
		sosend(fo, outgoing, 1);
		return;
	}
	sprintf(outgoing, "+OK %s octets\r\n", octets);
	sosend(fo, outgoing, 0);
	while (!eofmsg(msg)) {
		getsmsg(outgoing, sizeof(outgoing), msg);
		if (outgoing[0] == '.')
			sosend(fo, ".", 0);
		if (outgoing[0])
			sosend(fo, outgoing, 0);
		if ((outgoing[0] == '\r') || (outgoing[0] == '\n'))
			counter = 0;
		else
			counter++;
		if (count > 0)
			if (counter >= count)
				break;
	}
	strcpy(outgoing, ".\r\n");
	sosend(fo, outgoing, 1);
	closemsg(msg);
}



int
do_pop3(FILE * fi, FILE * fo)
{
	char            username[1024];
	char            password[1024];
	char            outgoing[2048];
	char            inp_line[2048];
	long            msgnum;
	int             authorized = 0;
	int             x;
	int             i;
	int             retcode;
	char           *p, *q;

	FILE           *index;

	signal(SIGPIPE, myhandler);
	signal(SIGALRM, myhandler);

	memset(username, 0, sizeof(username));
	memset(password, 0, sizeof(username));
	strcpy(outgoing, BANNER);
	sosend(fo, outgoing, 1);

	while (!authorized) {
		memset(inp_line, 0, sizeof(inp_line));
		x = soread(fi, inp_line);
		if (alarmhit) {
			retcode = CONN_SOCKETBROKEN;
			return retcode;
		}
		if (x == -1) {
			retcode = CONN_SOCKETBROKEN;
			return retcode;
		}
		p = strpbrk(inp_line, "\r\n");
		if (p)
			*p = 0;

		if (!strnicmp("USER", inp_line, 4)) {
			p = inp_line + 4;
			while ((*p == 32) || (*p == 9))
				p++;
			strcpy(username, p);
			if (username[0])
				sprintf(outgoing, "+OK\r\n");
			else
				sprintf(outgoing, "-ERR USER not specified\r\n");
			sosend(fo, outgoing, 1);
		} else if (!strnicmp("PASS", inp_line, 4)) {
			if (username[0] == 0) {
				sprintf(outgoing, "-ERR USER not specified\r\n");
				sosend(fo, outgoing, 1);
			} else {
				p = inp_line + 4;
				while ((*p == 32) || (*p == 9))
					p++;
				strcpy(password, p);
				authorized = check_authorized(username, password);
				if (!authorized) {
					sprintf(outgoing, "-ERR %s\r\n",
						jfpop_errstr[0] ? jfpop_errstr : "Bad password");
					sosend(fo, outgoing, 1);
				}
			}
		} else if (!strnicmp("QUIT", inp_line, 4)) {
			sprintf(outgoing, "+OK Bye!\r\n");
			sosend(fo, outgoing, 1);
			retcode = 0;
			return retcode;
		} else {
			strcpy(outgoing, "-ERR Unknown command\r\n");
			sosend(fo, outgoing, 1);
		}

	}


	strcpy(option.username, username);

	/* we should be authorized from here on */


	/* try to open index and read it */
	/* say +OK, or -ERR if we can't open up */

	index = openindex(username, 0);
	if (!index) {
		sprintf(outgoing, "-ERR Error %s\r\n", jfpop_errstr);
		sosend(fo, outgoing, 1);
		return CONN_LOCKERROR;
	}
	readindex(index);
	if (jfpop_err) {
		sprintf(outgoing, "-ERR %s\r\n", jfpop_errstr);
		sosend(fo, outgoing, 1);
		return CONN_UNKNOWN;
	}
	sprintf(outgoing, "+OK Greetings\r\n");
	sosend(fo, outgoing, 1);

	/* handle commands */
	/* when you quit, be sure to save before exiting if needed */





	while (authorized) {
		memset(inp_line, 0, sizeof(inp_line));
		x = soread(fi, inp_line);
		if (alarmhit) {
			retcode = CONN_SOCKETBROKEN;
			closeindex(index);	/* do not writeindex or save */
			return retcode;
		}
		if (x == -1) {
			retcode = CONN_SOCKETBROKEN;
			closeindex(index);	/* do no writeindex or save */
			return retcode;
		}
		p = strpbrk(inp_line, "\r\n");
		if (p)
			*p = 0;
		if (!strnicmp("STAT", inp_line, 4)) {
			strcpy(outgoing, stat_command());
			sosend(fo, outgoing, 1);
		} else if (!strnicmp("QUIT", inp_line, 4)) {
			authorized = 0;
			writeindex(index);
			closeindex(index);
			strcpy(outgoing, "+OK Bye\r\n");
			sosend(fo, outgoing, 1);
			retcode = 0;
			return retcode;	/* normal exit; */
		} else if (!strnicmp("NOOP", inp_line, 4)) {
			strcpy(outgoing, "+OK That was tough.\r\n");
			sosend(fo, outgoing, 1);
		} else if (!strnicmp("LIST", inp_line, 4)) {
			p = inp_line + 4;
			while ((*p == 32) || (*p == 9))
				p++;
			msgnum = atol(p);
			if (msgnum) {
				sprintf(outgoing, "+OK %s\r\n", list_command(msgnum - 1, fo));
				sosend(fo, outgoing, 1);
			} else {
				/* show all */
				sprintf(outgoing, "+OK\r\n");
				sosend(fo, outgoing, 1);
				for (i = 0; i < MAX_MESSAGES; i++)
					if (indexptr[i].text)
						if (!indexptr[i].deleted) {
							sprintf(outgoing, "%s\r\n",


							list_command(i, fo));
							sosend(fo,
							       outgoing, 0);
						}
				strcpy(outgoing, ".\r\n");
				sosend(fo, outgoing, 1);
			}

		} else if (!strnicmp("UIDL", inp_line, 4)) {
			p = inp_line + 4;
			while ((*p == 32) || (*p == 9))
				p++;
			msgnum = atol(p);
			if (msgnum) {
				sprintf(outgoing, "+OK %s\r\n", uidl_command(msgnum - 1, fo));
				sosend(fo, outgoing, 1);
			} else {
				sprintf(outgoing, "+OK\r\n");
				sosend(fo, outgoing, 1);
				/* show all */
				for (i = 0; i < MAX_MESSAGES; i++)
					if (indexptr[i].text)
						if (!indexptr[i].deleted) {
							sprintf(outgoing, "%s\r\n",


							uidl_command(i, fo));
							sosend(fo,
							       outgoing, 0);
						}
				strcpy(outgoing, ".\r\n");
				sosend(fo, outgoing, 1);
			}

		} else if (!strnicmp("RETR", inp_line, 4)) {
			p = inp_line + 4;
			while ((*p == 32) || (*p == 9))
				p++;
			msgnum = atol(p);
			if (msgnum) {
				show_message(msgnum - 1, fo, -1);
			} else {
				sprintf(outgoing, "-ERR RETR missing msgnum\r\n");
				sosend(fo, outgoing, 1);
			}

		} else if (!strnicmp("TOP", inp_line, 3)) {
			p = inp_line + 3;
			while ((*p == 32) || (*p == 9))
				p++;
			p = strtok(p, " \t\r\n");
			q = strtok(NULL, " \t\r\n");
			if (!q) {
				sprintf(outgoing, "-ERR TOP missing argument(s)\r\n");
				sosend(fo, outgoing, 1);
			} else {
				msgnum = atol(p);
				if (msgnum) {
					show_message(msgnum - 1, fo, atol(q));
				} else {
					sprintf(outgoing, "-ERR RETR missing msgnum\r\n");
					sosend(fo, outgoing, 1);
				}
			}

		} else if (!strnicmp("DELE", inp_line, 4)) {
			p = inp_line + 4;
			while ((*p == 32) || (*p == 9))
				p++;
			msgnum = atol(p);
			if (msgnum) {
				if ((indexptr[msgnum - 1].text) &&
				    (indexptr[msgnum - 1].deleted == 0)) {
					indexptr[msgnum - 1].deleted = 1;
					sprintf(outgoing, "+OK Done\r\n");
					sosend(fo, outgoing, 1);
				} else {
					sprintf(outgoing, "-ERR No such message\r\n");
					sosend(fo, outgoing, 1);
				}
			} else {
				sprintf(outgoing, "-ERR DELE missing msgnum\r\n");
				sosend(fo, outgoing, 1);
			}

		} else if (!strnicmp("RSET", inp_line, 4)) {
			for (i = 0; i < MAX_MESSAGES; i++)
				indexptr[i].deleted = 0;
			strcpy(outgoing, "+OK\r\n");
			sosend(fo, outgoing, 1);

		} else {
			strcpy(outgoing, "-ERR Unknown command\r\n");
			sosend(fo, outgoing, 1);
		}

	}
	/* we should NEVER reach this spot. */
	panic(__FILE__, __LINE__, "We should NEVER reach this spot");
	return 999;
}

int
jump_pop3(void)
{
	FILE           *fi, *fo;
#ifdef __OS2__
	int             hsock_in, hsock_out;	/* socket descriptors, kept
						 * global for close routines */
	if (option.socket) {
		/* for os/2 .. */
		hsock_out = _impsockhandle(option.socket, 0);
		if (hsock_out == -1)
			panic(__FILE__, __LINE__, "error occured on emx accept()");
		fo = fdopen(hsock_out, "w");
		fi = fdopen(hsock_out, "r");
		if (!fo) {
			panic(__FILE__, __LINE__, "can't open output stream\n");
		}
		if (!fi) {
			panic(__FILE__, __LINE__, "can't open input stream\n");
		}
	} else {
#endif
		/* stdin/stdout */
		fi = stdin;
		fo = stdout;

#ifdef __OS2__
	}
#endif
	return do_pop3(fi, fo);
}

int
sosend(FILE * file, char *data, int doflush)
{
	int             retcode;

	retcode = fputs(data, file);
	if (doflush)
		fflush(file);
	if (option.debug)
		if (option.socket)
			fprintf(stderr, data);
	if (retcode == EOF) {
		retcode = -1;
	} else {
		retcode = strlen(data);
	}
	return (retcode);
}

int
soread(FILE * file, char *data)
{
	int             retcode;
	char           *temp;
	alarm(60 * 10);		/* Be sure to abort out of routines */
	temp = fgets(data, 2000, file);
	alarm(0);		/* turn off the alarm */
	if (temp) {
		retcode = strlen(data);
	} else {
		retcode = -1;
	}
	if (option.debug)
		if (option.socket)
			fprintf(stderr, data);
	return (retcode);
}

void
stripcrlf(char *temp)
{
	if (temp) {
		if (strchr(temp, '\r')) {
			*strchr(temp, '\r') = '\0';
		}
		if (strchr(temp, '\n')) {
			*strchr(temp, '\n') = '\0';
		}
	}
}
