#include "jfcommon.h"
#ifndef __OS2__
#include <pwd.h>
#endif

/*
 * for the given user ID, verify that the password is correct.
 * 
 * for unix: adapt into getpwent
 * 
 * for os/2: make custom files for this
 * 
 */


char           *
getpassword(char *user)
{				/* might be encrypted! */
#ifndef __OS2__
	passwd         *pass;
#else
	FILE           *file;
	static char     line[1024];
	char            filename[1024];
	char            lookfor[1024];
	char           *p;
	char           *pwuser, *pwpass;
#endif
	if (!user) {
		jfpop_err = POPERR_NOUSER;
		strcpy(jfpop_errstr, "No username specified");
		return NULL;
	}
#ifndef __OS2__
	pass = getpwnam(user);
	endpwent();		/* close password */
	if (!pass) {
		jfpop_err = POPERR_NOUSER;
		strcpy(jfpop_errstr, "No such user");
		return NULL;
	}
	return pass->pw_passwd;
#else
	strcpy(lookfor, user);
	strlwr(lookfor);
	p = getenv("ETC");
	if (!p)
		p = "C:\\ETC";
	sprintf(filename, "%s\\password.pop", p);
	file = fopen(filename, "rt");
	if (!file) {
		jfpop_err = POPERR_NOPASS;
		sprintf(jfpop_errstr, "No password file found at %s", filename);
		return NULL;
	}
	while (!feof(file)) {
		memset(line, 0, sizeof(line));
		fgets(line, sizeof(line), file);
		if (line[0] == 0)
			continue;
		pwuser = strtok(line, ":\r\n");
		pwpass = strtok(NULL, ":\r\n");
		if (pwpass == NULL)
			continue;
		strlwr(pwuser);
		if (strcmp(pwuser, lookfor) == 0) {
			fclose(file);
			return pwpass;
		}
	}
	fclose(file);
	jfpop_err = POPERR_NOUSER;
	strcpy(jfpop_errstr, "User not found");
	return NULL;
#endif

}


int
checkpassword(char *pass, char *supplied)
{
	/* under unix, need to actually use the crypt utils */
#ifndef __OS2__
	char           *ep;
	ep = crypt(supplied, pass);
	if (strcmp(pass, ep) == 0)
#else
	if              (strcmp(pass, supplied) == 0)
#endif
		                return 1;
	return 0;
}

int
check_authorized(char *user, char *supplied)
{
	char            pass[1024];
	char           *p;
	p = getpassword(user);
	if (!p)
		return 0;
	strcpy(pass, p);
	return (checkpassword(pass, supplied));
}
