
#include "jfcommon.h"


/*
 * future version possibily:  use databases.. for now, use file system _as_ a
 * database
 * 
 */

char           *
newname(void)
{
	time_t          t;
	pid_t           p;
	static char     buf[1024];
#ifdef __OS2__
	char            buf_time[1024];
	char            buf_pid[1024];
#endif

	time(&t);
#ifdef __OS2__
	t %= (36 * 36 * 36 * 36 * 36);

#endif
	p = getpid();
#ifdef __OS2__
	p %= (36 * 36 * 36);
#endif

#ifndef __OS2__
	/* Unix */
	sprintf(buf, "%lx-%x", t, (int) p);
#else
	/* OS/2 EMX */
	_ulltoa(t, buf_time, 36);
	_ulltoa(p, buf_pid, 36);
#endif

#ifdef __OS2__
	sprintf(buf, "%s%s", buf_time, buf_pid);
#endif
	return buf;
}


msgtype        *
openmsg(char *username, char *record)
{

	/* if "record" == NULL  then assume create new message */

	msgtype        *msg = NULL;
	char            recordname[1024];

	msg = (msgtype *) calloc(1, sizeof(msgtype));
	if (!msg) {
		jfpop_err = POPERR_NOMEM;
		strcpy(jfpop_errstr, "No memory for msg in routine openread()");
		return NULL;
	}
	if (record)
		strcpy(recordname, record);
	else
		strcpy(recordname, newname());

	if (strpbrk(recordname, " \t,"))
		*strpbrk(recordname, " \t,") = 0;

	strcpy(msg->username, username);
	strcpy(msg->filename, generic_mailpath(username));
	strcat(msg->filename, recordname);
	strcpy(msg->recordname, recordname);

	msg->file = fopen(msg->filename, record ? "rb" : "wb");
	if (msg->file == NULL) {
		/* unable to open the file */
		jfpop_err = POPERR_NORECORD;
		sprintf(jfpop_errstr, "File not found: %s", msg->filename);
		free(msg);
		msg = NULL;
		return NULL;
	}
	return (msg);
}


char           *
recordnamemsg(msgtype * msg)
{
	return msg ? msg->recordname : "";
}

unsigned long
writesizemsg(msgtype * msg)
{
	/* only valid for messages being _written_ to */
	return msg ? msg->bytes : 0;
}

void
writelnmsg(msgtype * msg, char *line)
{

	/* maximum: 4096 bytes */
	char            linebuf[4096];
	char           *p;

	long            length;

	if (!msg)
		return;

	memset(linebuf, 0, sizeof(linebuf));
	strcpy(linebuf, line);
	p = strpbrk(linebuf, "\r\n");
	if (p)
		*p = 0;
	length = fprintf(msg->file, "%s\r\n", linebuf);
	if ((length == EOF) && (strlen(linebuf) != EOF))
		msg->errorwrite = 1;
	else
		msg->bytes += (strlen(linebuf) + 2);
}

void
closemsg(msgtype * msg)
{
	if (!msg)
		return;
	if (msg) {
		if (msg->file) {
			fclose(msg->file);
			msg->file = NULL;
		}
		free(msg);
		msg = NULL;
	}
}

int
eofmsg(msgtype * msg)
{
	return msg ? feof(msg->file) : 0;
}

int
getcmsg(msgtype * msg)
{
	int             ch;
	if (!msg)
		return EOF;
	ch = fgetc(msg->file);
	return ch;
}

char           *
getsmsg(char *dest, int size, msgtype * msg)
{
	memset(dest, 0, size);
	if (!msg)
		return dest;
	fgets(dest, size, msg->file);
	return dest;
}
