
#include "jfcommon.h"

int
add_msg(FILE * source, char *user)
{
	msgtype        *msg;
	char            line[4096];
	char            recordname[1024];
	unsigned long   recordsize;
	msg = openmsg(user, NULL);	/* create a message */
	if (!msg) {
		if (jfpop_err == 0) {
			jfpop_err = POPERR_UNDEF;
			strcpy(jfpop_errstr, "Unable to create message - unknown reason\n");
		}
		return -1;
	}
	fprintf(stderr, "file record is %s\n", recordnamemsg(msg));

	/* we do have a valid file handle */
	while (!feof(source)) {
		memset(line, 0, sizeof(line));
		fgets(line, sizeof(line), source);
		if (line[0] == 0)
			continue;
		writelnmsg(msg, line);
	}
	if (msg->errorwrite) {
		if (jfpop_err == 0) {
			jfpop_err = POPERR_WRITE;
			sprintf(jfpop_errstr, "Write error saving message");
		}
		return -1;
	}
	strcpy(recordname, recordnamemsg(msg));
	recordsize = writesizemsg(msg);
	sprintf(line, "%s %lu", recordname, recordsize);
	fprintf(stderr, "Adding to index: %s\n", line);
	if (addindex(user, line) < 0) {
		if (jfpop_err == 0) {
			jfpop_err = POPERR_WRITE;
			sprintf(jfpop_errstr, "Unable to add index record  user %s line %s", user, line);
		}
		return -1;
	}
	closemsg(msg);
	return 0;
}

int
jump_receive(void)
{
	if (option.username[0] == 0) {
		fprintf(stderr, "No username specified!");
		exit(option.errorlevel ? option.errorlevel : 255);
	}
	return add_msg(stdin, option.username);
}
