#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <dos.h>
#include <direct.h>
#include <share.h>
#include <io.h>
#include <fcntl.h>
#include <process.h>

char            cline[4096] = "";
char exename[256]="-";
char fsin[256]="-";
char fsout[256]="-";

int
runprogram(char *exename, char *parameters, char *sin, char *sout)
/*
 * exename is the program to run (.exe, .com) parameters are space-delim'd
 * parms sin - file to use for standard in, or NULL if to be left alone sout
 * - file to use for standard out, or NULL if to be left alone
 */
{
#define RUN_MAXPARMS 1000
#define RUN_PARMBUF 4096
	int             oldsin = 0, newsin = 0, oldsout = 0, newsout = 0;
	char            parmbuf[RUN_PARMBUF];
	char            exebuf[RUN_PARMBUF];
	char           *parms[RUN_MAXPARMS];
	int             i;
	int             retcode = 0;

	/* Tokenize parameters */
	for (i = 0; i < RUN_MAXPARMS; i++)
		parms[i] = NULL;
	memset(parmbuf, 0, sizeof(parmbuf));
	if (parameters) {
		strcpy(parmbuf, parameters);
		parms[1] = strtok(parmbuf, " ");
		for (i
		     = 2;
		     i < RUN_MAXPARMS;
		     i++)
			parms[i] = strtok(NULL, " ");
	}
	/* Find .EXE in the PATH and get the full name */
	memset(exebuf, 0, sizeof(exebuf));
	_searchenv(exename, "PATH", exebuf);
	if (exebuf[0] == 0) {
		fprintf(stderr, "Could not find %s in the current PATH\n", exename);
		return 254;
	}
	parms[0] = exebuf;


	/* Redirection of standard in */

	if (sin)
		if (*sin) 
if (strcmp(sin,"-"))
{

			/* Duplicate original handle to restore later. */
			oldsin = dup(fileno(stdin));
			if (oldsin == -1) {
				fprintf(stderr, "dup error on stdin\n");
				return 254;
			}
			newsin = open(sin, O_BINARY);
			if (newsin
				== -1) {
				fprintf(stderr, "Unable to open %s for stdin\n", sin);
				return 254;
				}
//fprintf(stderr,"debug:newsin=%i\n",newsin);
			dup2(newsin, fileno(stdin));
			close(newsin);

		}
	/* Redirection of standard in */

	if (sout)
		if (*sout) 
if (strcmp(sout,"-"))
{

			/* Duplicate original handle to restore later. */
			oldsout = dup(fileno(stdout));
			if (oldsout == -1) {
				fprintf(stderr, "dup error on stdout\n");
				return 254;
			}
			newsout = open(sout, O_BINARY | O_CREAT | O_TRUNC | O_WRONLY, S_IREAD | S_IWRITE);
			if (newsout
				== -1) {
				fprintf(stderr, "Unable to open %s for stdout\n", sout);
				return 254;
				}

//fprintf(stderr,"debug:newsout=%i\n",newsout);
			dup2(newsout, fileno(stdout));
			close(newsout);

		}
	/* spawn */
	retcode = spawnv(P_WAIT, exebuf, parms);

	/* restore */
	if (oldsin) {
		fflush(stdin);
		dup2(oldsin, fileno(stdin));
                close(oldsin);  /* hack 7/23 */
	}
	if (oldsout) {
		fflush(stdout);
		dup2(oldsout, fileno(stdout));
                  close(oldsout); /* hack 7/23 */
	}
  return retcode;
}




char           *
stristr(char *master, char *sub)
{
	int             l;
	l = strlen(sub);
	while (*master) {
		if (!strnicmp(master, sub, l))
			return master;
		master++;
	}
	return NULL;
}


void
showhelp(void)
{
	printf("Usage:   GIGOHELP {STDINNAME or -} {STDOUTNAME or -} prog.exe [parms]\n");
printf("\n\nThis program is merely a redirection helper, to avoid loading CMD.EXE\n");
printf("You are welcome to use this for other purposes, if it helps any, so long\n");
printf("no fee is charged.\n");
	exit(0);
}

int
main(int argc, char *argv[])
{
	int             i;

	if (argc < 4)
		showhelp();
 strcpy(fsin,argv[1]);  
 strcpy(fsout,argv[2]);
 strcpy(exename,argv[3]);
 if (argc>3) 
 for (i=4;i<argc;i++)
  {
  if (i!=4) strcat(cline," ");
   strcat(cline,argv[i]);
 }
i=runprogram(exename,cline,fsin,fsout);
	return i ;
}
