#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <direct.h>
#include <share.h>
#include <io.h>
#include <ctype.h>
#include <sys\stat.h>


#ifdef __BORLANDC__
 #include <dirent.h>
 #define MAXFILES 300
 #define BUFFERING 32000
#else
 #define MAXFILES 1000
 #define BUFFERING 65536
#endif

struct fileinfo
{
  char filename[80];
  char archivename[80];
  char key[200];
  long int partnum;
  long int parttotal;
};

#ifdef __BORLANDC__
  fileinfo huge *files=NULL;
#else
  fileinfo *files=NULL;
#endif

long maxfiles=0;
long totalfiles=0;

void bubblesort()
{
  int bubbles=1;
  fileinfo fi;
  long i;

  if (totalfiles<1) return;
  while (bubbles)
    for(bubbles=0,i=1;i<totalfiles;i++)
     {
       if (strcmp(files[i-1].key,files[i].key)>0)
         {
            memcpy(&fi,&files[i-1],sizeof(fi));
            memcpy(&files[i-1],&files[i],sizeof(fi));
            memcpy(&files[i],&fi,sizeof(fi));
            bubbles=1;
         }
     }
}

void dir_checkfile(char *name)
{
  FILE *file;
  char buf[256];
  char subject[256];
  char begin[256];
  char *filename,*partnum,*splitter,*partof,*p;

  memset(subject,0,sizeof(subject));
  memset(begin,0,sizeof(subject));
  printf("Checking: %12s\r",name);
  file=_fsopen(name,"rb",SH_DENYNO);
  if (!file) return;
  while(!feof(file))
   {
    memset(buf,0,sizeof(buf));
    fgets(buf,sizeof(buf),file);
    if (strnicmp(buf,"Subject: ",9)==NULL)
      strcpy(subject,buf);
    if (strncmp(buf,"begin",5)==NULL)
      strcpy(begin,buf);
    p=buf;
    while(*p)
      if (isascii(*p++)==0)
        {strcpy(begin," ");
          strcpy(subject," ");}
    if ((*begin) && (*subject)) break;
   }
  fclose(file);

  if (!*subject) if (!*begin)
       return;
  if (*subject)
   {
    strcpy(buf,subject);
    p=strtok(buf," ");         // "Subject:"
    filename=strtok(NULL," ");  // filename
    partnum=strtok(NULL," ");  // 01

    if (stricmp(partnum,"part")==NULL)
        partnum=strtok(NULL," ");   // I said, 01!
    splitter=strtok(NULL," ");  // of
    partof=strtok(NULL," ");   // 99
    p=strtok(NULL," ");

    if ((partof)  && (!p))
      if ((stricmp(splitter,"\\")) || (stricmp(splitter,"of")))
        {
          strcpy(files[totalfiles].filename,name);
          strcpy(files[totalfiles].archivename,filename);
          files[totalfiles].partnum=atol(partnum);
          files[totalfiles].parttotal=atol(partof);
          sprintf(files[totalfiles].key,"%s%08lu%08lu",filename,
           files[totalfiles].partnum,files[totalfiles].parttotal);
          totalfiles++;
          return;
        }
   }
  if (*subject)
   {
    strcpy(buf,begin);
    p=strtok(buf," ");         // "begin"
    p=strtok(NULL," ");        // 644
    filename=strtok(NULL," ");  // filename
    if (filename)
        {
          strcpy(files[totalfiles].filename,name);
          strcpy(files[totalfiles].archivename,filename);
          files[totalfiles].partnum=1;
          files[totalfiles].parttotal=1;
          sprintf(files[totalfiles].key,"%s%08lu%08lu",filename,
           files[totalfiles].partnum,files[totalfiles].parttotal);
          totalfiles++;
          return;
        }
   }
}

#ifdef __BORLANDC__
  #define OPENDIRSPEC ""
#else
  #define OPENDIRSPEC "*.*"
#endif

void            parse_dir(void func(char *))
{
    DIR            *dir;
    struct dirent  *ent;
    errno = 0;
redo:
    if ((dir = opendir(OPENDIRSPEC)) == NULL) {
        fprintf(stdout, "Unable to open directory\n");
        return;
    }
    while ((ent = readdir(dir)) != NULL) {
        if (ent->d_name[0]!='.')
          func(ent->d_name);
    }
    free((char*) dir);
}

void showfiles(void)
{
   long index;
   for (index=0;index<totalfiles;index++)
          printf("%lu | File: %s   Part %lu of %lu\n",
             index,
             files[index].filename,
             files[index].partnum,
             files[index].parttotal);
}

int uustrip(char *inname,char *outname)
{
  FILE *infile,*outfile,*testfile;
  char buf[256];
  int length;
  char index;
  char *p;
  char *validtokens[]={"begin","end","table","sum","section"};
  int allowline;
  int goodlines=0;
  int hadblank=0;

  infile=_fsopen(inname,"rt",SH_DENYNO);
  if (!infile)
   {
     fprintf(stderr,"Error opening %s\n",inname);
     return 1;
   }
  outfile=_fsopen(outname,"wt",SH_DENYRW);
  if (!outfile)
   {
    fprintf(stderr,"Error opening %s\n",outname);
    fclose(infile);
    return 1;
   }
 setvbuf(infile,NULL,_IOFBF,BUFFERING);
 setvbuf(outfile,NULL,_IOFBF,BUFFERING);
 while(!feof(infile))
  {
    buf[0]=0;
    fgets(buf,sizeof(buf),infile);
    if (buf[0]=='\n') hadblank=1;
    if (allowline=goodlines) goodlines--;

    if (!allowline)
    for (index=0;index<5;index++)
     if (strncmp(buf,validtokens[index],strlen(validtokens[index]))==NULL)
       allowline=1;
    if (strnicmp(buf,"begin ",6)==NULL)
      {
       p=buf;
       while (strpbrk(p," /\\:")) p++;
       if (!*p) p="noname";
       p=strtok(p," \n\r\0x09");
       testfile=_fsopen(p,"wb",SH_DENYNO);
       if (testfile)
         {
          if (isatty(fileno(testfile)))
               {strcat(p,"!"); fclose(testfile);}
	  else {fclose(testfile);unlink(p);}
         }
       sprintf(buf,"begin 644 %s\n",p);
      }
    if (!allowline)
       {
       length=(char)(((buf[0])-' ')&077) ; //46
       length*=4;
       length/=3;
       if (length) length++;
       allowline=((strlen(buf)>=length) && (strlen(buf)<=length+4)) ;
       if (!allowline) if (hadblank)
        if(strncmp(buf,"--",2))
         if (strlen(buf)>1)
         fprintf(stderr,"dat**?  %s",buf);
      }
    if (allowline)
      {
    if (strncmp(buf,"table",5)==NULL) goodlines=2;
    fprintf(outfile,"%s",buf);
      }
      //else
      //printf("Skip: %s",buf);
  }
 fclose(outfile);
 fclose(infile);
 return 0;
}

void process(char *name)
{
  long index;
  int err=0;
  char buf[256];
  printf("Processing %s\n",name);
  for (index=0;index<totalfiles;index++)
   if (strcmp(name,files[index].archivename)==NULL)
    {
       sprintf(buf,"part%lu",files[index].partnum);
       printf("uustriping %s to %s\n",files[index].filename,buf);
       err+=uustrip(files[index].filename,buf);
       if (err) break;
    }
  printf("\n");
  if (!err) err=system("UUDECODE -Y PART1.");
  if (err) printf("Bummer..\n");
  else printf("Cool!\n");


  for (index=0;index<totalfiles;index++)
   if (strcmp(name,files[index].archivename)==NULL)
        {
         printf(" Deleting part%lu\r",files[index].partnum);
         sprintf(buf,"part%lu",files[index].partnum);
         unlink(buf);
         if (!err)
          unlink(files[index].filename);
        }
  printf("\n");
}
void processfiles(void)
{
   long index;
   for (index=0;index<totalfiles;index++)
    if (files[index].partnum==1)
      process(files[index].archivename);
}

void main(int argc, char *argv[])
{
  unsigned long L;

  fprintf(stderr,"UUALL Copyright 1994 Jason Fesler.\n");
  setvbuf(stdout,NULL,_IONBF,0);


  #ifdef __BORLANDC__
  L=sizeof(fileinfo);
  L*=MAXFILES;
  files=(fileinfo huge*) farmalloc(L);
  if (files)
    memset(files,0,L);
  #else
  files=(fileinfo*) calloc(sizeof(fileinfo),MAXFILES);
  #endif
  if (!files)
  {
   fprintf(stderr,"Could not allocate memory.\n");
   exit(255);
  }
  maxfiles=MAXFILES;
 parse_dir(dir_checkfile);
 if (!totalfiles)
  {
    printf("No suitable files found.\n");
    exit(0);
  }
 bubblesort();
 processfiles();
}
