#include <i86.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <dos.h>
#include <time.h>

extern int      sim_usedosmem;
extern int      sim_useuppermem;


struct meminfo {
    unsigned        LargestBlockAvail;
    unsigned        MaxUnlockedPage;
    unsigned        LargestLockablePage;
    unsigned        LinAddrSpace;
    unsigned        NumFreePagesAvail;
    unsigned        NumPhysicalPagesFree;
    unsigned        TotalPhysicalPages;
    unsigned        FreeLinAddrSpace;
    unsigned        SizeOfPageFile;
    unsigned        Reserved[3];
}               MemInfo;

static struct rminfo {
    long            EDI;
    long            ESI;
    long            EBP;
    long            reserved_by_system;
    long            EBX;
    long            EDX;
    long            ECX;
    long            EAX;
    short           flags;
    short           ES,
                    DS,
                    FS,
                    GS,
                    IP,
                    CS,
                    SP,
                    SS;
}               RMI;

char           *lastmadeptr = NULL;
unsigned long   sim_lastdosmemory = 0;


/* simulate.cpp 13/12/93 11.57.58 */
unsigned long   sim_upper_coreleft(void);
unsigned long   sim_lower_coreleft(void);
unsigned long   coreleft(void);
short           sim_getselector(unsigned short paragraphs);
void            sim_dumpselector(short selector);
void            sim_init(void);
void            sim_free(char *p);
char           *sim_alloc(unsigned long size);
void           *sim_realloc(char *p, unsigned long newsize);
void           *sim_calloc(unsigned long size, unsigned long elements);


unsigned long   sim_upper_coreleft()
{
    union REGS      regs;
    struct SREGS    sregs;
    int             interrupt_no = 0x31;
    if (!sim_useuppermem)
        return 0;

    regs.x.eax = 0x00000500;
    memset(&sregs, 0, sizeof(sregs));
    sregs.es = FP_SEG(&MemInfo);
    regs.x.edi = FP_OFF(&MemInfo);

    int386x(interrupt_no, &regs, &regs, &sregs);
    return MemInfo.LargestBlockAvail;
}

unsigned long   sim_lower_coreleft(void)
{
    unsigned long   increaseby = 0x1000;    /* use 4k increments & start at
                                             * 4k */
    unsigned long   amount = increaseby;
    char           *p;
    if (!sim_usedosmem)
        return 0;

    for (;;) {
        p = sim_alloc(amount);

        if ((((unsigned long) p) > 0xfffff) || (!p)) {
            sim_free(p);
            amount -= 0x1000;
            sim_lastdosmemory = amount;
            return amount;
        }
        sim_free(p);
        amount += 0x1000;
    }
}

unsigned long   coreleft(void)
{
    unsigned long   l1,
                    l2;
    l1 = sim_upper_coreleft();
    l2 = sim_lower_coreleft();
    if (l1 > l2)
        return l1;
    else
        return l2;
}

int             heapcheck(void)
{
    return _heapchk();
}


short           sim_getselector(unsigned short paragraphs)
{
    union REGS      regs;
    struct SREGS    sregs;
    int             interrupt_no = 0x31;
    short           selector;
    unsigned short  segment;
    unsigned long   fulladdress;
    char far       *str;
    /* DPMI call 100h allocates DOS memory */
    memset(&sregs, 0, sizeof(sregs));
    regs.w.ax = 0x0100;
    regs.w.bx = 0x0001;
    int386x(interrupt_no, &regs, &regs, &sregs);
    segment = regs.w.ax;
    selector = regs.w.dx;


    fulladdress = segment;
    fulladdress *= 16;
    lastmadeptr = (char *) fulladdress;

    if (regs.x.cflag & 1)
        return 0;
    return selector;

}
void            sim_dumpselector(short selector)
{
    union REGS      regs;
    struct SREGS    sregs;
    int             interrupt_no = 0x31;
    short           segment;
    char far       *str;
    /* DPMI call 100h allocates DOS memory */
    memset(&sregs, 0, sizeof(sregs));
    regs.w.ax = 0x0101;
    regs.w.dx = selector;
    int386x(interrupt_no, &regs, &regs, &sregs);
}


#define TABLESIZE 10

short int       sim_inityet = 0;

struct sim_table_type {
    short           selector;
    char           *p;
}               sim_table[TABLESIZE];

void            sim_init(void)
{
    if (sim_inityet)
        return;
    sim_inityet++;
    sim_lastdosmemory = 0;
    memset(sim_table, 0, sizeof(sim_table));
}


void            sim_free(char *p)
{
    int             i;
    unsigned long   l;
    sim_init();
    l = (unsigned long) p;
    l /= 16;
    if (l < 0x10000) {          /* if it's in the lower meg */
        for (i = 0; i < TABLESIZE; i++)
            if (p == sim_table[i].p) {
                sim_dumpselector(sim_table[i].selector);
                memset(&sim_table[i], 0, sizeof(sim_table_type));
                return;
            }
    } else
        free(p);
}

char           *sim_alloc(unsigned long size)
{
    union REGS      regs;
    struct SREGS    sregs;
    int             interrupt_no = 0x31;
    short           selector;
    unsigned short  segment;
    unsigned long   fulladdress;
    int             index;
    char           *str = NULL;
    sim_init();
    if (!sim_usedosmem)
        goto useuppermemory;

usedosmemory:

    /* DPMI call 100h allocates DOS memory */
    memset(&sregs, 0, sizeof(sregs));
    regs.w.ax = 0x0100;
    fulladdress = size;
    fulladdress += 15;
    fulladdress /= 16;          /* get # of paragraphs; */
    if (fulladdress < 0xffff) {
        regs.w.bx = fulladdress;/* number of paragraphs being requests */
        int386x(interrupt_no, &regs, &regs, &sregs);

        if ((regs.x.cflag & 1) == 0) {  /* meaning, if there was no error, */
            segment = regs.w.ax;
            selector = regs.w.dx;
            fulladdress = segment;
            fulladdress *= 16;
            str = (char *) fulladdress;
            for (index = 0; index < TABLESIZE; index++)
                if (!sim_table[index].p) {
                    sim_table[index].p = str;
                    sim_table[index].selector = selector;
                    lastmadeptr = str;
                    return str;
                }
            /* oh shit.  No way to remember it! */

            sim_dumpselector(selector);
        }
        /* use standard allocation methods */
    }
useuppermemory:
    if (!sim_useuppermem)
        return NULL;
    str = (char *) malloc(size);
    return str;
}


int             sim_realloc_error = 0;
void           *sim_realloc(char *p, unsigned long newsize)
{
    int             i;
    unsigned long   l;

    union REGS      regs;
    struct SREGS    sregs;
    int             interrupt_no = 0x31;
    short           segment;
    char far       *str;
    sim_init();



    if (!newsize) {
        sim_free(p);
        return NULL;
    }
    if (!p) {
        return (void *) sim_alloc(newsize);
    }
    l = (unsigned long) p;
    if (l > 0xfffff)            /* if it's in the lower meg */
        return realloc((void *) p, newsize);

    newsize += 15;
    newsize /= 16;

    for (i = 0; i < TABLESIZE; i++)
        if (p == sim_table[i].p) {
            /* DPMI call 100h allocates DOS memory */
            memset(&sregs, 0, sizeof(sregs));
            regs.w.ax = 0x0102;
            regs.w.dx = sim_table[i].selector;
            regs.w.bx = newsize;
            int386x(interrupt_no, &regs, &regs, &sregs);
            sim_realloc_error = 0;
            if (regs.x.cflag & 1)
                sim_realloc_error = regs.w.ax;
            return p;           /* no matter what, send it back.. if it
                                 * doesn't shrink, oh well. */
        }
    return NULL;                /* sorry keemosabee, no pointer to realloc in
                                 * that structure */
}
void           *sim_calloc(unsigned long size, unsigned long elements)
{
    unsigned long   l;
    void           *p;
    l = size;
    l *= elements;

    p = sim_alloc(l);
    if (!p)
        return NULL;
    memset(p, 0, l);
    return p;

}
 /* void recurse(void) { char *p;
  *
  * printf("Coreleft:   %u / %u \n", sim_lower_coreleft(),sim_upper_coreleft());
  * p=sim_alloc(65536); if (p) { printf("Allocated address: %p  "); if (
  * (unsigned long) p < 0xfffff) printf("  (Dos Memory)\n"); else printf("
  * (The Real Stuff)\n");
  *
  * memset(p,0,65535);
  *
  * if (stackavail()>500) recurse(); else { printf("No more stack space for
  * recursion.\n"); delay(1000); } printf("Freeing %p..\n"); sim_free(p); } }
  *
  *
  * void main() { recurse(); sim_usedosmem=0;recurse();
  * sim_usedosmem=1;sim_useuppermem=0;recurse(); } */
