
/**/
/*                                                        */
/* This function will "munge" a uucp filename into a DOS  */
/* compatible filename in the scheme of WAFFLE 1.63       */
/*                                                        */
/* See the WAFFLE DOCS for information on the scheme used */
/*                                                        */
/**/

/* Modified 3/8/91 to fix a bug with "eastern" "D.eastee48eca7"
   returning VE48ECA7.D instead of EE48ECA7.D  by calculating the
   "residue" on only the last 6 chars of the stripped name */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>


/* Function Prototypes */
int             pow2(int n);
/* Table of prefix characters */
char            codes[36] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A',
    'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L',
    'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',
'X', 'Y', 'Z'};


char *foobarmunge(char *filename)
{
 static char munged[256];
 char orig[256];
 char *temp;
 int i,j,cmax,cd;


 strcpy(orig,filename);
 while(strlen(filename)>7) filename++;
 while(strchr(filename,'.')) filename++;

 memset(munged,0,sizeof(munged));
 strcpy(munged,"0");
 strcat(munged,filename);
 temp=munged;
 while(strlen(temp)>5) temp++;

 j=0;
 if (islower(temp[4])) j+=1;
 if (islower(temp[3])) j+=2;
 if (islower(temp[2])) j+=4;
 if (islower(temp[1])) j+=8;
 if (islower(temp[0])) j+=16;

  munged[0] = codes[j & 0x1f];
    strcat(munged, ".");
    strncat(munged,orig, 1);

    return munged;
}

char           *munge163(char *hostname, char *filename, int mode)
{

    static char     munged[256];
    char            temp[256],
                    c,
                   *cptr;
    int             i,
                    j,
                    cd,
                    cmax,
                    flag;
    /* Check that filename begins with 'D.' or 'X.' */
    if (strnicmp(filename, "D.", 2) && strnicmp(filename, "X.", 2) && strnicmp(filename, "C.", 2))
        return "BOGUS";

    /* Check hostname for validity */
    if (strlen(hostname) > 7) {
        /* Truncate it if > 7 */
        *(hostname + 7) = '\0';
    }
    /* strip off first n characters that match the hostname */
    for (i = 0; i < strlen(hostname); i++) {
        if (*(hostname + i) != *(filename + i + 2))
            break;
    }
    /*
     * unknown what this does if(i==0){ if(mode == 0){ strcpy(munged,
     * "#BOGUS#"); return(munged); } else{ i = mode - 1; } }
     */

    /* Copy just the unique part to temp */
    strcpy(temp, (filename + i + 2));

    /* see if temp is longer than 6 chars */
    /* if so, only calculate residue on last 6 */
    if (strlen(temp) >= 7) {
        cptr = temp + (strlen(temp) - 6);
    } else {
        cptr = temp;
    }

    /* Calculate 'code'  */
    cd = 0;
    cmax = strlen(cptr) - 1;

#ifdef AK
    for (i = cmax; i >= 0; i--)
        if (islower(*(cptr + i)))
            cd |= 1 << (cmax - i);
#else
    for (i = cmax; i >= 0; i--) {
        /*
         * AK: Is this program written in C or in BASIC? In C it is the most
         * complicated way possible.
         */
        if (islower(*(cptr + i))) {
            j = 1;
        } else {
            j = 0;
        }
        cd += j * (pow2(cmax - i));
    }
#endif

    /* Build final filename */
    munged[0] = codes[cd & 0x1f];
    munged[1] = '\0';
    strcat(munged, temp);

    strcat(munged, ".");
    strncpy(temp, filename, 1);
    temp[1] = '\0';
    strcat(munged, temp);

    return strupr(munged);
}
#ifndef AK

/**/
/* raise 2 to the nth power */
/**/

int             pow2(int n)
{
    switch (n) {
 case 0:
        return 1;
      case 1:
        return 2;
      case 2:
        return 4;
      case 3:
        return 8;
      case 4:
        return 16;
      case 5:
        return 32;
      case 6:
        return 64;
      case 7:
        return 128;
      default:
        fprintf(stderr, "Out of range in function'munge163/pow2()'\n");
        fprintf(stderr, "        --THIS SHOULD NEVER HAPPEN--\n");
        exit(1);
    }
    return 0;
}
#endif

char           *waffle_munger(char *str, char *system, char *ourname)
{
    char           *p;
    char            temp[128];
    char           *p1,
                   *p2;

    int             picky = 8;
loop:
    strcpy(temp, system);
    temp[picky] = 0;
    if (strncmp(temp, str + 2, strlen(temp)) == NULL) {
        strcpy(temp, system);
        p = munge163(temp, str, 1);
        return p;
    }
    strcpy(temp, ourname);
    temp[picky] = 0;
    if (strncmp(temp, str + 2, strlen(temp)) == NULL) {
        strcpy(temp, ourname);
        p = munge163(temp, str, 1);
        return p;
    }
    picky--;
    if (!picky) return(foobarmunge(str));
    goto loop;
}


main(int argc, char *argv[])
{
 if (argc!=4)
   {
    fprintf(stderr,"Usage:  %s unixfilename hostname sitename\n",argv[0]);
    exit(1);
   }
 printf("%s\n",waffle_munger(argv[1],argv[2],argv[3]));
}