  /*
   * BCONIO.H, BCONIO.C
   *
   * BORLAND "CONIO.H" COMPATIBILITY HANDLER
   *
   * MADE FOR WATCOM C++/32 v9.5 + RATIONAL SYSTEMS DOS4GW.EXE  EXTENDER
   *
   *
   * WILL REQUIRE MODS FOR ANY OTHER SYSTEM!
   *
   */

#include "bse.h"

/*
#define bconio
#include "bconio.h"
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>
#include <dos.h>
#include <malloc.h>
//#define test

*/

#undef vscreen
#define vscreen(x,y)  ourscreen[80*((y)-1)+(x)-1]


 int usevideo=1;

unsigned short int *ourscreen=NULL;  // will point to the real screen
unsigned short int directvideo=0;
         short int _wscroll=1;
struct text_info c_ti;

unsigned videotype = 0;  //1=color 2=mono 0=detect

  /*  Note below, the extra 0 -- we are using 32bit pointers! */

#define ON_A_COLOR 0xb8000
#define ON_A_MONO  0xb0000


void textmode(short newmode)
 {
  short m;
  short l;

  struct videoconfig vc;

if (newmode==NOMODECHANGE) goto getvc;

  m=newmode;
  if (m==C4350) m=CO80;
  l=_setvideomode(m);
  if (!l) l=_setvideomode(_DEFAULTMODE);
  if (newmode==C4350) l=_settextrows(_MAXTEXTROWS);

getvc:
  _getvideoconfig(&vc);

  c_ti.winleft=c_ti.wintop=1;
  c_ti.screenwidth=c_ti.winright=(char) vc.numtextcols;
  c_ti.screenheight=c_ti.winbottom=(char) vc.numtextrows;


  if ((vc.adapter==_MDPA) || (vc.adapter==_HERCULES))
    ourscreen=(unsigned short int *) ON_A_MONO;
   else
    ourscreen=(unsigned short int *) ON_A_COLOR;
  if (videotype==1)
    ourscreen=(unsigned short int *) ON_A_COLOR;
  else if (videotype==2)
    ourscreen=(unsigned short int *) ON_A_MONO;

  gotoxy(1,1);
  textattr(15);
 }

void imitate_borland(void)
 {
  textmode(NOMODECHANGE);
  cprintf("bconio init'd\r\n");
  }


void clrscr(void)
 {
     short int x,y,a;
  if (!usevideo) return;

     if (!directvideo)
      {
        scrollwindow(50);
        gotoxy(1,1);
        return;
      }
     a=c_ti.attribute;
     a*=256;
     a+=32;
     for (x=c_ti.winleft;
          x<=c_ti.winright;
            x++)
        for (y=c_ti.wintop;
             y<=c_ti.winbottom;
              y++)
          vputchar((char)x,(char)y,a);
     gotoxy(1,1);

 }
void clreol(void)
 {
     short int x,y,a;
  if (!usevideo) return;
     a=c_ti.attribute;
     a*=256;
     y=(char)(c_ti.cury+c_ti.wintop - 1);
     for (x=(char)(c_ti.curx+c_ti.winleft-1);
          x<=c_ti.winright;
            x++)
          vputchar((char)x,(char)y,a);
     if (!directvideo) // if it wasn't direct, then we need to move the cursor back
       gotoxy(c_ti.curx,c_ti.cury); // move the cursor back to where it belongs

 }

char wherex()
 {
   return c_ti.curx;
 }
char wherey()
 {
   return c_ti.cury;
 }



void scrollwindow(int amount)
 { int aoffset;
   int max = c_ti.winbottom-c_ti.wintop+1;
   char x,y,i;
  if (!usevideo) return;

   x=wherex();
   y=wherey();

   while (abs(amount) > max) amount--;
   if (!amount) amount=max;

   aoffset=(c_ti.winright - c_ti.winleft) * abs(amount);

   /**********************************
    * Get a copy of the old window and copy it to it's new location
    */

   if (!directvideo)
     _scrolltextwindow((signed char) amount);
   else
   if (abs(amount)<max)
      {


       if (amount>0)
            movetext(c_ti.winleft,
                    (char)(c_ti.wintop+amount),
                    c_ti.winright,
                    c_ti.winbottom,

                    c_ti.winleft,
                    c_ti.wintop);
        else
           movetext(c_ti.winleft,          // remember, AMOUNT is negative; values are reveresed
                    c_ti.wintop,
                    c_ti.winright,
                    (char)(c_ti.winbottom+amount),  // actaully, bottom-1,bottom-2.etc
                    c_ti.winleft,
                    (char)(c_ti.wintop-amount)); // actually, top+1,top+2, etc
      }

  /*
   *  This section redraws the missing parts of the screen with the
   *  current screen attributes
   */

   if (amount>0)
     for (i=(char)(max-amount+1);i<=max;i++)
       {
        gotoxy(1,i);
        clreol();
       }
   else
     for (i=1;i<=abs(amount);i++)
       {
         gotoxy(1,i);
         clreol();
       }
   gotoxy(x,y);
 }

void gettextinfo(struct text_info *r)
 {
    memcpy(r,&c_ti,sizeof(c_ti));
 }

void settextinfo(struct text_info *r)
 {
    memcpy(&c_ti,r,sizeof(c_ti));
    gotoxy(c_ti.curx,c_ti.cury);
    textattr(c_ti.attribute);
 }


void gettext(char x1,char y1,char x2,char y2,void *buf)
 {
    unsigned short int *buffer=(unsigned short int*) buf;
    char x,y;
    for (y=y1;y<=y2;y++)
     for (x=x1;x<=x2;x++)
      *buffer++=vgetchar(x,y);
    if (!directvideo)
      gotoxy(c_ti.curx,c_ti.cury);

 }
void puttext(char x1,char y1,char x2,char y2,void *buf)
 {
    unsigned short int *buffer=(unsigned short int*) buf;
    unsigned short int i;
    char x,y;
    for (y=y1;y<=y2;y++)
     for (x=x1;x<=x2;x++)
     {i=*buffer++;
      vputchar(x,y,i);}
    if (!directvideo)
      gotoxy(c_ti.curx,c_ti.cury);
 }

void movetext(char x1,char y1,char x2,char y2,char x3,char y3)
 {
    short offx,offy,x,y;
    short int i;

    offx = (short)((short)x3-(short)x1);
    offy = (short)((short)y3-(short)y1);

    for (y=y1;y<=y2;y++)
     for (x=x1;x<=x2;x++)
      {
        i=vgetchar((char)x,(char)y);
        vputchar((char)(x+offx),(char)(y+offy),i);
      }

    if (!directvideo)
      gotoxy(c_ti.curx,c_ti.cury);
 }



short voffset(char x,char y)
 {
    return (short)(80*(y-1)+x-1);
 }

#undef vputchar
#undef vgetchar

//dl = x, dh = y



void _bc_move(char , char );
#pragma aux _bc_move = \
  "mov ah, 2"\
  "mov bh, 0"\
  "int 10H"\
  parm [dl] [dh]\
  modify [eax ebx ecx edx];



void _bc_write(char , char );
#pragma aux _bc_write = \
  "mov ah, 9"\
  "mov bh, 0"\
  "mov cx, 1"\
  "int 10H"\
  parm [al] [bl]\
  modify [eax ebx ecx edx];

short _bc_get(void);
#pragma aux _bc_get = \
  "mov ah, 8"\
  "mov bh, 0"\
  "int 10H"\
  modify [eax ebx ecx edx];


void vputchar(char x,char y,short a)
 {
  char x1,x2;

  if (directvideo)
    {
     vscreen(x,y)=a;
     return;
    }


  x--;y--;
  _bc_move(x,y);
  x1 = (char) a;
  x2 = (char) (a >> 8);
  _bc_write(x1,x2);

 }
short vgetchar(char x,char y)
 {
  if (directvideo)
     return vscreen(x,y);

  x--;y--;
  _bc_move(x,y);
  return _bc_get();
 }


void gotoxy(char x,char y)
 {

  if (!usevideo) return;
  if (x<1) return;
  if (x>c_ti.winright - c_ti.winleft + 1) return;
  if (y<1) return;
  if (y>c_ti.winbottom - c_ti.wintop + 1) return;


  // remember, graph.h is BACKWORDS!!!
  _settextwindow(c_ti.wintop,c_ti.winleft,c_ti.winbottom,c_ti.winright);
  _settextposition(y,x);
  c_ti.curx=x;c_ti.cury=y;
 }

void textattr(char a)
 {
  if (!usevideo) return;
  c_ti.attribute=a;
  _settextcolor(a);
 }

void bell(void)
 {
  if (!usevideo) return;
     sound(440);
     delay(50);
     sound(220);
     delay(50);
     sound(110);
     delay(50);
     nosound();
 }


void cputchar(char ch)
{  short int a;

   switch ( ch )
   {
     case 0 : break;                                      /* null */
     case 7 : bell();break;                               /* bell */
     case 8 : if (c_ti.curx > 1) c_ti.curx--; break;      /* bs   */
     case 10: goto linefeed;                              /* lf   */
     case 12: clrscr();break;                             /* ff   */
     case 13: c_ti.curx = 1;break;                        /* cr   */
     default: a = c_ti.attribute;
              a *= 256;
              a += ch;
              vputchar((char)(c_ti.winleft + c_ti.curx - 1),
                       (char)(c_ti.wintop  + c_ti.cury -1),
                       a);
              if (c_ti.curx < (c_ti.winright - c_ti.winleft + 1))
                c_ti.curx++;
               else
                {
                    c_ti.curx=1;
          linefeed: if (!_wscroll) return;
                    if (_wscroll>0)
                      {
                       if (c_ti.cury < (c_ti.winbottom - c_ti.wintop + _wscroll))
                        c_ti.cury+=_wscroll;
                       else
                        scrollwindow(1);
                      }
                      else
                      {
                       if (c_ti.cury > 1-_wscroll)
                        c_ti.cury-=_wscroll;
                       else
                        scrollwindow(_wscroll);
                      }
                    break;
                }
   }
}

void cputs(char *str)
 {
  unsigned short ch;
  if (!usevideo) return;
  while (*str)
    cputchar((char)(ch=(char)(*str++)));
  gotoxy(c_ti.curx,c_ti.cury);
 }

void cputch(char ch)
 {
  if (!usevideo) return;
     cputchar(ch);
     gotoxy(c_ti.curx,c_ti.cury);
 }

void cprintf(char *fmt, ...)
{
   va_list argptr;
   char *buf;
   size_t maxsize;
  if (!usevideo) return;


   maxsize=stackavail();
   if (maxsize<4096)
     {
nomem:
      cputs("No memory to format ");
      cputs(fmt);
      return;
      }
   maxsize -= 2048;
   buf=(char *)alloca(maxsize);
   if (!buf)  goto nomem;

   va_start(argptr, fmt);
   vsprintf(buf,fmt,argptr);
   va_end(argptr);
   cputs(buf);
}

void window(char x1,char y1,char x2,char y2)
 {
  if (!usevideo) return;
 if (x1<1) return;
 if (y1<1) return;
 if (x2>c_ti.screenwidth) return;
 if (y2>c_ti.screenheight) return;
 c_ti.winleft = x1;
 c_ti.winright = x2;
 c_ti.wintop = y1;
 c_ti.winbottom = y2;
 gotoxy(1,1);  // also sets the "graph.h" text limits as well as ours, they'rs are bios driven (ick)
 }


