#define INCL_BASE
#include <os2.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <string.h>
#include <malloc.h>

#define bconio
#include "\watcom\source\bcon2\bco2.h"

 int usevideo=1;
 short int _wscroll=1;
struct text_info c_ti;

int test;
PBYTE testptr;

#define AT  (PBYTE) &

void textmode(short newmode)
 {
  if (newmode) newmode=0;/* shutup! */
  c_ti.winleft=c_ti.wintop=1;
  c_ti.screenwidth=c_ti.winright= (char) 80;
  c_ti.screenheight=c_ti.winbottom=(char) 25;
  gotoxy(1,1);
  textattr(15);
 }

void imitate_borland(void)
 {
  textmode(NOMODECHANGE);
  cputs("bconio/2 interface (C)1994 Jason Fesler\r\n\r\n");
  }

void clrscr(void)
 {
  if (usevideo) scrollwindow(65535);
  gotoxy(1,1);
  return;
}
void clreol(void)
 {
   int pcell;
   if (!usevideo) return;
   pcell = c_ti.attribute;
   pcell *= 256;
   pcell += 32;
   VioScrollUp(
               (short) (c_ti.wintop + c_ti.cury-2),
            (short) (c_ti.winleft + c_ti.curx -2),
               (short) (c_ti.wintop + c_ti.cury - 2),
               (short) (c_ti.winright - 1),
                    (unsigned short) 65535,AT pcell,0);
 }

char wherex()
 {
   return c_ti.curx;
 }
char wherey()
 {
   return c_ti.cury;
 }


void window(char x1,char y1,char x2,char y2)
 {
  if (!usevideo) return;
 if (x1<1) return;
 if (y1<1) return;
 if (x2>c_ti.screenwidth) return;
 if (y2>c_ti.screenheight) return;
 c_ti.winleft = x1;
 c_ti.winright = x2;
 c_ti.wintop = y1;
 c_ti.winbottom = y2;
 gotoxy(1,1);  // also sets the "graph.h" text limits as well as ours, they'rs are bios driven (ick)
 }


void scrollwindow(int amount)
 { int  pcell;
    pcell = c_ti.attribute;
    pcell *=0x100;
    pcell += ' ';
    int max = c_ti.winbottom-c_ti.wintop+1;

    if (!usevideo) return;
    while (abs(amount) > max) amount--;
    if (!amount) amount=max;
    if (amount>0) {
     VioScrollUp(
(short)(c_ti.wintop-1),
           (short)(c_ti.winleft-1),
(short)(c_ti.winbottom-1),
           (short)(c_ti.winright-1),
                   (short) (amount),AT pcell,0);
   }  else{
     amount = 0-amount;
     VioScrollDn(
(short)(c_ti.wintop-1),
           (short)(c_ti.winleft-1),
(short)(c_ti.winbottom-1),
           (short)(c_ti.winright-1),
                   (short) (amount),AT pcell,0);
  }
}

void gettextinfo(struct text_info *r)
 {
    memcpy(r,&c_ti,sizeof(c_ti));
 }

void settextinfo(struct text_info *r)
 {
    memcpy(&c_ti,r,sizeof(c_ti));
    gotoxy(c_ti.curx,c_ti.cury);
    textattr(c_ti.attribute);
 }


void gettext(char x1,char y1,char x2,char y2,void *buf)
 {
    unsigned short int *buffer=(unsigned short int*) buf;
    char x,y;
    for (y=y1;y<=y2;y++)
     for (x=x1;x<=x2;x++)
      *buffer++=vgetchar(x,y);
 }
void puttext(char x1,char y1,char x2,char y2,void *buf)
 {
    unsigned short int *buffer=(unsigned short int*) buf;
    unsigned short int i;
    char x,y;
    for (y=y1;y<=y2;y++)
     for (x=x1;x<=x2;x++)
     {i=*buffer++;
      vputchar(x,y,i);}
 }

void movetext(char x1,char y1,char x2,char y2,char x3,char y3)
 {
    short offx,offy,x,y;
    short int i;

    offx = (short)((short)x3-(short)x1);
    offy = (short)((short)y3-(short)y1);

    for (y=y1;y<=y2;y++)
     for (x=x1;x<=x2;x++)
      {
        i=vgetchar((char)x,(char)y);
        vputchar((char)(x+offx),(char)(y+offy),i);
      }

 }

short vgetchar(int x,int y)
 {
  short pcell;
  unsigned short size=sizeof(pcell);
  VioReadCellStr( AT pcell,
           & size,
            (short)(y-1),
            (short)(x-1),
            0);
  return pcell;
 }

void vputchar(int x,int y,int ac)
{ char buf[6];
  buf[0]=(char)(ac % 256);
  buf[1]=(char)(ac / 256);
  buf[2]=(char)0;
  buf[3]=(char)0;
   VioWrtCellStr (AT ac, 2,(char)(y-1),(char)(x-1), (HVIO) 0L);
 }                       


void gotoxy(int  x,int y)
 {
  USHORT results;
  if (!usevideo) return;
  if (x<1) return;
  if (x>c_ti.winright - c_ti.winleft + 1) return;
  if (y<1) return;
  if (y>c_ti.winbottom - c_ti.wintop + 1) return;

  c_ti.curx=(char)(x); c_ti.cury=(char)(y);
  y = c_ti.wintop + y - 2;
  x = c_ti.winleft + x - 2;
results = -1;
  VioSetCurPos( (char)(y), (char)(x),0);
}


/* #define textattr(a) (c_ti.attribute=(a))void textattr(int a) */

void bell(void)
 {
  if (!usevideo) return;
     DosBeep(440,50);
     DosBeep(0,50);
     DosBeep(220,5);
     DosBeep(0,50);
     DosBeep(110,5);
     DosBeep(0,50);
 }
void cputchar(char ch)
{  short int a;

   switch ( ch )
   {
     case 0 : break;                                      /* null */
     case 7 : bell();break;                               /* bell */
     case 8 : if (c_ti.curx > 1) c_ti.curx--; break;      /* bs   */
     case 10: goto linefeed;                              /* lf   */
     case 12: clrscr();break;                             /* ff   */
     case 13: c_ti.curx = 1;break;                        /* cr   */
     default: a = c_ti.attribute;
              a *= 256;
              a += ch;

              vputchar((char)(c_ti.winleft + c_ti.curx - 1),
                       (char)(c_ti.wintop  + c_ti.cury -1),
                       a);

              if (c_ti.curx < (c_ti.winright - c_ti.winleft + 1))
                c_ti.curx++;
               else
                {
                    c_ti.curx=1;
          linefeed: if (!_wscroll) return;
                    if (_wscroll>0)
                      {
                       if (c_ti.cury < (c_ti.winbottom - c_ti.wintop + _wscroll))
                        c_ti.cury+=_wscroll;
                       else
                        scrollwindow(1);
                      }
                      else
                      {
                       if (c_ti.cury > 1-_wscroll)
                        c_ti.cury-=_wscroll;
                       else
                        scrollwindow(_wscroll);
                      }
                    break;
                }
   }
}


void cputs(register char *str)
 {
  unsigned short ch;
  if (!usevideo) return;
  while (*str)
    cputchar((char)(ch=(char)(*str++)));
  gotoxy(c_ti.curx,c_ti.cury); 
 }
 
void cputch(char ch)
 {
  if (!usevideo) return;
     cputchar(ch);
     gotoxy(c_ti.curx,c_ti.cury);
 }
void            textbackground(char a){  textattr((char)(c_ti.attribute + a*16));}
void            textcolor(char a) {textattr((char)(a));}
void            lowvideo(void){textattr((char)(c_ti.attribute & 0xf7));}
void            highvideo(void){textattr((char)(c_ti.attribute & 0xf7 + 8));}
void            normvideo(void){textattr((char)(7));}

void cprintf(char *fmt, ...)
{
   va_list argptr;
   char *buf;
   size_t maxsize;
  if (!usevideo) return;


   maxsize=stackavail();
   if (maxsize<16384)
     {
nomem:
      cputs("No memory to format ");
      cputs(fmt);
      return;
      }
   maxsize = 8192;
   buf=(char *)alloca(maxsize);
   if (!buf)  goto nomem;

   va_start(argptr, fmt);
   vsprintf(buf,fmt,argptr);
   va_end(argptr);
   cputs(buf);
}

