
struct text_info {
    unsigned char   winleft;    /* left window coordinate */
    unsigned char   wintop;     /* top window coordinate */
    unsigned char   winright;   /* right window coordinate */
    unsigned char   winbottom;  /* bottom window coordinate */
    unsigned char   attribute;  /* text attribute */
    unsigned char   normattr;   /* normal attribute */
    unsigned char   currmode;   /* current video mode: BW40, BW80, C40, C80, or
                                 * C4350 */
    unsigned char   screenheight;   /* text screen's height */
    unsigned char   screenwidth;/* text screen's width */
    unsigned char   curx;       /* x-coordinate in current window */
    unsigned char   cury;       /* y-coordinate in current window */
};
extern struct text_info c_ti;
extern unsigned short int directvideo;
extern unsigned short int *c_ti_work[80 * 25];
extern short int _wscroll;

#define BLACK 0
#define BLUE 1
#define GREEN 2
#define CYAN 3
#define RED 4
#define MAGENTA 5
#define BROWN 6
#define LIGHTGRAY 7
#define DARKGRAY 8
#define LIGHTBLUE 9
#define LIGHTGREEN 10
#define LIGHTCYAN 11
#define LIGHTRED 12
#define PINK LIGHTRED
#define LIGHTMAGENTA 13
#define YELLOW 14
#define WHITE 15

#define LASTMODE _DEFAULTMODE
#define BW80     _TEXTBW80
#define CO80     _TEXTC80
#define BW40     _TEXTBW40
#define CO40     _TEXTC40
#define MONO     _TEXTMONO
#define C4350    (-5)
#define NOMODECHANGE (-6)



void            vputchar(int,int,int);
short           vgetchar(int,int);

void            settextinfo(struct text_info * r);
void            gettextinfo(struct text_info * r);

void            gotoxy(int x, int y);
char            wherex(void);
char            wherey(void);

void            cprintf(char *fmt,...);
void            cputs(char *str);
void            cputch(char);
void            putch(char);

//void            textattr(int newattr);
#define textattr(a) (c_ti.attribute=(a))
void            textbackground(char a);
void            textcolor(char a);
void            lowvideo(char a);
void            highvideo(char a);
void            normvideo(void);
void            _setcursortype(short x1);

void            clrscr(void);
void            clreol(void);
void            window(char x1, char y1, char x2, char y2);
void            insline(void);
void            delline(void);
void            scrollwindow(int);

int             imagesize(char x1, char y1, char x2, char y2);
void            gettext(char x1, char y1, char x2, char y2, void *buf);
void            puttext(char x1, char y1, char x2, char y2, void *buf);
void            movetext(char x1, char y1, char x2, char y2, char x3, char y3);

void imitate_borland(void);

#ifndef bconio
#define textattr(a) (c_ti.attribute=(a))
#define _setcursortype(x1) _settextcursor(x1)
#define wherex() (c_ti.curx)
#define wherey() (c_ti.cury)
#endif

#ifndef NULL
#if defined(__SMALL__) || defined(__MEDIUM__) || defined(__386__)
#define NULL   0
#else
#define NULL   0L
#endif
#endif
