#include <stdio.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>


int             fastaddmsgid = 1;
int             safethreads = 0;
unsigned long   lastaddedmsgid = 0xffffffff;

FILE           *msgidx = NULL, *msgtext = NULL;

void            errormsg(char *msg);
void            errormsgstring(char *fmt,...);


FILE           *
readwrite(char *name)
{
	FILE           *file;
	file = fopen(name, "r+b");
	if (!file) {
		file = fopen(name, "wb");
		if (file)
			fclose(file);
		file = fopen(name, "r+b");
	}
	return file;
}

/*
 * COMMENT_FOR_JASON
 * 
 * We need to start passing the entire MEssage-ID: to this routine, and
 * verifying that the hash was accurate. :(
 * 
 */

FILE           *
findmsgid(unsigned long msgid, char *str)
{
#define MIDSIZE 2048
	char            buf[2048];
	char           *p;
	unsigned long   mm[MIDSIZE];

	FILE           *msgtext = NULL;	/* _local_ msgtext.. */
	unsigned long   m[2], i, j;
	/* return back a FILE pointer of the MSGID in question */
	/* use the fast index to find it */

	if (!msgidx) {
		msgidx = readwrite("MSGID.IDX");
	} else
		fseek(msgidx, 0, SEEK_SET);
	if (!msgidx)
		return NULL;
	while (!feof(msgidx)) {
		memset(mm, 0, sizeof(mm));
		i = fread(mm, 1, sizeof(mm), msgidx);
		if (i < 1)
			break;	/* could not read any more */
		i = i / (sizeof(unsigned long));

		for (j = 0; j < i; j += 2)
			if (m[j] == msgid) {
				if (!fastaddmsgid) {
					fclose(msgidx);
					msgidx = NULL;
				}
				msgtext = readwrite("MSGID.LST");
				if (!msgtext)
					return NULL;
				fseek(msgtext, m[j + 1], SEEK_SET);

#ifdef USELESS_EFFORT
				/* verify that it's the right MSGID */

				memset(buf, 0, sizeof(buf));
				fgets(buf, sizeof(buf), msgtext);
				p = strtok(buf, " \t\r\n");
				p = strtok(NULL, " \t\r\n");
				if (!p) {
					errormsgstring("MSGID.IDX missing data; ignoring record");
					continue;
				}
				if (strcmp(str, p)) {
					errormsgstring("MSGID.IDX entry %s != %s; skiping to next record", str, p);
					continue;
				}
				errormsgstring("MSGID.IDX lookup: %s found", p);


				/* data is good */
				fseek(msgtext, m[j + 1], SEEK_SET);

#endif

				return msgtext;
			}
	}
	if (!fastaddmsgid) {
		fclose(msgidx);
		msgidx = NULL;
	}
	return NULL;

}
FILE           *
findmsgid(char *str)
{
	unsigned long   i;
	while (strchr(str, ' '))
		str++;
	i = strtoul(str, NULL, 16);
	return findmsgid(i, str);
}
extern char    *USENETBUF;
char           *token(char *, char *);
char           *emaddress(char *);

void
addmsgid(unsigned long msgid, char *mid, char *references, char *newsgroups)
{
	unsigned long   thesize;

	if (msgid == lastaddedmsgid)
		return;
	lastaddedmsgid = msgid;

	if (stricmp(newsgroups, "poster") == 0) {
		newsgroups = token(USENETBUF, "Reply-To:");
		if ((!newsgroups) || (!newsgroups[0]))
			newsgroups = token(USENETBUF, "From:");
		if ((!newsgroups) || (!newsgroups[0]))
			newsgroups = token(USENETBUF, "Sender:");
		if ((!newsgroups) || (!newsgroups[0]))
			newsgroups = "poster";
		newsgroups = emaddress(newsgroups);
	}
	if (!msgidx)
		msgidx = readwrite("MSGID.IDX");
	if (!msgidx) {
		printf("Unable to add to msgid.idx");
		return;
	}
	if (!msgtext)
		msgtext = readwrite("MSGID.LST");
	if (!msgtext) {
		printf("Unable to add to msgid.lst");
		fclose(msgidx);
		msgidx = 0;
		return;
	}
	fseek(msgidx, 0, SEEK_END);
	fseek(msgtext, 0, SEEK_END);
	thesize = ftell(msgtext);
	fwrite(&msgid, sizeof(msgid), 1, msgidx);
	fwrite(&thesize, sizeof(thesize), 1, msgidx);
	fprintf(msgtext, "%08lx %s %s\r\n%s\r\n", msgid, references, mid, newsgroups);
	if (!fastaddmsgid) {
		fclose(msgidx);
		msgidx = NULL;
		fclose(msgtext);
		msgtext = NULL;
	}
}
#ifdef NOTUSED
void
showid(unsigned long id)
{
	FILE           *file;
	char            buf[2048];
	file = findmsgid(id);
	if (file) {
		buf[0] = 0;
		fgets(buf, sizeof(buf), file);
		printf("%s", buf);
		buf[0] = 0;
		fgets(buf, sizeof(buf), file);
		printf("%s", buf);
		fclose(file);
	}
}


int 
main(int argc, char *argv[])
{
	FILE           *file;
	int             i;
	for (i = 0; i < 1000; i++) {
 	addmsgid(1, "<id@somewhere.com>","<asshole@somewhere.org>", "alt.spam,alt.hormel");
	}
        addmsgid(2,"<id2@somewhere.com>", "<asshole@somewhere.org> <id@somewhere.com>","alt.spam,alt.hormel");
	addmsgid(3, "<id3@somewhere.com>","<asshole@somewhere.org>", "alt.spam,alt.hormel");
	showid(1);
	showid(4);
	return 0;

}
#endif



