#include <stdio.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>


#ifdef __OS2__
char            inbuf[200000];
char            outbuf[200000];
#else
char            inbuf[16384];
char            outbuf[32768];
#endif


void 
makenewlist(unsigned long keepamount, unsigned long maxamount)
{
	FILE           *fin, *fout;
	char           *p;
	unsigned long   fs;

	unsigned long   totalsize, startingsize;
	unsigned long   percent = 0;
	unsigned long   lastpercent = 0;

	char            linebuf[2048];
	printf("Examining MSGID.LST\n");
	fin = fopen("MSGID.LST", "rb");
	if (!fin) {
		printf("Can not open MSGID.LST\n");
		exit(1);
	}
	setvbuf(fin, inbuf, _IOFBF, sizeof(inbuf));
	fout = fopen("MSGID.NEW", "wb");
	if (!fout) {
		printf("Can not create MSGID.NEW\n");
		exit(1);
	}
	setvbuf(fout, outbuf, _IOFBF, sizeof(outbuf));
	fseek(fin, 0, SEEK_END);
	fs = ftell(fin);
	if (fs < maxamount - 50000) {
		printf("MSGID.TXT is small enough already.\n");
		fclose(fin);
		fclose(fout);
		unlink("MSGID.NEW");
		exit(0);
	}
	totalsize = fs;
	fs = fs - keepamount;
	startingsize = fs;
	printf("Making new file; skipping %lu bytes\n", fs);
	fseek(fin, fs, SEEK_SET);
	for (;;) {
		linebuf[0] = 0;
		fgets(linebuf, sizeof(linebuf), fin);
		if (feof(fin)) {
			printf("Early EOF reached reading MSGID.LST\n");
			fclose(fin);
			fclose(fout);
			unlink("MSGID.NEW");
			return;
		}
		if (p = strpbrk(linebuf, "\r\n"))
			*p = 0;
		if (linebuf[0] == 0)
			continue;
		if (linebuf[strlen(linebuf) - 1] != '>')	/* not References */
			break;
	}
	for (;;) {
		percent = ((ftell(fin) - startingsize) * 100) / keepamount;
		if (percent != lastpercent) {
			printf("Copying.. %2u\%\r", percent);
			lastpercent = percent;
		}
		linebuf[0] = 0;
		fgets(linebuf, sizeof(linebuf), fin);
		if (feof(fin))
			break;
		fwrite(linebuf, strlen(linebuf), 1, fout);
	}
	fclose(fin);
        fclose(fout);
        printf("\nDone copying.\n");
	unlink("MSGID.LST");
	rename("MSGID.NEW", "MSGID.LST");
}

void 
reindex(void)
{
	char            linebuf[2048];
	char            buf2[2048];
	FILE           *fin, *fout;
	char           *p;
	unsigned long   i, pos;
	unsigned long   totalsize;
	unsigned long   percent = 0;
	unsigned long   lastpercent = 0;

	printf("Converting MSGID.LST->MSGID.IDX\n");
	fin = fopen("MSGID.LST", "rb");
	if (!fin) {
		printf("Can not open MSGID.LST\n");
		exit(1);
	}
	fseek(fin, 0, SEEK_END);
        totalsize = ftell(fin);
        fseek(fin,0,SEEK_SET);
	setvbuf(fin, inbuf, _IOFBF, sizeof(inbuf));
	fout = fopen("MSGID.IDX", "wb");
	if (!fout) {
		printf("Can not create MSGID.NEW\n");
		exit(1);
	}
	setvbuf(fout, outbuf, _IOFBF, sizeof(outbuf));

	while (!feof(fin)) {
		linebuf[0] = 0;
		buf2[0] = 0;
		pos = ftell(fin);
		fgets(linebuf, sizeof(linebuf), fin);
		strcpy(buf2, linebuf);
		p = strpbrk(buf2, "\r\n");
		if (p)
			*p = 0;
		if (buf2[0])
			if (buf2[strlen(buf2) - 1] == '>') {
				p = strchr(buf2, 32);
				if (p)
					*p = 0;
				i = strtoul(buf2, NULL, 16);
				fwrite(&i, sizeof(i), 1, fout);
				fwrite(&pos, sizeof(pos), 1, fout);
				percent = (pos * 100) / totalsize;
				if (percent != lastpercent) {
					printf("Indexing.. %lu\%\r", percent);
					lastpercent = percent;
				}
			}
        }
        printf("\nDone indexing.\n");
	fclose(fin);
	fclose(fout);

}



void 
showhelp(char *p)
{
	printf("Usage:  %s [minsize/megs] [maxsize/megs]\n", p);
	printf("   Ie:  %s 15 25   <- shrinks to 15 megs, when it reaches 25\n", p);
	printf("        %s  0  0   <- will just re-index\n", p);
	exit(1);
}

int
main(int argc, char *argv[])
{
	unsigned long   keepamount, maxamount;

	setvbuf(stdout, NULL, _IONBF, 0);


	if (argc < 3)
		showhelp(argv[0]);
	maxamount = atol(argv[2]);
	keepamount = atol(argv[1]);
	if (keepamount)
		printf("Keeping between %lu and %lu meg(s) of MSGID.LST\n", keepamount, maxamount);
	else
		printf("Reindexing MSGID.LST\n");
	keepamount = keepamount * 1048576;
	maxamount = maxamount * 1048576;
	printf("Keep amount is %lu bytes - buffer used, %lu bytes\n", keepamount,sizeof(inbuf));
	if (keepamount > 0)
		makenewlist(keepamount, maxamount);
	reindex();
	return 0;
}
