#include "main.h"
#include <time.h>
#include <signal.h>
#include "mark.inc"


text_info       windows[MAXWINDOWS];
extern long     totalsize;
extern int      registereduser;
#define screen ourscreen
#define video(x,y) screen[(x)-1 + ((y)-1)*80]

void            flybanner(int);

text_info      *ti = windows;

void            dumpwindow(text_info * newti, char *fmt,...)
{
    va_list         argptr;
    char            buffer[1024];
    text_info      *localti;
    char           *p;
    localti = ti;
    newwindow(newti);

    va_start(argptr, fmt);
    vsprintf(buffer, fmt, argptr);
    va_end(argptr);
    if (buffer[0] == '\n') {
        p = buffer + 1;
        if ((wherex() != 1) || (wherey() != 1))
            cprintf("\r\n");
    } else
        p = buffer;
    gettextinfo(ti);
    p[ti->winright
      - ti->winleft
      - ti->curx
      + 1
        ] = 0;
    cprintf("%s", p);
    newwindow(localti);
}


void            newwindow(text_info * newti)
{
    gettextinfo(ti);
    ti = newti;
    window(ti->winleft, ti->wintop, ti->winright, ti->winbottom);
    textattr(ti->attribute);
    gotoxy(ti->curx, ti->cury);
}
 /* title border text */

void            initcopyright(void)
{
    ti = ti_copyright;
    window(2,2,79,4);
    textattr(0x70);
#ifdef __DOS__
    if (ourscreen==(unsigned short int*) ON_A_MONO)
      textattr(0x07);
#endif
    cputs(COPYRIGHT);
    gettextinfo(ti);
}
void            initlog(void)
{
    ti = ti_log;
    window(2,7,79,12);
    textattr(0x70);
#ifdef __DOS__
    if (ourscreen==(unsigned short int*) ON_A_MONO)
      textattr(0x07);
#endif
    gettextinfo(ti);
}
void            initlogfile(void)
{
    char            fname[256];
    strcpy(fname, configstr("LOG"));
    if (!fname[0]) {
        errormsgstring("No log file specified in .CFG file");
        return;
    }
    loghandle = sopen(fname, O_BINARY | O_CREAT | O_RDWR, SH_DENYRW, S_IWRITE);
    if (loghandle < 1)
        loghandle = 0;
    else {
        lseek(loghandle, filelength(loghandle), SEEK_SET);
        write(loghandle, "\r\n\r\n", 4);
    }
    errormsgstring("GIGO %s", VERSION);
    #ifdef __DOS__
    errormsgstring("Total 32bit memory: %u", mem1=sim_upper_coreleft());
    errormsgstring("Total 16bit memory: %u", mem2=sim_lower_coreleft());
    #endif
}
void            initaction(void)
{
    ti = ti_action;
    window(64,15,78,21);
    textattr(0x70);
#ifdef __DOS
    if (ourscreen==(unsigned short int*) ON_A_MONO)
      textattr(0x07);
#endif
    gettextinfo(ti);
}
void            initumsg(void)
{
    ti = ti_umsg;
    window(2,14,62,22);
    textattr(0x70);
#ifdef __DOS__
    if (ourscreen==(unsigned short int*) ON_A_MONO)
      textattr(0x07);
#endif
    gettextinfo(ti);
}

char           *timedate(void)
{
    struct tm      *time_now;
    time_t          secs_now;
    static char     str[80];
    tzset();
    time(&secs_now);
    time_now = localtime(&secs_now);
    strftime(str, 80, "%m-%d-%y  %H:%M:%S", time_now);
    return str;
}

void            log(char *text)
{
    char           *p;
    text_info      *localti;
    localti = ti;
    newwindow(ti_log);
    p = timedate();
    cprintf("\r\n%s ", p);
    cputs(text);
    if (loghandle) {
        write(loghandle, p, strlen(p));
        write(loghandle, " ", 1);
        write(loghandle, text, strlen(text));
        write(loghandle, "\r\n", 2);
    }
    newwindow(localti);
}




extern char    *_argv[100];

void confuseoptimizer(char *string, unsigned int number)
{
  char buf[256];
  strcpy(buf,string);
  number=buf[0];
  /* this is pure BS ... */
   }

void            initwindows(void)
{
    int             i;
    char            startingtz[128];
    char           *p;
    /* directvideo=0; */
    startingtz[0] = 0;
    strcpy(startingtz, "TZ=");
    if ((p = getenv("TZ"))!=NULL)
        strcat(startingtz, p);
    putenv(startingtz);
    need_cleanup = 1;
    clrscr();
    for (i = 0; i < MAXWINDOWS; i++)
     {
         /* the optimizer screws up here - we MUST put something in .. :-(  to slow it down. */
         TRACK();
        confuseoptimizer(__FILE__,__LINE__);
        gettextinfo(&windows[i]);
     }
    flybanner(0);
    showmain();
    initcopyright();
    initlog();
    initumsg();
    initaction();
    atexit(closevideo);
}

void            closevideo(void)
{
    long            hours,
                    minutes,
                    seconds;
    if (!need_cleanup)
        return;                 /* don't do anything if we didn't allow
                                 * complete load */
    unlink("GIGO1");
    unlink("GIGO2");
    putenv("TZ=GMT+00");
    seconds = clock() / 100;

    minutes = seconds / 60;
    seconds %= 60;

    hours = minutes / 60;
    minutes %= 60;
    errormsgstring("Time used for GIGO: %lu:%02lu:%02lu", hours, minutes, seconds);
    if (loghandle)
        close(loghandle);
    loghandle = 0;

    if (!registereduser)
        flybanner(1);           /* force YOU HAVEN'T PAID! banner */

    window(1, 1, 80, 25);
    gotoxy(1, 25);
    if (registereduser)
        cputs("\r\n");
    textattr(7);
    clreol();
}
