#include "main.h"

/* ENC is the basic 1-character encoding function to make a char printing */
#define ENC(c) (char) ((c) ? ((c) & 077) + ' ': '`')
/*void outdec(char *p, char *buf);*/


extern unsigned int linesplit;

void            encode(int in, int out, long max);

inline void     outdec(char *p, char *buf)
{
    register int    c1,
                    c2,
                    c3,
                    c4;
    c1 = *p >> 2;
    c2 = (*p << 4) & 060 | (p[1] >> 4) & 017;
    c3 = (p[1] << 2) & 074 | (p[2] >> 6) & 03;
    c4 = p[2] & 077;
    *buf++ = ENC(c1);
    *buf++ = ENC(c2);
    *buf++ = ENC(c3);
    *buf = ENC(c4);
}


void            blockencode(int in, int out, long maxbytes)
{
    while (maxbytes) {
        if (maxbytes < 45000) {
            encode(in, out, maxbytes);
            maxbytes = 0;
        } else {
            encode(in, out, 45000);
            maxbytes -= 45000;
            if (eof(in))
                maxbytes = 0;
        }
    }
}


/*
 */
void            encode(int in, int out, long maxbytes)
{
    char           *outbuf;
    char           *buf;
    word            inleft;


    int             i,
                    n;
    long            totbytes = 0;
    if (!USENETBUF) {
        printfh(out, "Ouch!  Allocated buffers aren't there!");
        lseek(in, filelength(in), SEEK_SET);
    }
    outbuf = &USENETBUF[0];
    buf = &USENETBUF[64000];
    memset(USENETBUF, 0, usenetsize);

    inleft = (word) read(in, buf, maxbytes);

    for (;;) {
        /* 1 (up to) 45 character line */
        if (inleft == 0) {
            n = 0;
            goto zero;
        } else if (inleft < 45)
            totbytes += n = inleft;
        else
            totbytes += n = 45;

        inleft -= n;
/*finalpass:*/
        *(outbuf++) = ENC(n);
        for (i = 0; i < n; i += 3) {
            outdec(&buf[i], outbuf);
            outbuf += 4;
        }
        *(outbuf++) = '\n';
        buf += n;
zero:
        if (!n) {
            if (eof(in)) {
                *(outbuf++) = ENC(0);
                *(outbuf++) = '\n';
            }
            *outbuf = 0;
            write(out, USENETBUF, (outbuf - USENETBUF));
            break;
        }
    }
}
/*
 * output one group of 3 bytes, pointed at by p, on file f.
 */
void            makeascii(char *p);


