#include <i86.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <dos.h>
#include <time.h>

/*
 *   Small portions of this code are from Watcom's "memory.c" in their
 *   samples directory.  Presumably, Copyright 1994 by Watcom ...
 *
 *   All other work is Copyright 1994 by Jason Fesler.  All rights reserved.
 *   This file is _not_ to be distributed casually, as this source file
 *   is currently in bad need of cleaning up.  I would hate for this to
 *   be what people would think of when they see my name :-)
 *
 *   I plan on cleaning this up to make it DOS4G{w} specific
 *   (which assumes the lower 1 meg addresses are DOS memory, and
 *   also assumes that DOS memory is mapped at offsets 0..0xfffff).
 *   I also plan on merging in the memory code from the SNIP0494.LZH
 *   archives, which provide extensive bounds checking (overflow, underflow,
 *   etc), as that package looks very usefull for pointers under "C" ..
 *
 *   Let me know if you make any useful changes..
 *
 *   jfesler@netcom.com  (if this changes, probably jfesler@crl.com 6/94?)
 *   jfesler@wmeonlin.sacbbx.com (my home system).
 */


//#define jfesler
//#define test

  extern int      sim_usedosmem;  /* Set to "1" if you want DOS mem available */
  extern int      sim_useuppermem;/* set to "1" if you want 32 bit mem avail */

struct meminfo {
    unsigned        LargestBlockAvail;
    unsigned        MaxUnlockedPage;
    unsigned        LargestLockablePage;
    unsigned        LinAddrSpace;
    unsigned        NumFreePagesAvail;
    unsigned        NumPhysicalPagesFree;
    unsigned        TotalPhysicalPages;
    unsigned        FreeLinAddrSpace;
    unsigned        SizeOfPageFile;
    unsigned        Reserved[3];
}               MemInfo;


#ifdef jfesler

/*
 * I had need to reuse certain values from within my other programs.
 * It was easier and quicker, not to mention cleaner, to make the info
 * globally available here.
 *
 */

char           *lastmadeptr = NULL; /* Holds pointer to last sim_alloc command */
unsigned long   sim_lastdosmemory = 0;  /* when using coreleft(), which shows the greater of high or low free, this is
                                         * specifically the DOS amount that was found. */
#endif

/*
 * This module has to keep track of what memory is allocated, and where
 * so, via the DPMI services.  This helps the memory allocation routines
 * tell whether they should use dos services, or DPMI services, to
 * free or realloc a block of memory.
 *
 * In retrospect, since we are both running DOS4G{w}, we could probably
 * take the table checking out, and merely check the size of the unsigned
 * long that is used as a pointer.  If it's pointing to somewhere under
 * one meg, assume DOS, else assume DPMI.  However, getting this to work
 * under, say PharLapp, would not be fun then.
 *
 * Change TABLESIZE to change the number of DMPI entries to keep track
 * of...
 *
 */


#define TABLESIZE 100

short int       sim_inityet = 0;

struct sim_table_type {
    short           selector;
    char           *p;
}               sim_table[TABLESIZE];



/* simulate.cpp 13/12/93 11.57.58 */
unsigned long   sim_upper_coreleft(void);   /* specifically gets upper core free */
unsigned long   sim_lower_coreleft(void);   /* specifically gets lower core free */
unsigned long   coreleft(void); /* returns larger of upper/lower core free */
void            sim_free(char *p);  /* Free mem block */
char           *sim_alloc(unsigned long size);  /* Allocate mem block */
void           *sim_realloc(char *p, unsigned long newsize);    /* Realloc mem block */
void           *sim_calloc(unsigned long size, unsigned long elements); /* Calloc mem block */

int             sim_check(void)
// Double checks to make sure that the heap is functioning properly.
{
    int             i;
    i = _heapchk();
    if (!i)
        return 0;
    fprintf(stderr, "Heap error %i\n", i);
    return i;
}


unsigned long   sim_upper_coreleft()
// Returns the amount of real 32 bit memory available (asks the DPMI host)
{
    union REGS      regs;
    struct SREGS    sregs;
    int             interrupt_no = 0x31;
    if (!sim_useuppermem)
        return 0;

    regs.x.eax = 0x00000500;
    memset(&sregs, 0, sizeof(sregs));
    sregs.es = FP_SEG(&MemInfo);
    regs.x.edi = FP_OFF(&MemInfo);

    int386x(interrupt_no, &regs, &regs, &sregs);
    return MemInfo.LargestBlockAvail;
}

unsigned long   sim_lower_coreleft(void)
// Returns the amount of lower memory available; rounds to the nearest 4k
{
    unsigned long   increaseby = 0x1000;    /* use 4k increments & start at 4k */
    unsigned long   amount = increaseby;
    char           *p;
    if (!sim_usedosmem)
        return 0;

    for (;;) {
        p = sim_alloc(amount);

        if ((((unsigned long) p) > 0xfffff) || (!p)) {
            sim_free(p);
            amount -= 0x1000;
#ifdef jfesler
            sim_lastdosmemory = amount;
#endif
            return amount;
        }
        sim_free(p);
        amount += 0x1000;
    }
}

unsigned long   coreleft(void)
// Checks both upper and lower coreleft()'s, and returns greater of the two
{
    unsigned long   l1,
                    l2;
    l1 = sim_upper_coreleft();
    l2 = sim_lower_coreleft();
    if (l1 > l2)
        return l1;
    else
        return l2;
}

void            sim_dumpselector(short selector)
// Used internally to dump a 32-bit memory pointer
{
    union REGS      regs;
    struct SREGS    sregs;
    int             interrupt_no = 0x31;
    /* DPMI call 100h allocates DOS memory */
    memset(&sregs, 0, sizeof(sregs));
    regs.w.ax = 0x0101;
    regs.w.dx = selector;
    int386x(interrupt_no, &regs, &regs, &sregs);
}


void            sim_init(void)
// Initializes, if neccesary, the memory tracking table.
{
    if (sim_inityet)
        return;
    sim_inityet++;
#ifdef jfesler
    sim_lastdosmemory = 0;
#endif
    memset(sim_table, 0, sizeof(sim_table));
}


void            sim_free(char *p)
// Frees up memory (using DPMI or DOS, as appropriate)
{
    int             i;
    unsigned long   l;
    sim_init();
    l = (unsigned long) p;
    l /= 16;
    if (l < 0x10000) {          /* if it's in the lower meg */
        for (i = 0; i < TABLESIZE; i++)
            if (p == sim_table[i].p) {
                sim_dumpselector(sim_table[i].selector);
                memset(&sim_table[i], 0, sizeof(sim_table_type));
                return;
            }
    } else
        free(p);
}

char           *sim_alloc(unsigned long size)
// Allocate memory, using DOS or DPMI as appropropriate, from whichever
// service is willing to allocate it.  Returns NULL if neither service
// is available or selected.

// Note:  DOS memory is the first to be attempted.  If DOS will supply it,
// it will be the one to actually get used.
{
    union REGS      regs;
    struct SREGS    sregs;
    int             interrupt_no = 0x31;
    short           selector;
    unsigned short  segment;
    unsigned long   fulladdress;
    int             index;
    char           *str = NULL;
    sim_init();
    if (!sim_usedosmem)
        goto useuppermemory;

/* usedosmemory: */

    /* DPMI call 100h allocates DOS memory */
    memset(&sregs, 0, sizeof(sregs));
    regs.w.ax = 0x0100;
    fulladdress = size;
    fulladdress += 15;
    fulladdress /= 16;          /* get # of paragraphs; */
    if (fulladdress < 0xffff) {
        regs.w.bx =(unsigned short int) fulladdress;/* number of paragraphs being requests */
        int386x(interrupt_no, &regs, &regs, &sregs);

        if ((regs.x.cflag & 1) == 0) {  /* meaning, if there was no error, */
            segment = regs.w.ax;
            selector = regs.w.dx;
            fulladdress = segment;
            fulladdress *= 16;
            str = (char *) fulladdress;
            for (index = 0; index < TABLESIZE; index++)
                if (!sim_table[index].p) {
                    sim_table[index].p = str;
                    sim_table[index].selector = selector;
#ifdef jfesler
                    lastmadeptr = str;
#endif
                    return str;
                }
            /* oh shit.  No way to remember it! */

            sim_dumpselector(selector);
        }
        /* use standard allocation methods */
    }
useuppermemory:
    if (!sim_useuppermem)
        return NULL;
    str = (char *) malloc(size);
    return str;
}


int             sim_realloc_error = 0;  /* Gets set when there is a realloc error; you have to reset it yourself if you are
                                         * making use of it. I used it for breakpointing. */

void           *sim_realloc(char *p, unsigned long newsize)
// Takes a block of memory, and resizes it.
{
    int             i;
    unsigned long   l;

    union REGS      regs;
    struct SREGS    sregs;
    int             interrupt_no = 0x31;
    sim_init();



    if (!newsize) {
        sim_free(p);
        return NULL;
    }
    if (!p) {
        return (void *) sim_alloc(newsize);
    }
    l = (unsigned long) p;
    if (l > 0xfffff)            /* if it's in the lower meg */
        return realloc((void *) p, newsize);

    newsize += 15;
    newsize /= 16;

    for (i = 0; i < TABLESIZE; i++)
        if (p == sim_table[i].p) {
            /* DPMI call 100h allocates DOS memory */
            memset(&sregs, 0, sizeof(sregs));
            regs.w.ax = 0x0102;
            regs.w.dx = sim_table[i].selector;
            regs.w.bx = (unsigned short int) newsize;
            int386x(interrupt_no, &regs, &regs, &sregs);
            sim_realloc_error = 0;
            if (regs.x.cflag & 1)
                sim_realloc_error = regs.w.ax;
            return p;           /* no matter what, send it back.. if it doesn't shrink, oh well. */
        }
    return NULL;                /* sorry keemosabee, no pointer to realloc in that structure */
}

void           *sim_calloc(unsigned long size, unsigned long elements)
// Allocates and clears a block of memory (size*elements) long.
{
    unsigned long   l;
    void           *p;
    l = size;
    l *= elements;

    p = sim_alloc(l);
    if (p) memset(p,0,l);
    return p;

}

#ifdef TEST

// a testing function I made..

void            recurse(void)
{
    char           *p;

    printf("Coreleft:   %u / %u \n", sim_lower_coreleft(), sim_upper_coreleft());
    p = sim_alloc(65536);
    if (p) {
        printf("Allocated address: %p  ");
        if ((unsigned long) p < 0xfffff)
            printf("  (Dos Memory)\n");
        else
            printf(" (The Real Stuff)\n");

        memset(p, 0, 65535);

        if (stackavail() > 500)
            recurse();
        else {
            printf("No more stack space for recursion.\n");
            delay(1000);
        } printf("Freeing %p..\n");
        sim_free(p);
    }
}


void            main() {
    recurse();
    sim_usedosmem = 0;
    recurse();
    sim_usedosmem = 1;
    sim_useuppermem = 0;
    recurse();
} 

#endif 

