#include "main.h"
#include <ctype.h>
#include <io.h>
#include <time.h>

/* #define BREAKPOINTS */

void            uusend(char *, char *);

void            monitor(char *);

extern int mailinglists; /* is "@" in mapping.cfg? */

char           *
getline_lf(int handle)
{
	static char     line[512];
	int             size = 0;
	char            ch;
	line[size] = 0;
	for (line[size = 0] = 0;;) {
		if (!read(handle, &ch, 1))
			return line;
		switch (ch) {
		case 10:
			return line;
		case 13:
			break;
		default:
			line[size++] = ch;
			line[size] = 0;
			if (size == sizeof(line) - 1)
				return line;
		}
	}
}


char           *findstring(char *buf, char *search);
char           *
token(char *buffer, char *search)
{
	char            search2[256] = "\n";
	register int    size = 0;
	register char  *p;
	char            ch;
	lasttoken[0] = 0;
	if (!*buffer)
		return lasttoken;

	strcat(search2, search);
	if (strncmp(buffer, search, strlen(search)) == 0)
		p = buffer + strlen(search);
	else if ((p = findstring(buffer, search2)) != NULL)
		p += strlen(search2);
	if (!p)
		return lasttoken;
	p++;
	while (*p == 32)
		p++;
loop:
	ch = *p++;
	switch (ch) {
	case 0:
		goto quit;	/* end of memory block */
	case 1:
		goto quit;	/* end of kludge line */
	case 10:
ten:
		if ((*p == 9) || (*p == 32))
			if (*search != 1)
				if (*search2 != 1)
					goto loop;
		goto quit;
	case 13:
                if (*p==10) goto loop; /* ignore the cr */
                goto ten;
	default:
		lasttoken[size++] = ch;
		lasttoken[size] = 0;
		if (size == sizeof(lasttoken) - 1)
			goto quit;
	}
	goto loop;
quit:
	while ((lasttoken[0]) && (lasttoken[strlen(lasttoken) - 1] == 32))
		lasttoken[strlen(lasttoken) - 1] = 0;
	return lasttoken;
}

char           *findstring(char *, char *);	/* faster string finder */
char           *
fidostyle_date(void)
{
	char           *p, *q;
	static char     tline[50];
	char            templine[50];
	char           months[] = "JanFebMarAprMayJunJulAugSepOctNovDec";
	char            buf[256];
	long            month;
	long            msg_adjust;
	char            minus = '-';
	time_t          t;

	struct tm       local;
	struct tm       tm;
	p = token(USENETBUF, "Date:");
	if (p == NULL)
		goto notime;
	if (*p == 0)
		goto notime;
	while ((p) && (!isdigit(*p)))
		p++;		/* get to start of month etc */
	strcpy(buf, p);

	memset(tline, 0, sizeof(tline));
	memset(&tm, 0, sizeof(tm));
	memset(&local, 0, sizeof(tm));

	/* day */
	p = strtok(buf, " :-,");
	if (p == NULL)
		goto notime;
	tm.tm_mday = atoi(p);

	/* month */
	p = strtok(NULL, " :-,");
	if (p == NULL)
		goto notime;
	q = findstring(months, p);
	if (q) {
		month = (q - months);
		month /= 3;
		tm.tm_mon = month;
	}
	/* year */
	p = strtok(NULL, " :-,");
	if (p == NULL)
		goto notime;
	tm.tm_year = atoi(p);
	tm.tm_year %= 100;
	if (tm.tm_year < 80)
		tm.tm_year += 100;	/* so we can get beyond 1999 */

	p = strtok(NULL, " :,-");
	if (p == NULL)
		goto notime;
	tm.tm_hour = atoi(p);

	p = strtok(NULL, " :,-");
	if (p == NULL)
		goto notime;
	tm.tm_min = atoi(p);

	p = strtok(NULL, " :,");/* seconds */

	if (p == NULL) {
		tm.tm_sec = 0;
		goto nogmd;
	}
	if (!isdigit(*p))
		goto timezonecheck;
	tm.tm_sec = atoi(p);

	p = strtok(NULL, " :,");

timezonecheck:
	msg_adjust = 0;
	if (!p)
		goto nogmd;
	if (!*p)
		goto nogmd;
	if (*p == '-') {
		minus = '+';
		p++;
	}
	/* PMCE */
	if (!strcmp(p, "EST")) {
		minus = '+';
		msg_adjust = 5;
	} else if (!strcmp(p, "CST")) {
		minus = '+';
		msg_adjust = 6;
	} else if (!strcmp(p, "MST")) {
		minus = '+';
		msg_adjust = 7;
	} else if (!strcmp(p, "PST")) {
		minus = '+';
		msg_adjust = 8;
	} else if (!strcmp(p, "GMT")) {
		minus = '+';
		msg_adjust = 0;
	} else if (!strcmp(p, "EDT")) {
		minus = '+';
		msg_adjust = 4;
	} else if (!strcmp(p, "CDT")) {
		minus = '+';
		msg_adjust = 5;
	} else if (!strcmp(p, "MDT")) {
		minus = '+';
		msg_adjust = 6;
	} else if (!strcmp(p, "PDT")) {
		minus = '+';
		msg_adjust = 7;
	} else {
		msg_adjust = atol(p);
		if (msg_adjust % 100 == 0)
			msg_adjust /= 100;
	}
nogmd:
	if (msg_adjust % 100 == 30) {
		msg_adjust /= 100;
		//force divide now.
			sprintf(templine, "TZ=XXX%c%i:30", minus, msg_adjust);	/* using only for adjust
										 * purposes */
	} else
		sprintf(templine, "TZ=XXX%c%i", minus, msg_adjust);	/* using only for adjust
									 * purposes */
	putenv(templine);
	t = mktime(&tm);
	putenv(tzone);
	_localtime(&t, &local);
	strftime(tline, 40, "%d %b %y  %H:%M:%S ", &local);

	tline[19] = 0;
	return tline;
notime:
	strcpy(tline, "01 Jan 81  00:00:00 ");
	tline[19] = 0;
	return tline;
}
char           *
emaddress(char *p)
{
	char           *address, *remainder;
	static char     line[150];
	char            buf[LINESIZE];
	strcpy(buf, p);
	if (!buf[0])
		return "Unknown";
	switch (buf[strlen(buf) - 1]) {
	case ')':
		address = strtok(buf, "() ");
		remainder = strtok(NULL, "()");
		break;
	case '>':
		remainder = strtok(buf, "<>");
		address = strtok(NULL, " <>");
		break;
	default:
		address = remainder = buf;
		break;
	}
	if (!address)
		address = remainder;
	if (!remainder)
		remainder = address;
	if (!remainder)
		address = remainder = "Unknown";
	strcpy(line, address);
	if (!*line)
		strcpy(line, "UUCP");
	return line;
}
char           *
fidostyle_from(char *area)
{
	char           *p, *address, *remainder;
	static char     line[150];
	char            buf[LINESIZE];

	int             r;
	char           *_r;

	if (*area) {
		r = returnaddress_news;
		_r = _returnaddress_news;
	} else {
		r = returnaddress_email;
		_r = _returnaddress_email;
	}

	if (r)
		if (*_r) {
			strcpy(line, _r);
			return line;
		}
	p = token(USENETBUF, "From:");
	if (!*p)
		p = token(USENETBUF, "Reply-To:");
	if (!*p)
		p = token(USENETBUF, "Sender:");
	strcpy(buf, p);
	if (!buf[0])
		return "Unknown";
	switch (buf[strlen(buf) - 1]) {
	case ')':
		address = strtok(buf, "() ");
		remainder = strtok(NULL, "()");
		break;
	case '>':
		remainder = strtok(buf, "<>");
		address = strtok(NULL, " <>");
		break;
	default:
		address = remainder = buf;
		break;
	}
	if (!address)
		address = remainder;
	if (!remainder)
		remainder = address;
	if (!remainder)
		address = remainder = "Unknown";
	if ((r) && (strlen(address) < 35))
		strcpy(line, address);
	else
		strcpy(line, remainder);
	line[35] = 0;
	if (!*line)
		strcpy(line, "UUCP");
	return line;
}
char           *
fidostyle_subject(void)
{
	char           *p;
	static char     line[150];
	char            buf[LINESIZE];
	p = token(USENETBUF, "Subject:");
	if (!p)
		p = token(USENETBUF, "Title:");
	if (!p)
		p = token(USENETBUF, "Summary:");
	if (!p)
		p = token(USENETBUF, "Archive-Name:");
	if (!p)
		p = "Unknown";
        if (!*p) p="Untitled";
	strcpy(buf, p);
	buf[71] = 0;
	strcpy(line, buf);
	return line;
}

void 
fixheaders(void)
{
	char           *p;
	int             intoken;
	char            lastch;
	register char   ch;

	p = USENETBUF;
	lastch = 0;
	intoken = 1;

	while ((ch = *p) != 0) {
		if (ch == '\n') {
			intoken = 1;
			//start new token
				if (lastch == '\n')
				break;
			//shit, end of headers !
		}
		if (ch == ' ')
			intoken = 0;
		//done with token
			if (ch == '\x09')
			intoken = 0;

		if (intoken) {
			if (isalpha(lastch))
				*p = (char) tolower(ch);
			else
				*p = (char) toupper(ch);
		}
		lastch = *p++;
	}
}


void            make_echomsg(char *p);
#ifdef BREAKPOINTS
void 
bp(void)
{
	errormsgstring("Breakpoint hit!");
}
#endif

extern text_info *ti;
void sortsave(char *origtowho,char *configline);
char           *
special(char *p)
{
	if (strnicmp(p, "savetext", 8) == NULL)
		savetext("All", p);
        else if (strnicmp(p,"sortsave",8)==NULL)
               sortsave("All",p);
        else if (strnicmp(p,"savesort",8)==NULL)
               sortsave("All",p);
	else if (strnicmp(p, "logtext", 7) == NULL)
		logtext("All", p);
	else {
		errormsgstring("Huh?  Unknown extended mapping command \"%s\"", p);
		return NULL;
	}
	p = strtok(p, " ");
	//command
		p = strtok(NULL, " ");
	//location
		p = strtok(NULL, " ");
	//extra, ie newsgroup name
		return p;
}
char           *
nospecial(char *p)
{
	p = strtok(p, " ");
	//command
		p = strtok(NULL, " ");
	//location
		p = strtok(NULL, " ");
	//extra, ie newsgroup name
		return p;
}

void 
parseheader(void)
{
	char           *p;
	char           *news[100];
	char            buffer[2048];
	int             i;
	int             totalnewsgroups;
	int             maxed;
	long            usenetlength;
	char            cancel_msg[20] = "cmsg cancel";
	memset(news, 0, sizeof(news));
	if (usevideo) {
		newwindow(ti_umsg);
		clrscr();
#ifdef BREAKPOINTS
		if (*breakpoint)
			if (strstr(USENETBUF, breakpoint))
				bp();
#endif
		p = token(USENETBUF, "From:");
		if (!*p)
			p = token(USENETBUF, "Reply-To:");
		if (!*p)
			p = token(USENETBUF, "Sender:");
		if (*p) {
			p[54] = 0;
			cprintf("From: %s\r\n", p);
		}
		/* Control: message handling: preliminary */

		ti = ti_areas;

		gettextinfo(ti_areas);
		window(ti_area.winleft, (char) (ti_area.wintop + ti_area.cury), ti_area.winright, ti_area.winbottom);
		gotoxy(1, 1);
	}
		translate_control_contained = 0;
		if (translate_control) {
			p = token(USENETBUF, "Control: cancel");
			if ((p) && (*p))
				translate_control_contained = 1;
		}
		if (!translate_control_contained)
			if (delete_control) {
				p = token(USENETBUF, "Control:");
				if ((p) && (*p))
					return;
				//dump these messages !
			}
	p = token(USENETBUF, "Newsgroups:");
	strcpy(buffer, p);
	p = strtok(buffer, ", ");
	i = 0;
	while ((p) && (i < 100)) {
		news[i++] = p;
		p = strtok(NULL, ",");
	}

	for (totalnewsgroups = 0, i = 0; i < 100; i++)
		if (news[i]) {
			p = group2echo(news[i]);
			if (capture(2, news[i], "NEWS")) {
				totalnewsgroups++;
				continue;
			}
			if (i)
				cputch('\n');
			if (p)
				if (*p == '!') {
					cprintf("\rSpecial: %s", p + 2);
					p = special(p + 2);
				}
			if ((p) && (*p) && (totalnewsgroups < maxnewsgroups)) {
				totalnewsgroups++;
#ifdef __DOS__
				textattr((ourscreen == (unsigned short int *) ON_A_MONO) ? 0x07 : 0x71);
#else
				textattr(0x71);
#endif
				cprintf("\r%s=%s", news[i], p);
				printfh(logkept, "%s %s\r\n", news[i], p);
				make_echomsg(p);
			} else {
#ifdef __DOS__
				textattr((ourscreen == (unsigned short int *) ON_A_MONO) ? 0x0f : 0x74);
#else
				textattr(0x74);
#endif
				cprintf("\r%s _dumped_", news[i]);
				printfh(logdumped, "%s\r\n", news[i]);
#ifdef __DOS
				textattr((ourscreen == (unsigned short int *) ON_A_MONO) ? 0x07 : 0x71);
#else
				textattr(0x71);
#endif
			}
		} else
			i = 100;

	if (logtraffic) {
		maxed = totalnewsgroups;
		usenetlength = strlen(USENETBUF);

		for (totalnewsgroups = 0, i = 0; i < 100; i++)
			if (news[i]) {
				if (capture(0x82, news[i], "NEWS")) {
					totalnewsgroups++;
					printfh(logtraffic,
						"xi:%lu/%u %s %s %s -\r\n",
						usenetlength, maxed, "CAPTURED", news[i], gateway);
					continue;
				}
				p = group2echo(news[i]);
				if ((p) && (*p == '!'))
					p = nospecial(p + 2);
				if ((p) && (*p) && (totalnewsgroups < maxnewsgroups)) {
					totalnewsgroups++;
					printfh(logtraffic,
						"ni:%lu/%u %s %s - -\r\n",
					   usenetlength, maxed, p, news[i]);
				}
			} else
				i = 100;

	}
}
char           *mapmailinglist(char *usenet,char *fromwhere);
void            ftpmail(void);
extern int      emailheaderlog;
extern long     tousenet;
char           *idtime(long);
char           *who_from_line(char *);
char           *path_line(char *);

void 
bounceuucp(char *sentto, char *bouncefile, int infofile)
{
	bounceuucp(sentto, bouncefile, infofile, "mailer-daemon", "Gateway Mail Daemon");
}
void 
bounceuucp(char *sentto, char *bouncefile, int infofile, char *daemon, char *daemonname)
{
	char            buf[8192] = "";
	char            returnto[256];
	int             i;
	int             newshandle = 0;
	char           *p, *q, *udate;
	int             bouncetexthandle = 0;

	strcpy(returnto, token(USENETBUF, "Errors-To:"));
	if (!*returnto)
		strcpy(returnto, token(USENETBUF, "Resent-Sender:"));
	if (!*returnto)
		strcpy(returnto, token(USENETBUF, "Resent-From:"));
	if (!*returnto)
		strcpy(returnto, token(USENETBUF, "Sender:"));
	if (!*returnto)
		strcpy(returnto, token(USENETBUF, "From:"));
	if (!*returnto)
		strcpy(returnto, responsibleparty);
	strcpy(returnto, emaddress(returnto));

	if (infofile > 0) {
		errormsgstring("Sending info file back to user");
		errormsgstring("Sending info to: %s", returnto);
	} else {
  if (defined("PAGESAT"))
  {
    errormsgstring("PAGESAT keyword defined; bounced message not written");
    return;
  }
		cprintf("\r\n\n\nBouncing message back to the UUCP feed");
		cprintf("\r\nTo: %s", returnto);
		errormsgstring("Bouncing message back to the UUCP feed");
		errormsgstring("Bouncing back to: %s", returnto);
	}
	strcpy(buf, bouncefile);
	p = strtok(buf, " ");	/* bouncer's name */
	p = strtok(NULL, " ");	/* bounce text file */
	if (p)
		if (*p) {
			cprintf("\r\nSending text file %s", p);
			bouncetexthandle = sopen(p, O_TEXT | O_RDONLY, SH_DENYWR, S_IREAD);
			if (bouncetexthandle < 1) {
				errormsgstring("Could not send bounce text file %s", p);
				bouncetexthandle = 0;
			}
		}
	newshandle = makemailhandle(returnto, daemon);
	if (newshandle < 1) {
		errormsgstring("Could not create bounce handle");
		return;
	}
	*buf = 0;
	q = buf;
	q += strlen(q);
	strcat(q, who_from_line(normalize(daemon, "")));
	q += strlen(q);
	sprintf(q, "Date: %s\n", udate = currentunixdate());
	q += strlen(q);
	sprintf(q, "From: %s (%s)\n", normalize(daemon, ""), daemonname);

	if (infofile > 0) {
		q += strlen(q);
		sprintf(q, "Subject: Information request\n");
	} else {
		q += strlen(q);
		sprintf(q, "Subject: Message returned to sender\n");
	}
	q += strlen(q);
	sprintf(q, "Message-ID: <%s@%s.%s>\n", idtime(sequence++), mysite, domain);
	q += strlen(q);
	strcat(q, "\n");
	//if (!infofile)
		//sprintf(q + strlen(q), "(Invalid host or address: %s)\n\n", sentto);

	if (bouncetexthandle < 1) {
		if (infofile > 0) {
			q += strlen(q);
			strcat(q, "<info file was not available on host machine>\n");
		} else {
			memset(&phraseparm, 0, sizeof(phraseparm));
			phraseparm.sentto = sentto;
			phraseparm.returnto = returnto;
			if (infofile == -1)
				findphrase("bounceuucp:site");
			else
				findphrase("bounceuucp:user");
			do {
				strcat(q, parsephrase());
			}
			while (phrasefile);
		}
	}
	q += strlen(q);

	write(newshandle, buf, strlen(buf));

	if (bouncetexthandle) {
		i = 1;
		while (i) {
			memset(buf, 0, sizeof(buf));
			i = read(bouncetexthandle, buf, sizeof(buf) - 1);
			if (i) {
				makeascii(buf);
				write(newshandle, buf, i);
			}
		}
		close(bouncetexthandle);
	}
	virgin = 1;		/* need to lf->cr again.. */
	if (infofile < 1) {
		p = USENETBUF;
		while (*p) {
			if (*p == '\r')
				*p = '\n';
			p++;
		}
		write(newshandle, USENETBUF, strlen(USENETBUF));
	}
	tousenet++;
	if (logtraffic) {
		printfh(logtraffic,
			"eo:%lu/1 %s %s %s %s\r\n",
			filelength(newshandle),
			normalize(daemon, ""),
			returnto,
			gateway,
			daemon);
	}
	if (newshandle > 1)
		close(newshandle);
	if (emailheaderlog) {
		printfh(emailheaderlog, "\r\nDate: %s\r\n", udate);
		printfh(emailheaderlog, "To  : %s (internet)\r\n", returnto);
		printfh(emailheaderlog, "From: %s (fidonet)\r\n", normalize(daemon, ""));
		printfh(emailheaderlog, "Was-sent-to: %s\r\n", sentto);
		if (infofile > 0)
			printfh(emailheaderlog, "Subj: Information request\r\n");
		else
			printfh(emailheaderlog, "Subj: Message returned to sender\r\n");
	}
	if (logbounced) {
		printfh(logbounced, "\r\nDate: %s\r\n", udate);
		printfh(logbounced, "To  : %s (internet)\r\n", returnto);
		printfh(logbounced, "From: %s (fidonet)\r\n", normalize(daemon, ""));
           printfh(logbounced,"Was-sent-to: %s\r\n",sentto);
		if (infofile > 0)
			printfh(logbounced, "Subj: Information request\r\n");
		else
			printfh(logbounced, "Subj: Message returned to sender\r\n");
	}
}
char           *who_from_line(char *);
char           *path_line(char *);

void 
forwarduucp(char *sentto, char *bouncefile)
{
	char            buf[8192] = "";
	char            forwardto[256];
	word            totalsize = 0;
	int             newshandle = 0;
	char           *returnto = responsibleparty;
	char           *p, *q, *udate, *qq;
	dumpwindow(ti_umsg, "\r\n\n\nForwarding message back to the UUCP feed");

	strcpy(buf, bouncefile);
	p = strtok(buf, " ");	/* forward */
	p = strtok(NULL, " ");	/* address */
	if (p)
		if (*p) {
			strcpy(forwardto, p);
			dumpwindow(ti_umsg, "\nSending to: %s", p);
			if (stricmp(p, "NULL") == NULL)
				return;
		} else {
			errormsgstring("Forward specified for mail sent to %s; no forwarding address defined.  Forwarding to YOUR account.");
			sprintf(forwardto, "root@%s", mysite);
		}
	newshandle = makemailhandle(forwardto, p);
	if (newshandle < 1) {
		errormsgstring("Could not create forwarding handle");
		return;
	}
	*buf = 0;
	q = buf;
	q += strlen(q);
	strcat(q, who_from_line(p));

	q += strlen(q);
        sprintf(q,"X-Forwarding-Note: Was sent to %s; forwarding to %s\n",sentto,forwardto);
	q += strlen(q);

	totalsize = (word) strlen(buf);
	write(newshandle, buf, strlen(buf));
	virgin = 1;		/* need to lf->cr again.. */

	p = USENETBUF;
        
        if (strncmp(p,"from ",5)==0) {
  /* skip over the "from " line if present */
  p=strpbrk(p,"\r\n");
  if (p) p++; 
  else p=USENETBUF;
} 
	while (*p) {
		if (*p == '\r')
			*p = '\n';
		p++;
	}
	write(newshandle, USENETBUF, strlen(USENETBUF));
	tousenet++;

	if (logtraffic) {
		printfh(logtraffic,
			"eo:%lu/1 %s %s %s %s\r\n",
			filelength(newshandle),
			normalize("mailer-daemon", ""),
			forwardto,
			gateway,
			"forward");
	}
	if (newshandle > 1)
		close(newshandle);
	if (emailheaderlog) {
		printfh(emailheaderlog, "\r\nDate: %s\r\n", udate);
		printfh(emailheaderlog, "To  : %s (internet)\r\n", forwardto);
		printfh(emailheaderlog, "From: %s (fidonet)\r\n", normalize("mailer-daemon", ""));
		printfh(emailheaderlog, "Subj: Message forwarded from account %s to %s\r\n", sentto, forwardto);
	}
}

char           *
stristr(char *master, char *sub)
{
	int             l;
	l = strlen(sub);
	while (*master) {
		if (!strnicmp(master, sub, l))
			return master;
		master++;
	}
	return NULL;
}

int             checkvalidfidonet = 0;

void            postnews(char *p);

void 
parseemailheader(char *towho)
{
	char           *p, *q;
	char           *news[20];
	char            info[512];
	char            newtowho[512];
	char            address[100];
	char            buf[2000];
	char            buf2[2000];
	int             safe = 1;
	char           *origtowho = towho;
	translate_control_contained = 0;
	strcpy(newtowho, cleanup(towho, mysite));
	goto endtop;
top:
	memmove(towho + 5, towho, strlen(towho) + 1);
	strncpy(towho, "root:", 5);
	p = maplocal(towho);
	if (mapuser(towho) != NULL) {
		safe = 1;
		p = mapuser(towho);
		goto mappeduser;
	}
	goto senditdamnit;


endtop:
	towho = newtowho;
	memset(news, 0, sizeof(news));

	newwindow(ti_umsg);
	clrscr();

	if (logtraffic || capturedefined) {
		strcpy(account.theirside, "unknown");
		strcpy(account.ourside, emaddress(towho));
		strcpy(account.ftnaddress, gateway);
		strcpy(account.realname, "service");
	}
        if (emailheaderlog) {
printfh(emailheaderlog,"\r\n");
 p=token(USENETBUF,"Date:");
 if (p) if (*p) printfh(emailheaderlog,"Date: %s\r\n",p);
}
	p = token(USENETBUF, "From:");
	if (*p) {
		printfh(emailheaderlog, "From: %s (internet)\r\n", emaddress(p));
		if (logtraffic || capturedefined)
			strcpy(account.theirside, emaddress(p));
		p[54] = 0;
		cprintf("From: %s\r\n", p);
	}
	/* Check to see if it's from a mailer daemon */
	strcpy(buf2, emaddress(p));
	strcpy(buf, cleanup(buf2, ""));
	p = buf;
	q = strchr(buf, '@');
	if (q) {
		*q = 0;
	} else {
		p = strrchr(buf, '!');
		if (p == NULL)
			p = buf;
		if (*p == '!')
			p++;
	}
	safe = checkvalidfidonet = !(
				     (stricmp(p, "uucp") == NULL)
				     || (stricmp(p, "bounce") == NULL)
				     || (stristr(p, "!uucp"))
				     || (stristr(p, "bounce"))
				     || (stristr(p, "daemon"))
				     || (stristr(p, "demon"))
				     || (stristr(p, "mailer"))
				     || (*p == 0)	/* no name - just a site */
		);

	printfh(emailheaderlog, "To:   %s (fidonet)\r\n", emaddress(towho));
	cprintf("To  : %s\r\n", towho);

	if (safe == 0) {
		strcpy(buf2, emaddress(towho));
		strcpy(buf, cleanup(buf2, ""));
		p = buf;
		q = strchr(buf, '@');
		if (q)
			*q = 0;
		else {
			p = strrchr(buf, '!');
			if (p == NULL)
				p = buf;
			if (*p == '!')
				p++;
		}
		if (
		    (stristr(p, "error")) || (stristr(p, "-err")) || (stristr(p, "owner"))
			)
			safe = checkvalidfidonet = 1;
	}
	p = token(USENETBUF, "Subject:");
	if (*p) {
		printfh(emailheaderlog, "Subj: %s\r\n", p);
		p[54] = 0;
		cprintf("Subj: %s\r\n", p);
	}
printfh(emailheaderlog,"\r\n");
	cprintf("\r\n");

	ti = ti_areas;
	gettextinfo(ti_areas);
	window(ti_area.winleft, (char) (ti_area.wintop + ti_area.cury), ti_area.winright, ti_area.winbottom);
	gotoxy(1, 1);



	if (stricmp(towho, "fileserv") == 0)
		if (mapuser("fileserv") == NULL) {
	fileservreq:
			if (!safe)
				goto top;
			cprintf("fileserv request");
			if (logtraffic) {
				strcpy(account.realname, "fileserv");
				monitor("ei");
			}
			ftpmail();
			return;
		}
	if (stricmp(towho, "ftpmail") == 0)
		if (mapuser("ftpmail") == NULL)
			goto fileservreq;

	if (stricmp(towho, "diagnostics") == NULL) {
		if (!safe)
			return;
		if (logtraffic) {
			strcpy(account.theirside, "diagnostics");
			monitor("ei");
		}
		diagnostic(origtowho);
		return;
	}
	/* CAPTURE CHECKING */

	if (capture(1, account.ourside, account.theirside)) {
		strcpy(account.realname, "CAPTURED");
		strcpy(account.ftnaddress, gateway);
		monitor("xi");
		return;
	}
	/* CHECK FOR MAILING LIST MAPPING */
if (mailinglists) {

/*	p = mapmailinglist(towho,1);*/ /* 1=cleanup addresses */
p="";

if ((!p)||(!*p)) {

        p = token(USENETBUF, "From:");
 	if (*p) { strcpy(buf2,emaddress(p));}
        p=mapmailinglist(towho,buf2); /* 0=don't clean up addresses*/
 }
if ((!p)||(!*p)) {
	p = token(USENETBUF, "Reply-To:");
 	if (*p) { strcpy(buf2,emaddress(p));}
        p=mapmailinglist(towho,buf2); /* 0=don't clean up addresses*/
 }
if ((!p)||(!*p)) {
	p = token(USENETBUF, "Sender:");
 	if (*p) { strcpy(buf2,emaddress(p));}
        p=mapmailinglist(towho,buf2); /* 0=don't clean up addresses*/
 }
if ((!p)||(!*p)) {
	p = token(USENETBUF, "To:");
 	if (*p) { strcpy(buf2,emaddress(p));}
        p=mapmailinglist(towho,buf2); /* 0=don't clean up addresses*/
 }
	if (p)
		if (*p) {
			//if (!safe)
				//goto top;
			cprintf("Mailing list: %s\r\n", p);
			apparently_to = "";
			strcpy(whoto, "All");
			if (logtraffic) {
				strcpy(account.theirside, p);
				strcpy(account.realname, "mailing list");
				monitor("li");
			}
			make_echomsg(p);
			return;
		}

}
	p = mapuser(towho);
mappeduser:
	if (!p)
		p = mapsite(towho);
	checkvalidfidonet = 0;
	if (!p) {
		if ((!keepunknown) && (strchr(towho, '@')))
			p = "BOUNCESITE";
		else
			p = maplocal(towho);
	}
	if ((!p) || (!*p))
		p = "BOUNCE";


	if (strnicmp(p, "BOUNCESITE", 10) == NULL) {
		if (!safe)
			goto top;
		if (logtraffic) {
			strcpy(account.realname, "bounced");
			monitor("ei");
		}
		bounceuucp(origtowho, p, -1);
		//-1 = SITE bounce not a USER bounce
			return;
	}
	if (strnicmp(p, "BOUNCE", 6) == NULL) {
		if (!safe)
			goto top;
		if (logtraffic) {
			strcpy(account.realname, "bounced");
			monitor("ei");
		}
		bounceuucp(origtowho, p, 0);
		return;
	}
	if ((strnicmp(p, "FILESERV ", 9) == NULL)
	    || (strnicmp(p, "FILESERVER ", 11) == NULL)
	    || (strnicmp(p, "FTP ", 4) == NULL)
	    || (strnicmp(p, "FTPMAIL ", 8) == NULL))
		goto fileservreq;
	if ((stricmp(p, "FILESERV") == NULL)
	    || (stricmp(p, "FILESERVER") == NULL)
	    || (stricmp(p, "FTP") == NULL)
	    || (stricmp(p, "FTPMAIL") == NULL))
		goto fileservreq;


	if (strnicmp(p, "NEWS ", 5) == NULL) {
		if (!safe)
			goto top;
		if (logtraffic) {
			strcpy(account.realname, "email-to-news");
			monitor("no");
		}
		p += 5;
		cprintf("Email to news: %s\r\n", p);
		postnews(p);
		return;
	}
	if (strnicmp(p, "ECHO ", 5) == NULL) {
		if (!safe)
			goto top;
		if (logtraffic) {
			strcpy(account.realname, "email-to-echo");
			monitor("ni");
		}
		p += 5;
		cprintf("Email to echomail: %s\r\n", p);
		apparently_to = "";
		strcpy(whoto, "All");
		make_echomsg(p);
		return;
	}
	if (strnicmp(p, "FUNCTION ", 9) == NULL) {
		if (!safe)
			goto top;
		if (logtraffic) {
			strcpy(account.realname, "function");
			monitor("ei");
		}
		functionrequest(origtowho, p);
		return;
	}
	if (strnicmp(p, "UUSEND ", 7) == NULL) {
		if (!safe)
			goto top;
		if (logtraffic) {
			strcpy(account.realname, "uusend");
			monitor("ei");
		}
		uusend(origtowho, p);
		return;
	}
	if (strnicmp(p, "SAVETEXT ", 9) == NULL) {
		//if (!safe)
			//goto top;
		if (logtraffic) {
			strcpy(account.realname, "savetext");
			monitor("ei");
		}
		savetext(origtowho, p);
		return;
	}
	if  (strnicmp(p, "SAVESORT ", 9) == NULL) {
ssort:
		if (logtraffic) {
			strcpy(account.realname, "sortsave");
			monitor("ei");
		}
		sortsave(origtowho, p);
		return;
	}
	if  (strnicmp(p, "SORTSAVE ", 9) == NULL) goto ssort;
	if (strnicmp(p, "LOGTEXT ", 8) == NULL) {
		//if (!safe)
			//goto top;
		if (logtraffic) {
			strcpy(account.realname, "logtext");
			monitor("ei");
		}
		logtext(origtowho, p);
		return;
	}
	if (strnicmp(p, "INFO ", 5) == NULL) {
		if (!safe)
			goto top;
		if (logtraffic) {
			strcpy(account.realname, "info");
			monitor("ei");
		}
		bounceuucp(origtowho, p, 1, origtowho, origtowho);
		return;
	}
	if (strnicmp(p, "FORWARD ", 8) == NULL) {
		if (logtraffic) {
			strcpy(account.realname, "forward");
			monitor("ei");
		}
		forwarduucp(origtowho, p);
		return;
	}
senditdamnit:
	strcpy(info, p);
	cprintf("Translates to %s\r\n", info);
	p = strtok(info, " ,\x09");
	strcpy(address, p);
	p = strtok(NULL, "\r");
	if (p == NULL) {
		errormsgstring("Invalid USER statement for %s: missing parameters!", address);
		return;
	}
	while (*p == ' ')
		p++;		/* skip dead space */
	strcpy(whoto, p);
whotoloop:
	if (whoto[0])
		if (whoto[strlen(whoto) - 1] == 32) {
			whoto[strlen(whoto) - 1] = 0;
			goto whotoloop;
		}
	if (whoto[0] == '"')
		if (whoto[strlen(whoto) - 1] == '"') {	/* remove quotes */
			strcpy(buf, whoto + 1);
			strcpy(whoto, buf);
			if (whoto[0])
				whoto[strlen(whoto) - 1] = 0;
		}
	if (strlen(whoto) > 35)
		whoto[35] = 0;
	if (stricmp(whoto, "NULL") == 0) {
		cprintf("Message sent to NULL\r\n");
		return;
	}
	if (logtraffic) {
		strcpy(account.ftnaddress, address);
		strcpy(account.realname, whoto);
		monitor("ei");
	}
	fidoadr_split(address, &fidoadr);
	make_echomsg("");

}
void            statusline(char *buffer);
void 
rmailbag(char *peopleline)
{
	char            peoplebuf[LINESIZE];
	char           *people[250];
	int             i;
	char           *p;
	int             handle = 0;
	long            totalsize;
	long            thisblock;
	char            blocknum = 0;

	char            inquote = 0;


	if (!do_mail) {
		errormsgstring("MAIL being skipped");
		return;
	}
	//init accounting information - 1 element at a time, instead of the whole struct.
	                account.size = 0;
	account.divideby = 0;
	account.ourside[0] = 0;
	account.theirside[0] = 0;
	account.ftnaddress[0] = 0;
	account.realname[0] = 0;
	memset(people, 0, sizeof(people));
	strncpy(peoplebuf, peopleline, LINESIZE - 1);
	peoplebuf[LINESIZE - 1] = 0;	/* truncate */

	p = peoplebuf;
	inquote = 0;
	while (*p) {
		if (*p == '"')
			inquote = (char) (1 - inquote);
		if (*p == ' ')
			if (inquote == 0)
				*p = '';
		if (*p == ',')
			if (!inquote)
				*p = '';
		p++;
	}

	p = strtok(peoplebuf, "");
	i = 0;
	if (p)
		p = strtok(NULL, "");
	while (p) {
		if (i < 250)
			people[i] = p;
		account.divideby = ++i;
		//update accounting as well
			p = strtok(NULL, "");
	}


	/* let's read it in now */
	totalsize = account.size = thisblock = strlen(USENETBUF);
	for (i = 0; i < 250; i++)
		if ((people[i]) && (*people[i])) {
			apparently_to = people[i];
			parseemailheader(people[i]);
		} else
			i = 251;
}
int             parsevirgin = 0;
void 
parsenext(int handle)
{
	long            totalsize;
	long            thisblock;
	char           *p;
	long            thisposition;

	*USENETBUF = 0;

	/* Get the first line that says #! rnews.. */
loop:
	if (eof(handle))
		return;
	p = getline_lf(handle);
	if (strncmp(p, "#! rnews", 8))
		if (strncmp(p, "#! rmail", 8)) {	/* if we don't have it */

			/* Well, the header we we expecting wasn't there. */
			/* If we were at the top of the file, we can just */
			/* treat it as a single msg.  However, if this is */
			/* not the first line, then it _was_ a batch ..   */
			/* and something got garbled.  Keep reading until */
			/* we find the next #! rnews line..               */
			thisposition = tell(handle);

			if (parsevirgin == 0) {
				thisposition = tell(handle);
				sprintf(USENETBUF, "Corrupt news file!  Resynching.. file pointer at %lu.                                       \r\n", thisposition);
				statusline(USENETBUF);
				USENETBUF[0] = 0;
				goto loop;	/* reloop and syncronize */
			}
			lseek(handle, 0, SEEK_SET);
			totalsize = filelength(handle);
			goto readloop;
		}
	/* now, get the size of the next block */
	totalsize = atol(p + 8);
        if (totalsize<1) {
           totalsize=
            filelength(handle)-tell(handle);
        } /* endif */
readloop:
	parsevirgin = 0;
	thisblock = totalsize;
	if (thisblock >= usenetsize) {
		thisblock = usenetsize - 10;
	}
	thisblock = read(handle, USENETBUF, thisblock);
	USENETBUF[thisblock] = 0;	/* truncate end of string */
	if (totalsize >= thisblock) {
		lseek(handle, totalsize - thisblock, SEEK_CUR);
		if (tell(handle) >= filelength(handle))
			lseek(handle, 0, SEEK_END);
	}
	fixheaders();
	virgin = 1;
	if (strnicmp(p, "#! rmail", 8) == NULL) {
		rmailbag(p + 8);
	} else {
		parseheader();
	}			/* endif */

}

int             decompress_ondemand(char *filename);
void 
rnews(char *fin)
{
	int             inh;
	if (!do_news) {
		errormsgstring("News is being skipped.");
		killfiles = 0;
		return;
	}
	strcpy(whoto, "All");
	apparently_to = "";

	inh = decompress_ondemand(fin);
	if (inh < 1) {
		errormsgstring("Error opening %s", (void *) fin);
		return;
	}
	lseek(inh, 0L, SEEK_SET);	/* reset back to the front of the
					 * file */
	parsevirgin = 1;
	while (!eof(inh))
		parsenext(inh);
	errormsgstring("Closing %s", fin);
	close(inh);
	killfiles = 1;
}


void 
rmail(char *cmdname, char *archivename)
{
	char            peoplebuf[LINESIZE];
	char           *people[250];
	int             i;
	char           *p;
	int             handle = 0;
	long            totalsize;
	long            thisblock;
	char            blocknum = 0;

	char            inquote = 0;


	if (!do_mail) {
		errormsgstring("MAIL being skipped");
		return;
	}
	//init accounting information - 1 element at a time, instead of the whole struct.
	                account.size = 0;
	account.divideby = 0;
	account.ourside[0] = 0;
	account.theirside[0] = 0;
	account.ftnaddress[0] = 0;
	account.realname[0] = 0;
	memset(people, 0, sizeof(people));
	strncpy(peoplebuf, cmdname, LINESIZE - 1);
	peoplebuf[LINESIZE - 1] = 0;	/* truncate */

	p = peoplebuf;
	inquote = 0;
	while (*p) {
		if (*p == '"')
			inquote = (char) (1 - inquote);
		if (*p == ' ')
			if (inquote == 0)
				*p = '';
		if (*p == ',')
			if (!inquote)
				*p = '';
		p++;
	}


	p = strtok(peoplebuf, "");
	i = 0;
	if (p)
		p = strtok(NULL, "");
	while (p) {
		if (i < 250)
			people[i] = p;
		account.divideby = ++i;
		//update accounting as well
			p = strtok(NULL, "");
	}


	handle = sopen(archivename, (crlf ? O_TEXT : O_BINARY) | O_RDONLY, SH_DENYWR, S_IREAD);
	if (handle < 1) {
		errormsgstring("Missing: %s (skipping)", archivename);
		return;
	}
	/* let's read it in now */
	totalsize = filelength(handle);
	account.size = thisblock = read(handle, USENETBUF, totalsize >= usenetsize ? usenetsize - 1 : totalsize);
	USENETBUF[thisblock] = 0;	/* truncate end of string */
	close(handle);
	handle = 0;
	fixheaders();



	if (totalsize >= usenetsize) {
		lseek(handle, totalsize - usenetsize, SEEK_CUR);
	}
	virgin = 1;

	for (i = 0; i < 250; i++)
		if ((people[i]) && (*people[i])) {
			apparently_to = people[i];
			parseemailheader(people[i]);
		} else
			i = 251;
	killfiles = 1;
}
