#include "main.h"

/*
**        A Pratt-Boyer-Moore string search, written by Jerry Coffin
**  sometime or other in 1991.  Removed from original program, and
**  (incorrectly) rewritten for seperate, generic use in early 1992.
**  Corrected with help from Thad Smith, late March and early
**  April 1992...hopefully it's correct this time. Revised by Bob Stout.
**
**  This is hereby placed in the Public Domain by its author.
*/


static size_t   table[UCHAR_MAX];
static size_t   len;
static char    *findme;
/*
**  Call this with the string to locate to initialize the table
*/

void            init_search(const char *string)
{
    size_t          i;
    len = strlen(string);
    for (i = 0; i < UCHAR_MAX; i++)
        table[i] = len;
    for (i = 0; i < len; i++)
        table[(unsigned char) string[i]] = len - i - 1;
    findme = (char *) string;
}
/*
**  Call this with a buffer to search
*/

char           *strsearch(const char *string)
{
    register size_t shift;
    register size_t pos = len - 1;
    char           *here;
    size_t          limit = strlen(string);
    while (pos < limit) {
        while (pos < limit &&
               (shift = table[(unsigned char) string[pos]]) > 0) {
            pos += shift;
        }
        if (0 == shift) {
            if (0 == strncmp(findme,
                             here = (char *) &string[pos - len + 1], len)) {
                return (here);
            } else
                pos++;
        }
    }
    return NULL;
}


char           *findstring(char *buf, char *search)
/**/
/* Usage:*/
/*     findstring(buf,searchstring)  // first time*/
/*     findstring(buf,NULL)          // subsequent times*/
{
    if ((search) && (*search))
        init_search(search);
    return strsearch(buf);
}
