#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <ctype.h>
#include <i86.h>
#include <time.h>

//#define TESTING

void simplify(char *inplace,char *oursite)
{
  int l; register char *p;
  l=strlen(oursite);
  p=inplace;
  while (*p)
   {
    if (*p=='.') {
         if (p==inplace) memmove(p,p+1,strlen(p)); 
         if (*(p+1)=='.') memmove(p,p+1,strlen(p));
         if (*(p+1)==0) *p=0;
    } /* endif */
    if (strnicmp(p,oursite,l)==NULL)
     if ((p[l]==0) || (p[l]=='.'))
      if (p==inplace) *p=0; else if (*(p-1)=='.') {p--;*p=0;}
    if (*p) p++;
   }

}

char           *killbang(char *orig);


//#define debugstorage
/* cleanup will re-arrange and clean up an address for parsing */
/* quoted _names_ are handled, but _not_ addresses. */
char *cleanup( char *data, char *oursite)
{
   #ifdef debugstorage
     char buf[1024],buf2[1024],buf3[1024];
     static   char storage[1024];
    #else
     char buf[1024],buf3[1024];
      static char buf2[1024];
   #endif

   char *firstat=NULL,*lastat=NULL,*firstbang=NULL,*lastbang=NULL, *p, ch;
   long quote=0;
   strcpy(buf,data);
   p=buf;       /* prescan the incoming string */
   while (ch=*p)
    {  *p=(char) tolower(ch);
       if (ch=='"') {
         /* quote : special handling needed */
         if (*(p+1)=='"') {p++;p++;continue;}
         quote=1-quote; p++; continue;
       }
      if (quote!=0) {p++;continue;}  /* no handling of any character in quotes */
      if (ch=='!') {
        if (firstbang==NULL) firstbang=p;
        lastbang=p;
      }
      if (ch=='%') ch=*p='@';
      if (ch=='@')  {
        if (firstat==NULL) firstat=p;
        lastat=p;
      }
      p++;
    }

  /* done scanning, now determine actions */


 /* simple  user.name  */
 if ((firstat==NULL) && (firstbang==NULL))
   {
    #ifdef debugstorage
       strcpy(storage,buf);
       return storage;
    #else
       strcpy(buf2,buf);
       return buf2;
    #endif
   }

 /* them!them!site!user.name */
 if ((firstat==NULL) && (firstbang!=NULL))
   {
     /* bang paths only */
    *lastbang=0;
    lastbang++ ; /* truncate and step over */
    strcpy(buf2,lastbang); /* user name */
    strcpy(buf3,killbang(buf)); /* site name in reverse.naming.sequence */
    simplify(buf3,oursite);  /* cut our site out of it */
    if (buf3[0]) {strcat(buf2,"@");strcat(buf2,buf3);}
    #ifdef debugstorage
      strcpy(storage,buf2);
      return storage;
    #else
      return buf2;
    #endif
   }
 /* user@... or user%...  but no ! */
 if (firstbang==NULL)
   {
     /* internet style only only */
    *firstat=0;
    firstat++;   /* get past the user name, then simply the trails */
    p=firstat;
 
    while (*p) {if (*p=='@') *p='.'; p++;}  /* all @ marks turn to dots */
    simplify(firstat,oursite); /* get rid of the crap */

    strcpy(buf2,buf);
    if (*firstat) {strcat(buf2,"@"); strcat(buf2,firstat);}
    #ifdef debugstorage
      strcpy(storage,buf2);
      return storage;
    #else
      return buf2;
    #endif
   }

   /*  site!user@somewhere */
   if (lastbang < firstat)
   {
     /* confusing .. ! */
     /* clean bang paths */


     *lastbang=0;   /* buf = bang!site */
     lastbang++;    /* lastbang = user name */
     *firstat=0;    
      firstat++;    /* firstat = foo.bar.edu */
 
    strcpy(buf3,killbang(buf));
    strcat(buf3,".");
    strcat(buf3,firstat);
     p=buf3;
    while (*p) {if (*p=='@') *p='.'; p++;}  /* all @ marks turn to dots */
     simplify(buf3,oursite);
     strcpy(buf2,lastbang); /*user name*/
     if (buf3[0]) {
      strcat(buf2,"@");
      strcat(buf2,buf3);
     }
    #ifdef debugstorage
      strcpy(storage,buf2);
      return storage;
    #else
      return buf2;
    #endif
   }
  /* All else failed!  We don't understand this address. */
   /*  Should be   user@site!site!site  which does not make sense */

  #ifdef debugstorage
  strcpy(storage,buf);
  return storage;
  #else
  strcpy(buf2,buf);
  return buf2;
  #endif
}
char           *killbang(char *orig)
{
    register char           *p;
    char            temp[512];
    static char            temp2[512];
    char            temp3[512];
    strcpy(temp, orig);
    temp2[0] = 0;
    p = strtok(temp, "!");
    while (p) {
        if (temp2[0]==0)
            strcpy(temp2, p);
        else {
            sprintf(temp3, "%s.%s", p, temp2);
            strcpy(temp2, temp3);
        }
        p = strtok(NULL, "!");
    }
    return temp2;
}

void main(int argc,char *argv[]) 
{
   char inl[2048];
   char lastmysite[2048];
   char *p;
   long temp;
   long temp2;
   long countdown;
#ifdef TESTING
   
   strcpy(lastmysite,"wmeonlin");
   for (countdown=0; countdown<15000; countdown++)
     {
   cleanup("user@mysite.com",lastmysite);
   cleanup("mysite!user",lastmysite);
   cleanup("site!user@mysite",lastmysite);
   cleanup("mysite!site!user@gate",lastmysite);
   cleanup("user@mysite.com",lastmysite);
       }
  temp=clock(); /* clock ticks = 100*sec */
  temp= 7500000/temp;
  printf("%lu times per second\n",temp);
  delay(5000);
#else
   strcpy(lastmysite,"mysite");
   while (!feof(stdin))
    {
       inl[0]=0;
       fgets(inl,sizeof(inl),stdin);
       if ((p=strchr(inl,'\n'))!=NULL) *p=0;
       if ((p=strchr(inl,'\r'))!=NULL) *p=0;

       printf("translates to.. %s\n",cleanup(inl,lastmysite));
       temp=clock();
       for (countdown=0;countdown<50000;countdown++) {
          cleanup(inl,lastmysite);
       } /* endfor */
       temp2=clock();
       temp2-=temp;
       temp=5000000/temp2;
       printf("%lu times per second\n\n",temp);
    }
#endif
}

