#include "main.h"

#define eofidx (feof(nodefile))
#define gnextidx fread(&nextidx,sizeof(nextidx),1,nodefile)
#define gnext(idx) fread(&idx,sizeof(idx),1,nodefile)

int             _validaddress(FILE * nodefile,
                                              register unsigned short czone,
                                              register unsigned short cnet,
                                              register unsigned short cnode)
{
    unsigned short  zone,
                    net,
                    node;
    zone = net = node = 0;
    unsigned        nextidx = 0;
    fseek(nodefile, 0, SEEK_SET);
    while (!eofidx) {
        gnext(node);
        if (node == 65535) {
            gnext(zone);
            net=zone;
            node=0;
        }
        if (node == 65534) {
            gnext(net);
            node = 0;
        }
        if ((cnet == net) && (cnode == node) && (czone == zone))
            return 1;
    }
    return 0;
}
char            botherlookup = 1;

short           validaddress(unsigned short czone, unsigned short cnet, unsigned short cnode)
{
    short           i;
    FILE           *nodefile;
    char buf[80];
    if (!botherlookup)
        return 1;               /* no file? don't check */
    if (!defined("NODELIST"))  /* no config file entry, either */
      {
         botherlookup=0;
         return 1;
      }
    sprintf(buf,"%sNODELIST.GIG",configstr("NODELIST"));
    nodefile = _fsopen(buf,"rb",SH_DENYNO);
    if (!nodefile) {
        botherlookup = 0;
        errormsgstring("NODELIST.GIG not found; not verifying nodelist addresses internally.");
        return 1;
    }

    /*
     * Attempt to set a large buffer to hold the nodelist file;
     * if the large buffer doesn't work, then attempt to allocate a small
     * buffer instead.  If that fails also, then leave it unbuffered.
     */
    if (feof(nodefile))
     {
      errormsgstring("Nodelist index is empty!");
      botherlookup =0;
      return 1;
     }
    errormsgstring("Verifying address in nodelist file: %u:%u/%u",czone,cnet,cnode);

    setvbuf(nodefile, FIDONETBUF, _IOFBF, fidonetsize);
    i = (short) _validaddress(nodefile, czone, cnet, cnode);
    fclose(nodefile);
    errormsgstring(i?"Address verified.":"Address could not be found.");
    return i;
}
