#include "main.h"
#include <time.h>
#include <stdlib.h>

/* SENDTO  field 1: address */
/* 2: directory */
long            totalmsgsize = 0;
long            numberofsplits = 0;
long            splitnumber = 0;
long            split;
char            pktname[256] = "";

pktheadertype   pktheader;
packedmsgtype   packedmsg, packed2;


int             bottoms = 0;
extern int      shortkludge;
void            shortenkludge(char *p);

void            makepath(char *);
void
make_pktheader(void)
{
	char            pathname[80];
	char            buf[256];
	FIDOADR         FIDO;
	char           *p;
	strcpy(buf, configstr("SENDTO"));
	p = strtok(buf, " \x09");
	p = strtok(NULL, " \x09");
	strcpy(pathname, p);
	if (strlen(pathname) > 0)
		if (pathname[strlen(pathname) - 1] != '\\')
			strcat(pathname, "\\");
	makepath(pathname);	/* make sure it exists! */
loop:
	sprintf(pktname, "%s%08lx.pkt", pathname, sequence++);
	pkthandle = sopen(pktname, O_BINARY | O_RDONLY, SH_DENYWR, S_IREAD);
	if (pkthandle > 0) {
		close(pkthandle);
		goto loop;
	}
	/* errormsgstring("Creating %s",pktname); */
	pkthandle = sopen(pktname, O_BINARY | O_CREAT | O_TRUNC | O_RDWR, SH_DENYRW, S_IWRITE);
	if (pkthandle < 0) {
		errormsgstring("Could not create %s!", pktname);
		pkthandle = 0;
		return;
	}
	memset(&pktheader, 0, sizeof(pktheader));
	memset(&packedmsg, 0, sizeof(packedmsg));
	packedmsg.msgtype = pktheader.pkttype = 2;
	memcpy(&FIDO, &sendtoADDR, sizeof(FIDO));
	packedmsg.destnode = pktheader.destnode = FIDO.node;
	packedmsg.destnet = pktheader.destnet = FIDO.net;
	pktheader.destzone2 = pktheader.destzone = FIDO.zone;
	pktheader.destpoint2 = FIDO.point;

	memcpy(&FIDO, &gatewayADDR, sizeof(FIDO));
	packedmsg.orignode = pktheader.orignode = FIDO.node;
	packedmsg.orignet = pktheader.orignet = FIDO.net;
	pktheader.origzone2 = pktheader.origzone = FIDO.zone;
	pktheader.origpoint2 = FIDO.point;
	if ((FIDO.point) && (!defined("OLDTOSSER"))) {
		pktheader.orignet = (signed int) -1;
		pktheader.auxnet = FIDO.net;
	}
	pktheader.capabilword = 0x0001;
	pktheader.CWvalcopy = 0x0100;

	pktheader.productcode = PRODUCTCODE_L;
	pktheader.ProductCode = PRODUCTCODE_H;
	pktheader.revision = REVISION_H;
	pktheader.Revision = REVISION_L;

	memset(buf, 0, sizeof(buf));
	if (configstr("PKTPASSWORD"))
		strcpy(buf, configstr("PKTPASSWORD"));
	pktheader.password[0] = buf[0];
	pktheader.password[1] = buf[1];
	pktheader.password[2] = buf[2];
	pktheader.password[3] = buf[3];
	pktheader.password[4] = buf[4];
	pktheader.password[5] = buf[5];
	pktheader.password[6] = buf[6];
	pktheader.password[7] = buf[7];
	write(pkthandle, &pktheader, sizeof(pktheader));

}
void
close_pkt(void)
{
	if (pkthandle < 1)
		return;
	/* errormsgstring("Closing file handle %u",pkthandle); */
	write(pkthandle, "\x00\x00", 2);	/* end of packet. */
	if (tell(pkthandle) == 60) {
		close(pkthandle);
		/* errormsgstring("Deleting %s, no msgs in pkt",pktname); */
		unlink(pktname);
		pkthandle = 0;
		return;
	}
	close(pkthandle);
	pkthandle = 0;
}
#pragma exit close_pkt

char           *nextmemoryline(char *position);

void
makefidoheader(void)
{
	char            value[2048] = "";
	char            tokenname[2048] = "";
	static char     thistok[256] = "\n";
	long            headermax;
	FIDONETBUF[0] = 0;
	char           *p, *q, *end;
	int             allheaders = 0;
	int             thisheader;


	allheaders = *apparently_to ? keep_mail : keep_news;

	headermax = maxmessage - 1000;
	if (headermax < 1000)
		headermax = 1000;
	tofidonet++;
	q = p = USENETBUF;
	end = FIDONETBUF;
	if (bottoms) {
		if (*apparently_to)
			strcpy(end, "\r--- Email headers follow ---\r");
		else
			strcpy(end, "\r--- News headers follow ---\r");
		end += strlen(end);
	}
	if (*apparently_to) {
		thisheader = allheaders;
		if ((thisheader != 1) && (findstring(keep_, "APPARENTLY-TO:")))
			thisheader = 1;
		if ((thisheader != 2) && (findstring(hide_, "APPARENTLY-TO:")))
			thisheader = 2;
		if ((thisheader != 0) && (findstring(kill_, "APPARENTLY-TO:")))
			thisheader = 0;
		switch (thisheader) {
		case 1:
			sprintf(end, "Apparently-to: %s\r", apparently_to);
			break;
		case 2:
			sprintf(end, "Apparently-to: %s\r", apparently_to);
			break;
		}
		end = FIDONETBUF + strlen(FIDONETBUF);
	}
loop:
	p = nextmemoryline(q);
	q += __memline + 1;
	if (end - FIDONETBUF > headermax) {
		sprintf(end, "*Remaining header lines skipped*\r\r");
		return;
	}
	if (*p == 0) {
		strcat(end, "\r");
		return;
	}
	if ((p = strtok(p, " \x09")) != NULL) {
		strncpy(tokenname, p, 2047);
		tokenname[250] = 0;
		/* thistok staticly defined as "\n" */
		strcpy(&thistok[1], tokenname);
		strcat(thistok, "\n");
		strupr(thistok);
	}
	if ((p = strtok(NULL, "\n")) != NULL) {
		while (*p == 32)
			p++;
		strncpy(value, p, 2047);
	} else
		value[0] = 0;
	thisheader = allheaders;

	if ((thisheader != 1) && (findstring(keep_, thistok)))
		thisheader = 1;

	if ((thisheader != 2) && (findstring(hide_, thistok)))
		thisheader = 2;

	if ((thisheader != 0) && (findstring(kill_, thistok)))
		thisheader = 0;

	switch (thisheader) {
	case 1:
		sprintf(end, "%s %s\r", tokenname, value);
		break;
	case 2:
		sprintf(end, "%s %s\r", tokenname, value);
		shortenkludge(end);
		break;
	}
	end += strlen(end);

	while ((*q == 32) || (*q == 9)) {
		p = nextmemoryline(q);
		q += __memline + 1;
		if (*p) {
			switch (thisheader) {
			case 1:
				sprintf(end, "%s\r", p);
				break;
			case 2:
				sprintf(end, "%s\r", p);
				break;
			}
			end += strlen(end);
		}
	}
	goto loop;
}

char            thissubject[75];
extern char     whoto[256];
extern char     tzone[256];
extern FIDOADR  fidoadr;
extern char     smallvsn[80];

void
end_message(char echo)
{
	char            buf[LINESIZE];
	char           *p;


	if (echo) {
		p = token(USENETBUF, "Organization:");
		if (*p) {	/* org found .. */
			if (originmethod)
				sprintf(buf, "\r---\r * Origin: %s%s", origin, p);
			else
				sprintf(buf, "\r---\r * Origin: %s", origindef, p);
		} else {
			sprintf(buf, "\r---\r * Origin: %s", origindef, p);
		}
		buf[81 - strlen(originaddress)] = 0;
		sprintf(buf + strlen(buf), " (%s)\rSEEN-BY: %s\r", originaddress, seenby);
		if (path[0] != 0)
			sprintf(buf + strlen(buf), "\x01PATH: %s\r", path);

	} else {
		struct tm      *time_now;
		time_t          secs_now;
		time(&secs_now);
		time_now = gmtime(&secs_now);

                sprintf(buf, "\r---\rVia %s ", gateway);
                strftime(buf + strlen(buf), 80, "%Y%m%d.%H%M%S.UTC",time_now);
                sprintf(buf+strlen(buf)," gigo %s%c\r",VIAVERSION,registereduser ? '+' : '-');
	}
	write(pkthandle, buf, strlen(buf) + 1);	/* includes null on final
						 * part */
}

void
ftscid(char *msgid, char *buf, char *kludge, long split)
{
	char           *p;
	char           *source, *dest;
	unsigned long   i;

	p = emaddress(msgid);
	strcpy(buf, kludge);
	strcat(buf, "mid__");
	source = p;
	dest = buf + strlen(buf);
	while (*source) {
		*dest = *source;
		if (*source == '"')
			*dest = '_';
		if (*source == ' ')
			*dest = '_';
		dest++;
		source++;
	}
	*dest++ = 32;
	i = getcrc(p) & 0xffff0000 | split;
	ultoa(i, dest, 16);
	strcat(buf, "\r");
}


extern int      safethreads;
extern void     addmsgid(unsigned long, char *, char *, char *);
void
safemsgid(char *buf)
{
	char           *p, *q, *dest;

	/* get message id, make crc, get references, add to database */
	/* get last reference, make crc */
	char            MessageID[2048];
	char            References[2048];
	char            Followups[2048];
	char            Control[2048];

	memset(MessageID, 0, sizeof(MessageID));
	memset(References, 0, sizeof(References));
	memset(Followups, 0, sizeof(Followups));
	memset(buf, 0, sizeof(buf));
	strncpy(MessageID, token(USENETBUF, "Message-Id:"), sizeof(MessageID) - 1);
	strncpy(References, token(USENETBUF, "References:"), sizeof(References) - 1);
	strncpy(Followups, token(USENETBUF, "Followup-To:"), sizeof(Followups) - 1);

	if (Followups[0] == 0) {
		strncpy(Followups, token(USENETBUF, "Newsgroups:"), sizeof(Followups) - 1);
		if (strchr(Followups, ',') == NULL)
			Followups[0] = 0;
	}
	unsigned long   i;
	p = emaddress(MessageID);
	i = getcrc(p);
	sprintf(buf, "MSGID: %s %08lx\r", gateway, i);

	addmsgid(i, MessageID, References, Followups);

	p = References;
	while ((*p) && (q = strchr(p + 1, '<')))
		p = q;
	if (*p) {
		p = emaddress(p);
		i = getcrc(p);
		sprintf(buf + strlen(buf), "REPLY: %s %08lx\r", gateway, i);
	}
	if ((!delete_control) &&
	    (translate_control) &&
	    (translate_control_contained)) {
		memset(Control, 0, sizeof(Control));
		strncpy(Control, token(USENETBUF, "Control: cancel"), sizeof(Control) - 1);
		p = Control;
		while ((*p) && (q = strchr(p + 1, '<')))
			p = q;
		if (*p) {
			p = emaddress(p);
			i = getcrc(p);
			sprintf(buf + strlen(buf), "ACUPDATE: DELETE %s %08lx\r", gateway, i);
		}
	}
}


char            splitphrase[256];

void
makesplitkludge(char *q, long splitnumber, long numberofsplits)
{
	struct tm      *time_now;
	time_t          secs_now;
	int             i;

	if (splitnumber == 1) {	/* create the unique? split phrase for this
				 * long message */
		i = sequence++ % 10000;
		time(&secs_now);
		putenv("TZ=UTC0");
		time_now = localtime(&secs_now);
		strftime(splitphrase, 255, "SPLIT: %d %b %y %H:%M:%S ", time_now);
		sprintf(splitphrase + strlen(splitphrase), "@%u/%u                   ", gatewayADDR.net, gatewayADDR.node);
		sprintf(splitphrase + 40, "%u     ", i);
		splitphrase[45] = 0;
	}
	sprintf(q, "%s %02u/%02u ++++++++++\r", splitphrase, splitnumber, numberofsplits);
}

/* problems I see with this crap */
/*
 * newsgroup names do not always create the same area names invalidating the
 * CRC checking of the address
 * 
 */

char           *denmark_date(char *ftsc);
unsigned long   getcrc(char *buf);
#define crc32_str(x) getcrc(x)
char           *denmark_idtorfc(char *header, char *MID, char *area, char *to, char *from, char *subject, char *date, FIDOADR * adr);
char           *denmark_rfctoid(char *kludge, char *MID, char *area, int splitnumber);


void
shortenkludge(char *p)
{
	if (shortkludge)
		if (strlen(p) > shortkludge)
			strcpy(p + (shortkludge - 3), "..\r");
}

void
make_msgheader(char *echoname)
{
	char           *p, *q, *r;
	char            buf[2048];
	char            fromfield[50];
       

	if (pkthandle < 1)
		return;
	if (*echoname)
		write(pkthandle, &packedmsg, sizeof(packedmsg));
	else {
		packed2 = packedmsg;
		packed2.destnode = pktheader.destnode = fidoadr.node;
		packed2.destnet = pktheader.destnet = fidoadr.net;
		packed2.attribute = 32 + 1;	/* trans+private */
		write(pkthandle, &packed2, sizeof(packed2));
	}

	p = fidostyle_date();
	makeascii(p);
	write(pkthandle, p, 20);

	p = whoto;
	if (*echoname)
		p = token(USENETBUF, "X-Ftn-To:");
	if (!p)
		p = whoto;
	if (!*p)
		p = "All";
	write(pkthandle, p, strlen(p) + 1);

	p = fidostyle_from(echoname);
	makeascii(p);
	if (partial35)
		strcpy(fromfield, p);
	//for later comparison
	write(pkthandle, p, strlen(p) + 1);



	p = thissubject;
	makeascii(p);
	if (splitnumber == 1) {
		p += 3;
		cputch(' ');
	}
	cputch('.');

	write(pkthandle, p, strlen(p) + 1);
	switch (thissubject[1]) {
	case '9':
		thissubject[1] = '0';
		thissubject[0]++;
		break;
	default:
		thissubject[1]++;
	}

	buf[0] = 0;
	q = buf;

	if (*echoname) {
		sprintf(buf, "AREA:%s\r", echoname);
		strupr(buf);
	} else {
		if (!fidoadr.zone)
			fidoadr.zone = gatewayADDR.zone;
		if (!fidoadr.zone)
			fidoadr.zone = gatewayADDR.zone = 1;
		sprintf(buf, "INTL %u:%u/%u %u:%u/%u\r", fidoadr.zone, fidoadr.net, fidoadr.node,
			gatewayADDR.zone, gatewayADDR.net, gatewayADDR.node);
		if (fidoadr.point)
			sprintf(buf + strlen(buf), "TOPT %u\r", fidoadr.point);
		if (gatewayADDR.point)
			sprintf(buf + strlen(buf), "FMPT %u\r", gatewayADDR.point);
	}
	q = buf;
	while (*q)
		q++;

	if (splitnumber != 1)
		goto nomsgid;
	if (safethreads) {
		/* Safe threading via database records */
		safemsgid(q);

	} else if (nike) {
		/* Take the NIKE approach:  Just Do It!    (MSGID fields) */
		p = token(USENETBUF, "Message-Id:");
		if ((p) && (*p))
			ftscid(p, q, "MSGID: ", splitnumber);
		else
			sprintf(q, "MSGID: %s %08lx\r\n", gateway, sequence++);
		while (*q)
			q++;
		r = p = token(USENETBUF, "References:");
		r = strtok(p, " \x09\r\n");
		while (r) {
			if (*r)
				p = r;
			r = strtok(NULL, " \x09\r\n");
		}
		if ((p) && (*p))
			ftscid(p, q, "REPLY: ", 1);
	} else
		sprintf(q, "MSGID: %s %08lx\r", gateway, sequence++);
nomsgid:
	while (*q)
		q++;
	if (!safethreads)
		if (!delete_control)
			if (translate_control)
				if (translate_control_contained) {
					p = token(USENETBUF, "Control: cancel");
					p = emaddress(p);
					if ((p) && (*p))
						ftscid(p, q, "ACUPDATE: DELETE ", splitnumber);
					while (*q)
						q++;
				}
	if (partial35) {
		p = token(USENETBUF, "Reply-To:");
		if (*p == 0)
			p = token(USENETBUF, "From:");
		if (*p == 0) {
			p = token(USENETBUF, "From");
			if (*p)
				p = strtok(p, " ");
		}		/* get the first address listed */
		if (p)
			p = emaddress(p);
		if (strcmp(p, fromfield)) {	/* if not the same, then.. */
			while (*q)
				q++;
			sprintf(q, "REPLYTO %s UUCP\r\nREPLYADDR %s\r",
gateway, p);
		}
	} else if (fsc35) {
		p = token(USENETBUF, "Reply-To:");
		if (*p == 0)
			p = token(USENETBUF, "From:");
		if (*p == 0) {
			p = token(USENETBUF, "From");
			if (*p)
				p = strtok(p, " ");
		}		/* get the first address listed */
		while (*q)
			q++;
		sprintf(q, "REPLYTO %s UUCP\r\nREPLYADDR %s\r", gateway, emaddress(p));
	}
                if (flags[0]) 
                     sprintf(buf+strlen(buf),"FLAGS %s\r",flags);
	while (*q)
		q++;
	sprintf(q, "GID %s\r\n", gigosig);
	if (numberofsplits > 1) {
		while (*q)
			q++;
		makesplitkludge(q, splitnumber++, numberofsplits);
		//sprintf(q, "NOTE +++ SPLIT %lu of %lu +++\r", splitnumber++, numberofsplits);
	}
	write(pkthandle, buf, strlen(buf));
}



void
make_echomsg(char *echoname)
{
	register char  *p;
	register char   ch;
	long            sizeleft;
	int             bufsize;
	char            echon[256];
	static char     splitbuffer[161];
	int             splitflag;
	unsigned int    sizeofbuf;
	long            temp;

	char           *endofusenet;
	char           *startusenet;


	if (pkthandle < 1)
		return;
	split = linesplit;
	strcpy(echon, echoname);
	echoname = echon;

	if ((maxpkt) && (filelength(pkthandle) > maxpkt)) {
		close_pkt();
		make_pktheader();
	}
	/*
	 * Make FIDONETBUF contain the top of what we want the messages to
	 * have in it.
	 */

	makefidoheader();

	/*
	 * Now, make sure we can find the beginning of the message body. If
	 * we can't find it, make one.  If there's no room, abort the
	 * message.
	 */

	do {
		p = strstr(USENETBUF, "\n\n");
		if (p) {
			p += 2;
			startusenet = p;
			temp = strlen(p);
			endofusenet = p + temp;
			totalmsgsize = temp;
			do {
				if (*p == '\n')
					*p = '\r';
			} while (*p++);
		} else {
			errormsgstring("Grunged usenet message / no message body");
			if (strlen(USENETBUF) + 80 > usenetsize)
				return;
			strcat(USENETBUF, "\n\n(Grunged USENET message / no message body)\r");
		}
	} while (!p);



#define strlenusenet(q) (endofusenet-(q))

	sizeleft = split = maxmessage;

	if (multipleheaders) {
		numberofsplits = totalmsgsize;
		numberofsplits /= (split - strlen(FIDONETBUF));	/* 0..1-number of blocks */
	} else {
		numberofsplits = totalmsgsize + strlen(FIDONETBUF);	/* msg size
									 * alltogether.. */
		numberofsplits /= split;	/* 0..1-number of blocks */
	}
	numberofsplits++;	/* real number */
	splitnumber = 1;
	thissubject[0] = '0';
	thissubject[1] = '1';
	thissubject[2] = ':';
	thissubject[3] = 0;
	strcpy(thissubject + 3, fidostyle_subject());
	thissubject[71] = 0;

	make_msgheader(echoname);

	if (*FIDONETBUF) {
		bufsize = strlen(FIDONETBUF);
		if (bottoms == 0) {
			write(pkthandle, FIDONETBUF, bufsize);
			if (!multipleheaders)
				*FIDONETBUF = 0;
			//limits these headers to the first message
		}
		sizeleft -= bufsize;
		if (sizeleft < 1000)
			sizeleft = 1000;	/* break the limits rules */
	}
	p = startusenet;
	while (*p) {		/* as long as there is still data left.. */



		/*
		 * if we're full, but close to the end of the message, then
		 * just go ahead and finish it without splitting
		 */
		if ((!sizeleft) && (strlen(p) < 200))
			sizeleft = 200;



		/* if there is no room left in this message, split it up */

		if (!sizeleft) {
			splitflag = 0;
			while (splitflag < 160) {
				splitbuffer[splitflag++] = ch = *p++;
				if ((ch == '\n') || (ch == '\r'))
					break;
				if ((splitflag > 80) && (ch == ' '))
					break;
			}
			write(pkthandle, splitbuffer, splitflag);
			if (*FIDONETBUF)
				if (bottoms) {
					write(pkthandle, FIDONETBUF, bufsize);
					if (!multipleheaders)
						*FIDONETBUF = 0;
					//limits these headers to the first message
				}
			end_message(*echoname);	/* close that message out now */
			make_msgheader(echoname);	/* new message header */
			sizeleft = split;	/* reset size counter */
			if (*FIDONETBUF) {	/* if every msg */
				bufsize = strlen(FIDONETBUF);
				if (bottoms == 0) {
					write(pkthandle, FIDONETBUF, bufsize);
					if (!multipleheaders)
						*FIDONETBUF = 0;
					//limits these headers to the first message

				}
				sizeleft -= bufsize;
				if (sizeleft < 1000)
					sizeleft = 1000;	/* break the limits
								 * rules */
			}	/* end of *fidonetbuf checking */
		}		/* end of message splitting */
		sizeofbuf = strlenusenet(p);	/* we are referencing the
						 * USENETBUF for size */
		if (sizeofbuf > sizeleft)
			sizeofbuf = sizeleft;	/* we need to break things
						 * up.. */

		write(pkthandle, p, sizeofbuf);
		sizeleft -= sizeofbuf;	/* lower our buffer limits */
		p += sizeofbuf;	/* if there is anything left it will loop */
	}			/* end of while *p */



	/* okay, we got the message */

	if (strlenusenet(USENETBUF) >= usenetsize) {
		p = "\r\n\r\n---> This message was terribly long, and had to be cut short by the\r\n"
			"---> gateway.  Please, ask the sender to repost, but in smaller segments.\r\n\r\n";
		write(pkthandle, p, strlen(p));
		printfh(pkthandle, "The maximum message size from internet->fidonet is currently %lu characters.\n\n", usenetsize);
	}
	/* endmessagenow: */
	if (*FIDONETBUF)
		if (bottoms) {
			write(pkthandle, FIDONETBUF, bufsize);
			if (!multipleheaders)
				*FIDONETBUF = 0;
			//limits these headers to the first message
		}
	end_message(*echoname);
}
