#include "main.h"



FILE           *fcfg, *fmap, *fkeep, *fkill, *fhide, *fallow, *fsite, *fuser, *fblockaddr, *ffastreturn;

int             keeptemp = 0;

void            badbadbad(char *s);

FILE           *
barfopen(char *i1, char *i2)
{
	FILE           *temp;
	/* errormsgstring("i1=%s  i2=%s",i1,i2); */
	temp = fopen(i1, i2);
	return temp;
}


FILE           *
make(char *s)
{
	FILE           *file;
	char            buf[256];
	char            buf2[256];
	char           *p;

	buf[0] = 0;
	if ((p = getenv("TEMP")) != NULL)
		strcpy(buf, p);
	else if ((p = getenv("TMP")) != NULL)
		strcpy(buf, p);
	if (buf[0])
		if (buf[strlen(buf) - 1] != '\\')
			strcat(buf, "\\");
	strcat(buf, s);
	cprintf("buffer name %s\r\n", buf);
	strcpy(buf2, "wt+");
	file = barfopen(buf, buf2);
	if (!file) {
		sprintf(buf2, "Could not create %s", buf);
		badbadbad(buf2);
		exit(255);
	}
	fprintf(file, "\n");
	return file;
}

void
killtemp(char *s)
{
	char            buf[256];
	char           *p;

	if (keeptemp)
		return;
	buf[0] = 0;
	if ((p = getenv("TEMP")) != NULL)
		strcpy(buf, p);
	else if ((p = getenv("TMP")) != NULL)
		strcpy(buf, p);
	if (buf[0])
		if (buf[strlen(buf) - 1] != '\\')
			strcat(buf, "\\");
	strcat(buf, s);

	unlink(buf);
}

void
startparse(void)
{
	fcfg = make("$cfg.tmp");
	fmap = make("$map.tmp");
	fkeep = make("$keep.tmp");
	fkill = make("$kill.tmp");
	fhide = make("$hide.tmp");
	fallow = make("$allow.tmp");
	fsite = make("$site.tmp");
	fuser = make("$user.tmp");
	fblockaddr = make("$blockad.tmp");
	ffastreturn = make("$fastrtn.tmp");
}
void
stopparse(void)
{
	fclose(fcfg);
	fclose(fmap);
	fclose(fkeep);
	fclose(fkill);
	fclose(fhide);
	fclose(fallow);
	fclose(fsite);
	fclose(fuser);
	fclose(fblockaddr);
	fclose(ffastreturn);
	killtemp("$cfg.tmp");
	killtemp("$map.tmp");
	killtemp("$keep.tmp");
	killtemp("$kill.tmp");
	killtemp("$hide.tmp");
	killtemp("$allow.tmp");
	killtemp("$site.tmp");
	killtemp("$user.tmp");
	killtemp("$blockad.tmp");
	killtemp("$fastrtn.tmp");
}

char           *
getconfigsection(FILE * file)
{
	int             size;
	char           *ptr;

	fseek(file, 0, SEEK_SET);
	size = 1500 + filelength(fileno(file));
	//allow 1000 expansion space
		ptr = (char *) calloc(size, 1);
	if (ptr)
		fread(ptr, filelength(fileno(file)), 1, file);
	return ptr;
}



void
shorten(char *source)
{
	register char  *p;
	register char  *q;
	register int    upcase;
	char           *endofsource;

	char            lastch = ' ';

	endofsource = source + strlen(source);

	while ((p = strstr(source, "//")) != NULL)
		*p = ';';
	//makes // into;
	p = q = source;
	upcase = 1;
	/* p = source,  q = dest; */
rewhile:
	while (*p) {
trycaseagain:
		switch (*p) {
		case '\r':
			p++;
			goto rewhile;
		case ';':
			while ((*p) && (*p != '\n'))
				p++;
			goto rewhile;
		case 9:
			*p = ' ';
			goto trycaseagain;
		case ' ':
			if (lastch != ' ')
				if (lastch != '\n') {
					upcase = 0;
					break;
				}	/* allow it */
			p++;
			goto rewhile;	/* skip it */
		case '\n':
			upcase = 1;
			if (lastch == '\n') {
				p++;
				goto rewhile;
			}	/* skip it */
			while ((q != source) && (*(q - 1) == ' '))
				q--;	/* truncate trailing space */

		}
		if (upcase) {
			if (strchr("+-=<>@!", *source))
				upcase = 0;	/* turn off uppercase if
						 * first character is mapping
						 * related..) */
			lastch = *q++ = (char) toupper(*p++);
		} else
			lastch = *q++ = *p++;
	}
	*q = 0;			/* shorten it! */
	while (q < endofsource)
		*q++ = 0;
}

void
makefidoechos(char *filename, char *prepend)
{
	FILE           *file;
	char            buf[1024];
	char            buf2[1024];
	char           *p;
	p = strchr(filename, '\n');
	if (p)
		*p = 0;
	file = fopen(filename, "rt");
	if (!file) {
		strcpy(buf2, strerror(errno));
		errormsgstring("Could not open for read %s", filename);
		errormsgstring("According to strerror (debug info) : %s", buf2);
		need_cleanup = 0;
		exit(255);
	}
	cprintf("%s\r\n", filename);
	while (!feof(file)) {
		buf[0] = 0;
		fgets(buf, sizeof(buf), file);
		if (!buf[0])
			goto quit;
		shorten(buf);
		if (buf[0] == 10)
			continue;
		if (!buf[0])
			continue;
		//next line in config, please !
			p = strtok(buf, " \x09\n");
		if (!p)
			continue;
		if (!p[0])
			continue;

		strcpy(buf2, prepend);
		if (buf2[0])
			if (buf2[strlen(buf2) - 1] != '.')
				strcat(buf2, ".");
		strcat(buf2, p);
		strlwr(buf2);
		strupr(p);
		fprintf(fmap, "= %s %s\n", buf2, p);
	}
quit:
	fclose(file);
}

int
testkeyword(char *line, char *keyword)
{
	char            buf[256];
	strcpy(buf, keyword);
	strcat(buf, " ");
	if (strnicmp(buf, line, strlen(buf)) == NULL)
		return 1;
	strcpy(buf, keyword);
	strcat(buf, "_");
	if (strnicmp(buf, line, strlen(buf)) == NULL)
		return 1;
	return 0;
}

void            sleep(unsigned seconds);

void
parseconfigs(char *filename)
{
	FILE           *file;
	char            buf[1024];
	char           *p, *q;
	char           *bp2;
	p = strchr(filename, '\n');
	if (p)
		*p = 0;
	file = fopen(filename, "rt");
	if (!file) {
		strcpy(buf, strerror(errno));
		errormsgstring("Could not open for read %s", filename);
		errormsgstring("Error reported: %s", buf);
		sleep(1);
		need_cleanup = 0;
		exit(255);
	}
	cprintf("%s\r\n", filename);
	while (!feof(file)) {
		buf[0] = 0;
		fgets(buf, sizeof(buf), file);
		if (!buf[0])
			goto quit;
		shorten(buf);
		if (buf[0] == 10)
			continue;
		if (!buf[0])
			continue;
		//next line in config, please !

#ifdef __OS2__
			if (strnicmp(buf, "DOS ", 4) == NULL)
			continue;
		if (strnicmp(buf, "OS2 ", 4) == NULL) {
			buf[0] = 32;
			buf[1] = 32;
			buf[2] = 32;
			buf[3] = 32;
			shorten(buf);
		}
		if (strnicmp(buf, "OS/2 ", 5) == NULL) {
			buf[0] = 32;
			buf[1] = 32;
			buf[2] = 32;
			buf[3] = 32;
			buf[4] = 32;
			shorten(buf);
		}
#else
			if (strnicmp(buf, "OS2 ", 4) == NULL)
			continue;
		if (strnicmp(buf, "DOS ", 4) == NULL) {
			buf[0] = 32;
			buf[1] = 32;
			buf[2] = 32;
			buf[3] = 32;
			shorten(buf);
		}
		if (strnicmp(buf, "OS/2 ", 5) == NULL)
			continue;
#endif

		if (!strchr(buf, '\n'))
			strncat(buf, "\n", 1);

		if (strnicmp(buf, "KEEPTEMP", 8) == NULL)
			keeptemp = 1;

		if (testkeyword(buf, "APPEND"))
			parseconfigs(buf + 7);
		else if (testkeyword(buf, "INCLUDE"))
			parseconfigs(buf + 8);
		else if (testkeyword(buf, "FIDOECHOS")) {
			p = strtok(buf, " \x09\n");
			p = strtok(NULL, " \x09\n");
			q = strtok(NULL, " \x09\n");
			if ((p) && (*p) && (q) && (*q))
				makefidoechos(p, q);
		} else if (testkeyword(buf, "BLOCKADDR"))
			fprintf(fblockaddr, "%s", buf + 10);
		else if (testkeyword(buf, "BLOCKADDRESS"))
			fprintf(fblockaddr, "%s", buf + 13);
		else if (testkeyword(buf, "FASTRETURN"))
			fprintf(ffastreturn, "%s", buf + 11);
		else if ((testkeyword(buf, "KEEP")) & (stristr(buf, "THREAD") == NULL))
			fprintf(fkeep, "%s", buf + 5);
		else if (testkeyword(buf, "KILL"))
			fprintf(fkill, "%s", buf + 5);
		else if (testkeyword(buf, "HIDE"))
			fprintf(fhide, "%s", buf + 5);
		else if (testkeyword(buf, "ALLOW"))
			fprintf(fallow, "%s", buf + 6);
		else if (testkeyword(buf, "SITE"))
			fprintf(fsite, "%s", buf + 5);
		else if (testkeyword(buf, "USER"))
			fprintf(fuser, "%s", buf + 5);
                else if (testkeyword(buf, "MAP"))
                    {
			if (strchr("+-=!@<>", buf[4]))
					fprintf(fmap, "%s", buf + 4);
			else
                            parseconfigs(buf + 4);

                    }
		else if (
			 (buf[0] == '+') ||
			 (buf[0] == '-') ||
			 (buf[0] == '>') ||
			 (buf[0] == '<') ||
			 (buf[0] == '=') ||
			 (buf[0] == '@') ||
			 (buf[0] == '!')) {
			bp2 = &buf[1];
			if (bp2[0] == 32)
				bp2++;
			fprintf(fmap, "%c %s", buf[0], bp2);
		} else
			fprintf(fcfg, "%s", buf);
	}
quit:
	fclose(file);
}

void
readconfigfiles(char *filename)
{
	startparse();
	parseconfigs(filename);
	config = getconfigsection(fcfg);
	sitestart = getconfigsection(fsite);
	userstart = getconfigsection(fuser);
	keep_ = getconfigsection(fkeep);
	kill_ = getconfigsection(fkill);
	hide_ = getconfigsection(fhide);
	allow_ = getconfigsection(fallow);
	fastreturn_ = getconfigsection(ffastreturn);
	blockaddress_ = getconfigsection(fblockaddr);
	mapping = getconfigsection(fmap);
	stopparse();
}
