#include "main.h"


int             makemailhandle(char *towho, char *fromwho);
char           *idtime(long);
char            sendemailto[1024] = "";
extern int      emailheaderlog;
char           *emaddress(char *);
char           *who_from_line(char *);
unsigned long   pktsize = 45000;
extern int      logbounced;
extern int      logftpmail;

int             sendmode = 0;
int             sendmodethisfile = 0;

unsigned long   filesleft = 0;
unsigned long   filebytesleft = 0;
int             emtofidonet(char *);

long            thisfilesize;

int 
makeftpmail(char *archivename, int partnum, int parttotal)
{
	char            buf[12000];
	int             newshandle = 0;
	char           *q, *udate;
	newshandle = makemailhandle(sendemailto, "fileserv-error");
	q = buf;
	*q = 0;
	q += strlen(q);
	strcat(q, who_from_line(normalize("fileserv", "")));
	q += strlen(q);
	sprintf(q, "Date: %s\n", udate = currentunixdate());
	q += strlen(q);
	sprintf(q, "From: %s\n", normalize("fileserv", ""));
	q += strlen(q);
	if (partnum > 0) {
		q += strlen(q);
		sprintf(q, "Subject: %s part %u of %u\n", archivename, partnum, parttotal);
	} else if (partnum == 0) {
		q += strlen(q);
		sprintf(q, "Subject: Your fileserv request.\n");
	} else {
		q += strlen(q);
		sprintf(q, "Subject: %s encoded base64\n", archivename);
	}
	q += strlen(q);
sprintf(q,"Precedence: bulk\n");
q+=strlen(q);
	if (*archivename)
		if (partnum != -1)
			sprintf(q, "Archive-Name: %s/%u\n", archivename, partnum);
	q += strlen(q);
	sprintf(q, "Message-ID: <%s@%s.%s>\n", idtime(sequence++), mysite, domain);
	q += strlen(q);
	if (xmail) {
		sprintf(q, "X-Mail-Agent: %s\n", gigosig);
		q += strlen(q);
	}
	sprintf(q, "To: %s\n", sendemailto);
	q += strlen(q);

	if (partnum == -1) {
		sprintf(q, 
   "Mime-Version: 1.0\n"
   "Content-Type: MULTIPART/MIXED; BOUNDARY=\"boundary\"\n"
   );
		q += strlen(q);



	}
	*q = 0;
	strcat(q, "\n\n");
	makeascii(buf);
	write(newshandle, buf, strlen(buf));
	tousenet++;
	if (archivename)
		if (*archivename)
			if (emailheaderlog) {
				printfh(emailheaderlog, "\r\nDate: %s\r\n", udate);
				if (emtofidonet(sendemailto))
					printfh(emailheaderlog, "To  : %s (fidonet)\r\n", emaddress(sendemailto));
				else
					printfh(emailheaderlog, "To  : %s (internet)\r\n", emaddress(sendemailto));


				printfh(emailheaderlog, "From: %s (fidonet)\r\n", normalize("fileserv", ""));
				if (partnum)
					printfh(emailheaderlog, "Subj: %s part %u\r\n", archivename, partnum);
				else
					printfh(emailheaderlog, "Subj: Your fileserv request\r\n", archivename, partnum);
			}
	return newshandle;
}
int             emtofidonet(char *);

int 
checkforbinary(int handle, char *filename)
{
	char            buf[8192];
	int             bread = 1;
	int             index;
	errormsgstring("Checking file %s for binary characters", filename);
	lseek(handle, 0, SEEK_SET);
	bread = read(handle, buf, sizeof(buf));
	lseek(handle, 0, SEEK_SET);

	if (!bread)
		return 2;
	//empty ?

		for (index = 0; index < bread; index++) {
		if (
		    (!isprint(buf[index])) &&
		    (!isspace(buf[index])) &&
		    (buf[index] != 26)
			) {
			errormsgstring("It's BINARY, and will be UUENCODED..");
			return 2;	/* binary */
		}
	}
	/* ascii: */
	errormsgstring("It's ASCII, and will be sent as a message..");
	return 1;		/* ascii! */
}
int             ignorelimits = 0;
void            domime(FILE * fin, FILE * fout, char *filename);

void 
ftpmailmime(char *fullname, int mhandle)
{
	int             outh = 0;
	int             partnum = 1;
	unsigned long   outof;
	unsigned long   parttotal;
	char            line[2048];
	FILE           *infile;
	FILE           *outfile;
	char           *file;
	char           *p;

	long            size;
	file = fullname;
	while ((p = strpbrk(file, ":\\/ ")) != NULL)
		file = p + 1;

	infile = _fsopen(fullname, "rb", SH_DENYNO);
	if (!infile) {
errormsgstring("v--error: \"%s\"  for next line--v",strerror(errno));
  		errormsgstring("Could not open %s for mime fileserv!", fullname);
		printfh(mhandle, "Sorry, fileserv could not open your file at this time.\n");
		return;		/* bad! */
	};
	fseek(infile, 0, SEEK_END);
	//get length
		outof = ftell(infile);
	fseek(infile, 0, SEEK_SET);

	printfh(mhandle, "%s (%lu bytes)", file, outof);
	thisfilesize = outof;
	outh = makeftpmail(file, -1, 1);
	if (outh < 1) {
                errormsgstring("v--error: \"%s\"  for next line--v",strerror(errno));
		errormsgstring("Could not create mail packet for fileserv!");
		return;
	} else {
         errormsgstring("Handle for ftpmailmime::outh =  %i",outh);
        }
	outfile = fdopen(outh, "wb");
	clrscr();
	cprintf("Processing fileserv request\r\n");
	cprintf("%s\r\n", sendemailto);
	cprintf("%s mime\r\n", file);
        fprintf(outfile,"File name: %s\n",file);
	fprintf(outfile, "File size: %lu\n\n", outof);
fprintf(outfile,"\n"
"  This message is in MIME format.  The first part should be readable text,\n"
"  while the remaining parts are likely unreadable without MIME-aware tools.\n"
"  Send mail to mime@docserver.cac.washington.edu for more info.\n\n");

	domime(infile, outfile, file);
        fprintf(outfile,"--boundary--\n\n");
	fprintf(outfile, "\nThank you for using GIGO's FILESERV file-by-mail server! :-)\n");
	fclose(outfile);
	fclose(infile);
}

void 
ftpmailascii(char *fullname, int mhandle)
{
	int             outh = 0;
	int             partnum = 1;
	unsigned long   outof;
	unsigned long   parttotal;
	char            line[2048];
	FILE           *infile;
	FILE           *outfile;
	char           *file;
	char           *p;

	long            size;
	file = fullname;
	while ((p = strpbrk(file, ":\\/ ")) != NULL)
		file = p + 1;

	infile = _fsopen(fullname, "rt", SH_DENYNO);
	if (!infile) {
errormsgstring("v--error: \"%s\"  for next line--v",strerror(errno));
		errormsgstring("Could not open %s for ascii fileserv!", fullname);
		printfh(mhandle, "Sorry, fileserv could not open your file at this time.\n");
		return;		/* bad! */
	} else {
         errormsgstring("Handle for ftpmailascii::infile =  %i",infile);

 }
	fseek(infile, 0, SEEK_END);
	//get length
		outof = ftell(infile);
	fseek(infile, 0, SEEK_SET);

	parttotal = (outof / pktsize) + 1;
	printfh(mhandle, "%s (%lu bytes, estimated %lu parts)\n", file, outof, parttotal);

reloop:
	outh = makeftpmail(file, partnum, parttotal);
	if (outh < 1) {
errormsgstring("v--error: \"%s\"  for next line--v",strerror(errno));
		errormsgstring("Could not create mail packet for fileserv!");
		return;
	}
         errormsgstring("Handle for ftpmailascii::outh =  %i",outh);
	outfile = fdopen(outh, "wb");
	clrscr();
	cprintf("Processing fileserv request\r\n");
	cprintf("%s\r\n", sendemailto);
	cprintf("%s part %u/%u\r\n", file, partnum, parttotal);

	if (partnum == 1) {
		fprintf(outfile, "Total file size: %lu\n", outof);
		if (outof > pktsize) {
			fprintf(outfile, "Total number of parts (estimated): %lu\n", outof);
			fprintf(outfile, "Size per part (approx, will vary): %lu\n\n", pktsize);
		}
	}
	fprintf(outfile, "section %u of ascii_xfer of file %s\n--- cut here ---\n", partnum, file);
	partnum++;

	size = pktsize;
	for (;;) {
		if (feof(infile))
			break;
		line[0] = 0;
		fgets(line, sizeof(line), infile);
		if (!line[0])
			break;
		makeascii(line);
		fwrite(line, 1, strlen(line), outfile);
		size -= strlen(line);
		if (size <= 1)
			break;
	}

	fprintf(outfile, "\n--- cut here ---\n");

	if (feof(infile)) {
		fprintf(outfile, "\nThank you for using GIGO's FILESERV file-by-mail server! :-)\n");
		fclose(outfile);
		fclose(infile);
		return;
	}
	if ((logtraffic) && (outfile)) {
		printfh(logtraffic,
			"eo:%lu/1 %s %s %s %s\r\n",
			filelength(fileno(outfile)),
			normalize("fileserv", ""),
			sendemailto,
			gateway,
			"fileserv");
	}
	fclose(outfile);
	goto reloop;
}



void 
ftpmailfile(char *fullname, int mhandle)
{
	int             inh = 0;
	int             outh = 0;
	int             partnum = 1;
	unsigned long   outof;
	unsigned long   parttotal;
	char           *file;
	char           *p;
	unsigned long   temp;
char simplename[1024];
strcpy(simplename,fullname); file=simplename;
p=simplename;
        while ((p[0]) && (strpbrk(p+strlen(p)-1,":\\/ ")))
          p[strlen(p)-1] = 0;
	while ((p = strpbrk(file, ":\\/ ")) != NULL)
		file = p + 1;

	inh = sopen(fullname, O_BINARY | O_RDONLY, SH_DENYNO, S_IREAD);
	if (inh < 1) {
errormsgstring("v--error: \"%s\"  for next line--v",strerror(errno));
		errormsgstring("Could not open %s for fileserv!", fullname);
		printfh(mhandle, "Sorry, fileserv could not open your file at this time.\n");
		return;		/* bad! */
	} else
		errormsgstring("Opened %s as handle %i", fullname, inh);
	outof = filelength(inh);
	/* update filesleft and filebytesleft */
	if (!ignorelimits) {
		if (outof > filebytesleft) {
			printfh(mhandle, "Sorry, \"%s\" is too large for this request.\r\n", file);
			close(inh);
			return;
		}
		if (!filesleft) {
			printfh(outh, "Sorry, \"%s\" was not sent - already sent too many files.\r\n", file);
			close(inh);
			return;
		}
		filesleft--;
		filebytesleft -= outof;
	}
	sendmodethisfile = sendmode;
	if (!sendmode) {
		sendmodethisfile = checkforbinary(inh, fullname);
		lseek(inh, 0, SEEK_SET);
	}
	if (sendmodethisfile == 1) {	/* ascii */
		close(inh);
		ftpmailascii(fullname, mhandle);
		return;
	}
	if (sendmodethisfile == 3) {	/* mime */
		close(inh);
		ftpmailmime(fullname, mhandle);
		return;
	}
	printfh(mhandle, "%s (%lu bytes,", file, outof);
	outof /= pktsize;
	outof++;
	printfh(mhandle, " estimated %lu parts)\n", outof);
	parttotal = outof;



reloop:
	if (outh) {
    errormsgstring("ftpmailbinary closing outh=%i",outh);
		close(outh);	/* start again */
}
	outh = makeftpmail(file, partnum, parttotal);
	if (outh < 1) {
errormsgstring("v--error: \"%s\"  for next line--v",strerror(errno));
		errormsgstring("Could not create mail packet for fileserv!");
		return;
	}
         errormsgstring("New Handle for ftpmailbinary::outh =  %i",outh);
	outof = filelength(inh);
	outof /= pktsize;
	outof++;

	clrscr();
	cprintf("Processing fileserv request\r\n");
	cprintf("%s\r\n", sendemailto);
	cprintf("%s part %u/%u\r\n", file, partnum, outof);

	if (partnum == 1) {
		printfh(outh, "Total file size: %lu\n", filelength(inh));
		if (filelength(inh) > pktsize) {
			printfh(outh, "Total number of parts expected: %lu\n", outof);
			printfh(outh, "Binary size per part: %lu\n\n", pktsize);
			temp = pktsize;
			temp *= 4;
			temp /= 3;
			printfh(outh, "Uuencoded size per part: %lu\n\n", temp);
		}
	}
	printfh(outh, "section %u of uuencode of file %s\n", partnum, file);
	if (partnum == 1)
		printfh(outh, "begin 644 %s\n", file);
	partnum++;
	blockencode(inh, outh, pktsize);

	if ((logtraffic) && (outh)) {
		printfh(logtraffic,
			"eo:%lu/1 %s %s %s %s\r\n",
			filelength(outh),
			normalize("fileserv", ""),
			sendemailto,
			gateway,
			"fileserv");
	}
	if (eof(inh)) {
		printfh(outh, "end\n\nThank you for using GIGO's FILESERV file-by-mail server! :-)\n");
errormsgstring("closing outh %i",outh);
		close(outh);
errormsgstring("closing inh %i",inh);
		close(inh);
		return;
	}
	printfh(outh, "\n--- cut here ---\n");
	goto reloop;
}

char           *getline_lf(int handle);


void 
ftpmailget(char *filename, int mhandle)
{
	char            line[512];
	char            buf[512];
	char           *p,*p2;
	FILE           *truncwith;
	int             okfiles = 0;
	DIR            *dirp;
	struct dirent  *direntp;
	int             wildcards;
	int             checkpoint;
	int             killafter = 0;

	pktsize /= 45;
	pktsize *= 45;

	if (strnicmp(filename, "SIZE:", 5) == NULL) {
		pktsize = atol(filename + 5);
		pktsize /= 45;
		pktsize *= 45;
		if (pktsize < 1500)
			pktsize = 1500;
		printfh(mhandle, "Size per section set to %lu before encoding.\n", pktsize);
		return;
	}
	if (stricmp(filename, "ASC") == NULL) {
		sendmode = 1;
		printfh(mhandle, "ASCII mode forced for following files.\n");
		return;
	}
	if (stricmp(filename, "BIN") == NULL) {
		sendmode = 2;
		printfh(mhandle, "BINARY mode forced for following files.\n");
		return;
	}
	if (stricmp(filename, "MIM") == NULL) {
		sendmode = 3;
		printfh(mhandle, "MIME base64 mode forced for following files.\n");
		return;
	}
	if (stricmp(filename, "MIME") == NULL) {
		sendmode = 3;
		printfh(mhandle, "MIME base64 mode forced for following files.\n");
		return;
	}
	if (stricmp(filename, "DET") == NULL) {
		sendmode = 0;
		printfh(mhandle, "ASCII/BINARY mode will be autodetected for following files.\n");
		return;
	}
	if (strchr(filename, '\\')) {
		ignorelimits = 1;
		//queued by admin, don 't hold to limits
			killafter = 0;
		if ((*filename == '#')) {
			killafter = 1;
			filename++;
		}
		if ((*filename == '^')) {
			killafter = 2;
			filename++;
		}
		printfh(mhandle, "Absolute file name specified by host: %s\n", filename);
		ftpmailfile(filename, mhandle);
		if (killafter == 1) {
			errormsgstring("Truncating %s after sending via ftpmail\n", filename);
			truncwith = fopen(filename, "wt");
			if (truncwith)
				fclose(truncwith);
			killafter = 0;
		}
		if (killafter == 2) {
			errormsgstring("Deleting %s after sending via ftpmail\n", filename);
			unlink(filename);
		}
		return;
	}
	printfh(mhandle, "Searching for %s\n", filename);
	errormsgstring("Searching for %s", filename);
	p = configstr("FILESERV-LIST");
	if (!*p)
		p = configstr("OKFILES");
	if (!*p) {
		errormsgstring("FILESERV-LIST not defined, not allowing request");
		goto deny;
	}
	okfiles = sopen(p, O_BINARY | O_RDONLY, SH_DENYWR, S_IREAD);
	if (okfiles < 1) {
errormsgstring("v--error: \"%s\"  for next line--v",strerror(errno));
		errormsgstring("Could not open %s, fileserv request denied", p);
		goto deny;
	}
        errormsgstring("ftpmailget: okfiles=%i",okfiles);
	wildcards = (strpbrk(filename, "?*")) ? 1 : 0;
	strcpy(buf, configstr("FILESERV-HOLD"));
	if (buf[0]) {
		p = buf;
		goto gotline;
	}
loop:
	if (eof(okfiles)) {
		printfh(mhandle, "Done searching for %s\n", filename);
		close(okfiles);
		goto deny;
	}
	p = getline_lf(okfiles);
gotline:
	if (!*p)
		goto loop;
	strcpy(line, p);
	p = strtok(line, " ");
        p2 = strtok(NULL," ");
	if ((stricmp(p, filename) == 0) ||
	    ((*p == '@') && (stricmp(p + 1, filename) == 0))) {
		p = p2;
		if (!p)
			goto loop;	/* skip it */
		printfh(mhandle, "Magic Name!  ");
		errormsgstring("Magic Name! Real name: %s", p);
		ftpmailfile(p, mhandle);
		goto loop;
		/* magic? go ahead and reloop */
	}
	if (*p == '@')
		goto loop;	/* magic names not matching ours are ignored */
        if (p2) goto loop; /* also a hint that it's magic */
	strcpy(buf, line);
	if (strpbrk(buf, "*?") == NULL) {	/* if there are no wildcards
						 * ... */
		if (buf[strlen(buf) - 1] != '\\')	/* if the last character
							 * is not a slash .. */
			strcat(buf, "\\");	/* add one. */
		strcat(buf, "*.*");	/* now add the wildcards. */
	}
	dirp = opendir(buf);
	if (!dirp) {
errormsgstring("v--error: \"%s\"  for next line--v",strerror(errno));
		errormsgstring("Error checking %s for %s", buf, filename);
		goto loop;
	}
	for (;;) {
		direntp = readdir(dirp);
		if (direntp == NULL) {
			closedir(dirp);
			break;
		}
		strupr(direntp->d_name);
		if (direntp->d_name[0] != '.')
			if (match(filename, direntp->d_name)) {
				strcpy(buf, line);
				if (strpbrk(buf, "*?") == NULL) {	/* if there are no
									 * wildcards ... */
					if (buf[strlen(buf) - 1] != '\\')	/* if the last character
										 * is not a slash .. */
						strcat(buf, "\\");	/* add one. */
					strcat(buf, "*.*");	/* now add the
								 * wildcards. */
				}
				p = strrchr(buf, '\\');
				if (p)
					(*(++p)) = 0;
				strcat(buf, direntp->d_name);
				errormsgstring("Found %s (%lu bytes)", buf, direntp->d_size);
				ftpmailfile(buf, mhandle);
				if (!wildcards)
					//we are only going to show one instance..
				{
					closedir(dirp);
					//close the directory pointer
						close(okfiles);
					//close the okfiles file
						return;
				}
			}
	}
	goto loop;

deny:
	return;

}

void 
process_req(char *dir, char *name)
{
	int             inh;
	char           *p;
	char            nbuf[1024];
	char            line[1024];
	int             mhandle;
	sprintf(nbuf, "%s%s", dir, name);
	inh = sopen(nbuf, O_BINARY | O_RDONLY, SH_DENYWR, S_IREAD);
	if (inh < 1) {
errormsgstring("v--error: \"%s\"  for next line--v",strerror(errno));
		errormsgstring("Could not open %s", nbuf);
		return;
	}
errormsgstring("process_req: inh = %inh",inh);
	pktsize = ftpmaildefault;
	errormsgstring("Opened %s as handle %i", nbuf, inh);
	strcpy(sendemailto, getline_lf(inh));
	ccfile[0] = 0;
	if ((strnicmp(sendemailto, "CCLIST ", 7) == NULL)
	    || (strnicmp(sendemailto, "CCFILE ", 7) == NULL)) {
		p = strtok(sendemailto, " ");
		p = strtok(NULL, "\n");
		if (p) {
			if (stricmp(sendemailto, "CCFILE") == NULL)
				sprintf(ccfile, "%s", p);
			else
				strcpy(ccfile, p);
			strcpy(sendemailto, "Multiple Recipients");
		} else
			sprintf(sendemailto, "NULL@", mysite);
	} else if (emtofidonet(sendemailto))
		pktsize = 9990;	/* change the default to 10k for fidonet
				 * systems */
	newwindow(ti_umsg);
	clrscr();
	cprintf("FILESERV request from %s\r\n", sendemailto);
	printfh(logftpmail, "\r\nrequest from %s\r\n", sendemailto);

	mhandle = makeftpmail("", 0, 0);
	if (mhandle < 1) {
errormsgstring("v--error: \"%s\"  for next line--v",strerror(errno));
		errormsgstring("Could not create outgoing email");
		close(inh);
		return;
	}
	errormsgstring("process_req Opened mhandle %i", mhandle);

loop:
	if (eof(inh))
		goto quit;
	strcpy(line, getline_lf(inh));
	if (*line == 0)
		goto loop;
	if (*line == ';') {
		printfh(mhandle, "%s\n", line + 1);
		goto loop;
	}
	strupr(line);
	printfh(logftpmail, "%s\r\n", line);
	ftpmailget(line, mhandle);
	goto loop;
quit:
	close(inh);
	printfh(mhandle,"\n\nAny file(s) found, will be sent as seperate messages.\n");
	close(mhandle);
	unlink(nbuf);
	return;
}

void 
find_req(void)
{
	DIR            *dirp;
	struct dirent  *direntp;
	char            dirname[256];
	char            searchname[256];
	newwindow(ti_action);
	cprintf("Scanning REQs\r\n");
	strcpy(dirname, configstr("SPOOL"));
	if (dirname[strlen(dirname) - 1] != '\\')
		strcat(dirname, "\\");
	strcat(dirname, configstr("MYFEED"));
	strcat(dirname, "\\");
	sprintf(searchname, "%s*.req", dirname);
	errormsgstring("Scanning for %s", searchname);
	dirp = opendir(searchname);
	if (!dirp)
		return;
	for (;;) {
		promptquit();
		if (quitearly)
			return;
		direntp = readdir(dirp);
		if ((!direntp) || (quitearly)) {
			closedir(dirp);
			return;
		}
		sendmode = 0;	/* autodetect */
		filesleft = atol(configstr("FILESERV-MAXFILES"));
		if (!configline("FILESERV-MAXFILES"))
			filesleft = -1L;

		filebytesleft = atol(configstr("FILESERV-MAXBYTES"));
		if (!configline("FILESERV-MAXBYTES"))
			filebytesleft = -1L;

		errormsgstring("Found %s", direntp->d_name);
		process_req(dirname, direntp->d_name);
	}
}
