#include "main.h"

FILE *globalphrasefile=NULL;

void phraseopen(void)
{
  char *name;
  name=configstr("MESSAGES");
  if (name && *name)
    globalphrasefile=fopen(name,"rt");
  if (globalphrasefile) {errormsgstring("Opened message file %s",name);return;}
  if (!globalphrasefile)
    globalphrasefile=fopen("GATEWAY.MSG","rt");
    if (globalphrasefile) errormsgstring("Opened message file GATEWAY.MSG");
}
void phraseclose(void)
{
   if (globalphrasefile) fclose(globalphrasefile);
   globalphrasefile=NULL;
}
void badbadbad(char *buf);
void verifyexistance(char *tag)
{
   char buf[256];
  findphrase(tag);
  if (phrasefile) return;
  sprintf(buf,"Could not locate #%s# in gateway message file.",tag);
  badbadbad(buf);
}

void findphrase(char *tag)
{
   char buf[1024];
   int len;

  phrasefile=globalphrasefile;
  if (!phrasefile)
   {
     strcpy(phrasebuf,"*Missing GATEWAY.MSG file: message unavailable.\n");
     return;
   }
  fseek(globalphrasefile,0,SEEK_SET);
  sprintf(buf,"#%s#",tag);
  len=strlen(buf);

  while (!feof(phrasefile))
  {
     phrasebuf[0]=0;
     fgets(phrasebuf,sizeof(phrasebuf),phrasefile);
     if (strnicmp(buf,phrasebuf,len)==0)
       return; /* we found the line to read from */
  }
  phrasefile=NULL;
  sprintf(phrasebuf,"*Missing message from gateway message resource.\n",buf);
  return;
}

void findblock(char *block,char *account)
{
   char buf[1024];
   char acc[1024];

   int len;
   char *p,*next;

   strcpy(acc,account);
   strlwr(acc);
  phrasebuf[0]=0;

  phrasefile=globalphrasefile;
  if (!phrasefile) return;
  fseek(globalphrasefile,0,SEEK_SET);

  sprintf(buf,block);
  len=strlen(buf);
  while (!feof(phrasefile))
  {
     fgets(phrasebuf,sizeof(phrasebuf),phrasefile);
     if (strnicmp(buf,phrasebuf,len)==0)
       {
         p=next=phrasebuf+len;
         while (next) {
           p=strtok(next,"# ,\x09\x0a\x0d");
           next=strtok(NULL,"\r");
           if (p) {strlwr(p);
           if (match(p,acc))
             return; // found it!
           }
         }

       }
  }
  phrasefile=NULL;
  phrasebuf[0]=0;
  return;
}

void findsignature(char *account) {phrasefile=NULL;phrasebuf[0]=0;if (signatures) findblock("#signature#",account);}
char *readphrase(void)
{
  if (!phrasefile)
    {
      return phrasebuf;
    }
  phrasebuf[0]=0;
  if (feof(phrasefile))
    {
endphrase:
     phrasefile=NULL;
     return phrasebuf;
     }
  fgets(phrasebuf,sizeof(phrasebuf),phrasefile);
  if (phrasebuf[0]=='#') {phrasebuf[0]=0;goto endphrase;}
  return phrasebuf;
}

char *whonameonly(char *p)
{
  static char buf[256];
  strcpy(buf,p);
  p=strrchr(buf,' ');
  if (p==NULL) return buf;
  *p=0;
  return buf;
}

char *parsephrase(void)
{
  char *buf;
  char buf2[2048];
  char *p,*q;
  buf=readphrase();
  if (!*buf) return buf;
  if (!buf)  return buf;
  memset(buf2,0,sizeof(buf2));
  p=buf;
  q=buf2;
  while (*p)
   {
     if (*p=='*')
       {
          p++;
          if (strnicmp(p,"sentto",6)==0) {
              strcpy(q,phraseparm.sentto);p+=6;
            } else
          if (strnicmp(p,"whoto",5)==0) {
              strcpy(q,phraseparm.sentto);p+=5;
            } else

          if (strnicmp(p,"returnto",8)==0) {
              strcpy(q,phraseparm.returnto);p+=8;
            } else

          if (strnicmp(p,"whofrom",7)==0) {
              strcpy(q,phraseparm.whofrom);p+=7;
            } else
          if (strnicmp(p,"who.name",8)==0) {
              strcpy(q,cleanname(whonameonly(phraseparm.whofrom)));p+=8;
            } else
          if (strnicmp(p,"whoname",7)==0) {
              strcpy(q,whonameonly(phraseparm.whofrom));p+=7;
            } else

          if (strnicmp(p,"forwardto",9)==0) {
              strcpy(q,phraseparm.forwardto);p+=9;
            } else

          if (strnicmp(p,"gateadr",7)==0) {
              strcpy(q,gateway);p+=7;
            } else
          if (strnicmp(p,"gateway",7)==0) {
              strcpy(q,gateway);p+=7;
            } else

          if (strnicmp(p,"root",4)==0) {
                strcpy(q,normalize("root", ""));p+=4;
          } else 
          if (strnicmp(p,"*",1)==0) {
                strcpy(q,"*");p+=1;
          };

         q+=strlen(q);
       }
     else *q++=*p++;
   }

   return buf2;
}




