#include "main.h"
#include <ctype.h>
#include <io.h>
#include <time.h>



void copyfile(FILE *outfile,char *title,char *buffer,char *prefix)
{
  char buf[256];
  char *p,*position;
  char tab;
  int counter;
  fprintf(outfile,"\n---[%s  (%lu bytes)]-----------------\n",title,strlen(buffer));
  position=buffer;
  while(*position)
  {
    p=nextmemoryline(position);
    position+=__memline+1;
    if (*p==0) continue;
    if (*prefix)
      {
        if (strcmp(p,"_"))
          fprintf(outfile,"%s ",prefix);
        tab=0;counter=0;
        p=strtok(p," ");
        buf[0]=0;
        while(p)
         {
          counter++;
          while(strlen(buf)<tab)
            strcat(buf," ");
          strcat(buf," ");
          strcat(buf,p);
          if (counter<3) tab+=20;
          p=strtok(NULL," ");
         }
        fprintf(outfile,"%s\n",buf);
      }
     else
    if (strncmp(p,"PASSWORD ",9)==NULL)
      fprintf(outfile,"PASSWORD [censored]\n");
     else
       fprintf(outfile,"%s\n",p);
  }
}

void diagnostic(char *origtowho)
{
  FILE *file;
  char returnto[256]="";

  strcpy(returnto, token(USENETBUF, "From:"));
  if (!*returnto)
      strcpy(returnto, token(USENETBUF, "Sender:"));
  if (!*returnto)
      strcpy(returnto, responsibleparty);

  cprintf("Diagnostics Report request by %s",returnto);

  file=_fsopen("FUNCTION.REP","wt",SH_DENYWR);
  if (!file)
    {
      bounceuucp(origtowho,"diagnostics",0);
      return;
    }
  fprintf(file,"Diagnostics dump - GIGO "VERSION"\n\n");

  #ifdef __DOS__
  fprintf(file,"Memory avail now  32bit:  %lu\n",sim_upper_coreleft());
  fprintf(file,"Memory avail now  16bit:  %lu\n\n",sim_lower_coreleft());
  fprintf(file,"Memory avail start 32bit:  %lu\n",mem1);
  fprintf(file,"Memory avail start 16bit:  %lu\n",mem2);
  #endif

  fprintf(file,"sequence numbers: %lu\n"
               "                  %lu\n\n",sequence,dseq);
   if (registered())
     {
   fprintf(file,"Registered.\n");
     }
    else
    {
      if (registereduser)
       fprintf(file,"Huh?  _registereduser_=yes, registered()=no?\n");
      else
       fprintf(file,"Unregistered.\n");
    }

  copyfile(file,"General Config",config,"");
  copyfile(file,"Users",userstart,"USER");
  copyfile(file,"Sites",sitestart,"SITE");

  copyfile(file,"Keep",keep_,"KEEP");
  copyfile(file,"Kill",kill_,"KILL");
  copyfile(file,"Hide",hide_,"HIDE");
  copyfile(file,"Allow",allow_,"ALLOW");
  if (fastreturn_)
    copyfile(file,"FastReturn",fastreturn_,"FASTRETURN");
  copyfile(file,"Mapping",mapping,"");
  fclose(file);
  bounceuucp(origtowho,"INFO FUNCTION.REP",1);
  unlink("FUNCTION.REP");
}

