
;  ***  A GIGO Config File
;
;  Lines leading with a semi-colon are comments and will not be
;  processed by GIGO.

PASSWORD fribble
;
;  ***  Environment Parameters
;

;  Registration Information.  Once you have registered GIGO, fill in the
;  SERIALNUMBER and REGISTRATION fields.  These values are keyed to your
;  MYSITE entry, so please ensure you report your site correctly when you
;  register.

SERIALNUMBER        28
REGISTRATION        181k59m6i4kir1ibnhcc
IGNORE_CHARTER      pcjiowyiy2lh1hfmgek

;  TZ = Your timezone.  In most cases it will be EST5, CST6, MST7, PST8.
;  If you remove or leave out this field, the default is EST5

TZ EST5

;  GIGO will run faster if you enable direct video, but direct screen
;  writes can cause problems with some systems, or if you are using
;  Desqview.  If you use Desqview in 50 line text mode, or if you have
;  other incompatibility, you should specify "/BIOS" on the startup line.

;  GIGO, by default, does not require swapping to disk.  It normally leaves
;  the DOS portion of memory available for shelling.  However, if you find
;  that you need more memory to work with, and would like to make this memory
;  available to GIGO, you should simply make sure that SHROOM.COM is in the
;  gateway directory.  GIGO's loader will automaticly load SHROOM.COM up
;  before loading the dos extender up.

;  The following are if you wish to restrict GIGO by skipping
;  the RNEWS or RMAIL processes, or by not deleting the original file.
;
;  Alternately, you may use the following commands on the command line
;  when loading GIGO to specify the actions you *DO* want....  i.e.,
;  GATEWAY SACBBX.CFG /MAIL
;  Valid command line switches:  /MAIL /NEWS /FIDO

TEST         ; Do not delete files when done

;
;  ***  Directories
;

;  Where to place the log file.  There is no default.  Comment or remove
;  this line to skip making a log file.


;  GIGO is able to keep track of how each piece of news is processed.
;  LOGKEPT will log all newsgroups that were kept and what echo names they
;  were given.  LOGDUMPED logs which areas were dumped, i.e., because the
;  name of the area could not be found in your MAP file, they were not
;  added to your BBS.
:
;  If you do not need these options, turn them off - they _will_ slow
;  processing down!
log log

;LOGKEPT    d:\gateway\gigokeep.log
;LOGDUMPED   d:\gateway\gigodump.log
;LOGBOUNCED  d:\gateway\gigobncd.log
;LOGFTPMAIL  d:\gateway\gigoftp.log
;LOGEMAIL d:\email.log

;  The MAPPING file tells GIGO how to handle newsgroups.  The MAP command
;  tell GIGO where to find the mapping file.  The default is MAPPING.CFG in
;  GIGO's home directory.

MAP mapping.cfg



;  GIGO can send Fidonet echoes to usenet using usenet hierarchy names.
;
;  If an echo is being put back onto the Internet, but there is no explicit
;  mapping for it, GIGO will check to see if the name matches that of your
;  normal fidonet echos.
;
;  If it _does_ match, then GIGO will go ahead and export it to your host,
;  and prepend the following user-defined heiarchy name to it.  i.e.,
;  fidonet's FDECHO would become swizzle.fido.fdecho
;
;  Usage:  FIDOECHOS listname hierarchyname

;FIDOECHOS C:\FD\FE\FIDONET.NA swizzle.fido



;  COMPRESSION
;
;  Newsgroups are usually sent batched together and compressed.  These
;  files usually say "#! cunbatch" at the top, and it tells the receiving
;  end how to process them.
;
;  The following two parameters are the command lines needed for the
;  standard unix-world COMPRESS program.  This program is being included
;  in the GIGO extras.
;
;  Allow GIGO to handle compression of rnews files.  COMPRESS.EXE may be
;  replaced with GZIP.EXE if and only if your UUCP feed allows it on the
;  host system.  If commented out, GIGO will prepare mail to be sent
;  uncompressed.  This file must be in your GIGO directory or in the path.

;COMPRESS    COMPRESS.EXE

;  Allow GIGO to handle decompression of cunbatched files.  You may use
;  GZIP.EXE -d instead to allow decompression of both compressed and gzip'd
;  files (gzip autodetects the format being used).  This file must be in
;  your GIGO directory or in the path.

DECOMPRESS  COMPRESS.EXE -d
;DECOMPRESS  GZIP.EXE -d

;  FASTCOMPRESS tells GIGO that we are using a specially modified version
;  of the public domain COMPRESS program.  This modified version will
;  take care of adding or removing the "#! cunbatch" line on newsgroups
;  for us, saving the gateway a lot of time with messy tempory files.

FASTCOMPRESS

; If you are NOT using GIGO's compress program, which has been tailored
; for use with the gateway, you will need to run the following instead.
;COMPRESS compress.exe
;DECOMPRESS compress.exe -d
;;;;FASTCOMPRESS should not be used.



;
;  ***  Gateway Addressing
;
; The Gateway address is the address for GIGO to use when sending and
; receiving mail from & to Fidonet.  This may be a real address, listed
; in the Nodelist, a fake address, or a point address.

; Under _NO_circumstances_ should the gateway's address be the same as your
; address.  If you can not get a nodelist entry for it, then set it up
; as either a fake node, or as a point off of your system.  If you do not
; follow this precaution, you will find that the gateway will be attempting
; to process and bounce mail that was meant for you, instead of the gateway.

; Gateway address, and where to look for _uncompressed_ FTSC files.
; Also, what extension to look for.  Use * if unsure and GIGO will
; search all files in the directory you specify.
;
;   Valid suggestions:  GATEWAY 1:203/2 C:\OUTBOUND\ ?UT
;                       GATEWAY 1:203/2 C:\GECHO\PKTS\ PKT
;                       GATEWAY 1:203/2 C:\INBOUND\ *
;   Note, you may only specify this _once_.

GATEWAY 1:109/42 \files\  HUT

;  SENDTO and SEEN-BY control mail going into FidoNet. The address shows
;  what address the .PKT files should be addressed to (usually your
;  BBS's main Fidonet-style address).  The directory should be your
;  protected inbound directory.

SENDTO 1:109/2  \files\

;  Seen-by adds whatever 2-dimensional address(es) to the seen-by's.
;  Generally, this is going to be the net/node of the gateway.  Do NOT
;  (*repeat*) do NOT place zone or point information here, as it breaks
;  some mail processors!

SEEN-BY 109/42

;  Mail Address information about you and your feed.
;
;  EXAMPLES:
;
;  To get user.name@swizzle.com use:
;
;  MYSITE swizzle
;  DOMAIN com
;
;  To get user.name@swizzle.sacbbx.com use:
;
;  MYSITE swizzle
;  DOMAIN sacbbx.com

MYSITE blkcat                   ;your site uucp name (single name)
DOMAIN fidonet.org              ;Your site's address, minus the UUCP name
MYFEED uunet                    ;Your feed's UUCP machine name (for spooling)
                                ;(See MAPSTYLE for more information)

;MYPATH swizzle.com             ;If you want to override the site name used
                                ;in the Path: line, you may specify it here.
                                ;Leave alone unless you need it.

;CASE_INSENTIVE                 ; If your feed is remapping everything to
                                ; all uppercase, uncommenting this option
                                ; will tell GIGO to make all incomming
                                ; addresses to lowercase.  This is experimental
                                ; and not highly recommended; the suggested
                                ; action is to get a feed that doesn't alter
                                ; the mail like that.  But.. :-)

;CRLF                           ; Uncomment this line if your feed is sending
                                ; mail or news bundles with carriage returns
                                ; at the end of the line, instead of just
                                ; line feeds.  Enabling this option _will_
                                ; slow down processing some, as it will have
                                ; to translate cr/lf lines to just lf lines.
                                ; (Most sites won't need this option.)
                                ; (It's prefered that they turn OFF the CR's)


SPOOL \SPOOL\         ; Where your Waffle style UUCICO spool dir is
                                ; (must be the same as UUCICO's spool!)

;BAGS C:\BAGS\                  ; If you get .BAG files from Plannet
                                ; Connect you may specify this option here.
                                ; Note that you will still need to set up
                                ; the SPOOL, MYSITE, DOMAIN, and MYFEED
                                ; options.


; At the request of garux@mdtn_bbs ..  a specialty option to allow outgoing
; _email_ only to be routed to different spools, based on where it is headed.
; If you don't understand this option, don't use it.

; _Most_ sites don't need this, and the inclusion of even one of these
; statements will slow down _all_ outbound email, as it turns on the extra
; checking needed to figure out where to send things.  The routines had to
; make use of scanning the config memory every pass, and make use of regex
; routines (which are always slower processing).
;
; * Before using these, make sure you _really_ need them! *
;
;ROUTESPOOL host1  host1          ; Sends all mail to host1 directly to host1 spool
;ROUTESPOOL frackit frackit.uucp  ; same for frackit.uucp
;ROUTESPOOL frackit wfs.uucp      ; put all user@wfs.uucp mail in frackit's spool
;ROUTESPOOL host  *.uucp          ; Sends all user@....uucp messages to "host"

; Another option, that's for kludging value only, is to generate outgoing
; spool file names with your host's name in it, instead of your name in it.
; Don't use this option unless you know WHY you need it (it will be used by
; maybe 1% of the people around..)  Anyone using this option when they are
; not supposed to has about a 99% chance of losing their mail.
;
;BACKWARDSFEED     ; If you don't need this, don't use it - it will break!

;The BURT_JUDA_HACK option is meaningless for most people.  This option
;creates email headers with "From user@site.domain  date" instead of
;"From site!user date+time remote from site".
;*If this option helps you, great.  Don't do it unless you _know_ you need
;*it though.  Burt needed it for his special smtp scripts.
;BURT_JUDA_HACK



;  MAPSTYLE - Mapping style for default outbound email.  Gigo supports
;  practically any style of generating addresses now, as it is completely
;  definable by you, the admin.

;  If the message is being launched from the gateway itself, then no
;  "othersite" should be evident in the outbound headers.  See "SITE local"
;  command below.

;  EDIT THIS TO MATCH __YOUR__ SITE
;
;  *user   translates to the current user.name
;  *site   translates to the current SITE parameter
;  *mysite translates to the current MYSITE variable
;  *domain translates to the current DOMAIN variable
;  *myfeed translates to the current MYFEED variable
;  *fnz    translates to .f##.n##.z## (ie, *user@*fnz.fidonet.org)
;  *ftn    translates to ##-##-##-## (may have fewer #'s; this
;           variable is an alternative to *fnz, using fewer periods
;           and (usually) a shorter string.  The number of ##'s will
;           vary from 1 to 4 (ie, 203-7707 is enough to say net 203,
;           node 7707, in my zone).
;
;
;  You MUST define MAPSTYLELOCAL and MAPSTYLESITE
;
;  You may use any of the above variables; most importantly, *user
;  and *site.  Anything else can be filled in by you with specific
;  text, and may use the above variables if you wish.

MAPSTYLELOCAL     *user@*mysite.*domain
MAPSTYLESITE      *user@*site.*mysite.*domain

; Other examples:
; MAPSTYLELOCAL   *user@wmeonlin.sacbbx.com
; MAPSTYLESITE    *user@*site.wmeonlin.sacbbx.com
;
; MAPSTYLELOCAL  vogon1!frackit!mdtn_bbs!*user@psuvax.psu.edu
; MAPSTYLESITE   vogon1!frackit!mdtn_bbs!*site!*user@psuvax.psu.edu





;  *** Packet Generation
;

;  In messages from usenet to Fidonet, ORIGIN=ORGANIZATION will place
;  the "Organization" field from the usenet header into the Fidonet origin
;  line.  You may change the string following ORIGIN=ORGANIZATION to
;  meet your gateway's needs.  Example:
;
;  Organization: University of the World
;
;  - will become -
;
;  * Origin: Usenet: University of the World (1:125/110.99)

;ORIGIN=ORGANIZATION Usenet:
ORIGIN The Black Cat's Usenet <=> Fidonet Gateway
;
;  Along the same lines, ORGANIZATION=ORIGIN will place the Fidonet
;  origin line into the "Organization" field to messages bound for
;  usenet.  Example:

;  * Origin: Swizzle Stick BBS (1:125/110)
;
;  - will become -
;
;  Organization: Fidonet: Swizzle Stick BBS

ORGANIZATION=ORIGIN Fidonet:

;  If either ORGANIZATION=ORIGIN or ORIGIN=ORGANIZATION are excluded, _or_
;  simply left unspecified, the config verb(s) below will be used as their
;  respective place holders in the outbound mail.

;ORIGIN       Swizzle Stick <-> Internet Gateway
;ORGANIZATION Swizzle Stick

;  If your BBS or editor supports the FSC-35 specification, the FSC-35
;  command should be enabled.  This causes GIGO to add the ^aREPLY-TO and
;  ^aREPLYADDR kludges to messages.  If you are not sure if your BBS
;  supports FSC-35, leave the command in, as it will not cause a problem
;  for most BBS or editor software.  The exception is RemoteAccess, for
;  which this line should be commented out.

FSC-35

;  RETURNADDRESS_EMAIL <optionalname>
;  RETURNADDRESS_NEWS  <optionalname>
;  tells GIGO to use the person's email address (name@site)
;  in the From: field of a fidonet message if it is small enough to fit in.
;  If the address is too long, the person's name is used instead.
;  Commenting this verb will only import names in the From portion rather
;  than email addresses.

;  By default, a person's real name is placed in the fidonet header.

RETURNADDRESS_EMAIL     ; Uncomment this to put the email adddress in the hdr
;RETURNADDRESS_EMAIL UUCP; Uncomment to put "UUCP" in the message hdr
RETURNADDRESS_NEWS      ; Uncomment this to put the email address in the hdr
;RETURNADDRESS_NEWS UUCP ; Uncomment to put "UUCP" in the message hdr

;  SPLIT - split up large messages SQUISH, QMAIL, TOSSCAN, GECHO, FMAIL,
;  FASTECHO, WILDMAIL, RENEMAIL, TELEMAIL,  and 95% of the rest of the
;  tossers out there require a relatively small individual message size to
;  work smoothly.  Nearly every tosser since then has taken this example
;  and imposed a relativley small limit on fidonet messages. if you change
;  this from 15000, be sure you know everyone receiving from you will be
;  able to handle the incoming large mail you send.

SPLIT 10000

;  MAXPKT - provide a (approx) cuttoff point per .PKT do you REALLY want to
;  toss a 3.5 meg single packet? didn't think so, one small slipup and you
;  might lose a whole day's mail. commenting this verb will generate one
;  continuous mail packet, that may become questionable in the event of an
;  emergency abort. Unlike any other currently available gateway package
;  GIGO splices USENET batches into a seamless stream of fidonet poackets,
;  without pasing between each batch. This is necessarry to keep things
;  within a reasonable managability level.

MAXPKT 150000

;  LINEBREAK - specifies the longest line length allowed to to be sent to
;  the usenet site.  Any messages that have lines that are too long will be
;  wrapped.  Not always needed, and much faster off. Suggested: 78

LINEBREAK 78


; MAXNEWSGROUPS xx tells GIGO to allow up to xx copies
; of the same message to be cross-posted.  If the message is cross-posted
; to more newsgroups than the number you specify, GIGO will publish
; only the first copies.  Default = 20.

MAXNEWSGROUPS 20


;  THE MAILER-DAEMON
;
;  GIGO has a built-in mailer-daemon that can, if allowed, handle many
;  situations in an automatic manner.

;  The mail-daemon can:
;    o Bounce incorrently addressed netmail
;    o Bounce email that is destined to a BBS that does not exist
;    o Send back textfiles when a certain email-address is addressed
;    o Perform file-by-email requests

;  Most importantly, it will check any messages written by Fidonet users
;  who are attempting to send email.  It will verify that they have the
;  security to write the message; it will also see if it can correctly
;  figure out where the user wants to send the message.  If either case
;  turns out to be a problem, the user is sent the message back via netmail,
;  with information on why it was denied, or (better), information on how
;  to properly address the gateway.
;
;  This should be most useful for ex-Fredgate users who kept getting all
;  those messages in their lostfu directory! :-)

;
;  Another useful function of the daemon is for incomming email that is
;  meant to be turned back into netmail.  GIGO will attempt to parse the
;  email address, and determine where it should send the mail to.  If it
;  can't, GIGO has one of two options:  either A: bounce it back to the
;  internet user, or B: put it with _your_ netmail, so you can manually
;  handle it.

; KEEP_UNKNOWN   ; Uncomment this line to manually handle unknown email

;  The mail-daemon can also be set up to send back a textfile whenever
;  a specific email-address is sent mail.  A fake user is setup,
;  slightly different from normal user statements.  More discussion on
;  this is in the USER statement area.

;  USER  info@swizzle.com  INFO  infofile.txt

;  The mail-daemon can handle things like forwarding mail to a user's
;  new address, or it can be set up to bounce the mail back to usenet,
;  with a text file of your choice. This is also covered in the USER
;  statement area.

;  USER  jfesler@swizzle.com  FORWARD  jfesler@wmeonlin.sacbbx.com
;  USER  deadjoe@swizzle.com  BOUNCE   dead.txt
;  SITE  deadjoebbs           BOUNCE   deadbbs.txt



;  The mailer-daemon can also instead take all email to a specific user,
;  and save it to disk, either in a contiguos log, or as individial
;  files.  An example use for this is to have a special address for
;  uudecoded files, where you can run an external program to turn them
;  back to binaries.

;  USER  logme   LOGTEXT  logtext.log         ;saves to specified log file
;  USER  saveme  SAVETEXT C:\gateway\saveme\  ;saves to unique ########.IN

;  The mailer-daemon can also be easily expanded by you, the administrator.
;  GIGO is the first gateway to support external functions.
;
;  When used, GIGO can watch for email going to a special address.  Whenever
;  email is sent to that address, GIGO will
;    1: create FUNCTION.REQ
;    2: Run the specified program
;    3: Look for and send back FUNCTION.REP if available
;  I have successfully made a listserv processor, as well as a fax
;  gateway, both with about 10k of code.  The listserv processor + source
;  is in the main GIGO archives for you to look at and hopefully expand on.
;
;  Usage:
;   USER  requestname  FUNCTION  programname parameters

;  The mailer daemon can allow you to prevent fidonet users from
;  sending email to various addresses.  This is useful, for instance,
;  if you have a measured-rate UUCP service (or long distance charges),
;  and you don't feel like letting users request files on _your_ call.
;  BLOCKADDRESS allows you to specify a pattern for an address; if the
;  address that the user is emailing fits any of these patterns, the
;  message will be returned to him as undeliverable.
;
;  Note that this will block even YOUR attempts.  It doesn't discriminate
;  on who it blocks.
;
;BLOCKADDRESS + *listserv*
BLOCKADDRESS + *fileserv*
BLOCKADDRESS + *ftpmail*
BLOCKADDRESS + *BITFTP*
BLOCKADDRESS + *request*

;  Last, GIGO has the ability to check a nodelist index.  A seperate
;  nodelist compiler is included with GIGO, and comes with it's own docs.
;
;  If you specify the directory where NODELIST.GIG can be found, GIGO will
;  look up this nodelist index any time an email address comes in in the
;  form of user@f###.n###.z###.site.domain, or in the form of
;  user@##-##-##-##.site.domain.  If GIGO can not verify the existance of
;  that nodelist entry, GIGO will send the message back to the internet
;  user.
;
;  This option is here mainly because MsgTrack is not gateway aware, and will
;  bounce messages back to the gateway.  The gateway would in turn send a
;  message back to MsgTrack saying that it wrote the message wrong.  What
;  a mess!  If possible, please, use the NODELIST option in GIGO, to prevent
;  such a mess happening for you..
;
NODELIST D:\NODELIST\ ; Should point to where NODELIST.GIG will be found.





;  GIGO can act as a server for FILESERV requests.  Delete this line to
;  disable FILESERV access to your files.  This is a list of your file
;  requestable directories, one on each line.  You can point this to your
;  bink style okfiles catalog if you wish; magic names will be honored.
;
;  I have tried to make GIGO understand both FrontDoor style and Bink Style
;  request lists; you can list magic names and directory names with either
;  method.

;FILESERV-LIST      C:\FD\FLSEARCH.CTL
;FILESERV-MAXFILES  10
;FILESERV-MAXBYTES  10000000
;FILESERV-DEFAULT   75000      ; Default segment size for binaries
;FILESERV-ATTACH               ; If you want to allow file attachments
;FILESERV-INBOUND c:\fd\files\ ; Your fidonet inbound directory
;FILESERV-HOLD    c:\fd\hold\  ; Where to move files that were attached
; See the NOTES file re: file attachments for more detailed information.

;------------------------------------------------------------------
; The following allow you to decide which header lines
; to keep in the FTSC messages.  Specify
; Keep_<headerline>: to keep it in the message, and
; Kill_<headerline>: to butcher a line totally, and
; Hide_<headerline>: to keep it, but behind a hidden
; kludgeline so that average users can not see it.

;MULTIPLEHEADERS      ; States that you want to have the message headers
                     ; from the usenet message placed in _all_ fidonet
                     ; messages.  Comment this line out to have GIGO only
                     ; place the usenet headers on the first message
                     ; of a split message.


;RMAIL_KEEP_ALL      ;  This command specifies that GIGO should keep
                     ;  ALL header lines from an email message.
                     ;  The only exception would be if you specify
                     ;  a Hide_ line, then that header line will
                     ;  be hidden behind a kludge line.

Keep Apparently-to:  ; Shows the internet address a netmail message was
                     ; routed to originally.
Keep Archive-Name:   ; In the case of news.answers, the real name of the file
Kill Date:           ; What date the message was written
Keep From:           ; Who it's from (suggested, not all names are under 36
                     ; characters)
Keep To:
Keep Reply-To:
Keep Newsgroups:     ; What newsgroups the message was posted to
Keep Organization:   ; Organization (if any) of the person writing the msg
Kill Path:           ; This field is a USELESS field for most gateways
Kill Subject:        ; Full subject line
Kill Message-ID:     ; Original MSGID from the usenet message
Hide Received:
Hide Sender:
Keep In-Reply-To:
Hide Mime-Version:
Kill Content-Type:
Hide Errors-To:
Hide Precedence:
Hide X-To:
Hide X-Sender:
Hide X-Ftn-To:
Hide X-Ftn-From:
Hide X-Resent-By:
Hide X-Admin-Addr:
Hide X-List-Software:


;----------------------------------------------------------------------------
          ;;;;;;;;;        *  Mapping   *      ;;;;;;;;;

; Here's the guts of the name and account translations done by the gateway.
; There are _several_ different ways of handling USER and SITE statements;
; my attempts at expressing documentation are poor, so instead we will have
; examples of everything.

; Individual  accounts on your system are specified, with  who their owner is
; and what their fidonet address is. They will appear as "account@site.domain"

USER jpk           1:109/401.1  Joe Keenan
USER Joe.Keenan    1:109/401.1  Joe Keenan
USER postmaster    1:109/401.1  Postmaster
USER root          1:109/401.1  Joe Keenan

USER Dave.Aronson  1:109/120.0	Dave Aronson

; The following two examples are where the person does not exist on your
; BBS or gateway, but instead somewhere else.  You need to specify the
; entire address, __even_if_you_have_a_SITE_for_them_!.  GIGO takes the
; USER statements as priority over SITE statements.

;USER jfesler@wmeonlin.sacbbx.com 1:203/7707.0  Jason Fesler
;USER jdoe@somebbs.swizzle.com    1:125/1234.0  John Doe

; If someone starts abusing the gateway, you can block them out.
; Note that the "bounce" statement is on the left hand side this time.
; When the gateway tries to create this user's email address, it will see
; that their account says "bounce", and will send them back a nasty-gram(tm).

;USER bounce    1:2/3.4       User Name
;USER bounce    1:203/7707.1  Twit

USER Ronald.McClendon@f1.n261.z1.fidonet.org BOUNCE
USER Ronald.McClendon@f1056.n261.z1.fidonet.org BOUNCE
USER bounce     1:261/1       Robert McClendon
USER bounce     1:261/1056    Robert McClendon

USER eric.carlson@blkcat.fidonet.org BOUNCE

USER trey.causey@f310.n2602.z1.fidonet.org BOUNCE
USER 1-2602-310-0!trey.causey BOUNCE
USER bounce     1:2602/310    trey causey

; GIGO has a built-in mail-daemon that can perform various functions,
; such as send back a text file when triggered, or bounce mail back
; to the sender, or even forward the mail from one address to another.

; Sends INFOFILE.TXT whenever someone sends email to info@swizzle.com

;USER info@swizzle.com  INFO  infofile.txt


;USER dead2@swizzle.com BOUNCE              ; Bounces with generic message
;USER dead@swizzle.com  BOUNCE deaduser.txt ; Bounces the message back
                                            ; with the "deaduser.txt" file
;SITE deadbbs           BOUNCE deadbbs.txt  ; Bounces messages to all users
                                            ; @deadbbs.swizzle.com, and
                                            ; sends the "deadbbs.txt" file

SITE  f602.n109.z1.fidonet.org BOUNCE

;USER jfesler FORWARD jfesler@wmeonlin.sacbbx.com ; Forwards to the real address


; The mail-daemon can even attempt to catch fidonet-style names
; and give them email addresses.  For example, if someone sends a message
; to "Sysop" at your gateway's address, you can have it sent to
; your main account instead.

; Format:   MAPFU  internet-account  Real Name
;
; The internet account _must_ be the _full_ internet account name, even
; if it is going to your own gateway.

;MAPFU  root@swizzle.com             Sysop
;MAPFU  jfesler@wmeonlin.sacbbx.com  Jason Fesler

; Ever get twits sending areafix messages to the gateway?  Try this..

;MAPFU  areafix@swizzle.com          Areafix       ; Turns it to a valid address
;USER   areafix@swizzle.com  BOUNCE                ; and then the daemon can catch
                                                  ; it, and send the user back a
                                                  ; a nasty message!

; Now, you've got this great gateway program setup, and you'd like to
; allow some/most/everyone access to using the gateway.  However, you
; don't feel like manually putting everybody in... That gets to be VERY
; tedious.

; The SITE statements allow you to handle entire BBS's at a time,
; by defining them as a feed off of you (at least, as far as the internet
; is concerned).  Or, it will allow you to generate the "standard"
; fidonet style addresses (for example, jason.fesler@f7707.n203.z1.fidonet.org)
; Alternately, you can deny access for specific sites altogether.
;
; Most important, you have to tell the gateway what YOUR address(s) are.
; They are not always the same as you had them defined at the top of the
; config file, and sometimes you may have more than one address (multiline
; hubs, etc).

; The SITE LOCAL  <fido-address>  command tells the gateway that if someone
; on your BBS posts a message, but they do not have a specific account name
; setup, then GIGO should create an address like "user.name@yoursite.domain".

SITE LOCAL  1:109/401
SITE LOCAL  1:109/2
SITE LOCAL  1:109/0

; Now, you can define the BBS's that are local to you.  Email addresses
; that are generate automaticly will look like
; "user.name@bbsname.yoursite.domain" (or something similiar, depending
; on what mapstyle you have selected).  All of the users for a given BBS
; are defined at once with the single statement.
;
; Note that if the user has a USER statement in this config file, that will
; take priority, and the SITE statements will not even be looked at.

;SITE joesbbs 1:125/1      ; user.name@joesbbs.swizzle.com
;SITE nc      1:125/0      ; user.name@nc.swizzle.com
;SITE mypoint 1:125/110.1  ; user.name@mypoint.swizzle.com
;SITE somewhr 1:125/120    ; user.name@somewhr.swizzle.com

; You can deny a BBS by giving it the name "bounce".

;SITE bounce  1:203/7707.1 ; This stops Jason Fesler's point address.
;SITE bounce  1:125/9999   ; This stops "test" nodes using 1:125/9999

;SITE bounce 1:109/602

;  If you wish to be a public gateway for your local area, but you can not
;  get approval (or don't wish to) to become part of the .fidonet.org
;  distribution people (those are the ones that are allowed to fly the 
;  GUUCP flag in the nodelist), GIGO has an option for you.

;  SITE GATEWAY <fidonet-wildcard-address>

;  This option will generate email messages that automaticly use YOUR site's
;  address, with a numeric "bbs name" that the gateway can understand.  This
;  forces any return mail going back to that user to go via your gateway,
;  which is (probably) faster than using the "standard" fidonet address.

;SITE gateway 1:125/*.*    

;  With this statement, if Joe Blow at 1:125/1234 posts a message, his 
;  email address will be Joe.Blow@1234.swizzle.com.  

;  If Joe Blow posts from 1:125/1234.5, then his email address will be
;  Joe.Blow@125-1234-5.swizzle.com .

;  It looks confusing, but it's simpler than it looks.  The gateway includes
;  just enough information in the numeric portion of the address to figure
;  out where to send it back to if it needs to.  
;       Nodes in your net:    user.name@<node>.swizzle.com
;       Nodes outside....:    user.name@<net>-<node>.swizzle.com
;       Points           :    user.name@<net>-<node>-<point>.swizzle.com
;       Outside your zone:    user.name@<zone>-<net>-<node>-<point>.swizzle.com
;
;  You may specify multiple SITE GATEWAY .. statements if you wish to 
;  use this addressing style for more than one group of people.  
;  The Net 203 Gateway (wmeonlin.sacbbx.com) uses this format for 
;  the entire Northern California (USA) region, since I can deliver the mail 
;  faster than using the "standard" fidonet address.

; The next statement is to allow gating, but using the "standard" fidonet
; address.  Use this for people that are outside of the area that you are
; normally willing to gate for.

;SITE fidonet.org 1:*/*.*  ; This statement defines all other zone 1 BBS's
;SITE fidonet.org 2:*/*.*  ; with their "standard" gate address, ie
;SITE fidonet.org 3:*/*.*  ; user.name@n##.f###.z###.fidonet.org.
;SITE fidonet.org 4:*/*.*  
;SITE fidonet.org 5:*/*.*     
;SITE fidonet.org 6:*/*.*              

SITE fidonet.org 1:109/*.*              
SITE fidonet.org 1:261/*.*              

; The following command allows for "fast return" of mail that is addressed
; to the internet, but is actually supposed to be processed by your system.
; In these cases, the gateway will generate _incomming_ bundles instead of
; outgoing bundles, making the messages never even leave your system.
; Best use for this is "fidonet.org" addresses, since we are not allowed
; to send from fidonet, to fidonet, via the internet backbone (as part of
; our charter to get .fidonet.org).

; Note, to force compliance with this charter, "fidonet.org" is a forced issue
; with GIGO.  If you do not want GIGO to FASTRETURN anything for fidonet.org,
; contact me.  I will only grant the key to disable this function to very
; special circumstances that do not violate fidonet.org's charter.
; An example of this exception would be if you are the gateway for a
; different (and registered) organization, ie rbbsnet.org, where it _is_
; desirable to be able to email someone@*.fidonet.org ..

FASTRETURN fidonet.org
;FASTRETURN myspecialnetwork.org

; IGNORE_CHARTER xxxx       ; If you do NOT want fidonet.org put into the
;                           ; FASTRETURN statements automaticly, you must
;                           ; get a special key, simply email me with a
;                           ; good reason why.  Mostly, for people
;                           ; gating networks other than fidonet.

; Last, but not least, the final statement.  This is to bounce any 
; remaining addresses, telling them that they are not authorizid
; to use the gateway.  I only move mail for FidoNet; no other zones are 
; allowed to go through me, as I can not guarantee that their mail can
; be returned back to them if needed.

SITE bounce  *:*/*.*      ; This declines allowing anyone else from sending
                          ; email through your gateway.

