/*
 *  FIXMAP
 *
 *  Sample program that takes a GIGO function request file (FUNCTION.REQ),
 *  checks it, and then modifies your mapping.cfg file with the new
 *  request.  It assumes that the message body was written to look like
 *  a FidoNet areafix request.
 *
 *  Due to the lack of standards for asking your host to change your settings,
 *  this source code makes no attempts at doing so.  You are free to modify
 *  it for your needs.
 *
 *  Jason Fesler, June 1994    jfesler@wmeonlin.sacbbx.com
 */


/*  For simplicity sake, I include everything, so that I don't have
 *  any problems with the compiler knowing what I am talking about.
 */
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <process.h>
#include <share.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>
#include <ctype.h>
#include <direct.h>
#include <dos.h>
#include <stdarg.h>


char            mapfile[256] = "MAPPING.CFG";

struct headers {
    char            Apparently_To[256];
    char            To[256];
    char            From[256];
    char            Subject[256];
};

char autonews[32000];

/*
 * cmpcopy will compare the string at SOURCE, and see if it contains the
 * TOKEN.  If so, it will copy the value of that token to DEST.
 */

void            cmpcopy(char *token, char *source, char *dest)
{
    if (!strncmp(source, token, strlen(token))) {
        source += strlen(token);// get past the token itself
        while (*source == ' ')
            source++;           // get past the spaces
        strcpy(dest, source);
    }
}

/*
 *  readheaders will read lines until it finds a blank line or 
 *  end of file.  Known tokens will be copied to the structure
 *  called headers.
 */

 void            cmpcopy(char *token, char *source, char *dest);

void            readheaders(FILE * file, headers * header)
{
    char            line[1024] = " ";
    memset(header, 0, sizeof(headers));
    while ((*line) && (!feof(file))) {

        /* remember, GIGO stands for garbage in, garbage out. */
        memset(line, 0, sizeof(line));
        fgets(line, sizeof(line) - 1, file);

        /* fgets includes the line terminator; we need to remove it. */
        if (*line)
            if (line[strlen(line) - 1] == '\n')
                line[strlen(line) - 1] = 0;
        if (*line)
            if (line[strlen(line) - 1] == '\r')
                line[strlen(line) - 1] = 0;
        if (!*line)
            continue;           /* We got a blank line, or an eof */
        cmpcopy("Apparently-To:", line, header->Apparently_To);
        cmpcopy("To:", line, header->To);
        cmpcopy("From:", line, header->From);
        cmpcopy("Subject:", line, header->Subject);
    }
}


/*
 *  readlines will read the remainder of the file, and decide if it's
 *  going to ADD or DROP the area in question.
 * 
 *  It will append the + newsgroupname\n to the appropriate global variable
 *  buffer.
 */


void addautonews(char mode, char *name)
{
 sprintf(autonews+strlen(autonews),"%c %s\n",mode,name);
}

void writeautonews(void)
{
 FILE *file;
 if (autonews[0]) 
 {
 file=fopen("autonews.txt","wt");
 if (file) {
   fwrite(autonews,1,strlen(autonews),file);
 fclose(file);
   }
 }
}

void            readlines(FILE * file, char *adds, char *drops)
{
    char            line[1024] = " ";
    char            line2[1024];
    char             *p;

    strcpy(adds, "\n");
    strcpy(drops, "\n");

    while (!feof(file)) {
        memset(line, 0, sizeof(line));
        fgets(line, sizeof(line) - 1, file);

        if ((p=strpbrk(line,"\r\n"))!=NULL) *p=0;  /* we don't want the newline info on this */
        if (!line[0])       /* No line? No problem, go to the next line. */
            continue;           /* We got a blank line, or an eof */

        if (strnicmp(line,"--",2)==NULL) break;   /* Tearline */
        if (strnicmp(line,"|",2)==NULL) break;  /* Common start of a sig */
 
        if (!isalnum(line[1])) break; /* Huh? What the hell is THIS doing here? */
                                      /* Supposedly, newsgroups start with alpha or num */

        strcpy(line2,line);    /* this will be the uppercase equivalent */
        strupr(line2); strlwr(line);

        if (line[0] == '') continue;
        if (line[0] == '%') continue;
        if (line[0] == '-')
     {
            sprintf(drops + strlen(drops), "= %s %s\n", line + 1,line2+1);
            addautonews('-',line+1);
    }
        else
        if (line[0] == '+') 
   {
            sprintf(adds + strlen(adds), "= %s %s\n", line + 1,line2+1);
            addautonews('+',line+1);
   }
        else {
            sprintf(adds + strlen(adds), "= %s %s\n", line,line2);
            addautonews('+',line);
}

    }
}

/*
 * Generate the new map file.  ADDS are written at the top.
 * The file is then scanned line by line; any line that exists in the buffer
 * pointed to by DROPS or ADDS will not be output (either because they
 * are being dropped, or they were just added, and should not be printed
 * a second time around!)
 */


void            update_map(char *mappingcfg, char *adds, char *drops)
{
    FILE           *oldfile;
    FILE           *newfile;
    char            line[1024];
    char            line2[1024];
    unlink("MAPPING.BAK");
    rename(mappingcfg, "MAPPING.BAK");

    oldfile = fopen("MAPPING.BAK", "rt");
    if (!oldfile) {
        fprintf(stderr, "Damn! Could not open MAPPING.BAK for input\n");
        exit(1);
    }
    newfile = fopen(mappingcfg, "wt");
    if (!newfile) {
        fprintf(stderr, "Damn! Could not open %s for output\n", mappingcfg);
        exit(1);
    }
    fprintf(newfile, adds + 1, strlen(adds) - 1);

    while (!feof(oldfile)) {

        memset(line, 0, sizeof(line));line[0]='\n';
        fgets(line + 1, sizeof(line) - 2, oldfile);
        strcpy(line2,line);
        if (line2[1]==';') strcpy(line2+1,line+1);
        if (!line[1])
            continue;           /* We got a blank line, or an eof */
        if (strstr(drops, line))
            continue;
        if (strstr(adds, line))
            continue;
        if (strstr(drops, line2))
            continue;
        if (strstr(adds, line2))
            continue;
        fprintf(newfile, "%s", line + 1);
    }
/* don't!     fprintf(newfile,drops); */
    fclose(newfile);
    fclose(oldfile);
}

/*
 *  Find out what the message is all about, and handle it.
 *
 */

void            process_function(char *function_req, char *mappingcfg)
{
    FILE           *file;
    char           *adds;
    char           *drops;
    headers         header;
    adds = (char *) calloc(1, 64000);
    drops = (char *) calloc(1, 64000);
    if ((!adds) || (!drops)) {
        fprintf(stderr, "Could not allocate buffers.\n");
        exit(1);
    }
    file = fopen(function_req, "rt");
    if (!file) {
        fprintf(stderr, "Could not open %s for input.\n", function_req);
        exit(1);
    }
    readheaders(file, &header);
    readlines(file, adds, drops);
    fclose(file);
    printf("From: %s\n"
           "To  : %s\n"
           "Subj: %s\n", header.From, header.To, header.Subject);

    update_map(mappingcfg, adds, drops);
}

void            main(int argc, char *argv[])
{
  memset(autonews,0,sizeof(autonews));
    if (argc > 1)
        strcpy(mapfile, argv[1]);
    printf("FIXMAP Function Request Server for GIGO.\n"
      "Reads the areafix style message body and modifies your mapping file.\n"
           "(C) Copyright 1994 by Jason Fesler.  All rights reserved.\n\n"
        "Source code for this utility is available; it can provide a decent\n"
           "template for other function requests.\n\n"
           "Input file  :  FUNCTION.REQ\n"
           "Mapping File:  %s\n", mapfile);
    process_function("FUNCTION.REQ", mapfile);
  writeautonews();
}
