#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <os2.h>
#include <sys\types.h>
#include <sys\socket.h>
#include <netinet\in.h>
#include <arpa\inet.h>
#include <unistd.h>
#include <netdb.h>
#include <fcntl.h>
#include <io.h>
#include <share.h>
#include <sys/stat.h>
#include <sys/errno.h>

/* Can't someone just do a "#include *" extension? */

#define MAXDATA 1024

int             hsock_in, hsock_out;	/* socket descriptors, kept global
					 * for close routines */

void            closein(void);
void            closeout(void);
void            stripcrlf(char *);

void
main(int argc, char **argv)
{
	char            buffer[80];
	char           *hostname;
	char           *dlvr_agent = NULL;
	struct sockaddr_in sock_in, sock_out;
	struct hostent *hoststruct, *clientstruct;
	char            theirname[256];
	FILE           *fi, *fo;
	int             dlvr_type, i, x;
	unsigned char   a, b, c, d;
	time_t          t;

	int             processconnection(char *, char *, FILE *, FILE *, int, char *);
	void            usage(char *);

	printf("\x1b[0;1;36mHTTP Daemon\n");
	printf("\x1b[0;1;33m");	/* bright for warnings! */
	gethostname(buffer, 80);
	hoststruct = gethostbyname(buffer);
	a = hoststruct->h_addr[0];
	b = hoststruct->h_addr[1];
	c = hoststruct->h_addr[2];
	d = hoststruct->h_addr[3];

	hostname = strdup(hoststruct->h_name);
	hsock_in = socket(AF_INET, SOCK_STREAM, 0);
	memset(&sock_in, 0, sizeof(sock_in));
	i = 1;
	x = setsockopt(hsock_in, SOL_SOCKET, SO_REUSEADDR, &i, sizeof(i));
	if (x) {
		perror("Error on setsockopt()");
		exit(1);
	}
	printf("Daemon configured for %s (%i.%i.%i.%i)\n", hostname, a, b, c, d);

	sock_in.sin_family = AF_INET;
	sock_in.sin_addr.s_addr = INADDR_ANY;
	sock_in.sin_port = htons(80);

	memset(buffer, 0, 80);
	if (hsock_in == -1) {
		perror("Error occured on socket()");
		exit(1);
	}
	atexit(closein);
	x = bind(hsock_in, (struct sockaddr *) & sock_in, sizeof(sock_in));
	if (x == -1) {
		perror("Error occured on bind()");
		exit(1);
	}
	do {
		x = listen(hsock_in, 0);
		if (x == -1) {
			perror("Error occured on listen()");
			exit(1);
		}
		printf("\x1b[31m");
		printf("Waiting for connection...\n");
		i = sizeof(sock_out);
		hsock_out = accept(hsock_in, (struct sockaddr *) & sock_out, &i);
		if (hsock_out == -1) {
			perror("Error occured on accept()");
			exit(1);
		}
		fo = fdopen(hsock_out, "w");
		fi = fdopen(hsock_out, "r");
		if (!fo) {
			printf("Can't open output stream\n");
			exit(1);
		}
		if (!fi) {
			printf("Can't open input stream\n");
			exit(1);
		}
		atexit(closeout);

		d = (sock_out.sin_addr.s_addr & 0xff000000) / 0x1000000;
		c = (sock_out.sin_addr.s_addr & 0xff0000) / 0x10000;
		b = (sock_out.sin_addr.s_addr & 0xff00) / 0x100;
		a = (sock_out.sin_addr.s_addr & 0xff);
		sprintf(theirname, "Unknown_IP_Address_%u.%u.%u.%u", a, b, c, d);
		printf("\x1b[0;1;32m");

		hoststruct = gethostbyaddr((char *) &sock_out.sin_addr.s_addr, 4, AF_INET);
		if (hoststruct)
			strcpy(theirname, hoststruct->h_name);
		else
			printf("\x1b[5m");	/* blink */

		time(&t);
		printf("Connection accepted from %s  %s", theirname, ctime(&t));

		printf("\x1b[0;1;33m");
		x = processconnection(dlvr_agent, hostname, fi, fo, dlvr_type, theirname);
		close(hsock_out);
		fclose(fi);
		fclose(fo);
	} while (1);
}

int
processconnection(char *dlvr_agent, char *hostname, FILE * fi, FILE * fo, int dlvr_type, char *clientname)
{
	int             sosend(FILE *, char *);
	int             soread(FILE *, char *);

	char            inp_line[MAXDATA];
	char            filename[256];
	char            username[MAXDATA];
	FILE           *file = NULL;
	char *p;

	inp_line[0] = '\0';
	soread(fi, inp_line);
	stripcrlf(inp_line);
	strcpy(username, inp_line);
	printf("\x1b[0;36m>>> %s\n", username);
	printf("\x1b[0;35mFILE: ", username);
        p=strtok(username," \x09\r\n");
        strupr(p);
        if (strcmp(p,"GET")==NULL) {
         p=strtok(NULL,"\x09 \r\n");
         if (!p) p="index.html";         
         if (p) while (strpbrk(p,"\\/")) p++;
         if (*p==0) p="index.html";
          }
          else
           {
           p="oops.html";
           }
         strcpy(filename,p);
         file=fopen(filename,"rt");
         if (!file) if (!strchr(filename,'.'))
          { 
          strcat(filename,".html");
          file=fopen(filename,"rt");
          }
         if (!file) {
           strcpy(filename,"notfound.html");
           file=fopen(filename,"rt");
          }
         if (!file)
           {
           printf("404 File not found.\n");
        sosend(fo, "<HEAD><TITLE>404 Not Found</TITLE></HEAD>\n"
        "<BODY><H1>404 Not Found</H1>"
        "The requested URL was not found.\n"
        "</BODY>");
           }
         else
          { 
printf("%s\n",filename);
		while (feof(file) == NULL) {
			inp_line[0] = 0;
			fgets(inp_line, sizeof(inp_line), file);
			stripcrlf(inp_line);
			sosend(fo, inp_line);
			sosend(fo, "\n");
		}
		fclose(file);
		file = NULL;
          }
	return (0);
}

int
sosend(FILE * file, char *data)
{
	int             retcode;

	retcode = fputs(data, file);
	fflush(file);
	if (retcode == EOF) {
		retcode = -1;
	} else {
		retcode = strlen(data);
	}
	return (retcode);
}

int
soread(FILE * file, char *data)
{
	int             retcode;
	char           *temp;

	temp = fgets(data, MAXDATA, file);
	if (temp) {
		retcode = strlen(data);
	} else {
		retcode = -1;
	}
	return (retcode);
}

void
stripcrlf(char *temp)
{
	if (temp) {
		if (strchr(temp, '\r')) {
			*strchr(temp, '\r') = '\0';
		}
		if (strchr(temp, '\n')) {
			*strchr(temp, '\n') = '\0';
		}
	}
}

void
closein(void)
{
	close(hsock_in);
}

void
closeout(void)
{
	close(hsock_out);
}

