#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <direct.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include <time.h>
#include <sys\stat.h>
#include <share.h>
#include "bconio.h"

#include "proto.h"

char            pkte[80];
int             sim_usedosmem = 1;
int             sim_useuppermem = 0;

struct pktheadertype {
    unsigned short int
                    orignode,
                    destnode,
                    year,
                    month,
                    day,
                    hour,
                    minute,
                    second,
                    baud,
                    pkttype,
                    orignet,    /* -1 if from a point */
                    destnet;
    char            productcode,
                    revision,
                    password[8];
    unsigned short int origzone,
                    destzone,
                    auxnet,
                    CWvalcopy;  /* inverted capability word */
    char            ProductCode,
                    Revision;
    unsigned short int
                    capabilword,
                    origzone2,
                    destzone2,
                    origpoint2,
                    destpoint2;
    unsigned char   productdata[4];
};

struct packedmsgtype {
    unsigned short int
                    msgtype,    /* 2 */
                    orignode,
                    destnode,
                    orignet,
                    destnet,
                    attribute,
                    cost;

};

struct msgpointer {
    char           *buffer;     /* includes everything */
    long            size;
    char           *area;
    char           *subject;
    char           *msgid;
    unsigned long   val;
    unsigned long   datetime;
};

struct dirfiletype {
    char            name[9];
    unsigned long   crc;
    unsigned long   datetime;
    unsigned long   size;
};
dirfiletype    *dirfiles = NULL;
long            curdirfile = 0;
long            totaldirfiles = 0;
unsigned long   tackytimedate = 0;
unsigned long   tackysize = 0;


FILE           *outfile;
char           *readbuffer = NULL;
unsigned long   readbuffersize;
char           *writebuffer = NULL;
unsigned long   writebuffersize;


unsigned long  *areas;
unsigned long   totalareas = 0;

unsigned long   MAXPTRS;

pktheadertype   packetheader;
char           *tempbuf;
msgpointer     *msgptr = NULL;
unsigned long   msgcount = 0;
char           *masterbuf = NULL;
long            mastersize = 0;

long            totalmsgs = 0;
long            totalmsgsin = 0;

char            endoflinechars[] = "\n\r";
long            maxbufsize=4096*1024;
char            areasbbs[80]="AREAS.BBS";

int             strlineicmp(char *s1, char *s2)
{
    for (;;) {
        if (toupper(*s1) < toupper(*s2))
            return -1;
        if (toupper(*s1) > toupper(*s2))
            return 1;
        if (strchr(endoflinechars, *s1))
            break;              // if we're equal, tehn we only need to check
                                // ONE of the strings for eol!
        s1++;
        s2++;
    }
    return 0;                   // equal
}
int             strlinecmp(char *s1, char *s2)
{
    for (;;) {
        if ((*s1) < (*s2))
            return -1;
        if ((*s1) > (*s2))
            return 1;
        if (strchr(endoflinechars, *s1))
            break;              // if we're equal, tehn we only need to check
                                // ONE of the strings for eol!
        s1++;
        s2++;
    }
    return 0;                   // equal
}

int             compare(const void *op1, const void *op2)
{
    int             test;
    char           *p,
                   *q;
    const msgpointer *p1 = (const msgpointer *) op1;
    const msgpointer *p2 = (const msgpointer *) op2;
    test = strlinecmp(p1->area, p2->area);
    if (test)
        return test;

    test = strlineicmp(p1->subject, p2->subject);
    if (test)
        return test;
    if (p1->datetime == p2->datetime)  // ONLY if the time/dates are the same
      {
        if (p1->val > p2->val) return 1;
        if (p1->val < p2->val) return -1;

        p=p1->subject; p+=strlen(p)+1; // jump to body
        q=p2->subject; q+=strlen(q)+1; // jump to body
        p=strstr(p,"MSGID");if (!p++) p=""; // find the MSGID  wierd IF syntax but logic works
        q=strstr(q,"MSGID");if (!q++) q=""; // find the MSGID  wierd IF syntax but logic works
        test=strlinecmp(p,q); // compare MSGID's if available
        return test;
        }
    if (p1->datetime > p2->datetime)
        return 1;
    return 0;
}

void            sortstuff(void)
{
    if (msgcount < 3)
        return;                 // minimum needed to properly do this
    qsort(msgptr, msgcount, sizeof(msgpointer), compare);
}

void            dump_memory(void)
{

    unsigned long   counter;
    unsigned        index;
    if (!msgcount) {
        cprintf("Nothing in buffer.. ");
        goto killstuff;
    }
    cprintf("%lu msgs: ", msgcount);
    cprintf("Sorting.. ");
    sortstuff();
    cprintf("Writing.. ");
    for (counter = 0; counter < msgcount; counter++, totalmsgs++)
        if (msgptr[counter].size)
            fwrite(msgptr[counter].buffer, 1, msgptr[counter].size, outfile);

killstuff:
    index = 0;
    cprintf("Killing completed sources... ");
    parse_dir(".KLL", 0, make_old_die);
    memset(msgptr, 0, sizeof(msgpointer) * MAXPTRS);
    msgcount = 0;
    cprintf("Continuing.\r\n");
}

void            strcrlfcpy(char *dest, char *orig)
{
    while ((*orig) && (*orig != '\r') && (*orig != '\n') && (*orig != ''))
        *dest++ = *orig++;
    *dest = 0;                  // terminates
}

unsigned long   datekey(char *ftsc)
{
    struct tm       time_check;
    char           *months = "JanFebMarAprMayJunJulAugSepOctNovDec";
    char           *p;
    char            buf[150]="";
    char            buf2[150];

    memset(&time_check, 0, sizeof(time_check));

    memset(buf2,0,21);
    memcpy(buf2,ftsc,20);

    if ((p=strtok(buf2," :"))!=NULL) time_check.tm_mday = atoi(p); else return 0;
    if ((p=strtok(NULL," :"))!=NULL) strcpy(buf,p); else return 0;
    if ((p=strtok(NULL," :"))!=NULL) time_check.tm_year = atoi(p); else return 0;
    if ((p=strtok(NULL," :"))!=NULL) time_check.tm_hour = atoi(p); else return 0;
    if ((p=strtok(NULL," :"))!=NULL) time_check.tm_min = atoi(p); else return 0;
    if ((p=strtok(NULL," :"))!=NULL) time_check.tm_sec = atoi(p); else return 0;

       if (strstr(months,p))
         time_check.tm_mon = ((strstr(months,p))-p)/3;

    time_check.tm_year %= 100;
    if (time_check.tm_year < 80)
        time_check.tm_year += 100;  /* to go beyond 1999 */

    time_check.tm_isdst = -1;

    return mktime(&time_check);
}



void            getmessage(FILE * file, char *fidobuf)
{
    char           *ptr;
    char           *area,
                   *subject;
    char            key[512];
    unsigned long   crc;
    unsigned long   crcindex;
    unsigned long   rsfrom = 0;
    long            counter;
    char            ch = 0;



    ptr = 34 + (msgptr[msgcount].buffer = fidobuf);
    if (fread(fidobuf, 1, 34, file) < 34)
        return;
    while (((short int) *fidobuf) != 2) {
        if (feof(file))
            return;
        if (!rsfrom)
            rsfrom = ftell(file) - 34;
        cprintf("Resynchronizing (grunged pkt?): from %lu to %lu\r", rsfrom, (ftell(file) - 34));
        memmove(fidobuf, fidobuf + 1, 33);
        fidobuf[33] = fgetc(file);
        if (((short int) *fidobuf) == 2)
            cprintf("\r\n");
    }                      

    if (!fidobuf[0])
        return;                 // end of file ..
    if (feof(file))
        return;

    totalmsgsin++;

    counter = 0;
    // to
startcounter:
    if (feof(file))
      *ptr=0;
     else
    *ptr = fgetc(file);
    if (!*ptr++) {
        switch (++counter) {
        case 1:
            break;              // from
        case 2:
            subject = ptr;
            break;
        case 3:
            area = ptr;
            break;
        case 4:
            goto endcounter;    // end of message
        }
    }
    goto startcounter;
endcounter:
    msgptr[msgcount].size = (ptr - fidobuf);

    if (!strncmp(area, "AREA:", 5)) {
        area += 5;
        strcrlfcpy(key, area);
        strupr(key);
        if (totalareas) {
            crc = crc_str(key);
            for (ch = 0, crcindex = 0; crcindex < totalareas; crcindex++)
                ch |= (crc == areas[crcindex]);
            if (!ch)
                return;         // we don't WANT it! */
        }
        msgptr[msgcount].area = area;
    } else
        msgptr[msgcount].area = ""; // point to empty string for netmail

    msgptr[msgcount].val=0;
    while (!strnicmp(subject,"Re: ",4)) {ch=1;subject+=4;}
    if (isdigit(*subject))
     if (isdigit(*(subject+1)))
      if (*(subject+2)==':')
       {
        msgptr[msgcount].val=atoi(subject);
        subject+=3;
       }
    msgptr[msgcount].subject = subject;
    msgptr[msgcount].datetime = datekey(&fidobuf[14]);
    msgcount++;
}

void            getmessages(FILE * file)
{
    char           *fidobuf;
    long            offset;
    while (!feof(file)) {
        if (msgcount)
            fidobuf =
                msgptr[msgcount - 1].buffer +
                msgptr[msgcount - 1].size;
        else
            fidobuf = masterbuf;
        offset = fidobuf - masterbuf;
        if ((msgcount < MAXPTRS) && (offset < mastersize))
            getmessage(file, fidobuf);
        else
            dump_memory();
    }
}

void            process_packets(char *name)
{
    pktheadertype   newpkthdr;
    FILE           *file;
    char            filename[80];
    char            newname[80];

    sprintf(filename, "%s.%s", name, pkte);
    file = _fsopen(filename, "rb", SH_DENYRW);
    if (!file) {
        cprintf("Can not open %s\r\n", name);
        return;
    }
    setvbuf(file, readbuffer, _IOFBF, readbuffersize);
    fread(&newpkthdr, 1, sizeof(newpkthdr), file);
    memcpy(&newpkthdr.year, &packetheader.year, 14);    /* this is the date and
                                                         * baud info */
    if (memcmp(&newpkthdr, &packetheader, sizeof(packetheader)) == NULL) {
        cprintf("Reading %s.%s\r\n", name, pkte);
        getmessages(file);
        fclose(file);
        sprintf(newname, "%s.kll", name);
        rename(filename, newname);
        dirfiles[curdirfile].name[0] = 0;
    } else {
        fclose(file);
    }
}

void            process_first_packet(char *name)
{
    char            filename[80];
    unsigned long   TIME,
                    MSGSIN,
                    MSGSOUT,
                    secs,
                    rems;

    FILE           *file;

    TIME = clock();
    MSGSIN = totalmsgsin;
    MSGSOUT = totalmsgs;


    sprintf(filename, "%s.%s", name, pkte);
    cprintf("\r\nProcessing %s.. ", filename);
    file = _fsopen(filename, "rb", SH_DENYRW);
    if (!file) {
        cprintf("Could not open.\r\n", filename);
        return;
    }
    fread(&packetheader, 1, sizeof(packetheader), file);
    fclose(file);

    sprintf(filename, "%s.new", name);
    outfile = _fsopen(filename, "wb", SH_DENYRW);
    if (!file) {
        cprintf("Error creating %s.new\r\n", name);
        return;
    }
    setvbuf(outfile, writebuffer, _IOFBF, writebuffersize);
    fwrite(&packetheader, 1, sizeof(packetheader), outfile);
    cprintf("from %u/%u to %u/%u\r\n", packetheader.orignet, packetheader.orignode, packetheader.destnet, packetheader.destnode);
    parse_fastdir(process_packets, dirfiles[curdirfile].crc);
    dump_memory();
    filename[0] = 0;
    filename[1] = 0;
    fwrite(&filename[0], 1, 2, outfile);   // ending nulls
    fclose(outfile);

    TIME = clock() - TIME;
    MSGSIN = totalmsgsin - MSGSIN;
    MSGSOUT = totalmsgs - MSGSOUT;
    if (!TIME)
        TIME++;
    secs = TIME / 100;
    rems = TIME % 100;

    cprintf(" Time spent: %lu.%lu seconds\r\n"
            " messages: %lu in, %lu out.\r\n", secs, rems, MSGSIN, MSGSOUT);
    TIME = (MSGSIN + MSGSOUT) * 5000 / TIME;
    secs = TIME / 100;
    rems = TIME % 100;
    if (rems > 49)
        secs++;
    cprintf(" %lu per second (average msgs in->out time).\r\n", secs, rems);

}

void            make_old_die(char *name)
{
    char            f1[256];
    sprintf(f1, "%s.kll", name);
    unlink(f1);
}
void            make_new_pkt(char *name)
{
    char            f1[256];
    char            f2[256];
    sprintf(f1, "%s.new", name);
    sprintf(f2, "%s.%s", name, pkte);
    rename(f1, f2);
}


void            parse_fastdir(void func(char *), unsigned long crcneeded)
{
    long            index;
    for (index = 0; index < totaldirfiles; index++)
        if (dirfiles[index].name[0])
            if ((crcneeded == 0) || (crcneeded == dirfiles[index].crc)) {
                curdirfile = index;
                func(dirfiles[index].name);
            }
}



/* parse_dir
 *
 * requires extension we are searching for, and a pointer to the appropriate function
 *
 *
 * will call the specified function, with the file name (no path or extension provided)
 *
 */

void            parse_dir(char *extension, int single, void func(char *))
{
    DIR            *dir;
    struct dirent  *ent;
    char            buf[256];
    errno = 0;
redo:
    if ((dir = opendir("*.*")) == NULL) {
        fprintf(stdout, "Unable to open directory\r\n");
        return;
    }
    strupr(extension);
    while ((ent = readdir(dir)) != NULL) {
        strcpy(buf, ent->d_name);
        if (ent->d_size > 60)
            if (strstr(buf, extension)) {
                tackytimedate = ent->d_date;
                tackytimedate *= 0x10000;
                tackytimedate += ent->d_time;
                tackysize = ent->d_size;
                if (strchr(buf, '.'))
                    *strchr(buf, '.') = 0;
                func(buf);
                if (single) {
                    free((char *) dir);
                    cprintf("Rescanning directory\r\n");
                    goto redo;
                }
            }
    }
    free((char *) dir);
}

void            readareasbbs(void)
{
    FILE           *file;
    char           *p;
    char            buf[2048];
    totalareas = 0;

    file = _fsopen(areasbbs,"rt", SH_DENYNO);
    if (!file) {
        cprintf(" No %s found, message filter OFF\r\n",areasbbs);
        return;
    }
    areas = (unsigned long *) sim_calloc(10000, sizeof(unsigned long));
    if (!areas) {
        cprintf("* Could not allocate buffer for %s\r\n",areasbbs);
        exit(1);
    }
    cprintf(" Reading %s to pre-filter packets.\r\n",areasbbs);
    fgets(buf, sizeof(buf), file);
    while (!feof(file)) {
        if (totalareas > 10000) {
            cprintf("Maximum AREAS.BBS limit is 10000 areas.  Aborting.\r\n");
            exit(254);
        }
        buf[0] = 0;
        fgets(buf, sizeof(buf), file);
        if (buf[0] == ';')
            continue;           // ignore comments
        p = strtok(buf, " ");   // location/etc
        p = strtok(NULL, " ");  // area tag
        if (p)
            areas[totalareas++] = crc_str(p);
    }
    fclose(file);
    cprintf(" Total fidonet areas: %lu\r\n", totalareas);
    areas = (unsigned long *) sim_realloc((char *) areas, sizeof(unsigned long) * totalareas);
}


void            process_dirfiles(char *s)
{
    pktheadertype   newpkthdr;
    FILE           *file;
    char            filename[80];
    if (totaldirfiles > (64000/sizeof(dirfiletype)))
        return;
    if (strlen(s) > 8) {
        cprintf("Filename: %s.%s is too long; DOS name limitations are in effect.\r\n", s, pkte);
        return;
    }
    sprintf(filename, "%s.%s", s, pkte);
    file = _fsopen(filename, "rb", SH_DENYRW);
    if (!file)
        return;
    fread(&newpkthdr, 1, sizeof(newpkthdr), file);
    fclose(file);
    memset(&newpkthdr.year, 0, 14); /* blank out the time/date crap */
    if (newpkthdr.pkttype != 2)
        return;
    strcpy(dirfiles[totaldirfiles].name, s);
    dirfiles[totaldirfiles].crc = crc32_block((char *) &newpkthdr, sizeof(newpkthdr), 0xffffffff);
    dirfiles[totaldirfiles].datetime= tackytimedate;
    dirfiles[totaldirfiles].size = tackysize;
    cprintf(" %3lu File: %12s Signature: %lx\r", (totaldirfiles + 1), filename, dirfiles[totaldirfiles].crc);
    totaldirfiles++;
}

int             comparedirfiles(const void *op1, const void *op2)
{
    const dirfiletype *p1 = (const dirfiletype *) op1;
    const dirfiletype *p2 = (const dirfiletype *) op2;

    if (p1->crc < p2->crc) return -1;
    if (p1->crc > p2->crc) return 1;

    if (p1->datetime > p2->datetime)
        return 1;
    return 0;
}


void            getdirfiles(void)
{
    int             wx,
                    wy;
    totaldirfiles = 0;
    dirfiles = (dirfiletype *) sim_calloc(sizeof(dirfiletype), 64000/sizeof(dirfiletype));
    if (!dirfiles) {
        cprintf("Could not allocate directory information table\r\n");
        exit(1);
    }
    wx = wherex();
    wy = wherey();
    cprintf("Getting directory of files and their header information.\r\n");
    cprintf("(This may take a moment if you have quite a few files.)\r\n");
    parse_dir(pkte, 0, process_dirfiles);
    dirfiles = (dirfiletype *) sim_realloc((char *) dirfiles, (totaldirfiles * sizeof(dirfiletype)));
    gotoxy(1, wy + 1);
    clreol();
    gotoxy(1, wy + 2);
    clreol();
    gotoxy(1, wy);
    clreol();
    cprintf(" %lu files to process.\r\n", totaldirfiles);
    if (totaldirfiles>1)
     qsort(dirfiles, totaldirfiles, sizeof(dirfiletype), comparedirfiles);

}


void            imitate_borland();
int             _argc;
char           *_argv[100];

void            showhelp(void)
{
    cprintf("Psrt.Exe Options:\r\n"
            " /a=AREAS.BBS Filters .PKT files to only include areas in AREAS.BBS\r\n"
            " /e=PKT       Specifies you are working with .PKT files\r\n"
            " /e=QQQ       Specifies you are working with .QQQ files\r\n"
            " /k=4096      Maximum main buffer size (ie 4096=4 megs)\r\n"
            );
    exit(1);
}
void            getoptions(void)
{
    char            buf[80];
    if (paramswitch("/?"))
        showhelp();
    if (paramswitch("-?"))
        showhelp();
    if (paramswitch("/e"))
        strcpy(pkte, paramval("/e"));
    if (paramswitch("-e"))
        strcpy(buf, paramval("-e"));
    if (paramswitch("/a"))
        strcpy(areasbbs, paramval("/a"));
    if (paramswitch("-a"))
        strcpy(areasbbs, paramval("-a"));
    if (paramswitch("/k"))
        maxbufsize=atol(paramval("/k"))*1024;
    if (paramswitch("-k"))
        maxbufsize=atol(paramval("-k"))*1024;
    if (pkte[0] == 0)
        strcpy(pkte, ".PKT");
    if (pkte[0] == '.')
        memmove(pkte, pkte + 1, strlen(pkte));
    strupr(pkte);
}

unsigned long largestpktsize(void)
{
    long            index;
    unsigned long lastcrc=0;
    unsigned long lastpktsize=0;
    unsigned long largestpkt=0;
    for (index = 0; index < totaldirfiles; index++)
        if (dirfiles[index].name[0])
         {
          if (dirfiles[index].crc!=lastcrc)
           {
            lastpktsize=0;
            lastcrc=dirfiles[index].crc;
           }
            lastpktsize+=dirfiles[index].size;
            if (lastpktsize > largestpkt) largestpkt=lastpktsize;
         }
   largestpkt += 4096;
   largestpkt /= 4096;
   largestpkt *= 4096;   // _really_ nasty way to round off to the nearest 4k..
   largestpkt += 65536;  // extra padding for multiple files..
   if (largestpkt >= maxbufsize) largestpkt=maxbufsize;
   return largestpkt;
}



void            main(int argc, char *argv[])
{
    long            total,
                    secs,
                    rems,
                    i;


    for (i = 0; i < 50; i++)
        if (argv[i]) {
            _argv[i] = argv[i];
            printf("%u - %s\n", i, argv[i]);
        } else {
            argv[i] = NULL;
            i = 100;
        }
    _argc = argc;

    imitate_borland();
    directvideo = 1;
    clrscr();
    setvbuf(stdout, NULL, _IONBF, 0);   /* Allows messages to print
                                         * immediately */
    textattr(0x1e);
    clreol();
    cprintf("Psrt General-Purpose .PKT file sorter + filter\r\n");
    clreol();
    cprintf("Copyright 1994 by Jason Fesler.  All rights reserved.\r\n");
    textattr(0x0b);
    getoptions();

    readareasbbs();
    getdirfiles();
    if (!totaldirfiles) {
        cprintf("No files to process.\r\n");
        exit(0);
    }

    readbuffer = (char *) sim_calloc(1, 32768);
    readbuffersize = 32768;
    if (!readbuffer) {
        cprintf("* No read buffer available.  Continuing anyways..\r\n");
        goto doit;
    } else
        cprintf(" Fast read buffering enabled\r\n");

    writebuffer = (char *) sim_calloc(1, 32768);
    writebuffersize = 32768;
    if (!writebuffer) {
        cprintf("* No write buffer available.  Continuing anyways..\r\n");
        goto doit;
    } else
        cprintf(" Fast write buffering enabled\r\n");


    total = 65000 / sizeof(msgpointer);
tryindexagain:
    if (total < 100) {
        cprintf("* Not enough conventional ram to hold indexes.  Aborting..\r\n");
        exit(1);
    }
    msgptr = (msgpointer *) calloc(sizeof(msgpointer), total);
    if (!msgptr) {
        cprintf(" Allocating %lu indexes \r", total);
        total -= 10;
        goto tryindexagain;
    }
    cprintf(" Index can hold %lu messages\r\n", total);
    MAXPTRS = total;




    masterbuf = NULL;
    mastersize = largestpktsize();
    while (!masterbuf) {
        masterbuf = (char *) calloc(1, mastersize + 32768);
        if (!masterbuf) {
            if (mastersize > 128000) {  // work our way down
                mastersize -= 4096;
            } else {
        nomem:
                cprintf("Not enough memory.\r\n");
                exit(255);
            }
        }
    }                           // end while
    masterbuf = (char *) realloc((void *) masterbuf, mastersize);
    mastersize -= 65536;
    if (!masterbuf)
        goto nomem;

    cprintf(" Master buffer: %lu\r\n", mastersize);
    cprintf(" (Roughly between %lu and %lu messages, depending on size)\r\n", (mastersize / 16384), (mastersize / 1500));






    textattr(0x08);
    cprintf("");
    window(1, c_ti.cury + 1, 80, c_ti.screenheight);
                        
doit:
    textattr(0x03);
    /* Let's do it! */
    parse_fastdir(process_first_packet, 0);

    cprintf("\r\nRenaming .NEW files to %s files\r\n", pkte);

    parse_dir(".NEW", 0, make_new_pkt);

    total = clock();
    if (!total)
        total++;
    secs = total / 100;
    rems = total % 100;
    textattr(3 + 8);
    cprintf(" Time spent: %lu.%lu seconds\r\n"
    " messages: %lu in, %lu out.\r\n", secs, rems, totalmsgsin, totalmsgs);
    total = (totalmsgsin + totalmsgs) * 5000 / total;
    secs = total / 100;
    rems = total % 100;
    if (rems > 49)
        secs++;
    cprintf(" %lu per second (average msgs in->out time, including overhead).\r\n", secs, rems);
    window(1, 1, 80, c_ti.screenheight);
    gotoxy(1, c_ti.screenheight);
    textattr(7);
    cprintf("\r\n");
    exit(0);
}
