#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char            asciiaddress[256];
unsigned long   net, node;
char            hexaddress[256];
char            dirname[256];


/* #DEFINE DEBUG */


int
makebusy(char *base)
{
	char            buf[256];
	FILE           *f;
	sprintf(buf, "%s.bsy", base);
	printf("Busying %s\n", base);
	f = fopen(buf, "r");
	if (f) {
		fclose(f);
		printf("File %s already busy\n", base);
		return -1;
	}
	f = fopen(buf, "w");
	if (f) {
		fclose(f);
		return 1;
	}
	printf("File %s already busy\n", base);
	return -1;
}
void
unbusy(char *base)
{
	char            buf[256];
	FILE           *f;
	sprintf(buf, "%s.bsy", base);
	printf("Unlinking %s\n", buf);
	unlink(buf);
}

int
exist(char *name)
{
	FILE           *file;
	file = fopen(name, "r");
	if (file) {
		fclose(file);
		return 1;
	}
	return 0;
}

char           *
safename(char *inname)
{
	char            buf[256];
	static char     bigbuf[256];
	char           *p;

	strcpy(buf, inname);
loop:
	sprintf(bigbuf, "%s%s", dirname, buf);
#ifdef DEBUG
	printf("checking %s\n", bigbuf);
#endif
	if (!exist(bigbuf))
		return bigbuf;
#ifdef DEBUG
	printf("buf=%s not available, trying new name\r", buf);
#endif
	if (strchr(buf, '.') == NULL) {
		strcat(buf, ".001");
		goto loop;
	}
	p = buf + (strlen(buf) - 1);
	while (p > buf) {
		if (*p == '.') {
			p--;
			continue;
		} else if (*p == '9') {
			*p = 'a';
			break;
		} else if ((*p == 'f') || (*p == 'F')) {
			*p = '0';
			p--;
			if (p == buf) {
				sprintf(bigbuf, "!%s", buf);
				strcpy(buf, bigbuf);
				goto loop;
			}
		} else {
			(*p)++;
			break;
		}
	}
	goto loop;

	return NULL;
}

char           *
safepktname(char *inname)
{
	char            buf[256];
	static char     bigbuf[256];
	char           *p;

	strcpy(buf, inname);
loop:
	sprintf(bigbuf, "%s%s", dirname, buf);
#ifdef DEBUG
	printf("checking %s\n", bigbuf);
#endif
	if (!exist(bigbuf))
		return bigbuf;
#ifdef DEBUG
	printf("buf=%s not available, trying new name\r", buf);
#endif
	p = buf;
	while (*p) {
		if (*p == '.') {
			p++;
			continue;
		} else if (*p == '9') {
			*p = 'a';
			break;
		} else if ((*p == 'f') || (*p == 'F')) {
			*p = '0';
			p++;
		} else {
			(*p)++;
			break;
		}
	}
	goto loop;

	return NULL;
}



void 
copyfilevia4dos(char *fname, char *tname, int move)
{
	char            buf[512];

	if (move) {
		sprintf(buf, "move %s %s", fname, tname);
	} else {
		sprintf(buf, "copy %s %s", fname, tname);
	}
	printf("SYSTEM> %s\n", buf);
	system(buf);
}
void 
copyfile(char *fname, char *tname, int move)
{
	char            buf[512];
        sprintf(buf, "copy %s %s", fname, tname);
	printf("SYSTEM> %s\n", buf);
	system(buf);
        if (move) if (exist(tname)) unlink(fname);
}

void 
movepacket(char *ext)
{
	char            buf[256];
	char            buf2[256];
	char            newname[256];
	sprintf(buf, "%s.%s", hexaddress, ext);
	if (exist(buf)) {
		sprintf(buf2, "%s.pkt", hexaddress);
		strcpy(newname, safepktname(buf2));
		copyfile(buf, newname, 1);
	}
}

void 
movepackets(void)
{
	movepacket("cut");
	movepacket("dut");
	movepacket("out");
	movepacket("iot");
	movepacket("hut");
}
void 
moveflo(char *ext)
{
	char            buf[256];
	FILE           *f;
	char           *filename;
	char           *smallname;
	char            newname[256];
	int             move = 0;

	sprintf(buf, "%s.%s", hexaddress, ext);
	f = fopen(buf, "rt");
	if (!f)
		return;
	while (feof(f) == 0) {
		buf[0] = 0;
		fgets(buf, sizeof(buf), f);
		if (strpbrk(buf, "\r\n"))
			*strpbrk(buf, "\r\n") = 0;
		if (buf[0] == 0)
			continue;
		if (buf[0] == ';')
			continue;
		filename = buf;
		if (buf[0] == '^') {
			filename = buf + 1;
			move = 1;
		}
		if (buf[0] == '#') {
			filename = buf + 1;
			move = 2;
		}
		smallname = filename;
		while (strpbrk(smallname, "\\/"))
			smallname++;
#ifdef DEBUG 
		printf("filename=%s  smallname=%s\n", filename, smallname);
#endif
		strcpy(newname, safename(smallname));
#ifdef DEBUG
		printf("safename=%s\n", newname);
#endif
		copyfile(filename, newname, move);
	}
	fclose(f);
	sprintf(buf, "%s.%s", hexaddress, ext);
	printf("Unlinking %s\n", buf);
	unlink(buf);
}


void 
moveflos(void)
{
	moveflo("clo");
	moveflo("dlo");
	moveflo("flo");
	moveflo("ilo");
	moveflo("hlo");
}


void
banner(void)
{
	printf(
	       "Netflo 2.0   Copyright 1993,1995 by Jason Fesler.  All rights reserved.\n"
	       "If you paid anything for this program, you got ripped off!\n\n"
	);
}
void
helpexit(char *progname)
{
	printf(
		" Usage: %s net/node c:\\dest\\dirname\\ \n\n", progname);
printf(
"NetFlo is a utility that will scan your Binkley-style outbound for\n"
"outgoing mail and file attaches (*.OUT, *.FLO, etc), for delivery\n"
"via a LAN.  It will move any mail and file attaches to the directory\n"
"of your choice.  To use .. \n"
"Switch to your binkley style outbound directory.    CD \\OUTBOUND\\\n"
"Run netflo to where you want to send it             NETFLO 203/2 \\GATEWAY\\IN\n"
"\nIf you want to deliver mail for a point, you need to do things a bit\n"
"differently.  Switch to the point directory, and then use 0/POINTNUM.\n"
"ie,    CD \\OUTBOUND\\00CB1E1B.PNT\n"
"       NETFLO 0/1  \\POINTDIR\\INBOUND          (delivers 203/7707.1)\n"
"\nThis program is free to use, but may not be sold, packaged, etc\n"
"without the express written permission of the author.\n"
"Netflo is Copyright 1993,1995 by Jason Fesler.  All rights reserved.\n");
	exit(1);
}

void
main(int argc, char *argv[])
{
	char           *p;
	if (argc != 3)
		helpexit(argv[0]);
	strcpy(asciiaddress, argv[1]);
	strcpy(dirname, argv[2]);
	if (dirname[strlen(dirname) - 1] != '\\')
		strcat(dirname, "\\");

	p = strpbrk(asciiaddress, ":");
	if (p)
		helpexit(argv[0]);
	p = strpbrk(asciiaddress, "\\/");
	if (p) {
		*p = 0;
		p++;
		net = atol(asciiaddress);
		node = atol(p);
	} else
		helpexit(argv[0]);
	banner();
	printf("Delivering %lu/%lu to %s\n", net, node, dirname);
	sprintf(hexaddress, "%04lx%04lx", net, node);
	printf("Using bink number %s\n", hexaddress);
	if (makebusy(hexaddress) > 0) {
		movepackets();
		moveflos();
		unbusy(hexaddress);
	}
}
