{ Universal TObject, TCollection and some more }

{$i def.inc}

unit UniOBJ;
interface
uses
  {$IFDEF VIRTUALPASCAL}Use32,{$ENDIF}
  {$IFDEF SysUtils}SysUtils,
  {$ELSE}Strings,
  {$ENDIF}
  Upper;

const
{ TCollection error codes }
  coIndexError = -1;              { Index out of range }
  coOverflow   = -2;              { Overflow }

  MaxCollectionSize:integer = 65520 div SizeOf(Pointer);

type
  {$IFnDEF SysUtils}PString = ^string;{$ENDIF}

  PObject = ^TObject;
  TObject = object
    constructor init;
    destructor done; virtual;
    procedure Free;
  end;

  PItemList = ^TItemList;
  TItemList = array[0..0] of Pointer;

{ TCollection object }

  PCollection = ^TCollection;
  TCollection = object(TObject)
    Items: PItemList;
    Count: Integer;
    Limit: Integer;
    Delta: Integer;
    constructor Init(ALimit, ADelta: Integer);
{    constructor Load(var S: TStream);}
    destructor Done; virtual;
    function At(Index: Integer): Pointer;
    procedure AtDelete(Index: Integer);
    procedure AtFree(Index: Integer);
    procedure AtInsert(Index: Integer; Item: Pointer);
    procedure AtPut(Index: Integer; Item: Pointer);
    procedure Delete(Item: Pointer);
    procedure DeleteAll;
    procedure Error(Code, Info: Integer); virtual;
{    function FirstThat(Test: Pointer): Pointer;}
    procedure ForEach(Action:pointer);
    procedure Free(Item: Pointer);
    procedure FreeAll;
    procedure FreeItem(Item: Pointer); virtual;
{    function GetItem(var S: TStream): Pointer; virtual;}
    function IndexOf(Item: Pointer): Integer; virtual;
    procedure Insert(Item: Pointer); virtual;
{    function LastThat(Test: Pointer): Pointer;}
    procedure Pack;
{    procedure PutItem(var S: TStream; Item: Pointer); virtual;}
    procedure SetLimit(ALimit: Integer); virtual;
{    procedure Store(var S: TStream);}
  private
    procedure Chk(Index:integer);
  end;

{ TSortedCollection object }

  PSortedCollection = ^TSortedCollection;
  TSortedCollection = object(TCollection)
    Duplicates: Boolean;
    constructor Init(ALimit, ADelta: Integer);
{    constructor Load(var S: TStream);}
    function Compare(Key1, Key2: Pointer): Integer; virtual;
    function IndexOf(Item: Pointer): Integer; virtual;
    procedure Insert(Item: Pointer); virtual;
    function KeyOf(Item: Pointer): Pointer; virtual;
    function Search(Key: Pointer; var Index: Integer): Boolean; virtual;
{    procedure Store(var S: TStream);}
  end;

{ TStringCollection object }

  PStringCollection = ^TStringCollection;
  TStringCollection = object(TSortedCollection)
    function Compare(Key1, Key2: Pointer): Integer; virtual;
    procedure FreeItem(Item: Pointer); virtual;
{    function GetItem(var S: TStream): Pointer; virtual;
    procedure PutItem(var S: TStream; Item: Pointer); virtual;}
  end;

{ TStrCollection object }

  PStrCollection = ^TStrCollection;
  TStrCollection = object(TSortedCollection)
    function Compare(Key1, Key2: Pointer): Integer; virtual;
    procedure FreeItem(Item: Pointer); virtual;
{    function GetItem(var S: TStream): Pointer; virtual;
    procedure PutItem(var S: TStream; Item: Pointer); virtual;}
  end;


procedure Abstract;
procedure StrDispose(Str:PChar); { In VP/2 SysUtils some bug (?) }
{$IFnDEF SysUtils}
function NewStr(const S: String): PString;
procedure DisposeStr(P: PString);
{$ENDIF}

IMPLEMENTATION

procedure Abstract;
begin
     RunError(211);
end;

type str1 = string[1];
const StrAdd = SizeOf(str1)-1;

procedure StrDispose(Str:PChar);
begin
     if Str<>NIL then FreeMem(Str,StrLen(Str));
end;

{$IFnDEF SysUtils}

function NewStr(const S: String): PString;
var p:PString;
begin
     GetMem(p,StrAdd+length(s));
     p^:=s;
     NewStr:=p;
end;

procedure DisposeStr(P: PString);
begin
     if p<>NIL then FreeMem(p,StrAdd+length(p^));
end;
{$ENDIF}

constructor TObject.init;
begin
     FillChar(PChar(@Self)[SizeOf(TObject)],SizeOf(Self)-SizeOf(TObject),0);
end;

destructor TObject.done;
begin
end;

procedure TObject.Free;
begin
     Dispose(PObject(@Self),Done);
end;

{ TCollection }

constructor TCollection.Init(ALimit, ADelta: Integer);
begin
     inherited Init;
     Delta := ADelta;
     SetLimit(ALimit);
end;

destructor TCollection.Done;
begin
     FreeAll;
     SetLimit(0);
end;

procedure TCollection.Chk;
begin
     if (Index>=Count) or (Index<0) then Error(coIndexError,0);
end;

function TCollection.At(Index:integer):pointer;
begin
     Chk(Index);
     At:=Items^[Index];
end;

procedure TCollection.AtDelete(Index: Integer);
begin { - }
     Chk(Index);
     dec(Count);
     if Index<Count then move(Items^[Index+1],Items^[Index],(Count-Index)*SizeOf(pointer));
     Items^[Count]:=NIL;
end;

procedure TCollection.AtFree(Index: Integer);
var Item: Pointer;
begin { - }
     Item:=At(Index);
     AtDelete(Index);
     FreeItem(Item);
end;

procedure TCollection.AtInsert(Index: Integer; Item: Pointer);
var i:integer;
begin

     if Index<Count then begin
        if Count=Limit then SetLimit(Limit+Delta);
        move(Items^[Index],Items^[Index+1],(Count-Index)*SizeOf(pointer));
        inc(Count);
     end else begin
         if Index>=Limit then SetLimit(Limit+Delta);
         Count:=Index+1;
     end;
     Items^[Index]:=Item;
end;

procedure TCollection.AtPut(Index:integer; Item:pointer);
begin
     Chk(Index);
     Items^[Index]:=Item;
end;

procedure TCollection.Delete(Item:pointer);
begin
     AtDelete(IndexOf(Item));
end;

procedure TCollection.DeleteAll;
begin
     Count:=0;
end;

procedure TCollection.Error(Code,Info:integer);
begin
     RunError(212-Code);
end;

procedure TCollection.ForEach(Action:pointer);
var i:integer;
    p:procedure(Item:pointer);
begin
{     p:=Action;
     for i:=0 to Count-1 do p(At(i));}
abstract;
end;

procedure TCollection.Free(Item:pointer);
begin
     Delete(Item);
     FreeItem(Item);
end;

procedure TCollection.FreeAll;
var i:Integer;
begin
     for i:=0 to Count-1 do FreeItem(Items^[i]);
     Count:=0;
end;

procedure TCollection.FreeItem(Item:pointer);
begin
     if Item<>nil then PObject(Item)^.Free;
end;

function TCollection.IndexOf(Item:pointer):Integer;
var i:integer;
begin
     for i:=0 to Count-1 do if Items^[i]=Item then begin
         IndexOf:=i;
         exit;
     end;
     IndexOf:=-1;
end;

procedure TCollection.Insert(Item:pointer);
begin
     AtInsert(Count,Item);
end;

procedure TCollection.SetLimit(ALimit: Integer);
var AItems: PItemList;
begin
  if ALimit < Count then ALimit:=Count;
  if ALimit > MaxCollectionSize then ALimit:=MaxCollectionSize;
  if ALimit <> Limit then begin
     if ALimit=0 then AItems:=nil else begin
        GetMem(AItems, ALimit*SizeOf(Pointer));
        if (Count<>0) and (Items<>nil) then
           Move(Items^,AItems^,Count*SizeOf(Pointer));
     end;
     if Limit <> 0 then FreeMem(Items,Limit*SizeOf(Pointer));
     Items := AItems;
     Limit := ALimit;
  end;
end;

procedure TCollection.Pack;
var p:pointer;
    i,i1:integer;
begin
     i1:=0;
     for i:=0 to Count-1 do if Items^[i]<>NIL then begin
         Items^[i1]:=Items^[i];
         inc(i1);
     end;
     Count:=i1;
end;

{ TSortedCollection }

constructor TSortedCollection.Init(ALimit, ADelta: Integer);
begin
     inherited init(ALimit, ADelta);
     Duplicates:=False;
end;

function TSortedCollection.Compare(Key1,Key2:Pointer):Integer;
begin
  Abstract;
end;

function TSortedCollection.IndexOf(Item: Pointer): Integer;
var I:Integer;
begin
  IndexOf := -1;
  if Search(KeyOf(Item), I) then
  begin
    if Duplicates then
      while (I < Count) and (Item <> Items^[I]) do Inc(I);
    if I < Count then IndexOf := I;
  end;
end;

procedure TSortedCollection.Insert(Item:pointer);
var I:Integer;
begin
  if not Search(KeyOf(Item),I) or Duplicates then AtInsert(I,Item);
end;

function TSortedCollection.KeyOf(Item:pointer):pointer;
begin
     KeyOf := Item;
end;

function TSortedCollection.Search(Key: Pointer; var Index: Integer): Boolean;
var
  L, H, I, C: Integer;
begin
  Search := False;
  L := 0;
  H := Count - 1;
  while L <= H do
  begin
    I := (L + H) shr 1;
    C := Compare(KeyOf(Items^[I]), Key);
    if C < 0 then L := I + 1 else
    begin
      H := I - 1;
      if C = 0 then
      begin
        Search := True;
        if not Duplicates then L := I;
      end;
    end;
  end;
  Index := L;
end;

{ TStringCollection }

function TStringCollection.Compare(Key1, Key2: Pointer): Integer;
begin
     if PString(Key1)^<PString(Key2)^ then Compare:=-1
     else if PString(Key1)^>PString(Key2)^ then Compare:=1
     else Compare:=0;
end;

procedure TStringCollection.FreeItem(Item: Pointer);
begin
     DisposeStr(Item);
end;

{ TStrCollection }

function TStrCollection.Compare(Key1, Key2: Pointer): Integer;
begin
  Compare := StrComp(Key1,Key2);
end;

procedure TStrCollection.FreeItem(Item: Pointer);
begin
  StrDispose(Item);
end;


BEGIN
     if SizeOf(integer)>2 then MaxCollectionSize:=high(integer);
END.

