{$i def.inc}
unit OS2EA;
interface
{$IFDEF OS2}
uses Strings,OS2Def,OS2Base;
type SizeInt=ULong;
const EAError:ApiRet=0;
{$ELSE}
uses Strings;
type SizeInt=integer;
const OS2Error:longint=0;
{$ENDIF}

function OS2Get1EA(Name,EAName:PChar; var Buf:pointer; var BufSize:longint; var Start:PChar):SizeInt;


IMPLEMENTATION

{$IFnDEF OS2}
function DosQueryPathInfo(PathName: PChar; InfoLevel: word; var InfoBuf;
  cbInfoBuf: SizeInt):integer;
assembler;
asm
   les di,InfoBuf
   mov cx,cbInfoBuf
   mov dx,InfoLevel
   mov ax,5702h
   mov bx,0FFFFh
   push ds
   lds si,PathName
   int 21h
   pop ds
   jnc @ERR
   xor ax,ax
@ERR:
end;
{$ENDIF}

type  { EAOP2 }
  TR1 = record
    Size:longint;
    {$IFDEF OS2}NextOfs:longint;{$ENDIF}
    NameSize:byte;
    Name:array [0..255] of char;
    Align:array [0..4] of byte;
  end;

  TR2 = record
    Size:longint;
    {$IFDEF OS2}NextOfs:longint;{$ENDIF}
    Flag:byte;
    NameSize:byte;
    ValSize:word;
    Data:array [0..1024] of char;
  end;

  TR0 = record
    R1:^TR1;
    R2:^TR2;
    Error:longint;
  end;

function OS2Get1EA;
var R:TR0;
    R2:^TR2;
    R1:TR1;
    i,p:longint;
begin
     OS2Get1EA:=0;
     R2:=Buf;
     R.R2:=Buf;
     R.Error:=0;

     FillChar(R1,SizeOf(R1),0);
     R.R1:=@R1;
     while (longint(R.R1) and 3)<>0 do inc(longint(R.R1));

     i:=StrLen(EAName);
     R.R1^.NameSize:=i;
     R.R1^.Size:=i+SizeOf(R1)-SizeOf(R1.Name)-SizeOf(R1.Align)+1;
     {$IFDEF OS2}R.R1^.NextOfs:=0;{$ENDIF}
     StrCopy(R.R1^.Name,EAName);

     FillChar(R2^,BufSize,0);
     R2^.Size:=BufSize-16;
     repeat
           if DosQueryPathInfo(Name,3,R,SizeOf(R))<>0 then exit;
           i:=R2^.Size;
           {$IFnDEF OS2}
           if i>65530 then i:=65530;
           {$ENDIF}
           if BufSize<i then begin
              FreeMem(Buf,BufSize);
              BufSize:=R2^.Size;
              GetMem(Buf,BufSize)
           end else Break;
     until false;
     if i<=8 then exit;
     i:=R2^.ValSize;
     if i=0 then exit;
     dec(i,4);
     Start:=@R2^.Data[R2^.NameSize+5];
     OS2Get1EA:=i;
end;

END.

