Program ITC_usered;
Uses dos, crt, palett;
Const
	MaxScr=25;
   Ver='v0.1.12';

Type

	Spec_line = Record
		line : String[64];
		i : Integer;
	End;

	UserRec = Record {USER.DAT}
		Name     : string[40];
		Location : string[40];
		Comment  : string[40];
		PassWord : string[20];
		BirthDate: string[8];
		Phone    : string[20];

		FirstDate  : string[8];
		MsgMailed  : word;
		MsgReceived: word;
		Calls      : word;
		Lines      : byte;

		LastTime: string[8];
		LastDate: string[8];
		LastConf: word;

		TimeDay : integer;
		TimeLeft: integer;
		TimeBank: word;

		AcsLevel  : byte;
		AcsFlag   : byte;
		PointRatio: byte;
		FilePoints: longint;

		ULFiles: word;
		DLFiles: word;
		ULkB   : longInt;
		DLkB   : longInt;

		NewUser  : boolean;
		Protected: boolean;
		Deleted  : boolean;
		Xpert    : boolean;
		Hidden   : boolean;
		Disabled : boolean;

		SubEnabled  : boolean;
		ResetDate   : string[8];
		ResetProfile: byte;
	End;

	ProfileRec = Record {PROFILE.DAT}
		Comment: string[40];

		TimeDay   : word;
		AcsLevel  : byte;
		AcsFlag   : byte;
		FilePoints: word;
		PointRatio: byte;

		NewUser   : boolean;
		Protected : boolean;
		Deleted   : boolean;
		Hidden    : boolean;
		Disabled  : boolean;

		SubEnabled: boolean;
		SubDays : word;
		SubReset: byte;
	End;

Var
	UserFile		: File of UserRec;
   UserFTemp 	: UserRec;
   ProfileFile	: File of ProfileRec;
   ProfileFTemp: ProfileRec;
   UserdatStr  : String[12];
   regs 			: registers;
   Help			: Array [1..200] of String[70];
	xold, yold	: Byte;
   temp : word;

	ItcStrTemp : spec_line;
	ItcStr	: String[24];
	ItcStr2	: String[24];
   FlagStr  : String[8];
   Quit		: Boolean;
   ChangeMade : Boolean;
   B1			: Char;
   ButtonNr	: Byte;
   UserNum	: LongInt;
   MaxUser	: LongInt;
	Video0	: ARRAY[1..4000] OF WORD ABSOLUTE $B800:$0000;
	Video1	: ARRAY[1..4000] OF WORD ABSOLUTE $B800:$1000;

{$I my_readln.prc}
{}
Procedure vpm1;
	Var
   	loops : Word;
	Begin
      For loops := 1 to 4000 Do
      		 Video1[loops] := Video0[loops]
	End;
{}
Procedure vpm2;
	Var
   	loops : Word;
	Begin
      For loops := 1 to 4000 Do
			Video0[loops] := Video1[loops];
	End;
{}
Procedure wsc( ascii, x, y : Byte ); { Original : write_spec_char }
	Begin
      GotoXY( x,y );
      regs.ah := $09;
      regs.al := ascii;
      regs.bl := $09;
      regs.cx := 1;
      Intr( $10, regs );
		GotoXY( x+1,y );
   End;
{ Proc ^^ by Hung T /PG94 }
{}
Procedure EmptyUserRec;
Begin
	UserFTemp.Name     :='';
	UserFTemp.Location :='';
	UserFTemp.Comment  :=ProfileFTemp.Comment;
	UserFTemp.PassWord :='';
	UserFTemp.BirthDate:='00/00/00';
	UserFTemp.Phone    :='';

	UserFTemp.FirstDate  :='00/00/00';
	UserFTemp.MsgMailed  :=0;
	UserFTemp.MsgReceived:=0;
	UserFTemp.Calls      :=0;
	UserFTemp.Lines      :=24;

	UserFTemp.LastTime:='00:00:00';
	UserFTemp.LastDate:='00/00/00';
	UserFTemp.LastConf:=1;

	UserFTemp.TimeDay :=ProfileFTemp.TimeDay;
	UserFTemp.TimeLeft:=30;
	UserFTemp.TimeBank:=0;

	UserFTemp.AcsLevel  :=ProfileFTemp.AcsLevel;
	UserFTemp.AcsFlag   :=ProfileFTemp.AcsFlag;
	UserFTemp.PointRatio:=ProfileFTemp.PointRatio;
	UserFTemp.FilePoints:=ProfileFTemp.FilePoints;

	UserFTemp.ULFiles:=0;
	UserFTemp.DLFiles:=0;
	UserFTemp.ULkB   :=0;
	UserFTemp.DLkB   :=0;

	UserFTemp.NewUser  :=ProfileFTemp.NewUser;
	UserFTemp.Protected:=ProfileFTemp.Protected;
	UserFTemp.Deleted  :=ProfileFTemp.Deleted;
	UserFTemp.Xpert    :=False;
	UserFTemp.Hidden   :=ProfileFTemp.Hidden;
	UserFTemp.Disabled :=ProfileFTemp.Disabled;

	UserFTemp.SubEnabled		:=ProfileFTemp.SubEnabled;
	UserFTemp.ResetDate		:='01/01/01';
	UserFTemp.ResetProfile	:=ProfileFTemp.SubReset;
End;

{}
Procedure HelpProc;
Var
Varv		: byte;
Quit2		: boolean;
Falt		: byte;

Begin
	Falt:=1;

	Window(4,4,76,21);
   TextAttr:=$1B;
   Clrscr;
   Write('');
   GotoXY(27,1);
	TextAttr:=$17;
   Write(' iNSTiNCT '+ver+' HELP ');

   TextAttr:=$1B;
   Writeln;
   Writeln(' iTC USER EDiTOR 4 iTC - Copyright (C) 1995 By Tien Huynh [PG95] ');
   Writeln(' Disclaimer: I''m not responsible for any damages caused by this program.');
	Writeln(' Ŀ');
   Writeln('  Command:          Keys:                    ');
   Writeln('  New User          Ins                      ');
   Writeln('  Remove User       Del                      ');
   Writeln('  Select User       Page Up/Page Down        ');
   Writeln('  First/Last User   Home/End                 ');
   Writeln('  Find User         Alt-F                    ');
   Writeln(' ');
	Writeln(' ');
   Writeln(' USER.DAT is automatically saved after changes.');
   Writeln(' ');
   Writeln(' ');
   Writeln(' <press any key to continue> ');
   Write('');
   Window(1,1,80,25);
   TextAttr:=$08;
   For varv:=5 To 20 Do Begin
      GotoXY(77,varv);
   	Write('');
   End;
   GotoXY(4,21);
	Write('  ');

   Readkey;
End;
{}
Procedure _init_help;
Begin
  	help[1] := ' PRESS ENTER TO CONFiRM, iF NOTHING ENTERED - iNPUT ABORTED';
   help[2] := ' USE THE FORM : MM/DD/YY';
   help[3] := ' ';
   help[4] := ' SET FLAG ON/OFF WiTH SPACE, ESC TO QUiT ';

   help[11] := ' USER FiLEPOiNTS (-1000000..1000000)';
   help[12] := ' USER FiLEPOiNT RATiO (1..9)';
   help[13] := ' USER ACCESS LEVEL (1..255)';
	help[14] := ' USER ACCESS FLAGS';

   help[21] := ' FiLES UL:ED BY USER';
   help[22] := ' FiLES DL:ED BY USER';
   help[23] := ' kB UL:ED BY USER';
   help[24] := ' kB DL:ED BY USER';

   help[31] := ' DATE TO END SUBSCRiPTiON';
   help[32] := ' END SUBSCRiPTiON FALLBACK PROFiLE (1..10)';
   help[33] := ' USER TOGGLES';

   help[41] := ' TiME (MiN) AVAiLABLE TO USER PER DAY';
   help[42] := ' TiME (MiN) LEFT TODAY';
   help[43] := ' TiME (MiN) STORED IN TiMEBANK';
   help[44] := ' FiRST TiME ON';
   help[45] := ' MESSAGES MAiLED BY USER';
   help[46] := ' MESSAGES RECEiVED BY USER';
   help[47] := ' CALLS MADE BY USER';
   help[48] := ' LiNES PER SCREEN';
   help[49] := ' LAST TiME ON';
   help[50] := ' LAST DATE ON';
   help[51] := ' LAST CONFERENCE USER WAS iN ';

   help[101] := ' USER''S NAME';
   help[102] := ' USER LOCATiON/GROUP';
   help[103] := ' COMMENT';
   help[104] := ' PASSWORD';
   help[105] := ' TELEPHONE NUMBER';
   help[106] := ' DAY OF BiRTH - MM/DD/YY';
   help[107] := ' ACCESS LEVEL AND FLAGS';
   help[108] := ' AMOUNT OF UL,DL,FiLEPOiNTS AND RATiO';
   help[109] := ' THiNGS ABOUT SUBSCRiPTiON & SOME TOGGLES';
   help[110] := ' TiME AND CALL STATiSTiCS';

   help[100] := ' MAN OF THE YEAR, TiME 1994    +<:-)';
 {  help[50] := ' +<:-)              SiMCiTY 2000 URBAN RENEWEL KiT             (-:>+';}
End;
{}
Procedure helpwin(strnum:byte);
Const tom = ' ';
Var
	x,y : byte;
   ta	 : word;
Begin
	x:=wherex;
   y:=wherey;
   ta:=TextAttr;
   GotoXY(6,19);
   TextAttr:=$0F;
	Write(tom:69);
   GotoXY(6,19);
   Write(Help[strnum]);
   GotoXY(x,y);
   TextAttr:=ta;
End;

{}
Function  DeleteRecs(Var AFile; From, Count : LongInt; BufSize : Word) : Integer ;

{ AFile   : any typed or untyped file (not Text), must be opened           }
{ From    : number of 1st record to delete, 0-based                        }
{ Count   : number of record(s) to delete                                  }
{ BufSize : size of the buffer to allocate. Must be > record size          }

Var  Buffer    : Pointer ;              { pointer to buffer                }
     Src       : LongInt ;              { source record pointer            }
     Cnt       : LongInt ;              { scratch                          }
     Last      : LongInt ;              { last record to move              }
     f         : File Absolute AFile ;  { file we're going to work on      }
     Err       : Integer ;              { error code                       }
Label
     Sortie ;
Begin
     Last:=FileSize(f) ;
     Src:=From+Count ;
     If Count>(Last-From) Then Count:=Last-From ;

     { check BufSize against FileRec(f).RecSize }
     If (BufSize<FileRec(f).RecSize) Or
        (MaxAvail<BufSize) Then
     Begin
          DeleteRecs:=1 ; { error }
          Exit ;
     End ;

     GetMem(Buffer, BufSize) ;

     While Src<Last Do
     Begin
          Cnt:=BufSize Div FileRec(f).RecSize ;
          If (Src+Cnt)>Last Then Cnt:=Last-Src ;
          Seek(f, Src) ;
          BlockRead(f, Buffer^, Cnt) ;
          { error check }
          Err:=IOResult ;
          If Err<>0 Then GoTo Sortie ;
          Seek(f, From) ;
          BlockWrite(f, Buffer^, Cnt) ;
          { error check }
          Err:=IOResult ;
          If Err<>0 Then GoTo Sortie ;
          Inc(Src, Cnt) ;
          Inc(From, Cnt) ;
     End ;

     Seek(f, Last-Count) ;
     Truncate(f) ;
Sortie:
     DeleteRecs:=Err ;
     FreeMem(Buffer, BufSize) ;
End;
{}
Procedure ReadProfiledat;
Begin
	Assign(ProfileFile,ItcStr2+'\profile.dat');
   Reset(ProfileFile);
	Read(ProfileFile,ProfileFTemp);
   Close(ProfileFile);
End;
{}
Procedure ReadUserdat(UserNum:Byte);
Begin
	{$I-}
	Assign(UserFile,ItcStr2+UserdatStr);
   Reset(UserFile);
   Seek(UserFile,UserNum);
   Read(UserFile,UserFTemp);
   {$I+}
   If IOResult<>0 Then Begin
     Window(1,1,80,25);
     Vpm2;
     TextAttr:=$0F;
     GotoXY(xold,yold);
     Writeln('A severe I/O error occured! Terminating Execution');
     Writeln(' AX=',regs.ax,' BX=',regs.bx,' CX=',regs.cx,' DX=',regs.bx);
     Writeln(' CS=',regs.ax,' DS=',regs.bx,' ES=',regs.cx,' SS=',regs.bx);
     Writeln(' IP=',regs.ax,' SI=',regs.bx,' DI=',regs.cx,' SP=',regs.bx,' BP=',regs.bx);
     Writeln;
     Writeln('In the year of our Lord .:95:. Tien Huynh''s user editor crashed');
     TextAttr:=$09;
     Halt(0);
   End;
   Close(UserFile);
End;
{}
Procedure _init_MaxUser;
Begin
   ReadUserdat(0);
   Assign(UserFile,ItcStr2+'\user.dat');
   Reset(UserFile);
   MaxUser:=FileSize(UserFile);
   Close(UserFile);
End;
{}
Procedure AddUser(UserNum:word);
Begin
	Assign(UserFile,ItcStr2+UserdatStr);
   Reset(UserFile);
   Seek(UserFile,MaxUser);
   EmptyUserRec;
	Write(UserFile,UserFTemp);
   Close(UserFile);
End;
{}
Procedure DelUser(UserNum:word);
Begin
	Assign(UserFile,ItcStr2+UserdatStr);
   Reset(UserFile);
   DeleteRecs(UserFile,UserNum,1,65000);
   Close(UserFile);
End;

{}
Procedure SaveUserdat(UserNum : word);
Begin
	Assign(UserFile,ItcStr2+UserdatStr);
   Reset(UserFile);
   Seek(UserFile,UserNum);
	Write(UserFile,UserFTemp);
   Close(UserFile);
End;

{}
Function FileCheck( s : string ): Boolean;
Begin
	{ Fastest solution }
	FileCheck := fSearch(UserdatStr,s) <> '';
End;

{}
Procedure Button(Num : Byte);
Begin
   TextBackground(White);
   TextColor(Black);
   GotoXY(20,23);
   Write('   SER  ');
   GotoXY(30,23);
   Write('   OAD  ');
   GotoXY(40,23);
   Write('   AVE  ');
   GotoXY(50,23);
   Write('   UiT  ');
   TextColor(White);
   GotoXY(22,23);
   Write('U');
   GotoXY(32,23);
   Write('L');
   GotoXY(42,23);
   Write('S');
   GotoXY(52,23);
   Write('Q');
   TextBackground(Black);
	TextColor(Darkgray);
   GotoXY(28,23);
   Write('');
   GotoXY(38,23);
   Write('');
   GotoXY(48,23);
   Write('');
   GotoXY(58,23);
   Write('');
	GotoXY(21,24);
   Write('      ');
   TextBackground(White);
   Case Num of
		1: Begin
			 GotoXY(22,23);
			 TextColor(Black); Write('U');
			 TextColor(White); Write('SER');
			End;
		2: Begin
          GotoXY(32,23);
			 TextColor(Black); Write('L');
			 TextColor(White); Write('OAD');
      	End;
		3:	Begin
          GotoXY(42,23);
			 TextColor(Black); Write('S');
			 TextColor(White); Write('AVE');
      	End;
		4: Begin
      	 GotoXY(52,23);
			 TextColor(Black); Write('Q');
			 TextColor(White); Write('UiT');
      	End;
   End;
End;
{}
Function Dec2Bin(Dec : Byte): String;
Var
BinStr : string[8];
dec2, num : byte;

Begin
dec2 := 128;

 For num:= 8 downto 1 do begin
  If (dec-dec2)>=0 Then Begin
    Binstr[num] := '1';
    dec:=dec-dec2;
   End Else Begin
    BinStr[num] := '0';
  End;
 dec2 := dec2 div 2;
 End;

 Dec2Bin:=BinStr;
End;

{}
Function FS2Dec(FS : String): Byte;
Var
dec2, num, dec : byte;

Begin
dec2 := 1;
dec := 0;

 For num:= 1 to 8 do begin
  If FS[num]='1' Then Begin
    dec := dec+dec2;
  End;
 dec2 := dec2 * 2;
 End;

 FS2Dec:=dec;
End;

{}
Procedure Main;
Begin
   FadeDown;
   TextBackground(Black);
   Clrscr;
   Delay(500);

   TextBackground(Blue);
   ClrEol;
   TextBackground(Black);
   TextColor(Blue);
   Writeln;
   Write(' ');
	TextColor(White);
	GotoXY(70,2);
   Write(' iNSTiNCT ');
   GotoXY(25,13);
   Write('Pre-Alfa,. '+ver+' Platin Group 95');
   GotoXY(25,14);
   Write('  iTC USER EDiTOR by Tien Huynh  ');

   TextBackground(Blue);
   TextColor(LightGray);
   GotoXY(1,25);
   ClrEol;
   Write('    - USER EDiTOR 4 iTC Version 1.00 - Copyright (C) 1995 By Caffer [PG95]');
   Button(1);
{ Drawing the fake buttons...}
	 FadeUp;

End;

{}
Procedure FieldFill(FieldNum, Y : Byte);
Const Tom = '';
Var
varv : word;
Begin
   With UserFTemp Do Begin
	Case FieldNum of
   99 : Begin End;
   1 : Begin
          TextAttr:=$08;
          For varv:=16 to 56 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(16,y);
          TextAttr:=$0F;
          Write(Name);
		End;
   2 : Begin
          TextAttr:=$08;
          For varv:=16 to 56 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(16,y);
          TextAttr:=$0F;
          Write(Location);
   	End;
	3 : Begin
			 TextAttr:=$08;
          For varv:=16 to 56 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(16,y);
          TextAttr:=$0F;
          Write(Comment);
   	End;
	4 : Begin
			 TextAttr:=$08;
          For varv:=16 to 56 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(16,y);
          TextAttr:=$0F;
          Write(Password);
   	End;
   5 : Begin
			 TextAttr:=$08;
			 For varv:=11 to 31 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(11,y);
          TextAttr:=$0F;
          Write(Phone);
   	End;
   6 : Begin
			 TextAttr:=$0F;
          GotoXY(11,11);
          Write(BirthDate);
   	End;
   71 : Begin
			 TextAttr:=$08;
          For varv:=20 to 28 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,5);
          TextAttr:=$0F;
          Write(FilePoints);
   	End;
   72 : Begin
          GotoXY(20,y);
          TextAttr:=$0F;
          Write('1/',PointRatio);
   	End;
   73 : Begin
			 TextAttr:=$08;
          For varv:=20 to 22 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,y);
          TextAttr:=$0F;
          Write(AcsLevel);
   	End;
	74 : Begin
          TextAttr:=$0F;
          ReadUserdat(UserNum);
          FlagStr:=Dec2Bin(AcsFlag);
          If FlagStr[1]='1' Then Begin GotoXY(21,8); Write('');
			  End Else Begin GotoXY(21,8); Write(' '); End;
          If FlagStr[2]='1' Then Begin GotoXY(21,9); Write('');
			  End Else Begin GotoXY(21,9); Write(' '); End;
          If FlagStr[3]='1' Then Begin GotoXY(21,10); Write('');
			  End Else Begin GotoXY(21,10); Write(' '); End;
          If FlagStr[4]='1' Then Begin GotoXY(21,11); Write('');
			  End Else Begin GotoXY(21,11); Write(' '); End;
          If FlagStr[5]='1' Then Begin GotoXY(21,12); Write('')
			  End Else Begin GotoXY(21,12); Write(' '); End;
          If FlagStr[6]='1' Then Begin GotoXY(21,13); Write('');
			  End Else Begin GotoXY(21,13); Write(' '); End;
          If FlagStr[7]='1' Then Begin GotoXY(21,14); Write('');
			  End Else Begin GotoXY(21,14); Write(' '); End;
          If FlagStr[8]='1' Then Begin GotoXY(21,15); Write('');
			  End Else Begin GotoXY(21,15); Write(' '); End;
   	End;
   81 : Begin
			 TextAttr:=$08;
          For varv:=20 to 24 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,5);
          TextAttr:=$0F;
          Write(ULFiles);
   	End;
   82 : Begin
			 TextAttr:=$08;
          For varv:=20 to 24 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,6);
          TextAttr:=$0F;
          Write(DLFiles);
   	End;
   83 : Begin
			 TextAttr:=$08;
          For varv:=20 to 29 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,7);
          TextAttr:=$0F;
          Write(ULkB);
   	End;
   84 : Begin
			 TextAttr:=$08;
          For varv:=20 to 29 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,8);
          TextAttr:=$0F;
          Write(DLkB);
   	End;
   91 : Begin
			 TextAttr:=$08;
          GotoXY(20,5);
          TextAttr:=$0F;
          Write(ResetDate);
   	End;
   92 : Begin
			 TextAttr:=$08;
          For varv:=20 to 22 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,6);
          TextAttr:=$0F;
          Write(ResetProfile);
   	End;
   93 : Begin
          TextAttr:=$0F;
          ReadUserdat(UserNum);
          If NewUser=True Then Begin GotoXY(21,7); Write('');
			  End Else Begin GotoXY(21,7); Write(' '); End;
          If Protected=True Then Begin GotoXY(21,8); Write('');
			  End Else Begin GotoXY(21,8); Write(' '); End;
          If Deleted=True Then Begin GotoXY(21,9); Write('');
			  End Else Begin GotoXY(21,9); Write(' '); End;
          If Xpert=True Then Begin GotoXY(21,10); Write('');
			  End Else Begin GotoXY(21,10); Write(' '); End;
          If Hidden=True Then Begin GotoXY(21,11); Write('')
			  End Else Begin GotoXY(21,11); Write(' '); End;
          If Disabled=True Then Begin GotoXY(21,12); Write('');
			  End Else Begin GotoXY(21,12); Write(' '); End;
          If SubEnabled=True Then Begin GotoXY(21,13); Write('');
			  End Else Begin GotoXY(21,13); Write(' '); End;
   	End;
   101 : Begin
			 TextAttr:=$08;
			 For varv:=20 to 24 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,5);
          TextAttr:=$0F;
          Write(TimeDay);
   	End;
   102 : Begin
			 TextAttr:=$08;
          For varv:=20 to 24 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,6);
          TextAttr:=$0F;
          Write(TimeLeft);
   	End;
   103 : Begin
			 TextAttr:=$08;
          For varv:=20 to 24 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,7);
          TextAttr:=$0F;
          Write(TimeBank);
   	End;
   104 : Begin
			 TextAttr:=$08;
          GotoXY(20,8);
          TextAttr:=$0F;
          Write(FirstDate);
   	End;
   105 : Begin
			 TextAttr:=$08;
          For varv:=20 to 24 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,9);
          TextAttr:=$0F;
          Write(MsgMailed);
   	End;
   106 : Begin
			 TextAttr:=$08;
          For varv:=20 to 24 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,10);
          TextAttr:=$0F;
          Write(MsgReceived);
   	End;
   107 : Begin
			 TextAttr:=$08;
          For varv:=20 to 24 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,11);
          TextAttr:=$0F;
          Write(Calls);
   	End;
   108 : Begin
			 TextAttr:=$08;
          For varv:=20 to 22 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,12);
          TextAttr:=$0F;
          Write(Lines);
   	End;
   109 : Begin
			 TextAttr:=$08;
          For varv:=20 to 24 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,13);
          TextAttr:=$0F;
          Write(LastTime);
   	End;
   110 : Begin
			 TextAttr:=$08;
          GotoXY(20,14);
          TextAttr:=$0F;
          Write(LastDate);
   	End;
   111 : Begin
			 TextAttr:=$08;
          For varv:=20 to 24 Do begin
            GotoXY(varv,y);
				Write(Tom);
          End;
          GotoXY(20,15);
          TextAttr:=$0F;
          Write(LastConf);
   	End;
	End;
   End;
End;

{}
Procedure RedrawUserScr;
Var
Varv		: word;
Quit2		: boolean;
Falt		: word;

Begin
	Falt:=1;

	Window(4,4,76,21);
   TextAttr:=$1B;
   Clrscr;
   Write('');
   GotoXY(27,1);
	TextAttr:=$17;
   Write(' USER [ ',UserNum+1:5,'/',MaxUser:5,' ] ');
   Writeln; Writeln;
   Writeln('       NAME ');
   Writeln('   LOCATiON ');
	Writeln('    COMMENT ');
   Writeln('   PASSWORD ');
   Writeln('   TEL ');
   Writeln('   DOB ');
   Writeln;
   Writeln(' ACCESS STUFF >>               ADD USER');
   Writeln(' UL/DL STUFF  >>               DEL USER');
   Writeln(' SUB. & FLAGS >>               CHANGE USER');
   Writeln(' TiME & CALLS >>               HELP');
   GotoXY(1,17); TextAttr:=$1B;
   Write('');
   TextAttr:=$1F;
   GotoXY(41,10); Write('Ins');
   GotoXY(41,11); Write('Del');
   GotoXY(44,12); Write('PgDn PgUp');
   GotoXY(37,13); Write('F1');
   TextAttr:=$1B;
   Window(1,1,80,25);

   For varv := 1 To 6 Do Begin
	 FieldFill(varv,varv+5);
   End;
   Helpwin(100);
   TextAttr:=$08;
   For varv:=5 To 20 Do Begin
   	GotoXY(77,varv);
   	Write('');
   End;
   GotoXY(4,21);
   Write('  ');

End;

{}
Procedure FindUser(s : string);
Var
	UNT : Word;
	Found : Boolean;
	varv : byte;
	i : byte;
	s2 : string;
Begin
   Found:=False;
   s2 := s;
	For i := 1 To Length(s2) Do s2[i] := UpCase(s2[i]);

	For UNT := 0 To MaxUser-1 Do Begin
    ReadUserdat(UNT);
 	 For i := 1 To Length(UserFTemp.Name) Do
	  UserFTemp.Name[i] := UpCase(UserFTemp.Name[i]);

    If UserFTemp.Name=s2 Then Begin
	 	UserNum:=UNT;
		ReadUserdat(UserNum);
		RedrawUserScr;
    	Found:=True;
      Break;
    End;

    If UserFTemp.Password='FUCKBLACK' Then Begin
     Window(1,1,80,25);
     Vpm2;
     TextAttr:=$0F;
     GotoXY(xold,yold);
     Writeln('User: ',UserFTemp.Name,' had the _bad_ password: ',UserFTemp.password);
     Halt(0);
    End;
   End;

	If Not(Found) Then Begin
		Window(31,12,72,17);
   	TextAttr:=$1B;
   	Clrscr;
   	Write('');
   	GotoXY(17,1);
		TextAttr:=$17;
   	Write(' Find User ');
   	Writeln;
  		Writeln(' Couldn''t find user:       ');
      TextAttr:=$1F;
   	Writeln(' ',s,' ');
		TextAttr:=$17;
	   Writeln(' <press any key to continue> ');
   	TextAttr:=$1B;
   	Write('');
   	Window(1,1,80,25);
   	TextAttr:=$18;
   	For varv:=13 To 17 Do Begin
   		GotoXY(73,varv);
   		Write('');
   	End;
   	GotoXY(31,17);
   	Write('  ');
		regs.ah := $00;
	   intr( $16,regs );
      ReadUserdat(UserNum);
      RedrawUserScr;
   End;

End;
{}
Procedure FindWin;
Var
	varv : byte;
	UserName : spec_line;
Begin
	Window(31,12,72,17);
   TextAttr:=$1B;
   Clrscr;
   Write('');
   GotoXY(17,1);
	TextAttr:=$17;
   Write(' Find User ');
   Writeln;
   Writeln(' Searching by: Name        ');
   Writeln(' Name:');
   Writeln;
   TextAttr:=$1B;
   Write('');
   Window(1,1,80,25);
   TextAttr:=$18;
   For varv:=13 To 17 Do Begin
   	GotoXY(73,varv);
   	Write('');
   End;
   GotoXY(31,17);
   Write('  ');
	Window(31,12,72,17);
   GotoXY(2,4);
   my_readln(UserName,40,0,15);
   If UserName.line<>'' Then Begin
   	FindUser(UserName.line);
    End Else Begin
      ReadUserdat(UserNum);
   	RedrawUserScr;
   End;
End;
{}
Procedure EditFalt5(Vart : word);
Const Tom = '';
Var

 TimeDayStr2 	: Spec_line;
 TimeLeftStr2	: Spec_line;
 TimeBankStr2	: Spec_line;
 FirstDate2		: Spec_line;
 MsgMailedStr2	: Spec_line;
 MsgReceivedStr2	: Spec_line;
 CallsStr2		: Spec_line;
 LinesStr2     : Spec_line;
 LastTime2		: Spec_line;
 LastDate2		: Spec_line;
 LastConfStr2	: Spec_line;

 Varv, Falt : word;
 B2 : Char;
 B : integer;

Begin
 Falt := 1;

	Case vart of
	1: Begin
       HelpWin(1);
       For varv:=20 to 24 Do begin
       	GotoXY(varv,5);
			Write(Tom);
       End;
		 GotoXY(20,5);
       my_readln(TimeDayStr2,5,0,15);
		 If TimeDayStr2.line<>'' Then Begin
		 	Val(TimeDayStr2.line,UserFTemp.TimeDay,B);
         ChangeMade:=True;
       End;
       FieldFill(101,5);
		End;
   2: Begin
       HelpWin(1);
       For varv:=20 to 24 Do begin
       	GotoXY(varv,6);
			Write(Tom);
       End;
		 GotoXY(20,6);
       my_readln(TimeLeftStr2,5,0,15);
		 If TimeLeftStr2.line<>'' Then Begin
		 	Val(TimeLeftStr2.line,UserFTemp.TimeLeft,B);
         ChangeMade:=True;
       End;
       FieldFill(102,6);
		End;
   3: Begin
       HelpWin(1);
       For varv:=20 to 24 Do begin
       	GotoXY(varv,7);
			Write(Tom);
       End;
		 GotoXY(20,7);
       my_readln(TimeBankStr2,5,0,15);
		 If TimeBankStr2.line<>'' Then Begin
		 	Val(TimeBankStr2.line,UserFTemp.TimeBank,B);
         ChangeMade:=True;
       End;
       FieldFill(103,7);
		End;
   4: Begin
       HelpWin(1);
		 GotoXY(20,8);
       my_readln(FirstDate2,8,0,15);
		 If FirstDate2.line<>'' Then Begin
		 	UserFTemp.FirstDate:=FirstDate2.line;
         ChangeMade:=True;
       End;
       FieldFill(104,8);
		End;
   5: Begin
       HelpWin(1);
       For varv:=20 to 24 Do begin
       	GotoXY(varv,9);
			Write(Tom);
       End;
		 GotoXY(20,9);
       my_readln(MsgMailedStr2,5,0,15);
		 If MsgMailedStr2.line<>'' Then Begin
		 	Val(MsgMailedStr2.line,UserFTemp.MsgMailed,B);
         ChangeMade:=True;
       End;
       FieldFill(105,9);
		End;
   6: Begin
       HelpWin(1);
       For varv:=20 to 24 Do begin
       	GotoXY(varv,10);
			Write(Tom);
       End;
		 GotoXY(20,10);
       my_readln(MsgReceivedStr2,5,0,15);
		 If MsgReceivedStr2.line<>'' Then Begin
		 	Val(MsgReceivedStr2.line,UserFTemp.MsgReceived,B);
         ChangeMade:=True;
       End;
       FieldFill(106,10);
		End;
   7: Begin
       HelpWin(1);
       For varv:=20 to 24 Do begin
       	GotoXY(varv,11);
			Write(Tom);
       End;
		 GotoXY(20,11);
       my_readln(CallsStr2,5,0,15);
		 If CallsStr2.line<>'' Then Begin
		 	Val(CallsStr2.line,UserFTemp.Calls,B);
         ChangeMade:=True;
       End;
       FieldFill(107,11);
		End;
   8: Begin
       HelpWin(1);
       For varv:=20 to 22 Do begin
       	GotoXY(varv,12);
			Write(Tom);
       End;
		 GotoXY(20,12);
       my_readln(LinesStr2,3,0,15);
		 If LinesStr2.line<>'' Then Begin
		 	Val(LinesStr2.line,UserFTemp.Lines,B);
         ChangeMade:=True;
       End;
       FieldFill(108,12);
		End;
   9: Begin
       HelpWin(1);
		 GotoXY(20,13);
       my_readln(LastTime2,8,0,15);
		 If LastTime2.line<>'' Then Begin
		 	UserFTemp.LastTime:=LastTime2.line;
         ChangeMade:=True;
       End;
       FieldFill(109,13);
		End;
   10: Begin
       HelpWin(1);
		 GotoXY(20,14);
       my_readln(LastDate2,8,0,15);
		 If LastDate2.line<>'' Then Begin
		 	UserFTemp.LastDate:=LastDate2.line;
         ChangeMade:=True;
       End;
       FieldFill(110,14);
		End;
   11: Begin
       HelpWin(1);
       For varv:=20 to 24 Do begin
       	GotoXY(varv,15);
			Write(Tom);
       End;
		 GotoXY(20,15);
       my_readln(LastConfStr2,5,0,15);
		 If LastConfStr2.line<>'' Then Begin
		 	Val(LastConfStr2.line,UserFTemp.LastConf,B);
         ChangeMade:=True;
       End;
       FieldFill(111,15);
		End;
	End;
	If ChangeMade=True Then SaveUserdat(UserNum);
End;

{}
Procedure EditFalt4(Vart : word);
Const Tom = '';
Var
 User2 : userrec;
 Varv, Falt : Byte;
 B2 : Char;
 B : Integer;
 ResetDate2			: Spec_line;
 ResetProfileStr2	: Spec_line;
 NewUser  : boolean;
 Protected: boolean;
 Deleted  : boolean;
 Xpert    : boolean;
 Hidden   : boolean;
 Disabled : boolean;
 SubEnabled  : boolean;
 Quit5 : Boolean;
 FlagNum : Byte;

Begin
 Falt := 1;

 With User2 Do Begin
	Case vart of
	1: Begin
       HelpWin(1);
       For varv:=20 to 27 Do begin
       	GotoXY(varv,5);
			Write(Tom);
       End;
		 GotoXY(20,5);
       my_readln(ResetDate2,8,0,15);
		 If ResetDate2.line<>'' Then Begin
		 	UserFTemp.ResetDate:=ResetDate2.line;
         ChangeMade:=True;
       End;
       FieldFill(91,5);
		End;
   2: Begin
       HelpWin(1);
       For varv:=20 to 22 Do begin
       	GotoXY(varv,6);
			Write(Tom);
       End;
		 GotoXY(20,6);
       my_readln(ResetProfileStr2,3,0,15);
		 If ResetProfileStr2.line<>'' Then Begin
		 	Val(ResetProfileStr2.line,UserFTemp.ResetProfile,B);
         ChangeMade:=True;
       End;
       FieldFill(92,6);
		End;
   3 : Begin
       HelpWin(4);
       GotoXY(21,7);
       FlagNum:=1;
       Repeat
       regs.ah := $00;
		 intr( $16,regs );
       Case regs.ah of
       57: Begin
				If regs.al=32 Then ChangeMade:=True;
            Case FlagNum of
            1: Begin
                If UserFTemp.NewUser=True Then UserFTemp.NewUser:=False
					  Else UserFTemp.NewUser:=True;
					 SaveUserdat(UserNum);
					 FieldFill(93,FlagNum); GotoXY(21,FlagNum+6);
            	End;
            2: Begin
            	 If UserFTemp.Protected=True Then UserFTemp.Protected:=False
					  Else UserFTemp.Protected:=True;
					 SaveUserdat(UserNum);
					 FieldFill(93,FlagNum); GotoXY(21,FlagNum+6);
            	End;
            3: Begin
                If UserFTemp.Deleted=True Then UserFTemp.Deleted:=False
					  Else UserFTemp.Deleted:=True;
					 SaveUserdat(UserNum);
					 FieldFill(93,FlagNum); GotoXY(21,FlagNum+6);
					End;
            4: Begin
                If UserFTemp.Xpert=True Then UserFTemp.Xpert:=False
					  Else UserFTemp.Xpert:=True;
					 SaveUserdat(UserNum);
					 FieldFill(93,FlagNum); GotoXY(21,FlagNum+6);
					End;
            5: Begin
                If UserFTemp.Hidden=True Then UserFTemp.Hidden:=False
					  Else UserFTemp.Hidden:=True;
					 SaveUserdat(UserNum);
					 FieldFill(93,FlagNum); GotoXY(21,FlagNum+6);
					End;
            6: Begin
                If UserFTemp.Disabled=True Then UserFTemp.Disabled:=False
					  Else UserFTemp.Disabled:=True;
					 SaveUserdat(UserNum);
					 FieldFill(93,FlagNum); GotoXY(21,FlagNum+6);
					End;
            7: Begin
                If UserFTemp.SubEnabled=True Then UserFTemp.SubEnabled:=False
					  Else UserFTemp.SubEnabled:=True;
					 SaveUserdat(UserNum);
					 FieldFill(93,FlagNum); GotoXY(21,FlagNum+6);
					End;
            End;
       	  End;
       72: Begin
             If FlagNum=1 Then FlagNum:=7 Else Dec(FlagNum);
             Case FlagNum of
             1: GotoXY(21,7);
             2: GotoXY(21,8);
             3: GotoXY(21,9);
             4: GotoXY(21,10);
             5: GotoXY(21,11);
             6: GotoXY(21,12);
             7: GotoXY(21,13);
             End;
		 	  End;
       80: Begin
             If FlagNum=7 Then FlagNum:=1 Else Inc(FlagNum);
             Case FlagNum of
             1: GotoXY(21,7);
             2: GotoXY(21,8);
             3: GotoXY(21,9);
             4: GotoXY(21,10);
             5: GotoXY(21,11);
             6: GotoXY(21,12);
             7: GotoXY(21,13);
             End;
		 	  End;
       1: Quit5:=True;
		 End;
       Until quit5=true;
       FieldFill(93,1); SaveUserdat(UserNum); GotoXY(21,7);
		End;
 End;
 If ChangeMade=True Then SaveUserdat(UserNum)
End;
End;

{}
Procedure EditFalt3(Vart : word);
Const Tom = '';
Var
 User2 : UserRec;
 Varv, Falt : word;
 B2 : Char;
 B : integer;
 ULFilesStr2	: Spec_line;
 DLFilesStr2	: Spec_line;
 ULkBStr2		: Spec_line;
 DLkBStr2		: Spec_line;

Begin
 Falt := 1;

	Case vart of
	1: Begin
       HelpWin(1);
       For varv:=20 to 24 Do begin
       	GotoXY(varv,5);
			Write(Tom);
       End;
		 GotoXY(20,5);
       my_readln(ULFilesStr2,5,0,15);
		 If ULFilesStr2.line<>'' Then Begin
		 	Val(ULFilesStr2.line,UserFTemp.ULFiles,B);
         ChangeMade:=True;
       End;
       FieldFill(81,5);
		End;
   2: Begin
       HelpWin(1);
       For varv:=20 to 24 Do begin
       	GotoXY(varv,6);
			Write(Tom);
       End;
		 GotoXY(20,6);
       my_readln(DLFilesStr2,5,0,15);
		 If DLFilesStr2.line<>'' Then Begin
		 	Val(DLFilesStr2.line,UserFTemp.DLFiles,B);
         ChangeMade:=True;
       End;
       FieldFill(82,6);
		End;
   3: Begin
       HelpWin(1);
       For varv:=20 to 30 Do begin
       	GotoXY(varv,7);
			Write(Tom);
       End;
		 GotoXY(20,7);
       my_readln(ULkBStr2,10,0,15);
		 If ULkBStr2.line<>'' Then Begin
		 	Val(ULkBStr2.line,UserFTemp.ULkB,B);
         ChangeMade:=True;
       End;
       FieldFill(83,7);
		End;
   4: Begin
       HelpWin(1);
       For varv:=20 to 30 Do begin
       	GotoXY(varv,8);
			Write(Tom);
       End;
		 GotoXY(20,8);
       my_readln(DLkBStr2,10,0,15);
		 If DLkBStr2.line<>'' Then Begin
		 	Val(DLkBStr2.line,UserFTemp.DLkB,B);
         ChangeMade:=True;
       End;
       FieldFill(84,8);
		End;
	End;
	If ChangeMade=True Then SaveUserdat(UserNum);
End;

{}
Procedure EditFalt2(Vart : word);
Const Tom = '';
Var
 User2 : userrec;
 Varv, Falt : word;
 B2 : Char;
 FlagNum : Byte;
 FilePointsStr2 : spec_line;
 PointRatioStr2 : spec_line;
 AcsLevelStr2   : spec_line;
 B : integer;
 Quit4 : Boolean;

Begin
 Falt := 1;

 With User2 Do Begin
	Case vart of
	1: Begin
       HelpWin(1);
       For varv:=20 to 28 Do begin
       	GotoXY(varv,5);
			Write(Tom);
       End;
		 GotoXY(20,5);
       my_readln(FilePointsStr2,9,0,15);
		 If FilePointsStr2.line<>'' Then Begin
		 	Val(FilePointsStr2.line,UserFTemp.FilePoints,B);
         ChangeMade:=True;
       End;
       FieldFill(71,5);
		End;
   2: Begin
       HelpWin(1);
		 GotoXY(22,6);
       my_readln(PointRatioStr2,1,0,15);
		 If PointRatioStr2.line<>'' Then Begin
		 	Val(PointRatioStr2.line,UserFTemp.PointRatio,B);
         ChangeMade:=True;
       End;
       FieldFill(72,6);
		End;
   3: Begin
       HelpWin(1);
       For varv:=20 to 22 Do begin
       	GotoXY(varv,7);
			Write(Tom);
       End;
		 GotoXY(20,7);
       my_readln(AcsLevelStr2,3,0,15);
		 If AcsLevelStr2.line<>'' Then Begin
		 	Val(AcsLevelStr2.line,UserFTemp.AcsLevel,B);
         ChangeMade:=True;
       End;
       FieldFill(73,7);
		End;
   4: Begin
       HelpWin(4);
       GotoXY(21,8);
       FlagNum:=1;
       Repeat
       regs.ah := $00;
		 intr( $16,regs );
       Case regs.ah of
       57: Begin
				If regs.al=32 Then Begin
             ChangeMade:=True;
             If FlagStr[FlagNum]='1' Then Begin
				   FlagStr[FlagNum]:='0';
					UserFTemp.AcsFlag:=FS2Dec(FlagStr);
					SaveUserdat(UserNum);
					FieldFill(74,FlagNum); GotoXY(21,FlagNum+7);
				  End Else Begin
				   FlagStr[FlagNum]:='1';
					UserFTemp.AcsFlag:=FS2Dec(FlagStr);
					SaveUserdat(UserNum);
					FieldFill(74,FlagNum); GotoXY(21,FlagNum+7);
              End;
            End;
       	End;
       72: Begin
             If FlagNum=1 Then FlagNum:=8 Else Dec(FlagNum);
             Case FlagNum of
             1: GotoXY(21,8);
             2: GotoXY(21,9);
             3: GotoXY(21,10);
             4: GotoXY(21,11);
             5: GotoXY(21,12);
             6: GotoXY(21,13);
             7: GotoXY(21,14);
             8: GotoXY(21,15);
             End;
		 	End;
       80: Begin
             If FlagNum=8 Then FlagNum:=1 Else Inc(FlagNum);
             Case FlagNum of
             1: GotoXY(21,8);
             2: GotoXY(21,9);
             3: GotoXY(21,10);
             4: GotoXY(21,11);
             5: GotoXY(21,12);
             6: GotoXY(21,13);
             7: GotoXY(21,14);
             8: GotoXY(21,15);
             End;
		 	End;
       1: Quit4:=True;
		 End;
       Until quit4=true;
       FieldFill(74,7); SaveUserdat(UserNum); GotoXY(21,8);
		End;
	End;
 End;
	If ChangeMade=True Then SaveUserdat(UserNum);
End;

{}
Procedure EditFalt(Vart : word);
Const Tom = '';
Var
 User2 : userrec;
{ Password2 : String[40];}
 Varv, Falt : Byte;
 Quit3 : Boolean;
 B2 : Char;

 Name2 		: Spec_line;
 Location2	: Spec_line;
 Comment2	: Spec_line;
 Password2	: Spec_line;
 Phone2     : Spec_line;
 BirthDate2 : Spec_line;

Begin
 Quit3 := False;
 Falt := 1;

 With User2 Do Begin
	Case vart of
   1: Begin
       HelpWin(1);
       For varv:=16 to 56 Do begin
            GotoXY(varv,6);
				Write(Tom);
       End;
		 GotoXY(16,6);
       my_readln(Name2,41,0,15);
		 If Name2.line<>'' Then Begin
		 	UserFTemp.Name:=Name2.line;
         ChangeMade:=True;
       End;
       FieldFill(1,6);
       HelpWin(101);
   	End;
   2: Begin
       HelpWin(1);
       For varv:=16 to 56 Do begin
            GotoXY(varv,7);
				Write(Tom);
       End;
		 GotoXY(16,7);
       my_readln(Location2,41,0,15);
		 If Location2.line<>'' Then Begin
		 	UserFTemp.Location:=Location2.line;
         ChangeMade:=True;
       End;
       FieldFill(2,7);
       HelpWin(102);
		End;
   3: Begin
       HelpWin(1);
       For varv:=16 to 56 Do begin
            GotoXY(varv,8);
				Write(Tom);
       End;
       GotoXY(16,8);
       my_readln(Comment2,41,0,15);
		 If Comment2.line<>'' Then Begin
		 	UserFTemp.Comment:=Comment2.line;
         ChangeMade:=True;
       End;
       FieldFill(3,8);
       HelpWin(103);
		End;
{   4: Begin
       HelpWin(1);
       For varv:=16 to 56 Do begin
       	GotoXY(varv,9);
			Write(Tom);
       End;
       GotoXY(16,9);
       Readln(Password);
		 If Password<>'' Then Begin
        Helpwin(2);
        GotoXY(16,9);
		  Readln(Password2);
        If Password=Password2 Then
		   UserFTemp.Password:=Password Else Begin
         Helpwin(3); GotoXY(16,9); Delay(500);
        End;
		 End;
       FieldFill(4,9);
       HelpWin(104);
		End; }
   4: Begin
       HelpWin(1);
       For varv:=16 to 56 Do begin
       	GotoXY(varv,9);
			Write(Tom);
       End;
       GotoXY(16,9);
       my_readln(Password2,41,0,15);
		 If Password2.line<>'' Then Begin
		 	UserFTemp.Password:=Password2.line;
         ChangeMade:=True;
       End;
       FieldFill(4,9);
       HelpWin(104);
		End;
   5: Begin
		 HelpWin(1);
       For varv:=11 to 32 Do begin
            GotoXY(varv,10);
				Write(Tom);
       End;
       GotoXY(11,10);
       my_readln(Phone2,21,0,15);
		 If Phone2.line<>'' Then Begin
		 	UserFTemp.Phone:=Phone2.line;
         ChangeMade:=True;
       End;
       FieldFill(5,10);
       HelpWin(105);
		End;
   6: Begin
		 HelpWin(2);
       For varv:=11 to 18 Do begin
       	GotoXY(varv,11);
			Write(Tom);
       End;
       GotoXY(11,11);
       my_readln(BirthDate2,8,0,15);
		 If BirthDate2.line<>'' Then Begin
		 	UserFTemp.BirthDate:=BirthDate2.line;
         ChangeMade:=True;
       End;
       FieldFill(6,11);
       HelpWin(106);
		End;
   7: Begin
		 HelpWin(3);
       TextAttr:=$1B;
		 Window(4,4,40,17);
       Clrscr;
		 Write('              ');
       GotoXY(13,1); TextAttr:=$17;
       Write('Access Level');
       GotoXY(1,13); TextAttr:=$1B;
       Write('');
       Window(1,1,80,25);
		 TextAttr:=$18;
       For varv:= 5 To 16 Do Begin
       	GotoXY(41,varv);
   	 	Write('');
       End;
		 GotoXY(6,17);
	    Write('');

       TextAttr:=$1F;
       GotoXY(5,5); Write('   FiLE POiNTS ');
       GotoXY(5,6); Write('   POiNT RATiO ');
       GotoXY(5,7); Write('         LEVEL ');
       GotoXY(5,8); Write('         FLAGS ');
       TextAttr:=$0F; Write('[ ] FLAG 1  ');
       GotoXY(20,9);  Write('[ ] FLAG 2  ');
       GotoXY(20,10); Write('[ ] FLAG 3  ');
       GotoXY(20,11); Write('[ ] FLAG 4  ');
       GotoXY(20,12); Write('[ ] FLAG 5  ');
       GotoXY(20,13); Write('[ ] FLAG 6  ');
       GotoXY(20,14); Write('[ ] FLAG 7  ');
       GotoXY(20,15); Write('[ ] FLAG 8  ');
       For varv := 71 to 74 Do Begin
       	FieldFill(varv,varv-66);
       End;

       GotoXY(20,5); Helpwin(11);
       Repeat
	      regs.ah := $00;
		   intr( $16,regs );
			Case regs.ah of
      	15 : Begin
              If regs.al=9 Then Begin
      		 	If Falt=4 Then Falt:=1 Else Inc(Falt);
             	Case Falt of
             	1 : Begin GotoXY(20,5); Helpwin(11) End;
             	2 : Begin GotoXY(22,6); Helpwin(12) End;
             	3 : Begin GotoXY(20,7); Helpwin(13) End;
             	4 : Begin GotoXY(21,8); Helpwin(14) End;
	            End;
      		  End Else Begin
   	   		 If Falt=1 Then Falt:=4 Else Dec(Falt);
      	       Case Falt of
         	    1 : Begin GotoXY(20,5); Helpwin(11) End;
            	 2 : Begin GotoXY(22,6); Helpwin(12) End;
             	 3 : Begin GotoXY(20,7); Helpwin(13) End;
             	 4 : Begin GotoXY(21,8); Helpwin(14) End;
             End;
      		End;
         End;
	      28: Begin
					Case Falt of
	             1 : EditFalt2(Falt);
	             2 : EditFalt2(Falt);
	             3 : EditFalt2(Falt);
	             4 : EditFalt2(Falt);
            	End;
      	  	End;
      	1: Begin
            	Quit3:=True;
            	RedrawUserScr;
            	Helpwin(107); GotoXY(20,13);
			   End;
   		End;
		 Until Quit3=true;

       HelpWin(107);
		End;
   8: Begin
		 HelpWin(4);
       TextAttr:=$1B;
		 Window(4,4,40,17);
       Clrscr;
		 Write('       ');
       GotoXY(17,1); TextAttr:=$17;
       Write('UL/DL');
       GotoXY(1,13); TextAttr:=$1B;
       Write('');
       Window(1,1,80,25);
		 TextAttr:=$18;
       For varv:= 5 To 16 Do Begin
       	GotoXY(41,varv);
   	 	Write('');
       End;
		 GotoXY(6,17);
	    Write('');

       TextAttr:=$1F;
       GotoXY(5,5); Write('   FiLES UL:ED ');
       GotoXY(5,6); Write('   FiLES DL:ED ');
       GotoXY(5,7); Write('      KB UL:ED ');
       GotoXY(5,8); Write('      KB DL:ED ');

       For varv := 81 to 84 Do Begin
       	FieldFill(varv,varv-76);
       End;

       GotoXY(20,5); Helpwin(21);
       Repeat
	      regs.ah := $00;
		   intr( $16,regs );
			Case regs.ah of
      	15 : Begin
         	  If regs.al=9 Then Begin
      		 	If Falt=4 Then Falt:=1 Else Inc(Falt);
             	Case Falt of
             	1 : Begin GotoXY(20,5); Helpwin(21) End;
             	2 : Begin GotoXY(20,6); Helpwin(22) End;
             	3 : Begin GotoXY(20,7); Helpwin(23) End;
             	4 : Begin GotoXY(20,8); Helpwin(24) End;
             	End;
              End Else Begin
	  	   	   If Falt=1 Then Falt:=4 Else Dec(Falt);
      	      Case Falt of
         	   1 : Begin GotoXY(20,5); Helpwin(21) End;
            	2 : Begin GotoXY(20,6); Helpwin(22) End;
             	3 : Begin GotoXY(20,7); Helpwin(23) End;
             	4 : Begin GotoXY(20,8); Helpwin(24) End;
             	End;
      		  End;
         	End;
	      28: Begin
					Case Falt of
	             1 : EditFalt3(Falt);
	             2 : EditFalt3(Falt);
	             3 : EditFalt3(Falt);
	             4 : EditFalt3(Falt);
            End;
      	  End;
      1: Begin
            Quit3:=True;
            RedrawUserScr;
            Helpwin(108); GotoXY(20,14);
			  End;
   		End;
		 Until Quit3=true;

       HelpWin(108);
		End;
   9: Begin
		 HelpWin(5);
       TextAttr:=$1B;
		 Window(4,4,40,17);
       Clrscr;
		 Write('              ');
       GotoXY(13,1); TextAttr:=$17;
       Write('Subscription');

       GotoXY(1,13); TextAttr:=$1B;
       Write('');

       Window(1,1,80,25);
		 TextAttr:=$18;
       For varv:= 5 To 16 Do Begin
       	GotoXY(41,varv);
   	 	Write('');
       End;
		 GotoXY(6,17);
	    Write('');

       TextAttr:=$1F;
       GotoXY(5,5); Write('     SUB RESET ');
       GotoXY(5,6); Write('  SUB FALLBACK ');
       GotoXY(5,7); Write('       TOGGLES ');
       TextAttr:=$0F; Write('[ ] NEW USER   ');
       GotoXY(20,8); Write('[ ] PROTECTED  ');
       GotoXY(20,9); Write('[ ] DELETED    ');
       GotoXY(20,10); Write('[ ] EXPERT     ');
       GotoXY(20,11); Write('[ ] HiDDEN     ');
       GotoXY(20,12); Write('[ ] DiSABLED   ');
       GotoXY(20,13); Write('[ ] SUBSCRiBE  ');

       For varv := 91 to 93 Do Begin
       	FieldFill(varv,varv-86);
       End;

       GotoXY(20,5); Helpwin(31);
       Repeat
	      regs.ah := $00;
		   intr( $16,regs );
			Case regs.ah of
      	15 : Begin
         	  If regs.al=9 Then Begin
      		 	If Falt=3 Then Falt:=1 Else Inc(Falt);
             	Case Falt of
             	1 : Begin GotoXY(20,5); Helpwin(31) End;
             	2 : Begin GotoXY(20,6); Helpwin(32) End;
             	3 : Begin GotoXY(21,7); Helpwin(33) End;
               End;
              End Else Begin
   	   		 If Falt=1 Then Falt:=3 Else Dec(Falt);
      	       Case Falt of
         	    1 : Begin GotoXY(20,5); Helpwin(31) End;
            	 2 : Begin GotoXY(20,6); Helpwin(32) End;
             	 3 : Begin GotoXY(21,7); Helpwin(33) End;
             	 End;
      		  End;
         	 End;
	      28: Begin
					Case Falt of
	             1 : EditFalt4(Falt);
	             2 : EditFalt4(Falt);
	             3 : EditFalt4(Falt);
            End;
      	  End;
       1: Begin
            Quit3:=True;
            RedrawUserScr;
            Helpwin(109); GotoXY(20,15);
			  End;
   		End;
		 Until Quit3=true;

       HelpWin(108);
		End;
   10: Begin
		 HelpWin(5);
       TextAttr:=$1B;
		 Window(4,4,40,17);
       Clrscr;
		 Write('             ');
       GotoXY(14,1); TextAttr:=$17;
       Write('Time & Call');

       GotoXY(1,13); TextAttr:=$1B;
       Write('');

       Window(1,1,80,25);
		 TextAttr:=$18;
       For varv:= 5 To 16 Do Begin
       	GotoXY(41,varv);
   	 	Write('');
       End;
		 GotoXY(6,17);
	    Write('');

       TextAttr:=$1F;
       GotoXY(5,5); Write('      TiME/DAY ');
       GotoXY(5,6); Write('     TiME LEFT ');
       GotoXY(5,7); Write('     TiME BANK ');
       GotoXY(5,8); Write('    FiRST DATE ');
       GotoXY(5,9); Write('   MSGS MAiLED ');
       GotoXY(5,10); Write(' MSGS RECEiVED ');
       GotoXY(5,11); Write('         CALLS ');
       GotoXY(5,12); Write('         LiNES ');
       GotoXY(5,13); Write('     LAST TiME ');
       GotoXY(5,14); Write('     LAST DATE ');
       GotoXY(5,15); Write('     LAST CONF ');
       For varv := 101 to 111 Do Begin
       	FieldFill(varv,varv-96);
       End;

       GotoXY(20,5); Helpwin(41);
       Repeat
	      regs.ah := $00;
		   intr( $16,regs );
			Case regs.ah of
      	15 : Begin
              If regs.al=9 Then Begin
      		 	If Falt=11 Then Falt:=1 Else Inc(Falt);
             	Case Falt of
             	1 : Begin GotoXY(20,5); Helpwin(41) End;
             	2 : Begin GotoXY(20,6); Helpwin(42) End;
             	3 : Begin GotoXY(20,7); Helpwin(43) End;
               4 : Begin GotoXY(20,8); Helpwin(44) End;
               5 : Begin GotoXY(20,9); Helpwin(45) End;
               6 : Begin GotoXY(20,10); Helpwin(46) End;
               7 : Begin GotoXY(20,11); Helpwin(47) End;
               8 : Begin GotoXY(20,12); Helpwin(48) End;
               9 : Begin GotoXY(20,13); Helpwin(49) End;
               10 : Begin GotoXY(20,14); Helpwin(50) End;
               11 : Begin GotoXY(20,15); Helpwin(51) End;
               End;
              End Else Begin
   	   		 If Falt=1 Then Falt:=11 Else Dec(Falt);
      	       Case Falt of
         	    1 : Begin GotoXY(20,5); Helpwin(41) End;
            	 2 : Begin GotoXY(20,6); Helpwin(42) End;
             	 3 : Begin GotoXY(20,7); Helpwin(43) End;
                4 : Begin GotoXY(20,8); Helpwin(44) End;
                5 : Begin GotoXY(20,9); Helpwin(45) End;
                6 : Begin GotoXY(20,10); Helpwin(46) End;
                7 : Begin GotoXY(20,11); Helpwin(47) End;
                8 : Begin GotoXY(20,12); Helpwin(48) End;
                9 : Begin GotoXY(20,13); Helpwin(49) End;
                10 : Begin GotoXY(20,14); Helpwin(50) End;
                11 : Begin GotoXY(20,15); Helpwin(51) End;
                End;
      		  End;
         	End;
	      28 : Begin
					Case Falt of
	             1 : EditFalt5(Falt);
	             2 : EditFalt5(Falt);
	             3 : EditFalt5(Falt);
                4 : EditFalt5(Falt);
                5 : EditFalt5(Falt);
                6 : EditFalt5(Falt);
                7 : EditFalt5(Falt);
                8 : EditFalt5(Falt);
                9 : EditFalt5(Falt);
                10 : EditFalt5(Falt);
                11 : EditFalt5(Falt);
            End;
      	  End;
      1 : Begin
            Quit3:=True;
            RedrawUserScr;
            Helpwin(110); GotoXY(20,16);
			  End;
   		End;
		 Until Quit3=true;

       HelpWin(108);
		End;
   End;
 End;
	If ChangeMade=True Then SaveUserdat(UserNum);
End;

{}
Procedure User;
Var
Varv		: byte;
Quit2		: boolean;
Falt		: byte;
oldx,oldy : Byte;

Begin
{   SelectUserScr;}

   RedrawUserScr;

   Falt:=1;
   Repeat
      regs.ah := $00;
	   intr( $16,regs );
		Case regs.ah of
      15 : Begin
            If regs.al=9 Then Begin
      		 If Falt=10 Then Falt:=1 Else Inc(Falt);
             Case Falt of
             1 : Begin GotoXY(16,6); Helpwin(101) End;
             2 : Begin GotoXY(16,7); Helpwin(102) End;
             3 : Begin GotoXY(16,8); Helpwin(103) End;
             4 : Begin GotoXY(16,9); Helpwin(104) End;
             5 : Begin GotoXY(11,10); Helpwin(105) End;
             6 : Begin GotoXY(11,11); Helpwin(106) End;
             7 : Begin GotoXY(20,13); Helpwin(107); End;
             8 : Begin GotoXY(20,14); Helpwin(108); End;
             9 : Begin GotoXY(20,15); Helpwin(109); End;
				 10 : Begin GotoXY(20,16); Helpwin(110); End;
             End;
      		End Else
				Begin
        		  If Falt=1 Then Falt:=10 Else Dec(Falt);
              Case Falt of
              1 : Begin GotoXY(16,6); Helpwin(101) End;
              2 : Begin GotoXY(16,7); Helpwin(102) End;
              3 : Begin GotoXY(16,8); Helpwin(103) End;
              4 : Begin GotoXY(16,9); Helpwin(104) End;
              5 : Begin GotoXY(11,10); Helpwin(105) End;
              6 : Begin GotoXY(11,11); Helpwin(106) End;
              7 : Begin GotoXY(20,13); Helpwin(107); End;
              8 : Begin GotoXY(20,14); Helpwin(108); End;
              9 : Begin GotoXY(20,15); Helpwin(109); End;
				  10 : Begin GotoXY(20,16); Helpwin(110); End;
              End;
      		End;
           End;
      28: Begin
				Case Falt of
             1 : EditFalt(Falt);
             2 : EditFalt(Falt);
             3 : EditFalt(Falt);
             4 : EditFalt(Falt);
             5 : EditFalt(Falt);
             6 : EditFalt(Falt);
             7 : EditFalt(Falt);
             8 : EditFalt(Falt);
             9 : EditFalt(Falt);
             10 : EditFalt(Falt);
            End;
      	  End;
      81: Begin
           If regs.al=0 Then Begin
            If UserNum>0 Then Begin
             oldx:=WhereX;
             oldy:=WhereY;
           	 Dec(UserNum);
				 ReadUserdat(UserNum);
             RedrawUserScr;
             GotoXY(oldx,oldy);
            End Else Begin
             oldx:=WhereX;
             oldy:=WhereY;
				 UserNum:=MaxUser-1;
				 ReadUserdat(UserNum);
             RedrawUserScr;
             GotoXY(oldx,oldy);
           End;
          End;
      	 End;
      73: Begin
           If regs.al=0 Then Begin
            If UserNum<MaxUser-1 Then Begin
             oldx:=WhereX;
             oldy:=WhereY;
				 Inc(UserNum);
             ReadUserdat(UserNum);
             RedrawUserScr;
             GotoXY(oldx,oldy);
            End Else Begin
             oldx:=WhereX;
             oldy:=WhereY;
				 UserNum:=0;
             ReadUserdat(UserNum);
             RedrawUserScr;
             GotoXY(oldx,oldy);
            End;
           End;
         End;
      71: Begin
           If regs.al=0 Then Begin
             oldx:=WhereX;
             oldy:=WhereY;
				 UserNum:=0;
             ReadUserdat(UserNum);
             RedrawUserScr;
             GotoXY(oldx,oldy);
           End;
         End;
      79: Begin
           If regs.al=0 Then Begin
             oldx:=WhereX;
             oldy:=WhereY;
				 UserNum:=(MaxUser-1);
             ReadUserdat(UserNum);
             RedrawUserScr;
             GotoXY(oldx,oldy);
				End;
         End;
      82: Begin
			  If regs.al=0 Then Begin
            oldx:=WhereX;
            oldy:=WhereY;
            UserNum:=MaxUser;
            AddUser(UserNum);
            Inc(MaxUser);
            UserNum:=MaxUser-1;
            ReadUserdat(UserNum);
            RedrawUserScr;
            GotoXY(oldx,oldy);
           End;
      	End;
      83: Begin
           If regs.al=0 Then Begin
				If MaxUser>1 Then Begin
				 DelUser(UserNum);
             If UserNum>0 Then Dec(UserNum);
             oldx:=WhereX;
             oldy:=WhereY;
             Dec(MaxUser);
             ReadUserdat(UserNum);
             RedrawUserScr;
             GotoXY(oldx,oldy);
            End;
           End;
      	End;
      59: Begin
           If regs.al=0 Then Begin
            oldx:=WhereX;
            oldy:=WhereY;
				HelpProc;
            RedrawUserScr;
            GotoXY(oldx,oldy);
			  End;
      	End;
      33: Begin
           If regs.al=0 Then Begin
            oldx:=WhereX;
            oldy:=WhereY;
            FindWin;
            GotoXY(oldx,oldy);
			  End;
      	End;
      1: Begin
            Quit2:=True;
			  End;
   	End;
   Until (quit2=True);
   Window(1,3,80,24);
   Clrscr;
	Window(1,1,80,25);
End;
{}
Procedure Load;
var
 varv : byte;
Begin
	Window(20,9,60,16);
   TextColor(Cyan);
   TextBackground(Blue);
   Clrscr;
	Write('');
   TextAttr:=$17; GotoXY(13,1);
   Writeln(' LOAD USER FiLE ');
   TextColor(White);
	Writeln('  Enter the PATH to the user file you');
   Writeln('  want to edit. USER.DAT is the only ');
   Writeln('  allowed filename.                  ');
   Writeln('  EX: C:\ITC                         ');

   GotoXY(1,7); TextColor(Cyan);
   Write('');
	Window(1,3,80,24);
   TextBackground(Black);
   TextColor(Darkgray);
   For varv:= 8 To 14 Do Begin
    	GotoXY(61,varv);
  	 	Write('');
   End;
   GotoXY(20,14);
   Write('  ');
   GotoXY(22,12);
   my_readln(ItcStrTemp,30,0,15);

{   If ItcStrTemp.line<>'' Then FileCheck(ItcStrTemp.line);}

   If (FileCheck(ItcStrTemp.line)=True) And (ItcStrTemp.line<>'') Then Begin
     ItcStr2 := ItcStrTemp.line;
     _init_MaxUser;
     If UserNum>MaxUser Then UserNum:=0;
     ReadUserdat(UserNum);
     Window(20,9,60,16);
     TextAttr:=$1F;
     Writeln;
     Writeln('                                       ');
	  Writeln('  File found and successfully loaded!');
     Writeln('  In The Year Of Our Lord .:95:.');
	  Writeln('   <press any key to continue>  ');
     Writeln('                                ');
     Readkey;
	End;
	If (FileCheck(ItcStrTemp.line)=False) And (ItcStrTemp.line<>'') Then Begin
     Window(20,9,60,16);
     TextAttr:=$1F;
     Writeln;
	  Writeln('  File not found. Please check your   ');
     Writeln('  typing and try again.             ');
     Writeln('  In The Year Of Our Lord .:95:.    ');
     Writeln('   <press any key to continue>      ');
     Writeln('                                    ');
     Readkey;

   End;

	  Window(1,3,80,24); TextAttr:=$0F;
     Clrscr;
     Window(1,1,80,25);
End;

{}
Procedure Save;
Begin
	Window(30,10,47,15);
   TextColor(Cyan);
   TextBackground(Blue);
   Clrscr;
	Write  ('');
   Writeln; TextColor(White);
   Writeln('  Automatic save ');
   Writeln; TextColor(Cyan);
   Write  ('');
	Window(1,3,80,24);
   TextBackground(Black);
   TextColor(Darkgray);
   GotoXY(48,9);
   Write('');
   GotoXY(48,10);
   Write('');
   GotoXY(48,11);
   Write('');
   GotoXY(48,12);
   Write('');
   GotoXY(30,13);
   Write('  ');
   TextBackground(Black);
	Readkey;
   Clrscr;
   Window(1,1,80,25);
End;

{}
Begin
   xold := wherex;
   yold := wherey;
   vpm1;
   Quit:=False;
   UserdatStr:='\user.dat';
	ButtonNr:=1;
   EmptyUserRec;
   _init_help;

	For temp := 1 to EnvCount do begin
    ItcStr := Copy(EnvStr(temp), 1, 8);
    If ItcStr='INSTINCT' Then ItcStr2:=Copy(EnvStr(temp), 10, 24)
   End;

   If (ItcStr2='') Or (Not(FileCheck(Itcstr2))) Then Quit:=True;

    If Quit=True Then Begin
      ClrScr;
      Sound(200);
      Delay(50);
      Nosound;
      Writeln('CAN''T FIND USER.DAT MAKE SURE YOU HAVE THE');
      Writeln('RIGHT ENVIRONMENT STRiNG AND A EXISTING USER.DAT');
      Writeln('Please type the following line:');
      Writeln('SET INSTINCT=<BBS base path>');
      Writeln('or use Itcsetup to create a new USER.DAT ');
      regs.ah := $00;
	   intr( $16,regs );
      vpm2;
      gotoxy(xold,yold);
      Halt(0);
     End;

	_init_MaxUser;

	Main;
   Repeat
   regs.ah := $00;
	intr( $16,regs );
		Case regs.ah of
      15 : Begin
             If regs.al=9 Then Begin
      		  If ButtonNr=4 Then ButtonNr:=1 Else Inc(ButtonNr);
              Button(ButtonNr);
      		 End Else Begin
              If ButtonNr=1 Then ButtonNr:=4 Else Dec(ButtonNr);
              Button(ButtonNr);
             End;
      	  End;
      28: Begin
             Case ButtonNr of
              1 : User;
              2 : Load;
              3 : Save;
              4 : Quit:=True;
      	    End;
           End;
      1: Begin
				 Break;
				End;
      End;
   Button(ButtonNr);
   Until (Quit=True);
   TextBackground(Black);
   TextColor(White);
   FadeDown;
   Delay(500);
   vpm2;
   Gotoxy(xold,yold);
   FadeUp;
End.
