{

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ  v1.15

  The Universal Multimedia Interface For BBS Software
  Copyright 1995-1997 * Larry L. Athey * BBS Utiliteez Software


  Information Regarding MAX Graphics:
  
  Notice is hereby given that the MAXscript/MAXcontrol/MAXcolor language,
  and MAXterm are products of BBS Utiliteez Software and are protected by
  US copyrights listed with the US Library Of Congress (1996)....

  No changes, additions, subtractions, or other modifications shall be made
  to MAXscript/MAXcontrol/MAXcolor language or the MAX Graphics development
  kit without express written permission from Larry L. Athey, BBS Utiliteez
  Software, Alliance, Nebraska, USA....

  The MAXscript/MAXcontrol/MAXcolor language may be used in any BBS or Door
  software 100% royalty free. You are also allowed to implement full local
  graphics viewing in any BBS or Door software 100% royalty free. However,
  any program that uses the MAXscript/MAXcontrol/MAXcolor language *MUST*
  bear the MAX Graphics/BBS Utiliteez Software copyright notice....


  Example: MAX Graphics and the MAXscript/MAXcontrol/MAXcolor language is
           Copyright 1995-1997 * Larry L. Athey * BBS Utiliteez Software



  This is the main MAXscript/MAXcontrol/MAXcolor interpreter unit. This unit
  is used to read strings of text and convert them into local graphics.  You
  will notice there are quite a few re-used procedures and variables in here
  which may be a bit confusing.  This is done in order to keep the code to a
  minimum, sorry about the added confusion....

  This unit requires you to either have a copy of TDK or otherwise known as
  The DoorKit from BBS Utiliteez Software, or any other communications type
  development kit. If you choose not to use TDK, then you will need to make
  heavy modifications to this unit to use your own procedures/functions....

{$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
UNIT _SCRIPT;

INTERFACE

TYPE Max_Data = RECORD               {The MAX data record for conversions   }
     Text     : STRING;              {Text string for the current record    }
     Code     : BYTE;                {MAXcontrol/MAXcolor command code      }
     VType    : BYTE;                {126-MAXcontrol, 125-MAXcolor          }
     V        : ARRAY[1..10] OF INTEGER;{Array of command variables         }
     END;

VAR
  _Max       : Max_Data;       {Record variable for the Max_Data record     }
  ResPath    : STRING[80];     {Resource Path                               }
  SesPath    : STRING[80];     {Session Path                                }
  DownPath1  : STRING[80];     {System download path                        }
  DownPath2  : STRING[80];     {System download path backup                 }
  User_Name  : STRING[30];     {The current user's name                     }
  Pass_Word  : STRING[30];     {The current user's password                 }
  ScrStr     : STRING;         {String that holds the current script command}
  UseSB      : BOOLEAN;        {Use SoundBlaster [Y/N]                      }
  ScreenDone : BOOLEAN;        {Becomes TRUE upon the End_Screen() command  }
  MaxConv    : BOOLEAN;        {Only convert MAX commands [Y/N]             }
  TextFile   : TEXT;           {Text file created by Start_Text_File()      }

PROCEDURE CheckControlLine(Command : STRING);
{^ This procedure is used to check a text string to see if it matches one
   of the predefined MAXscript commands.}
PROCEDURE CheckScriptLine(Command : STRING);
{^ This procedure is used to check a text string to see if it matches one
   of the predefined MAXcontrol commands.}
PROCEDURE CheckColorCommand(Command : STRING);
{^ This procedure is used to check a text string to see if it matches one
   of the predefined MAXcolor commands.}
PROCEDURE WriteSystemInfo;
{^ This procedure writes the SYSTEM.NFO file.}
PROCEDURE Text_View_Window(X1,Y1,X2,Y2 : INTEGER);
PROCEDURE Text_View_Port(X1,Y1,X2,Y2 : INTEGER);
{^ These are leftovers from MAXpaint. The actual procedures must remain in
   the body of this unit, but you may remove the procedure forwards if you
   don't need them made public.}

IMPLEMENTATION

USES DOS, CRT, GRAPH, {*}MOUSE, {*}VESACHK, SVGAUNIT, SVGAANSI,
     TDK_VARS, DOORKIT1, DOORKIT2;
    {^^^^^^^^^^^^^^^^^^^^^^^^^^^^---See note in the above!}

{Units marked with an asterisk are from the ULTRABGI.ZIP development kit.   }

PROCEDURE WriteSystemInfo;
VAR
  Txt    : TEXT;
  TheDir : STRING[68];
BEGIN
  GETDIR(0,TheDir);
  ASSIGN(Txt,'SYSTEM.NFO');
  REWRITE(Txt);
  WRITELN(Txt,'Program Name..........: '+ProgramName);
  WRITELN(Txt,'MAXscript Version.....: '+MaxID);
  WRITELN(Txt,'Current Directory.....: '+TheDir);
  WRITELN(Txt,'Download Path.........: '+AllCaps(DownPath1));
  WRITELN(Txt,'User Name.............: '+User_Name);
  WRITELN(Txt,'User Password.........: '+Pass_Word);
  WRITELN(Txt,'Operating System......: '+OsStr);
  WRITELN(Txt,'Conventional Memory...: '+IntToStr(MEMAVAIL)+' Bytes');
  WRITELN(Txt,'Free Disk Space.......: '+IntToStr(DISKFREE(0))+' Bytes');
  IF IsVesa THEN WRITELN(Txt,'VESA Compatible.......: YES')
            ELSE WRITELN(Txt,'VESA Compatible.......: NO');
  IF SVGAmode THEN WRITELN(Txt,'Current Video Mode....: SVGA')
              ELSE WRITELN(Txt,'Current Video Mode....: Text');
  CLOSE(Txt);
END;

PROCEDURE ShowRemoteScreen(FName : STRING);
VAR
  Txt : TEXT;
  X   : BYTE;
BEGIN
  IF NOT FExist(SesPath + FName) THEN BEGIN
    OutText_XY(10,30,15,1,SesPath + FName + ' Not Found!');
    OutText_XY(10,40,15,1,'Please Update Your Resources!');
    CheckScriptLine('Siren()');
    EXIT;
  END;
  ASSIGN(Txt,SesPath + FName);
  RESET(Txt);
  WHILE NOT EOF(Txt) DO BEGIN
    READLN(Txt,ScrStr);
    ScrStr := StripBoth(ScrStr,' ');
    IF POS(#255#126,ScrStr) = 1 THEN CheckControlLine(ScrStr) ELSE
    IF POS(#255#125,ScrStr) = 1 THEN CheckColorCommand(ScrStr) ELSE
    IF ScrStr <> '' THEN CheckScriptLine(ScrStr);
  END;
  CLOSE(Txt);
END;

PROCEDURE Do_ADDTO_PICKLIST(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := StripBoth(P,#39);
  IF MaxConv THEN WITH _Max DO BEGIN
    Text  := P;
    Code  := 149;
    VType := 126;
    EXIT;
  END;
  AddTo_PickList(P);
END;

PROCEDURE Do_ANIMATE_ICON(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 1000;
  _Max.V[6] := 255;
  _Max.V[7] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 1000 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
      6 : IF _Max.V[6] = 255 THEN BEGIN
            _Max.V[6] := StrToInt(Temp);
            IF (_Max.V[6] > 3) OR (_Max.V[6] < 1) THEN _Max.V[6] := 1;
            Temp := '';
          END;
      7 : IF _Max.V[7] = 255 THEN BEGIN
            _Max.V[7] := StrToInt(Temp);
            IF _Max.V[7] > 99 THEN _Max.V[7] := 99;
            Temp := '';
          END;
    END;
  END;
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 173;
    VType := 126;
    CASE V[6] OF
      1 : BEGIN
            V[9]  := 15;
            V[10] := 15;
          END;
      2 : BEGIN
            V[9]  := 29;
            V[10] := 29;
          END;
      3 : BEGIN
            V[9]  := 59;
            V[10] := 59;
          END;
    END;
    EXIT;
  END;
  WITH _Max DO AnimateIcon(V[1],V[2],V[3],V[4],V[5],V[6],V[7]);
END;

PROCEDURE Text_View_Window(X1,Y1,X2,Y2 : INTEGER);
VAR
  WinX2,
  WinY2  : INTEGER;
BEGIN
  ResetANSI;
  IF X2 > 77 THEN X2 := 77;
  IF Y2 > 25 THEN Y2 := 25;
  IF NOT MaxConv THEN BEGIN
    TvWin.X1     := X1;
    TvWin.Y1     := Y1;
    TvWin.X2     := X2;
    TvWin.Y2     := Y2;
    TvWin.Active := TRUE;
  END;
  WinX2    := ((X2*8) + 22) + X1;
  WinY2    := ((Y2*14) + 42) + Y1;
  StartX   := X1 + 11;
  StartY   := Y1 + 31;
  ColLimit := X2;
  RowLimit := Y2;
  SETFILLSTYLE(1,C.Win1Back); BAR(X1,Y1,WinX2,WinY2);
  SETCOLOR(C.Win1High); RECTANGLE(X1,Y1,WinX2,WinY2);
  SETCOLOR(C.Win1Low);  RECTANGLE(X1 + 3,Y1 + 3,WinX2 - 3,WinY2 - 3);
  SETCOLOR(0); SETLINESTYLE(SolidLn,0,3);
  LINE(WinX2 + 2,WinY2 + 1,X1 + 5,WinY2 + 1);
  LINE(WinX2 + 1,Y1 + 5,WinX2 + 1,WinY2);
  Draw_Line(X1 + 1,WinY2,WinX2,WinY2,C.Win1Frame2);
  Draw_Line(WinX2,Y1 + 1,WinX2,WinY2,C.Win1Frame2);
  SETFILLSTYLE(1,C.ActiveHdr); BAR(X1 + 4,Y1 + 4,WinX2 - 4,Y1 + 22);
  Draw_Line(X1 + 4,Y1 + 23,WinX2 - 4,Y1 + 23,C.Win1Frame1);
  OutText_XY(X1 + 9,Y1 + 6,C.HdrTitle,2,'Text View Window');
  Draw_Line(X1 + 4,WinY2 - 3,WinX2 - 3,WinY2 - 3,C.Win1High);
  Draw_Line(WinX2 - 3,Y1 + 4,WinX2 - 3,WinY2 - 3,C.Win1High);
  FrameLow(X1 + 10, Y1 + 30,WinX2 - 10,WinY2 - 10);
  Clr_Scr;
END;

PROCEDURE Text_View_Port(X1,Y1,X2,Y2 : INTEGER);
BEGIN
  ResetANSI;
  IF X2 > 79 THEN X2 := 79;
  IF Y2 > 25 THEN Y2 := 25;
  IF NOT MaxConv THEN BEGIN
    TvWin.X1     := X1;
    TvWin.Y1     := Y1;
    TvWin.X2     := X2;
    TvWin.Y2     := Y2;
    TvWin.Active := TRUE;
  END;
  StartX   := X1;
  StartY   := Y1;
  ColLimit := X2;
  RowLimit := Y2;
  FrameLow(X1-1,Y1-1,X1 + (X2 * 8) + 1,Y1 + (Y2 * 14) + 1);
  Clr_Scr;
END;

PROCEDURE Do_SQUARE(P : STRING ; WhichOne : BYTE);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp   := '';
  PCount := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 1000 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  IF MaxConv THEN WITH _Max DO BEGIN
    CASE WhichOne OF
      1 : Code := 159;
      2 : Code := 144;
      3 : Code := 145;
      4 : Code := 162;
      5 : Code := 147;
      6 : Code := 146;
      7 : Code := 132;
      8 : BEGIN
            Code := 252;
            IF V[3] > 77 THEN V[3] := 77;
            IF V[4] > 25 THEN V[4] := 25;
          END;
      9 : Code := 171;
      10: Code := 174;
      11: BEGIN
            Code := 186;
            IF V[3] > 79 THEN V[3] := 79;
            IF V[4] > 25 THEN V[4] := 25;
          END;
    END;
    VType := 126;
    EXIT;
  END;
  WITH _Max DO BEGIN
    SETCOLOR(V[5]);
    CASE WhichOne OF
      1 : BAR(V[1],V[2],V[3],V[4]);
      2 : FrameHigh(V[1],V[2],V[3],V[4]);
      3 : FrameLow(V[1],V[2],V[3],V[4]);
      4 : RECTANGLE(V[1],V[2],V[3],V[4]);
      5 : LoweredBox(V[1],V[2],V[3],V[4]);
      6 : RaisedBox(V[1],V[2],V[3],V[4]);
      7 : Draw_Line(V[1],V[2],V[3],V[4],V[5]);
      8 : Text_View_Window(V[1],V[2],V[3],V[4]);
      9 : Click_Zone(V[1],V[2],V[3],V[4],V[5]);
     10 : User_Button(V[1],V[2],V[3],V[4],V[5]);
     11 : Text_View_Port(V[1],V[2],V[3],V[4]);
    END;
  END;
END;

PROCEDURE Do_CHANGE_FIELD(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := StripBoth(P,#39);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 152;
    VType := 126;
    V[1]  := StrToInt(P);
    EXIT;
  END;
  ChangeField(StrToInt(P));
END;

PROCEDURE Do_CLEAR_SCREEN(P : STRING);
BEGIN
  P := StripBoth(P,#39);
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 161;
    VType := 126;
    V[1]  := StrToInt(P);
    EXIT;
  END;
  SETCOLOR(0); RECTANGLE(0,0,639,479);
  SETFILLSTYLE(1,StrToInt(P)); BAR(1,21,638,458);
END;

PROCEDURE Do_DRAW_BUTTON(P : STRING);
VAR
  Loop    : BYTE;
  PCount  : BYTE;
  UseIcon : BOOLEAN;
  DoAll   : BOOLEAN;
  Temp    : STRING;
  Scrap   : CHAR;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 255;
  _Max.V[5] := 0;
  _Max.V[6] := 1000;
  UseIcon   := FALSE;
  DoAll     := FALSE;
  Scrap     := '!';
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 255 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF Scrap = '!' THEN BEGIN
            IF Temp = '1' THEN BEGIN
              UseIcon := TRUE;
              _Max.V[5] := 1;
            END;
            Scrap := '.';
            Temp  := '';
          END;
      6 : IF _Max.V[6] = 1000 THEN BEGIN
            _Max.V[6] := StrToInt(Temp);
            IF _Max.V[6] > 99 THEN _Max.V[6] := 99;
            Temp := ''
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 130;
    VType := 126;
    EXIT;
  END;
  WITH _Max DO Draw_Button(V[1],V[2],V[3],V[4],UseIcon,V[6],Text);
END;

PROCEDURE Do_DRAW_CIRCLE(P : STRING);
VAR
  PCount : BYTE;
  Loop   : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 158;
    VType := 126;
    EXIT;
  END;
  WITH _Max DO BEGIN
    SETCOLOR(V[4]);
    CIRCLE(V[1],V[2],V[3]);
  END;
END;

PROCEDURE Do_ELLIPSE(P : STRING ; WhichOne : BYTE);
VAR
  PCount : BYTE;
  Loop   : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 1000;
  _Max.V[6] := 1000;
  _Max.V[7] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 1000 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
      6 : IF _Max.V[6] = 1000 THEN BEGIN
            _Max.V[6] := StrToInt(Temp);
            Temp := '';
          END;
      7 : IF _Max.V[7] = 1000 THEN BEGIN
            _Max.V[7] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  IF MaxConv THEN WITH _Max DO BEGIN
    CASE WhichOne OF
      1 : Code := 166;
      2 : Code := 172;
      3 : Code := 175;
      4 : Code := 178;
      5 : Code := 179;
    END;
    VType := 126;
    IF WhichOne = 5 THEN CASE V[7] OF
      1 : BEGIN
            V[8] := 15;
            V[9] := 15;
          END;
      2 : BEGIN
            V[8] := 29;
            V[9] := 29;
          END;
      3 : BEGIN
            V[8] := 59;
            V[9] := 59;
          END;
    END;
    EXIT;
  END;
  WITH _Max DO BEGIN
    IF WhichOne < 3 THEN SETCOLOR(V[7]);
    CASE WhichOne OF
      1 : BEGIN
            SETCOLOR(V[7]);
            ELLIPSE(V[1],V[2],V[3],V[4],V[5],V[6]);
          END;
      2 : BEGIN
            SETCOLOR(V[7]);
            SECTOR(V[1],V[2],V[3],V[4],V[5],V[6]);
          END;
      3 : BEGIN
            SETCOLOR(V[6]);
            PIESLICE(V[1],V[2],V[3],V[4],V[5]);
          END;
      4 : BEGIN
            Draw_Line(V[1],V[2],V[3],V[4],V[7]);
            Draw_Line(V[3],V[4],V[5],V[6],V[7]);
            Draw_Line(V[5],V[6],V[1],V[2],V[7]);
          END;
      5 : BEGIN
            IF V[3] > 99 THEN V[3] := 99;
            IF V[4] > 99 THEN V[4] := 99;
            IF V[5] > 99 THEN V[5] := 99;
            IF V[6] > 99 THEN V[6] := 99;
            IF (V[7] > 3) AND (V[7] < 1) THEN V[7] := 1;
            Flip_Icon(V[1],V[2],V[3],V[4],V[5],V[6],V[7]);
          END;
    END;
  END;
END;

PROCEDURE Do_DRAW_WINDOW(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 255 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 128;
    VType := 126;
    EXIT;
  END;
  WITH _Max DO Draw_Window(V[1],V[2],V[3],V[4],V[5],3,Text);
END;

PROCEDURE Do_END_SCREEN;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 254;
    VType := 126;
    EXIT;
  END;
  IF PickInfo.Active AND NOT PickInfo.Running THEN SetUp_PickList;
  IF TextReader.Active AND NOT TextReader.Running THEN ShowTextPage;
  IF TextEditor.Active AND NOT TextEditor.Running THEN RunTextEditor;
  Show_Mem;
  ScreenDone := TRUE;
END;

PROCEDURE Do_ENTRY_FIELD(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 255;
  _Max.V[4] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 255 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 255 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 131;
    VType := 126;
    EXIT;
  END;
  WITH _Max DO Entry_Field(V[1],V[2],V[3],V[4],Text);
END;

PROCEDURE Do_FIELD_TEXT(P : STRING ; WhichOne : BYTE);
VAR
  F      : INTEGER;
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
  Txt    : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            F := _Max.V[1];
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  IF MaxConv THEN WITH _Max DO BEGIN
    VType := 126;
    CASE WhichOne OF
      1 : Code := 248;
      2 : Code := 183;
    END;
    EXIT;
  END;
  CASE WhichOne OF
    1 : Fields[F].Text := _Max.Text;
    2 : BExt[F].ButStr := _Max.Text;
  END;
END;

PROCEDURE Do_GET_EDITOR_TEXT;
VAR
  Loop  : BYTE;
  TFile : TEXT;
  TStr  : String[80];
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 249;
    VType := 126;
    EXIT;
  END;
  RaisedBox(0,459,639,479);
  ShadowText(282,461,14,0,2,'Sending Editor Text');
  IF FExist(EditorFile) THEN BEGIN
    ASSIGN(TFile,EditorFile);
    RESET(TFile);
    WHILE NOT EOF(TFile) DO BEGIN
      READLN(TFile,TStr);
      IF Carrier THEN SendStr(TStr+#13#10);
    END;
    CLOSE(TFile);
  END;
  IF Carrier THEN SendStr(#255#255#13#10);
  RaisedBox(0,459,639,479);
  ShadowText(7,461,15,0,2,'Running Under '+OsStr);
  Show_Mem;
END;

PROCEDURE Do_GET_FIELD_DATA;
VAR
  Loop : BYTE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 250;
    VType := 126;
    EXIT;
  END;
  RaisedBox(0,459,639,479);
  ShadowText(282,461,14,0,2,'Sending Field Data');
  FOR Loop := 1 TO NFields DO IF Carrier THEN SendStr(Fields[Loop].Text+#13#10);
  IF Carrier THEN SendStr(#255#255#13#10);
  RaisedBox(0,459,639,479);
  ShadowText(7,461,15,0,2,'Running Under '+OsStr);
  Show_Mem;
END;

PROCEDURE Do_GET_PICK_INFO;
VAR
  Loop : BYTE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 247;
    VType := 126;
    EXIT;
  END;
  IF Carrier THEN BEGIN
    SendStr(IntToStr(PickInfo.Current)+#13#10);
    SendStr(PickList^[PickInfo.Current]+#13#10);
    SendStr(#255#255#13#10);
  END;
END;

PROCEDURE Do_LOAD_TEXT_FILE(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := GetFileName(StripBoth(P,#39));
  IF MaxConv THEN WITH _Max DO BEGIN
    Text  := P;
    Code  := 167;
    VType := 126;
    EXIT;
  END;
  FillTextBuffer(SesPath + P);
END;

PROCEDURE Do_MOUSE_MASK(P : STRING);
VAR
  M : WORD;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  M := StrToInt(P);
  IF M > 18 THEN M := MouseClockCursor;
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 141;
    VType := 126;
    V[1]  := M;
    EXIT;
  END;
  MouseGraphicCursor(M);
END;

PROCEDURE Do_NEW_PICKLIST(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            IF _Max.V[3] > 30 THEN _Max.V[3] := 30;
            Temp := '';
          END;
      4 : IF _Max.V[4] = 255 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            IF _Max.V[4] > 80 THEN _Max.V[4] := 80;
            Temp := '';
          END;
    END;
  END;
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 168;
    VType := 126;
    EXIT;
  END;
  WITH _Max DO New_PickList(V[1],V[2],V[3],V[4]);
END;

PROCEDURE Do_NEW_TEXT_EDITOR(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := StripBoth(P,#39);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 154;
    VType := 126;
    V[1]  := StrToInt(P);
    EXIT;
  END;
  IF FExist(EditorFile) THEN FErase(EditorFile);
  New_TextEditor(StrToInt(P));
END;

PROCEDURE Do_NEW_TEXT_READER(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := StripBoth(P,#39);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 156;
    VType := 126;
    V[1]  := StrToInt(P);
    EXIT;
  END;
  New_TextReader(0,StrToInt(P));
END;

PROCEDURE Do_PLAY_SOUND(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := GetFileName(StripBoth(P,#39));
  IF MaxConv THEN WITH _Max DO BEGIN
    Text  := P;
    Code  := 163;
    VType := 126;
    EXIT;
  END;
  IF NOT UseSB THEN EXIT;
  _Execute('MAXSOUND.EXE',SesPath + P);
END;

PROCEDURE Do_PUT_IMAGE(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := GetFileName(StripBoth(Temp,#39));
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 164;
    VType := 126;
    EXIT;
  END;
  WITH _Max DO Put_Image(V[1],V[2],SesPath + Text);
END;

PROCEDURE Do_PUT_ICON(P : STRING ; IconSize : BYTE);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            IF _Max.V[3] > 99 THEN _Max.V[3] := 99;
            Temp := '';
          END;
    END;
  END;
  IF MaxConv THEN WITH _Max DO BEGIN
    CASE IconSize OF
      1 : BEGIN
            Code := 138;
            V[4] := 15;
            V[5] := 15;
          END;
      2 : BEGIN
            Code := 137;
            V[4] := 29;
            V[5] := 29;
          END;
      3 : BEGIN
            Code := 136;
            V[4] := 59;
            V[5] := 59;
          END;
    END;
    VType := 126;
    EXIT;
  END;
  WITH _Max DO CASE IconSize OF
    1 : PutIcon16(V[1],V[2],V[3]);
    2 : PutIcon30(V[1],V[2],V[3]);
    3 : PutIcon60(V[1],V[2],V[3]);
  END;
END;

PROCEDURE Do_TRIANGLE(P : STRING ; WhichOne : BYTE);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  IF MaxConv THEN WITH _Max DO BEGIN
    CASE WhichOne OF
      1 : BEGIN
            Code := 170;
            V[4] := 14;
            V[5] := 14;
          END;
      2 : Code := 177;
      3 : Code := 165;
    END;
    VType := 126;
    EXIT;
  END;
  WITH _Max DO CASE WhichOne OF
    1 : Radio_Button(V[1],V[2],V[3]);
    2 : PUTPIXEL(V[1],V[2],V[3]);
    3 : FLOODFILL(V[1],V[2],V[3]);
  END;
END;

PROCEDURE Do_RESET_PICKLIST(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := StripBoth(P,#39);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 151;
    VType := 126;
    V[1]  := StrToInt(P);
    EXIT;
  END;
  Reset_PickList(StrToInt(P));
END;

PROCEDURE Do_SET_FILL_STYLE(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF P[Loop] <> #44 THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  IF _Max.V[1] > 11 THEN _Max.V[1] := 1;
  IF _Max.V[2] > 255 THEN _Max.V[2] := 0;
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 160;
    VType := 126;
    EXIT;
  END;
  WITH _Max DO SETFILLSTYLE(V[1],V[2]);
END;

PROCEDURE Do_STANDARD_TEXT(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 255 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  IF _Max.V[3] > 255 THEN _Max.V[3] := 0;
  IF _Max.V[4] > 4 THEN _Max.V[4] := 3;
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 142;
    VType := 126;
    EXIT;
  END;
  WITH _Max DO OutText_XY(V[1],V[2],V[3],V[4],Text);
END;

PROCEDURE Do_SHADOW_TEXT(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 255 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  IF _Max.V[3] > 255 THEN _Max.V[3] := 0;
  IF _Max.V[4] > 255 THEN _Max.V[4] := 0;
  IF _Max.V[5] > 4 THEN _Max.V[5] := 3;
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 143;
    VType := 126;
    EXIT;
  END;
  WITH _Max DO ShadowText(V[1],V[2],V[3],V[4],V[5],Text);
END;

PROCEDURE Do_RESET_REMOTE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 169;
    VType := 126;
    EXIT;
  END;
  ResetGraphics;
  ResetANSI;
  EditorFile  := SesPath + 'TEXTFILE.TXT';
  IconLib16   := SesPath + 'ICON_LIB.001';
  IconLib30   := SesPath + 'ICON_LIB.002';
  IconLib60   := SesPath + 'ICON_LIB.003';
  BBSmessages := TRUE;
END;

PROCEDURE Do_SIREN;
VAR
  Frequency : INTEGER;
  Count     : BYTE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 184;
    VType := 126;
    EXIT;
  END;
  Count := 0;
  REPEAT
    INC(Count);
    Frequency := 600;
    REPEAT
      INC(Frequency,10);
      DELAY(1);
      SOUND(Frequency);
    UNTIL Frequency = 1200;
    REPEAT
      DEC(Frequency,10);
      DELAY(1);
      SOUND(Frequency);
    UNTIL Frequency = 600;
  UNTIL Count = 5;
  NOSOUND;
END;

PROCEDURE Do_MAXECUTE(TheFile : STRING);
VAR
  TheDir : STRING;
BEGIN
  IF MaxConv THEN WITH _Max DO BEGIN
    Text  := StripBoth(TheFile,#39);
    Code  := 185;
    VType := 126;
    EXIT;
  END;
  GETDIR(0,TheDir);
  TheFile := StripBoth(TheFile,#39);
  DeInitComport;
  Draw_Window(0,0,693,479,2,3,'');
  RESTORECRTMODE;
  CHDIR(NoPath(SesPath));
  _Execute(TheFile,TheDir);
  FErase('MAXINFO.DEF');
  CHDIR(TheDir);
  SETGRAPHMODE(GETGRAPHMODE);
  InitPalette;
  InitMouse;
  IF MouseInstalled THEN BEGIN
    SetPixelToMickey(6,10);
    UseSimMouse := True;
    MouseColor  := (15);
    SetMouseArea(0,0,639,479);
    SetMousePosition(PutMx(GetMaxX SHR 1),PutMy(GetMaxY SHR 1));
    MouseGraphicCursor(MouseStandard);
    ShowMouse;
  END;
  ShowMouse;
  Kill_Window;
  IF NOT InitComport THEN ErrorLog('Comport Error!',1,TRUE);
  SendStr(#13);
END;

PROCEDURE Do_EDITOR_FILE(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  EditorFile := SesPath + GetFileName(StripBoth(P,#39));
  IF MaxConv THEN WITH _Max DO BEGIN
    Text  := GetFileName(EditorFile);
    Code  := 176;
    VType := 126;
  END;
END;

PROCEDURE Do_HIDE_MOUSE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 139;
    VType := 126;
    EXIT;
  END;
  HideMouse;
END;

PROCEDURE Do_SHOW_MOUSE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 140;
    VType := 126;
    EXIT;
  END;
  ShowMouse;
END;

PROCEDURE Do_KILL_WINDOW;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 129;
    VType := 126;
    EXIT;
  END;
  Kill_Window;
END;

PROCEDURE Do_LARGE_ICON_LIB(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IconLib60 := SesPath + GetFileName(StripBoth(P,#39));
  IF MaxConv THEN WITH _Max DO BEGIN
    Text  := GetFileName(IconLib60);
    Code  := 135;
    VType := 126;
  END;
END;

PROCEDURE Do_MEDIUM_ICON_LIB(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IconLib30 := SesPath + GetFileName(StripBoth(P,#39));
  IF MaxConv THEN WITH _Max DO BEGIN
    Text  := GetFileName(IconLib30);
    Code  := 134;
    VType := 126;
  END;
END;

PROCEDURE Do_SMALL_ICON_LIB(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IconLib16 := SesPath + GetFileName(StripBoth(P,#39));
  IF MaxConv THEN WITH _Max DO BEGIN
    Text  := GetFileName(IconLib16);
    Code  := 133;
    VType := 126;
  END;
END;

PROCEDURE Do_LOAD_FONT(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Text  := GetFileName(StripBoth(P,#39));
    Code  := 148;
    VType := 126;
    EXIT;
  END;
  LoadUserFont(SesPath + GetFileName(StripBoth(P,#39)));
END;

PROCEDURE Do_REDRAW_FIELD;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 153;
    VType := 126;
    EXIT;
  END;
  RedrawField;
END;

PROCEDURE Do_RUN_TEXT_EDITOR;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 155;
    VType := 126;
    EXIT;
  END;
  IF TBuff <> NIL THEN BEGIN
    Show_Mem;
    RunTextEditor;
  END;
END;

PROCEDURE Do_SETUP_PICKLIST;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 150;
    VType := 126;
    EXIT;
  END;
  IF PickList <> NIL THEN SetUp_PickList;
END;

PROCEDURE Do_SHOW_TEXT_PAGE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 157;
    VType := 126;
    EXIT;
  END;
  IF Tbuff <> NIL THEN ShowTextPage;
END;

PROCEDURE Do_SHOW_REMOTE_SCREEN(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Text  := GetFileName(StripBoth(P,#39));
    Code  := 251;
    VType := 126;
    EXIT;
  END;
  ShowRemoteScreen(GetFileName(StripBoth(P,#39)));
END;

PROCEDURE Do_START_SCREEN;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 253;
    VType := 126;
  END;
END;

PROCEDURE Do_START_TEXT_FILE(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Text  := SesPath+GetFileName(StripBoth(P,#39));
    Code  := 180;
    VType := 126;
    EXIT;
  END;
  RaisedBox(0,459,639,479);
  ShadowText(280,461,14,0,2,'Receiving Text');
  ASSIGN(TextFile,SesPath+GetFileName(StripBoth(P,#39)));
  REWRITE(TextFile);
END;

PROCEDURE Do_PUT_TEXT_FILE(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  DELETE(P,1,1);
  DELETE(P,LENGTH(P),1);
  IF MaxConv THEN WITH _Max DO BEGIN
    Text  := P;
    Code  := 181;
    VType := 126;
    EXIT;
  END;
  WRITELN(TextFile,P);
END;

PROCEDURE Do_END_TEXT_FILE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  IF MaxConv THEN WITH _Max DO BEGIN
    Code  := 182;
    VType := 126;
    EXIT;
  END;
  RaisedBox(0,459,639,479);
  ShadowText(7,461,15,0,2,'Running Under '+OsStr);
  Show_Mem;
  CLOSE(TextFile);
END;

PROCEDURE CheckControlLine(Command : STRING);
VAR
  Code : CHAR;
BEGIN
  Code       := Command[3];
  ScreenDone := FALSE;
  DELETE(Command,1,3);
  IF Command[LENGTH(Command)] = #255 THEN BEGIN
    DELETE(Command,LENGTH(Command),1);
    CASE Code OF
      #149 : Do_ADDTO_PICKLIST(Command);
      #173 : Do_ANIMATE_ICON(Command);
      #159 : Do_SQUARE(Command,1);
      #152 : Do_CHANGE_FIELD(Command);
      #161 : Do_CLEAR_SCREEN(Command);
      #171 : Do_SQUARE(Command,9);
      #130 : Do_DRAW_BUTTON(Command);
      #158 : Do_DRAW_CIRCLE(Command);
      #248 : Do_FIELD_TEXT(Command,1);
      #166 : Do_ELLIPSE(Command,1);
      #172 : Do_ELLIPSE(Command,2);
      #132 : Do_SQUARE(Command,7);
      #162 : Do_SQUARE(Command,4);
      #128 : Do_DRAW_WINDOW(Command);
      #176 : Do_EDITOR_FILE(Command);
      #178 : Do_ELLIPSE(Command,4);
      #253 : Do_START_SCREEN;
      #254 : Do_END_SCREEN;
      #131 : Do_ENTRY_FIELD(Command);
      #165 : Do_TRIANGLE(Command,3);
      #175 : Do_ELLIPSE(Command,3);
      #144 : Do_SQUARE(Command,2);
      #145 : Do_SQUARE(Command,3);
      #249 : Do_GET_EDITOR_TEXT;
      #250 : Do_GET_FIELD_DATA;
      #247 : Do_GET_PICK_INFO;
      #139 : Do_HIDE_MOUSE;
      #129 : Do_KILL_WINDOW;
      #135 : Do_LARGE_ICON_LIB(Command);
      #148 : Do_LOAD_FONT(Command);
      #167 : Do_LOAD_TEXT_FILE(Command);
      #147 : Do_SQUARE(Command,5);
      #134 : Do_MEDIUM_ICON_LIB(Command);
      #141 : Do_MOUSE_MASK(Command);
      #168 : Do_NEW_PICKLIST(Command);
      #154 : Do_NEW_TEXT_EDITOR(Command);
      #156 : Do_NEW_TEXT_READER(Command);
      #163 : Do_PLAY_SOUND(Command);
      #164 : Do_PUT_IMAGE(Command);
      #136 : Do_PUT_ICON(Command,3);
      #137 : Do_PUT_ICON(Command,2);
      #138 : Do_PUT_ICON(Command,1);
      #170 : Do_TRIANGLE(Command,1);
      #177 : Do_TRIANGLE(Command,2);
      #146 : Do_SQUARE(Command,6);
      #153 : Do_REDRAW_FIELD;
      #151 : Do_RESET_PICKLIST(Command);
      #169 : Do_RESET_REMOTE;
      #155 : Do_RUN_TEXT_EDITOR;
      #160 : Do_SET_FILL_STYLE(Command);
      #150 : Do_SETUP_PICKLIST;
      #140 : Do_SHOW_MOUSE;
      #157 : Do_SHOW_TEXT_PAGE;
      #133 : Do_SMALL_ICON_LIB(Command);
      #142 : Do_STANDARD_TEXT(Command);
      #143 : Do_SHADOW_TEXT(Command);
      #252 : Do_SQUARE(Command,8);
      #186 : Do_SQUARE(Command,11);
      #251 : Do_SHOW_REMOTE_SCREEN(Command);
      #174 : Do_SQUARE(Command,10);
      #179 : Do_ELLIPSE(Command,5);
      #180 : Do_START_TEXT_FILE(Command);
      #181 : Do_PUT_TEXT_FILE(Command);
      #182 : Do_END_TEXT_FILE;
      #183 : Do_FIELD_TEXT(Command,2);
      #184 : Do_SIREN;
      #185 : Do_MAXECUTE(Command);
    END;
  END;
  ScrStr := '';
END;

PROCEDURE CheckScriptLine(Command : STRING);
VAR
  Temp : STRING;
  Loop : BYTE;
  Stop : BYTE;
BEGIN
  Temp       := '';
  ScreenDone := FALSE;
  FOR Loop := 1 TO LENGTH(Command) DO BEGIN
    Stop := Loop;
    IF Command[Loop] <> '(' THEN Temp := Temp + UPCASE(Command[Loop]);
    IF Command[Loop] = '(' THEN Break;
  END;
  DELETE(Command,1,Stop);
  IF Command[LENGTH(Command)] = ')' THEN BEGIN
    DELETE(Command,LENGTH(Command),1);
    IF Temp = 'ADDTO_PICKLIST' THEN Do_ADDTO_PICKLIST(Command);
    IF Temp = 'ANIMATE_ICON' THEN Do_ANIMATE_ICON(Command);
    IF Temp = 'BAR' THEN Do_SQUARE(Command,1);
    IF Temp = 'BUTTON_EXTENSION' THEN Do_FIELD_TEXT(Command,2);
    IF Temp = 'CHANGE_FIELD' THEN Do_CHANGE_FIELD(Command);
    IF Temp = 'CLEAR_SCREEN' THEN Do_CLEAR_SCREEN(Command);
    IF Temp = 'CLICK_ZONE' THEN Do_SQUARE(Command,9);
    IF Temp = 'DRAW_BUTTON' THEN Do_DRAW_BUTTON(Command);
    IF Temp = 'DRAW_CIRCLE' THEN Do_DRAW_CIRCLE(Command);
    IF Temp = 'DRAW_ELLIPSE' THEN Do_ELLIPSE(Command,1);
    IF Temp = 'DRAW_BEZIER' THEN Do_ELLIPSE(Command,2);
    IF Temp = 'DRAW_LINE' THEN Do_SQUARE(Command,7);
    IF Temp = 'DRAW_RECTANGLE' THEN Do_SQUARE(Command,4);
    IF Temp = 'DRAW_TRIANGLE' THEN Do_ELLIPSE(Command,4);
    IF Temp = 'DRAW_WINDOW' THEN Do_DRAW_WINDOW(Command);
    IF Temp = 'EDITOR_FILE' THEN Do_EDITOR_FILE(Command);
    IF Temp = 'END_SCREEN' THEN Do_END_SCREEN;
    IF Temp = 'ENTRY_FIELD' THEN Do_ENTRY_FIELD(Command);
    IF Temp = 'FIELD_TEXT' THEN Do_FIELD_TEXT(Command,1);
    IF Temp = 'FLIP_ICON' THEN Do_ELLIPSE(Command,5);
    IF Temp = 'FLOOD_FILL' THEN Do_TRIANGLE(Command,3);
    IF Temp = 'FRAME_HIGH' THEN Do_SQUARE(Command,2);
    IF Temp = 'FRAME_LOW' THEN Do_SQUARE(Command,3);
    IF Temp = 'GET_EDITOR_TEXT' THEN Do_GET_EDITOR_TEXT;
    IF Temp = 'GET_FIELD_DATA' THEN Do_GET_FIELD_DATA;
    IF Temp = 'GET_PICK_INFO' THEN Do_GET_PICK_INFO;
    IF Temp = 'HIDE_MOUSE' THEN Do_HIDE_MOUSE;
    IF Temp = 'KILL_WINDOW' THEN Do_KILL_WINDOW;
    IF Temp = 'LARGE_ICON_LIB' THEN Do_LARGE_ICON_LIB(Command);
    IF Temp = 'LOAD_FONT' THEN Do_LOAD_FONT(Command);
    IF Temp = 'LOAD_TEXT_FILE' THEN Do_LOAD_TEXT_FILE(Command);
    IF Temp = 'LOWERED_BOX' THEN Do_SQUARE(Command,5);
    IF Temp = 'MAXECUTE' THEN Do_MAXECUTE(Command);
    IF Temp = 'MEDIUM_ICON_LIB' THEN Do_MEDIUM_ICON_LIB(Command);
    IF Temp = 'MOUSE_MASK' THEN Do_MOUSE_MASK(Command);
    IF Temp = 'NEW_PICKLIST' THEN Do_NEW_PICKLIST(Command);
    IF Temp = 'NEW_TEXT_EDITOR' THEN Do_NEW_TEXT_EDITOR(Command);
    IF Temp = 'NEW_TEXT_READER' THEN Do_NEW_TEXT_READER(Command);
    IF Temp = 'PIE_SLICE' THEN Do_ELLIPSE(Command,3);
    IF Temp = 'PLAY_SOUND' THEN Do_PLAY_SOUND(Command);
    IF Temp = 'PUT_IMAGE' THEN Do_PUT_IMAGE(Command);
    IF Temp = 'PUT_LARGE_ICON' THEN Do_PUT_ICON(Command,3);
    IF Temp = 'PUT_MEDIUM_ICON' THEN Do_PUT_ICON(Command,2);
    IF Temp = 'PUT_PIXEL' THEN Do_TRIANGLE(Command,2);
    IF Temp = 'PUT_SMALL_ICON' THEN Do_PUT_ICON(Command,1);
    IF Temp = 'RADIO_BUTTON' THEN Do_TRIANGLE(Command,1);
    IF Temp = 'RAISED_BOX' THEN Do_SQUARE(Command,6);
    IF Temp = 'REDRAW_FIELD' THEN Do_REDRAW_FIELD;
    IF Temp = 'RESET_PICKLIST' THEN Do_RESET_PICKLIST(Command);
    IF Temp = 'RESET_REMOTE' THEN Do_RESET_REMOTE;
    IF Temp = 'RUN_TEXT_EDITOR' THEN Do_RUN_TEXT_EDITOR;
    IF Temp = 'SET_FILL_STYLE' THEN Do_SET_FILL_STYLE(Command);
    IF Temp = 'SETUP_PICKLIST' THEN Do_SETUP_PICKLIST;
    IF Temp = 'SHOW_MOUSE' THEN Do_SHOW_MOUSE;
    IF Temp = 'SHOW_TEXT_PAGE' THEN Do_SHOW_TEXT_PAGE;
    IF Temp = 'SMALL_ICON_LIB' THEN Do_SMALL_ICON_LIB(Command);
    IF Temp = 'STANDARD_TEXT' THEN Do_STANDARD_TEXT(Command);
    IF Temp = 'SHADOW_TEXT' THEN Do_SHADOW_TEXT(Command);
    IF Temp = 'SHOW_REMOTE_SCREEN' THEN Do_SHOW_REMOTE_SCREEN(Command);
    IF Temp = 'SIREN' THEN Do_SIREN;
    IF Temp = 'START_SCREEN' THEN Do_START_SCREEN;
    IF Temp = 'START_TEXT_FILE' THEN Do_START_TEXT_FILE(Command);
    IF Temp = 'PUT_TEXT_FILE' THEN Do_PUT_TEXT_FILE(Command);
    IF Temp = 'END_TEXT_FILE' THEN Do_END_TEXT_FILE;
    IF Temp = 'TEXT_VIEW_WINDOW' THEN Do_SQUARE(Command,8);
    IF Temp = 'TEXT_VIEW_PORT' THEN Do_SQUARE(Command,11);
    IF Temp = 'USER_BUTTON' THEN Do_SQUARE(Command,10);
  END;
  ScrStr := '';
END;

PROCEDURE GetUserInfo;
BEGIN
  IF Carrier THEN BEGIN
    SendStr(User_Name+#13#10);
    SendStr(Pass_Word+#13#10);
    SendStr(#255#255#13#10);
  END;
END;

PROCEDURE GetResourceInfo;
VAR
  DirInfo : SEARCHREC;
  FName   : STRING[12];
  TheList : TEXT;
BEGIN
  RaisedBox(0,459,639,479);
  ShadowText(272,461,14,0,2,'Sending Resource Info');
  ASSIGN(TheList,'RES.NFO');
  REWRITE(TheList);
  FINDFIRST(SesPath+'*.*',Anyfile - Directory - VolumeID,DirInfo);
  WHILE DOSERROR = 0 DO BEGIN
    WRITELN(TheList,AllCaps(DirInfo.Name));
    FINDNEXT(DirInfo);
  END;
  CLOSE(TheList);
  RESET(TheList);
  WHILE NOT EOF(TheList) DO BEGIN
    READLN(TheList,FName);
    IF Carrier THEN SendStr(FName+#13#10);
  END;
  IF Carrier THEN SendStr(#255#255#13#10);
  CLOSE(TheList);
  RaisedBox(0,459,639,479);
  ShadowText(7,461,15,0,2,'Running Under '+OsStr);
  Show_Mem;
END;

PROCEDURE GetSystemInfo;
VAR
  Txt     : TEXT;
  InfoStr : STRING;
BEGIN
  WriteSystemInfo;
  RaisedBox(0,459,639,479);
  ShadowText(275,461,14,0,2,'Sending System Info');
  ASSIGN(Txt,'SYSTEM.NFO');
  RESET(Txt);
  WHILE NOT EOF(Txt) DO BEGIN
    READLN(Txt,InfoStr);
    IF Carrier THEN SendStr(InfoStr+#13#10);
  END;
  IF Carrier THEN SendStr(#255#255#13#10);
  CLOSE(Txt);
  RaisedBox(0,459,639,479);
  ShadowText(7,461,15,0,2,'Running Under '+OsStr);
  Show_Mem;
END;

PROCEDURE CheckColorCommand(Command : STRING);
VAR
  CCode : CHAR;
  Color : INTEGER;
BEGIN
  CCode := Command[3];
  DELETE(Command,1,3);
  IF Command[LENGTH(Command)] = #255 THEN BEGIN
    DELETE(Command,LENGTH(Command),1);
    Color := StrToInt(Command);
    IF Color > 255 THEN Color := 0;
    FILLCHAR(_Max,SIZEOF(_Max),0);
    WITH _Max DO BEGIN
      Code  := ORD(CCode);
      VType := 125;
      V[1]  := Color;
      IF MaxConv THEN EXIT;
    END;
    IF CCode IN [#127..#199] THEN WITH C DO CASE CCode OF
      {---- MAXcolor  Commands ----}
      #127 : Win1Back      := Color;
      #128 : Win4Back      := Color;
      #129 : Win1High      := Color;
      #130 : Win4High      := Color;
      #131 : Win1Low       := Color;
      #132 : Win4Low       := Color;
      #133 : Win1Frame1    := Color;
      #134 : Win1Frame2    := Color;
      #135 : Win4Frame     := Color;
      #136 : ActiveHdr     := Color;
      #137 : InactiveHdr   := Color;
      #138 : HdrTitle      := Color;
      #139 : ButtonFrame   := Color;
      #140 : ButtonFace    := Color;
      #141 : ButtonHigh    := Color;
      #142 : ButtonLow     := Color;
      #143 : ButtonHot     := Color;
      #144 : ButtonText    := Color;
      #145 : FrameHigh     := Color;
      #146 : FrameLow      := Color;
      #147 : BoxBack       := Color;
      #148 : BoxHigh       := Color;
      #149 : BoxLow        := Color;
      #150 : FieldTextHigh := Color;
      #151 : FieldTextLow  := Color;
      #152 : FieldBack     := Color;
      #153 : FieldFrame    := Color;
      #154 : FieldHigh     := Color;
      #155 : QuoteColor    := Color;
      #156 : MsgColor      := Color;
      #157 : TearColor     := Color;
      #158 : FlagColor     := Color;
      #159 : MsgIDcolor    := Color;
      #160 : TextBack      := Color;
      #161 : PickHighFore  := Color;
      #162 : PickHighBack  := Color;
      #163 : ScreenColor   := Color;
    END ELSE IF CCode IN [#200..#254] THEN CASE CCode OF
    {------- Special System Commands -------}
      #200 : GetUserInfo;
      #201 : GetResourceInfo;
      #202 : DownPath1 := SesPath;
      #203 : DownPath1 := ResPath;
      #204 : DownPath1 := DownPath2;
      #205 : GetSystemInfo;
      #206 : BEGIN
               Command := GetFileName(StripBoth(Command,#39));
               FErase(SesPath+Command);
             END;
      #207 : BEGIN
               Command := GetFileName(StripBoth(Command,#39));
               FErase(ResPath+Command);
             END;
    END;
    {---------------------------------------}
  END;
  ScrStr := '';
END;

BEGIN
  UseSB     := TRUE;
  MaxConv   := FALSE;
  ResPath   := '';
  SesPath   := '';
  DownPath1 := '';
  DownPath2 := '';
  User_Name := '';
  Pass_Word := '';
  ScrStr    := '';
END.
