{ TRYGEMFO.PAS (23 March 1993) (Borland Pascal 7.0, real) }
program TryGEMFont;
{==============================================================================
This is a test bed for trying out the effect of text settings on the operation
of OutGEMText and OutGEMTextXY.
==============================================================================}
uses DOS, CRT, Graph, BgiDriv, GEMFontU;

var

  OriginalTextAttr: byte;

  GEMFontPtr: pointer;
  FontHeaderPtr: PExtendedGEMFontHeader absolute GEMFontPtr;
  GraphDriver, GraphMode: integer;
  MaxX, MaxY: integer;
  Leading, MinCode, MaxCode: word;
  ErrorCode: word;
  TextSettings: TextSettingsType;
{*****************************************************************************}
procedure SystemFontProc; external;
{$L SYSTEM.OBJ }
{*****************************************************************************}
function ColorMonitor: boolean;
{ The function returns True if the monitor attached to the system is a color
  monitor, False if it is a monochrome monitor.  (The information is taken
  from the System Equipment Data Area.) }
var
  Flags: byte;
begin { ColorMonitor }
  asm
    int $11
    mov Flags,ah
  end;
  ColorMonitor := (Flags and $30) <> $30
end; { ColorMonitor }
{*****************************************************************************}
function RegisterFont(var ErrorCode: word): boolean;
begin { RegisterFont }
  GEMFontPtr := RegisterGEMFont(@SystemFontProc,Leading,ErrorCode);
  RegisterFont := GEMFontPtr <> nil
end; { RegisterFont }
{*****************************************************************************}
procedure ClearGraphicsScreen;
begin { ClearGraphicsScreen }
{ Fill the screen with light gray: }
  SetFillStyle(SolidFill,LightGray);
  Bar(0,0,MaxX,MaxY)
end; { ClearGraphicsScreen }
{*****************************************************************************}
procedure WaitForKeyPress;
var
  Ch: char;
begin { WaitForKeyPress }
  Ch := ReadKey;
  if Ch = #0 then Ch := ReadKey
end; { WaitForKeyPress }
{*****************************************************************************}
begin { ViewGEM }
  OriginalTextAttr := TextAttr;
  if ColorMonitor
    then TextAttr := $17   { light gray on blue }
    else TextAttr := $70;  { black on low-intensity white }

  ClrScr;

  {DetectGraph(GraphDriver,GraphMode);
  if (GraphDriver = grNotDetected) or (GraphDriver <> VGA)
    then begin
      TextAttr := OriginalTextAttr;
      Writeln('This program requires a VGA.');
      Halt(1)
    end
    else begin
      GraphMode := VGAHi;
      if RegisterBGIDriver(@EGAVGADriverProc) < 0 then begin
        TextAttr := OriginalTextAttr;
        Writeln('EGA/VGA: ',GraphErrorMsg(GraphResult));
        Halt(1)
      end
    end;}

  FileMode := 0;  { allow read-only files to be processed }
  GEMFontPtr := nil;

  ClrScr;

  if RegisterFont(ErrorCode)

    then begin  { font registered }
      with FontHeaderPtr^ do begin
        Writeln('Font name: ',FontName,' (height: ',PointSize,' pixels)');
        Writeln('Character code range: ',LowASCII,'-',HighASCII)
      end; { with ... }
      Writeln;
      Writeln('Text in this font will be displayed in various positions and orientations.');
      Writeln('After each display, press a key to see the next display.');
      Writeln;
      Writeln('                           [Press any key to begin!]');
      WaitForKeyPress;

      {InitGraph(GraphDriver,GraphMode,'');
      if GraphResult <> grOK then begin
        TextAttr := OriginalTextAttr;
        Writeln('Error attempting to switch to graphics mode.');
        Halt(1)
      end;}
      InitBGI256;

      MaxX := GetMaxX;
      MaxY := GetMaxY;

      ClearGraphicsScreen;
      SetColor(Red);

    { Horizontal, left-to-right }

      MoveTo(0,Leading);
      OutGEMText(GEMFontPtr,'Procrastination is the thief of time.');
      WaitForKeyPress;

      MoveTo(MaxX div 2,3*Leading);
      SetTextJustify(CenterText,TopText);
      OutGEMText(GEMFontPtr,'Procrastination is the thief of time.');
      WaitForKeyPress;

      MoveTo(MaxX,5*Leading);
      SetTextJustify(RightText,TopText);
      OutGEMText(GEMFontPtr,'Procrastination is the thief of time.');
      WaitForKeyPress;

      MoveTo(MaxX div 2,7*Leading);
      SetTextJustify(LeftText,TopText);
      OutGEMText(GEMFontPtr,'Procrastination is the thief of time.');
      WaitForKeyPress;

      MoveTo(-(MaxX div 2),9*Leading);
      SetTextJustify(LeftText,TopText);
      OutGEMText(GEMFontPtr,'Procrastination is the thief of time.');
      WaitForKeyPress;

    { Vertical, bottom-to-top. }

      ClearGraphicsScreen;
      SetTextStyle(DefaultFont,VertDir,1);
      MoveTo(MaxX div 2,MaxY);
      OutGEMText(GEMFontPtr,'Procrastination is the thief of time.');
      WaitForKeyPress;

    { Vertical, top-to-bottom }
      SetTextStyle(DefaultFont,2,1);
      MoveTo(MaxX div 2+2*Leading,0);
      OutGEMText(GEMFontPtr,'Procrastination is the thief of time.');
      WaitForKeyPress;

    { Horizontal, right-to-left. }

      ClearGraphicsScreen;
      SetTextStyle(DefaultFont,3,1);  { right-to-left direction }

      MoveTo(MaxX,Leading);
      SetTextJustify(RightText,TopText);
      OutGEMText(GEMFontPtr,'Procrastination is the thief of time.');
      WaitForKeyPress;

      MoveTo(MaxX div 2,3*Leading);
      SetTextJustify(CenterText,TopText);
      OutGEMText(GEMFontPtr,'Procrastination is the thief of time.');
      WaitForKeyPress;

      MoveTo(0,5*Leading);
      SetTextJustify(LeftText,TopText);
      OutGEMText(GEMFontPtr,'Procrastination is the thief of time.');
      WaitForKeyPress;

      MoveTo(MaxX div 2,7*Leading);
      SetTextJustify(RightText,TopText);
      OutGEMText(GEMFontPtr,'Procrastination is the thief of time.');
      WaitForKeyPress;

      MoveTo(MaxX div 2,9*Leading);
      SetTextJustify(LeftText,TopText);
      OutGEMText(GEMFontPtr,'Procrastination is the thief of time.');
      WaitForKeyPress;

    { Vertical, top to bottom, unrotated. }
      ClearGraphicsScreen;
      SetColor(Blue);
      MoveTo(MaxX div 2,0);
      LineTo(MaxX div 2,MaxY);
      SetColor(Red);
      SetTextStyle(DefaultFont,4,1);  { top to bottom, unrotated }

      MoveTo(MaxX div 2,0);
      SetTextJustify(LeftText,CenterText);
      OutGEMText(GEMFontPtr,'Procrastination is the thief of time.');
      WaitForKeyPress;

      CloseGraph;
      ClrScr
    end  { font registered }

    else begin  { font not registered }
      ClrScr;
      Writeln('Error trying to register the font: ',ErrorCode);
      Writeln('                         [Press any key to continue.]');
      WaitForKeyPress
    end;  { font not registered }

  TextAttr := OriginalTextAttr;
  ClrScr
end. { ViewGEM }
